/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import gde.ui.tab.GraphicsComposite;
import gde.ui.tab.SelectorComposite;
import gde.utils.TimeLine;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class GraphicsWindow
extends CTabItem {
    static final Logger log = Logger.getLogger(GraphicsWindow.class.getName());
    public static final String GRAPHICS_TYPE = "graphics_type";
    final CTabFolder tabFolder;
    SashForm graphicSashForm;
    boolean isCurveSelectorEnabled = true;
    int[] sashFormWeights = new int[]{100, 1000};
    SelectorComposite curveSelectorComposite;
    GraphicsComposite graphicsComposite;
    final DataExplorer application;
    final Channels channels;
    final Settings settings;
    final String tabName;
    final TimeLine timeLine = new TimeLine();
    final GraphicsType graphicsType;

    public GraphicsWindow(CTabFolder currentDisplayTab, int style, GraphicsType currentType, String useTabName, int index) {
        super(currentDisplayTab, style, index);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.application = DataExplorer.getInstance();
        this.tabFolder = currentDisplayTab;
        this.graphicsType = currentType;
        this.tabName = useTabName;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(this.tabName);
    }

    public void create() {
        this.graphicSashForm = new SashForm((Composite)this.tabFolder, 256);
        this.setControl((Control)this.graphicSashForm);
        this.curveSelectorComposite = new SelectorComposite(this.graphicSashForm, this.graphicsType, "  " + Messages.getString("GDE_MSGT0254"));
        this.graphicsComposite = new GraphicsComposite(this.graphicSashForm, this.graphicsType);
        try {
            if (GDE.shell.getClientArea().width > 117) {
                this.graphicSashForm.setWeights(new int[]{117, GDE.shell.getClientArea().width - 117});
            }
        }
        catch (IllegalArgumentException e) {
            log.log(java.util.logging.Level.WARNING, "graphicSashForm.setWeights(this.sashFormWeights) failed!", e);
        }
    }

    public boolean isVisible() {
        return this.graphicsComposite.isVisible();
    }

    public void redrawGraphics(final boolean redrawCurveSelector) {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.graphicsComposite.doRedrawGraphics();
            this.graphicsComposite.updateCaptions();
            if (redrawCurveSelector) {
                this.curveSelectorComposite.doUpdateCurveSelectorTable();
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphicsWindow.this.graphicsComposite.doRedrawGraphics();
                    GraphicsWindow.this.graphicsComposite.updateCaptions();
                    if (redrawCurveSelector) {
                        GraphicsWindow.this.curveSelectorComposite.doUpdateCurveSelectorTable();
                    }
                }
            });
        }
    }

    public void updateCaptions() {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.graphicsComposite.updateCaptions();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphicsWindow.this.graphicsComposite.updateCaptions();
                }
            });
        }
    }

    public void updateCurveSelectorTable() {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.curveSelectorComposite.doUpdateCurveSelectorTable();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphicsWindow.this.curveSelectorComposite.doUpdateCurveSelectorTable();
                }
            });
        }
    }

    public void setSashFormWeights(int newSelectorCompositeWidth) {
        int[] newWeights;
        int tabFolderClientAreaWidth = this.tabFolder.getBounds().width;
        int bestGuessWidth = this.application.getClientArea().width;
        if (tabFolderClientAreaWidth > bestGuessWidth) {
            log.log(Level.WARNING, "tabFolder clientAreaWidth missmatch, tabFolderWidth = " + tabFolderClientAreaWidth + " vs applicationWidth = " + bestGuessWidth);
            tabFolderClientAreaWidth = bestGuessWidth;
            this.tabFolder.setSize(tabFolderClientAreaWidth, this.tabFolder.getBounds().height);
        }
        if (this.sashFormWeights[0] != (newWeights = new int[]{newSelectorCompositeWidth = newSelectorCompositeWidth > tabFolderClientAreaWidth / 2 ? tabFolderClientAreaWidth / 2 : newSelectorCompositeWidth, tabFolderClientAreaWidth - newSelectorCompositeWidth})[0] || this.sashFormWeights[1] != newWeights[1]) {
            this.sashFormWeights = newWeights;
            try {
                if (this.sashFormWeights.length == 2 && this.sashFormWeights[1] != 0) {
                    this.graphicSashForm.setWeights(this.sashFormWeights);
                }
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "graphicSashForm.setWeights(this.sashFormWeights) failed!", e);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "sash weight = " + this.sashFormWeights[0] + ", " + this.sashFormWeights[1] + " tabFolderClientAreaWidth = " + tabFolderClientAreaWidth + " graphicsType = " + String.valueOf((Object)this.graphicsType));
            }
        }
    }

    public int getWidth() {
        return this.graphicSashForm.getSize().x;
    }

    public int[] getSashFormWeights() {
        return this.sashFormWeights;
    }

    public boolean isCurveSelectorEnabled() {
        return this.isCurveSelectorEnabled;
    }

    public void setCurveSelectorEnabled(boolean enabled) {
        this.isCurveSelectorEnabled = enabled;
        if (enabled) {
            this.setSashFormWeights(this.curveSelectorComposite.getSelectorColumnWidth());
        } else {
            this.setSashFormWeights(0);
        }
    }

    public SashForm getGraphicSashForm() {
        return this.graphicSashForm;
    }

    public void enableGraphicsHeader(boolean enabled) {
        this.graphicsComposite.enableGraphicsHeader(enabled);
    }

    public void enableRecordSetComment(boolean enabled) {
        this.graphicsComposite.enableRecordSetComment(enabled);
    }

    public void clearHeaderAndComment() {
        this.graphicsComposite.clearHeaderAndComment();
    }

    public void setModeState(GraphicsComposite.GraphicsMode mode) {
        this.graphicsComposite.setModeState(mode);
    }

    public SelectorComposite getCurveSelectorComposite() {
        return this.curveSelectorComposite;
    }

    public GraphicsComposite getGraphicsComposite() {
        return this.graphicsComposite;
    }

    public boolean isActiveCurveSelectorContextMenu() {
        return this.curveSelectorComposite.contextMenu.isActive();
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.graphicSashForm.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.graphicSashForm.print(imageGC);
        if (GDE.IS_MAC) {
            this.graphicSashForm.print(imageGC);
            Image graphics = this.graphicsComposite.getGraphicsPrintImage();
            if (graphics != null) {
                imageGC.drawImage(graphics, bounds.width - graphics.getBounds().width, 0);
                graphics.dispose();
            }
        }
        imageGC.dispose();
        return tabContentImage;
    }

    ImageData flipHorizontal(ImageData inputImageData) {
        int bytesPerPixel = inputImageData.bytesPerLine / inputImageData.width;
        int outBytesPerLine = inputImageData.width * bytesPerPixel;
        byte[] outDataBytes = new byte[inputImageData.data.length];
        int outX = 0;
        int outY = 0;
        int inIndex = 0;
        int outIndex = 0;
        for (int y = 0; y < inputImageData.height; ++y) {
            for (int x = 0; x < inputImageData.width; ++x) {
                outX = x;
                outY = inputImageData.height - y - 1;
                inIndex = y * inputImageData.bytesPerLine + x * bytesPerPixel;
                outIndex = outY * outBytesPerLine + outX * bytesPerPixel;
                System.arraycopy(inputImageData.data, inIndex, outDataBytes, outIndex, bytesPerPixel);
            }
        }
        return new ImageData(inputImageData.width, inputImageData.height, inputImageData.depth, inputImageData.palette, outBytesPerLine, outDataBytes);
    }

    public void setCurveAreaBackground(Color curveAreaBackground) {
        this.graphicsComposite.curveAreaBackground = curveAreaBackground;
        this.graphicsComposite.graphicCanvas.redraw();
    }

    public void setCurveAreaBorderColor(Color borderColor) {
        this.graphicsComposite.curveAreaBorderColor = borderColor;
        this.graphicsComposite.graphicCanvas.redraw();
    }

    public void setSurroundingBackground(Color surroundingBackground) {
        this.graphicsComposite.surroundingBackground = surroundingBackground;
        this.graphicsComposite.setBackground(surroundingBackground);
        this.graphicsComposite.graphicsHeader.setBackground(surroundingBackground);
        this.graphicsComposite.recordSetComment.setBackground(surroundingBackground);
        this.graphicsComposite.doRedrawGraphics();
    }

    public void setHeaderCommentColor(Color borderColor) {
        this.graphicsComposite.headerCommentColor = borderColor;
        this.graphicsComposite.graphicsHeader.setForeground(borderColor);
        this.graphicsComposite.graphicsHeader.redraw();
        this.graphicsComposite.recordSetComment.setForeground(Settings.getInstance().getHeaderCommentColor());
        this.graphicsComposite.recordSetComment.redraw();
    }

    public GraphicsType getGraphicsType() {
        return this.graphicsType;
    }

    public void updateColorSchema() {
        if (this.curveSelectorComposite != null) {
            this.curveSelectorComposite.updateColorSchema();
        }
    }

    public static enum GraphicsType {
        NORMAL,
        COMPARE,
        UTIL;


        public TabAreaContextMenu.TabMenuType toTabType() {
            switch (this.ordinal()) {
                case 0: {
                    return TabAreaContextMenu.TabMenuType.GRAPHICS;
                }
                case 1: {
                    return TabAreaContextMenu.TabMenuType.COMPARE;
                }
                case 2: {
                    return TabAreaContextMenu.TabMenuType.UTILITY;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

