/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.exception.OutOfRangeException;

class BicubicSplineFunction
implements BivariateFunction {
    private static final short N = 4;
    private final double[][] a = new double[4][4];
    private final BivariateFunction partialDerivativeX;
    private final BivariateFunction partialDerivativeY;
    private final BivariateFunction partialDerivativeXX;
    private final BivariateFunction partialDerivativeYY;
    private final BivariateFunction partialDerivativeXY;

    BicubicSplineFunction(double[] coeff) {
        this(coeff, false);
    }

    BicubicSplineFunction(double[] coeff, boolean initializeDerivatives) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                this.a[i2][j2] = coeff[i2 * 4 + j2];
            }
        }
        if (initializeDerivatives) {
            final double[][] aX = new double[4][4];
            final double[][] aY = new double[4][4];
            final double[][] aXX = new double[4][4];
            final double[][] aYY = new double[4][4];
            final double[][] aXY = new double[4][4];
            for (int i3 = 0; i3 < 4; ++i3) {
                for (int j3 = 0; j3 < 4; ++j3) {
                    double c2 = this.a[i3][j3];
                    aX[i3][j3] = (double)i3 * c2;
                    aY[i3][j3] = (double)j3 * c2;
                    aXX[i3][j3] = (double)(i3 - 1) * aX[i3][j3];
                    aYY[i3][j3] = (double)(j3 - 1) * aY[i3][j3];
                    aXY[i3][j3] = (double)j3 * aX[i3][j3];
                }
            }
            this.partialDerivativeX = new BivariateFunction(){

                public double value(double x2, double y2) {
                    double x22 = x2 * x2;
                    double[] pX = new double[]{0.0, 1.0, x2, x22};
                    double y22 = y2 * y2;
                    double y3 = y22 * y2;
                    double[] pY = new double[]{1.0, y2, y22, y3};
                    return BicubicSplineFunction.this.apply(pX, pY, aX);
                }
            };
            this.partialDerivativeY = new BivariateFunction(){

                public double value(double x2, double y2) {
                    double x22 = x2 * x2;
                    double x3 = x22 * x2;
                    double[] pX = new double[]{1.0, x2, x22, x3};
                    double y22 = y2 * y2;
                    double[] pY = new double[]{0.0, 1.0, y2, y22};
                    return BicubicSplineFunction.this.apply(pX, pY, aY);
                }
            };
            this.partialDerivativeXX = new BivariateFunction(){

                public double value(double x2, double y2) {
                    double[] pX = new double[]{0.0, 0.0, 1.0, x2};
                    double y22 = y2 * y2;
                    double y3 = y22 * y2;
                    double[] pY = new double[]{1.0, y2, y22, y3};
                    return BicubicSplineFunction.this.apply(pX, pY, aXX);
                }
            };
            this.partialDerivativeYY = new BivariateFunction(){

                public double value(double x2, double y2) {
                    double x22 = x2 * x2;
                    double x3 = x22 * x2;
                    double[] pX = new double[]{1.0, x2, x22, x3};
                    double[] pY = new double[]{0.0, 0.0, 1.0, y2};
                    return BicubicSplineFunction.this.apply(pX, pY, aYY);
                }
            };
            this.partialDerivativeXY = new BivariateFunction(){

                public double value(double x2, double y2) {
                    double x22 = x2 * x2;
                    double[] pX = new double[]{0.0, 1.0, x2, x22};
                    double y22 = y2 * y2;
                    double[] pY = new double[]{0.0, 1.0, y2, y22};
                    return BicubicSplineFunction.this.apply(pX, pY, aXY);
                }
            };
        } else {
            this.partialDerivativeX = null;
            this.partialDerivativeY = null;
            this.partialDerivativeXX = null;
            this.partialDerivativeYY = null;
            this.partialDerivativeXY = null;
        }
    }

    public double value(double x2, double y2) {
        if (x2 < 0.0 || x2 > 1.0) {
            throw new OutOfRangeException(x2, (Number)0, 1);
        }
        if (y2 < 0.0 || y2 > 1.0) {
            throw new OutOfRangeException(y2, (Number)0, 1);
        }
        double x22 = x2 * x2;
        double x3 = x22 * x2;
        double[] pX = new double[]{1.0, x2, x22, x3};
        double y22 = y2 * y2;
        double y3 = y22 * y2;
        double[] pY = new double[]{1.0, y2, y22, y3};
        return this.apply(pX, pY, this.a);
    }

    private double apply(double[] pX, double[] pY, double[][] coeff) {
        double result2 = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                result2 += coeff[i2][j2] * pX[i2] * pY[j2];
            }
        }
        return result2;
    }

    public BivariateFunction partialDerivativeX() {
        return this.partialDerivativeX;
    }

    public BivariateFunction partialDerivativeY() {
        return this.partialDerivativeY;
    }

    public BivariateFunction partialDerivativeXX() {
        return this.partialDerivativeXX;
    }

    public BivariateFunction partialDerivativeYY() {
        return this.partialDerivativeYY;
    }

    public BivariateFunction partialDerivativeXY() {
        return this.partialDerivativeXY;
    }
}

