/*
 * Decompiled with CFR 0.152.
 */
package gde.device.bantam;

import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.bantam.EStationDialog;
import gde.device.bantam.eStation;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.xml.bind.JAXBException;

public class eStationBC6
extends eStation {
    public eStationBC6(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        this.dialog = new EStationDialog(this.application.getShell(), this);
    }

    public eStationBC6(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.dialog = new EStationDialog(this.application.getShell(), this);
    }

    @Override
    public EStationDialog getDialog() {
        return this.dialog;
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2FourDigitsIntegerString((byte[])dataBuffer, (byte)-128, (int)1, (int)(dataBuffer.length - 2)));
        }
        points[0] = (((dataBuffer[35] & 0xFF) - 128) * 100 + ((dataBuffer[36] & 0xFF) - 128)) * 10;
        points[1] = (((dataBuffer[33] & 0xFF) - 128) * 100 + ((dataBuffer[34] & 0xFF) - 128)) * 10;
        points[2] = (((dataBuffer[43] & 0xFF) - 128) * 100 + ((dataBuffer[44] & 0xFF) - 128)) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
        points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
        points[5] = (((dataBuffer[41] & 0xFF) - 128) * 100 + ((dataBuffer[42] & 0xFF) - 128)) * 10;
        points[6] = 0;
        int i = 0;
        int j = 0;
        while (i < points.length - 7) {
            points[i + 7] = (((dataBuffer[j + 45] & 0xFF) - 128) * 100 + ((dataBuffer[j + 46] & 0xFF) - 128)) * 10;
            if (points[i + 7] > 0) {
                maxVotage = points[i + 7] > maxVotage ? points[i + 7] : maxVotage;
                minVotage = points[i + 7] < minVotage ? points[i + 7] : minVotage;
            }
            ++i;
            j += 2;
        }
        points[6] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 0;
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
            points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[6] = 0;
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            while (j < points.length - 7) {
                points[j + 7] = ((convertBuffer[k + 16] & 0xFF) << 24) + ((convertBuffer[k + 17] & 0xFF) << 16) + ((convertBuffer[k + 18] & 0xFF) << 8) + ((convertBuffer[k + 19] & 0xFF) << 0);
                if (points[j + 7] > 0) {
                    maxVotage = points[j + 7] > maxVotage ? points[j + 7] : maxVotage;
                    minVotage = points[j + 7] < minVotage ? points[j + 7] : minVotage;
                }
                ++j;
                k += 4;
            }
            int n = points[6] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
        recordSet.getDevice().updateVisibilityStatus(recordSet, true);
    }
}

