/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.smmodellbau.UniLogDialog;
import gde.exception.CheckSumMissmatchException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class UniLogSerialPort
extends DeviceCommPort {
    static final Logger log = Logger.getLogger(UniLogSerialPort.class.getName());
    public static final String NUMBER_RECORD = "number_record";
    public static final String TIME_MILLI_SEC = "time_ms";
    public static final String A_MODUS_1_2_3 = "aModus_1_2_3";
    static final byte[] COMMAND_QUERY_STATE = new byte[]{84};
    static final byte[] COMMAND_RESET = new byte[]{114};
    static final byte[] COMMAND_READ_DATA = new byte[]{108};
    static final byte[] COMMAND_REPEAT = new byte[]{119};
    static final byte[] COMMAND_DELETE = new byte[]{-64, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6};
    static final byte[] COMMAND_QUERY_CONFIG = new byte[]{-64, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4};
    static final byte[] COMMAND_QUERY_TELE_CONFIG = new byte[]{-64, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
    static final byte[] COMMAND_LIVE_VALUES = new byte[]{118};
    static final byte[] COMMAND_START_LOGGING = new byte[]{83};
    static final byte[] COMMAND_STOP_LOGGING = new byte[]{115};
    static final byte DATA_STATE_WAITING = 87;
    static final byte DATA_STATE_READY = 70;
    static final byte DATA_STATE_OK = 106;
    static final int DATA_LENGTH_BYTES = 24;
    static int TIME_OUT_MS = 2000;
    boolean isLoggingActive = false;
    boolean isTransmitFinished = false;
    int reveiceErrors = 0;

    public UniLogSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public Vector<Vector<byte[]>> getData(UniLogDialog dialog) throws Exception {
        boolean isPortOpenedByMe = false;
        Vector<Vector<byte[]>> dataCollection = new Vector<Vector<byte[]>>();
        int numberMeasurementsLess4 = 0;
        byte[] readBuffer = new byte[24];
        try {
            int counter;
            int numberRecordSet;
            int memoryUsed;
            log.log(Level.FINE, "start");
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            this.reveiceErrors = 0;
            if (this.waitDataReady()) {
                int memoryLeft;
                this.write(COMMAND_QUERY_CONFIG);
                readBuffer = this.read(readBuffer, 2000);
                this.verifyChecksum(readBuffer);
                memoryUsed = memoryLeft = ((readBuffer[6] & 0xFF) << 8) + (readBuffer[7] & 0xFF);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "memoryUsed = " + memoryUsed);
                }
                this.write(COMMAND_RESET);
                dialog.setReadDataProgressBar(0);
                Vector<byte[]> telegrams = new Vector<byte[]>();
                numberRecordSet = 1;
                counter = 0;
                while (memoryLeft-- > 0) {
                    readBuffer = this.readSingleTelegramm();
                    if (numberRecordSet == (readBuffer[5] & 0xF8) / 8 + 1) {
                        telegrams.add(readBuffer);
                    } else {
                        if (telegrams.size() > 4) {
                            dataCollection.add(telegrams);
                        } else {
                            ++numberMeasurementsLess4;
                        }
                        numberRecordSet = (readBuffer[5] & 0xF8) / 8 + 1;
                        telegrams = new Vector();
                        telegrams.add(readBuffer);
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "numberRecordSet = " + numberRecordSet + " memoryLeft = " + memoryLeft);
                    }
                    if (++counter % 5 == 0) {
                        dialog.updateDataGatherProgress(counter, numberRecordSet, this.reveiceErrors, numberMeasurementsLess4, memoryUsed);
                    }
                    if (!this.isTransmitFinished) continue;
                    log.log(Level.WARNING, "transmission stopped by user");
                    break;
                }
                if (telegrams.size() > 4) {
                    dataCollection.add(telegrams);
                }
            } else {
                throw new IOException(Messages.getString((String)"GDE_MSGE0026"));
            }
            numberMeasurementsLess4 = numberRecordSet - dataCollection.size();
            dialog.updateDataGatherProgress(counter, numberRecordSet, this.reveiceErrors, numberMeasurementsLess4, memoryUsed);
            log.log(Level.FINE, "end");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
            log.log(Level.FINE, "stop");
        }
        return dataCollection;
    }

    public synchronized byte[] readSingleTelegramm() throws Exception {
        byte[] readBuffer = new byte[24];
        try {
            this.write(COMMAND_READ_DATA);
            readBuffer = this.read(readBuffer, 4000);
            if (!this.isChecksumOK(readBuffer)) {
                readBuffer = this.readRetry(readBuffer);
            }
        }
        catch (Throwable e) {
            readBuffer = this.readRetry(readBuffer);
        }
        return readBuffer;
    }

    byte[] readRetry(byte[] readBuffer) throws IOException, TimeOutException, CheckSumMissmatchException {
        StringBuilder sb;
        if (log.isLoggable(Level.WARNING)) {
            sb = new StringBuilder();
            sb.append("Read before data: ");
            sb.append(StringHelper.byte2Hex2CharString((byte[])readBuffer, (int)readBuffer.length));
            log.logp(Level.WARNING, "UniLogSerialPort", "readRetry", sb.toString());
        }
        ++this.reveiceErrors;
        this.write(COMMAND_REPEAT);
        readBuffer = new byte[24];
        readBuffer = this.read(readBuffer, 4000);
        this.verifyChecksum(readBuffer);
        if (log.isLoggable(Level.WARNING)) {
            sb = new StringBuilder();
            sb.append("Read after data: ");
            sb.append(StringHelper.byte2Hex2CharString((byte[])readBuffer, (int)readBuffer.length));
            log.logp(Level.WARNING, "UniLogSerialPort", "readRetry", sb.toString());
        }
        return readBuffer;
    }

    public boolean wait4LiveData(int retrys) throws Exception {
        boolean isLiveDataAvailable = false;
        if (this.isConnected()) {
            this.application.setCursor(SWTResourceManager.getCursor((int)1));
            while (this.getAvailableBytes() < 10 && retrys-- > 0 && !this.isInterruptedByUser) {
                this.write(COMMAND_LIVE_VALUES);
                WaitTimer.delay((long)250L);
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "retryLimit = " + retrys);
            }
            if (!this.isInterruptedByUser) {
                this.read(new byte[24], 1000);
                isLiveDataAvailable = true;
            }
        } else {
            throw new Exception(Messages.getString((String)"GDE_MSGE0031"));
        }
        this.application.setCursor(SWTResourceManager.getCursor((int)0));
        return isLiveDataAvailable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized byte[] queryLiveData() throws Exception {
        byte[] readBuffer = new byte[24];
        if (!this.isConnected()) throw new Exception(Messages.getString((String)"GDE_MSGE0031"));
        try {
            this.write(COMMAND_LIVE_VALUES);
            readBuffer = this.read(readBuffer, TIME_OUT_MS * 2);
            if (this.isChecksumOK(readBuffer)) return readBuffer;
            this.write(COMMAND_LIVE_VALUES);
            readBuffer = this.read(readBuffer, TIME_OUT_MS * 2);
            this.verifyChecksum(readBuffer);
            return readBuffer;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    public boolean startLogging() throws Exception {
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
                WaitTimer.delay((long)TIME_OUT_MS);
            }
            this.write(COMMAND_START_LOGGING);
            this.isLoggingActive = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.close();
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return this.isLoggingActive;
    }

    public synchronized boolean stopLogging() throws Exception {
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            this.write(COMMAND_STOP_LOGGING);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.close();
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return !this.isLoggingActive;
    }

    public synchronized boolean clearMemory() throws Exception {
        boolean success;
        block7: {
            success = false;
            try {
                if (this.isConnected()) break block7;
                this.open();
                if (this.waitDataReady()) {
                    this.write(COMMAND_DELETE);
                    byte[] readBuffer = new byte[1];
                    readBuffer = this.read(readBuffer, TIME_OUT_MS * 2);
                    if (readBuffer[0] != 106) {
                        success = true;
                    }
                    break block7;
                }
                throw new IOException(Messages.getString((String)"GDE_MSGE0032"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                this.close();
            }
        }
        return success;
    }

    public synchronized boolean setConfiguration(byte[] updateBuffer) throws Exception {
        boolean success;
        block10: {
            success = false;
            boolean isPortOpenedByMe = false;
            try {
                if (!this.isConnected()) {
                    this.open();
                    isPortOpenedByMe = true;
                }
                if (this.checkConnectionStatus()) {
                    if (this.checkDataReady()) {
                        this.write(updateBuffer);
                        byte[] readBuffer = new byte[1];
                        readBuffer = this.read(readBuffer, TIME_OUT_MS * 2);
                        if (readBuffer[0] == 106) {
                            success = true;
                        }
                        break block10;
                    }
                    throw new IOException(Messages.getString((String)"GDE_MSGE0032"));
                }
                throw new IOException(Messages.getString((String)"GDE_MSGE0033"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                if (isPortOpenedByMe) {
                    this.close();
                }
            }
        }
        return success;
    }

    public synchronized byte[] readConfiguration() throws Exception {
        byte[] readBuffer;
        block9: {
            readBuffer = new byte[24];
            boolean isPortOpenedByMe = false;
            try {
                if (!this.isConnected()) {
                    this.open();
                    isPortOpenedByMe = true;
                }
                if (this.checkConnectionStatus()) {
                    if (this.checkDataReady()) {
                        this.write(COMMAND_QUERY_CONFIG);
                        readBuffer = this.read(readBuffer, TIME_OUT_MS * 2);
                        this.verifyChecksum(readBuffer);
                        break block9;
                    }
                    throw new IOException(Messages.getString((String)"GDE_MSGE0033"));
                }
                throw new IOException(Messages.getString((String)"GDE_MSGE0032"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                if (isPortOpenedByMe) {
                    this.close();
                }
            }
        }
        return readBuffer;
    }

    public synchronized byte[] readTelemetryConfiguration() throws Exception {
        byte[] readBuffer;
        block9: {
            readBuffer = new byte[24];
            boolean isPortOpenedByMe = false;
            try {
                if (!this.isConnected()) {
                    this.open();
                    isPortOpenedByMe = true;
                }
                if (this.checkConnectionStatus()) {
                    if (this.checkDataReady()) {
                        this.write(COMMAND_QUERY_TELE_CONFIG);
                        readBuffer = this.read(readBuffer, TIME_OUT_MS * 2);
                        this.verifyChecksum(readBuffer);
                        break block9;
                    }
                    throw new IOException(Messages.getString((String)"GDE_MSGE0033"));
                }
                throw new IOException(Messages.getString((String)"GDE_MSGE0032"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                if (isPortOpenedByMe) {
                    this.close();
                }
            }
        }
        return readBuffer;
    }

    public synchronized boolean checkConnectionStatus() throws IOException, TimeOutException {
        boolean isConnect = false;
        int counter = 50;
        while (!isConnect && counter-- > 0) {
            this.write(COMMAND_QUERY_STATE);
            byte[] buffer = new byte[1];
            WaitTimer.delay((long)100L);
            if ((buffer = this.read(buffer, TIME_OUT_MS))[0] != 87 && buffer[0] != 70) continue;
            isConnect = true;
        }
        return isConnect;
    }

    public synchronized boolean checkDataReady() throws Exception {
        boolean isReady = false;
        int counter = 20;
        while (!isReady && counter-- > 0) {
            this.write(COMMAND_QUERY_STATE);
            byte[] buffer = new byte[1];
            if ((buffer = this.read(buffer, TIME_OUT_MS))[0] != 70) continue;
            isReady = true;
        }
        return isReady;
    }

    public synchronized boolean waitDataReady() throws Exception {
        boolean isReady = false;
        isReady = this.checkConnectionStatus();
        isReady = this.checkDataReady();
        return isReady;
    }

    private void verifyChecksum(byte[] readBuffer) throws CheckSumMissmatchException {
        int checkSum = 0;
        int checkSumLast2Bytes = 0;
        checkSum = Checksum.ADD((byte[])readBuffer, (int)2) + 1;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "checkSum = " + checkSum);
        }
        checkSumLast2Bytes = ((readBuffer[22] & 0xFF) << 8) + (readBuffer[23] & 0xFF);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "checkSumLast2Bytes = " + checkSumLast2Bytes);
        }
        if (checkSum != checkSumLast2Bytes) {
            throw new CheckSumMissmatchException(Messages.getString((String)"GDE_MSGE0034", (Object[])new Object[]{checkSum, checkSumLast2Bytes}));
        }
    }

    private boolean isChecksumOK(byte[] readBuffer) {
        int checkSum = 0;
        int checkSumLast2Bytes = 0;
        checkSum = Checksum.ADD((byte[])readBuffer, (int)2) + 1;
        checkSumLast2Bytes = ((readBuffer[22] & 0xFF) << 8) + (readBuffer[23] & 0xFF);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "checkSum = " + checkSum + " checkSumLast2Bytes = " + checkSumLast2Bytes);
        }
        return checkSum == checkSumLast2Bytes;
    }

    public void setTransmitFinished(boolean isFinished) {
        this.isTransmitFinished = isFinished;
    }

    public boolean isTransmitFinished() {
        return this.isTransmitFinished;
    }
}

