/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import org.apache.commons.math3.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendreRuleFactory
extends BaseRuleFactory<Double> {
    @Override
    protected Pair<Double[], Double[]> computeRule(int numberOfPoints) throws DimensionMismatchException {
        if (numberOfPoints == 1) {
            return new Pair<Double[], Double[]>(new Double[]{0.0}, new Double[]{2.0});
        }
        Double[] previousPoints = (Double[])this.getRuleInternal(numberOfPoints - 1).getFirst();
        Double[] points = new Double[numberOfPoints];
        Double[] weights = new Double[numberOfPoints];
        int iMax = numberOfPoints / 2;
        for (int i2 = 0; i2 < iMax; ++i2) {
            double a2 = i2 == 0 ? -1.0 : previousPoints[i2 - 1];
            double b2 = iMax == 1 ? 1.0 : previousPoints[i2];
            double pma = 1.0;
            double pa = a2;
            double pmb = 1.0;
            double pb = b2;
            for (int j2 = 1; j2 < numberOfPoints; ++j2) {
                int two_j_p_1 = 2 * j2 + 1;
                int j_p_1 = j2 + 1;
                double ppa = ((double)two_j_p_1 * a2 * pa - (double)j2 * pma) / (double)j_p_1;
                double ppb = ((double)two_j_p_1 * b2 * pb - (double)j2 * pmb) / (double)j_p_1;
                pma = pa;
                pa = ppa;
                pmb = pb;
                pb = ppb;
            }
            double c2 = 0.5 * (a2 + b2);
            double pmc = 1.0;
            double pc = c2;
            boolean done = false;
            while (!done) {
                done = b2 - a2 <= Math.ulp(c2);
                pmc = 1.0;
                pc = c2;
                for (int j3 = 1; j3 < numberOfPoints; ++j3) {
                    double ppc = ((double)(2 * j3 + 1) * c2 * pc - (double)j3 * pmc) / (double)(j3 + 1);
                    pmc = pc;
                    pc = ppc;
                }
                if (done) continue;
                if (pa * pc <= 0.0) {
                    b2 = c2;
                    pmb = pmc;
                    pb = pc;
                } else {
                    a2 = c2;
                    pma = pmc;
                    pa = pc;
                }
                c2 = 0.5 * (a2 + b2);
            }
            double d2 = (double)numberOfPoints * (pmc - c2 * pc);
            double w2 = 2.0 * (1.0 - c2 * c2) / (d2 * d2);
            points[i2] = c2;
            weights[i2] = w2;
            int idx = numberOfPoints - i2 - 1;
            points[idx] = -c2;
            weights[idx] = w2;
        }
        if (numberOfPoints % 2 != 0) {
            double pmc = 1.0;
            for (int j4 = 1; j4 < numberOfPoints; j4 += 2) {
                pmc = (double)(-j4) * pmc / (double)(j4 + 1);
            }
            double d3 = (double)numberOfPoints * pmc;
            double w3 = 2.0 / (d3 * d3);
            points[iMax] = 0.0;
            weights[iMax] = w3;
        }
        return new Pair<Double[], Double[]>(points, weights);
    }
}

