/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfNameTree {
    private static final int leafSize = 64;

    public static PdfDictionary writeTree(HashMap<String, ? extends PdfObject> items, PdfWriter writer) throws IOException {
        if (items.isEmpty()) {
            return null;
        }
        Object[] names = new String[items.size()];
        names = items.keySet().toArray(names);
        Arrays.sort(names);
        if (names.length <= 64) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            for (int k2 = 0; k2 < names.length; ++k2) {
                ar.add(new PdfString((String)names[k2], null));
                ar.add(items.get(names[k2]));
            }
            dic.put(PdfName.NAMES, ar);
            return dic;
        }
        int skip = 64;
        PdfIndirectReference[] kids = new PdfIndirectReference[(names.length + 64 - 1) / 64];
        for (int k3 = 0; k3 < kids.length; ++k3) {
            int offset;
            int end = Math.min(offset + 64, names.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfString((String)names[offset], null));
            arr.add(new PdfString((String)names[end - 1], null));
            dic.put(PdfName.LIMITS, arr);
            arr = new PdfArray();
            for (offset = k3 * 64; offset < end; ++offset) {
                arr.add(new PdfString((String)names[offset], null));
                arr.add(items.get(names[offset]));
            }
            dic.put(PdfName.NAMES, arr);
            kids[k3] = writer.addToBody(dic).getIndirectReference();
        }
        int top2 = kids.length;
        while (true) {
            int k4;
            if (top2 <= 64) {
                PdfArray arr = new PdfArray();
                for (k4 = 0; k4 < top2; ++k4) {
                    arr.add(kids[k4]);
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.KIDS, arr);
                return dic;
            }
            int tt = (names.length + (skip *= 64) - 1) / skip;
            for (k4 = 0; k4 < tt; ++k4) {
                int offset;
                int end = Math.min(offset + 64, top2);
                PdfDictionary dic = new PdfDictionary();
                PdfArray arr = new PdfArray();
                arr.add(new PdfString((String)names[k4 * skip], null));
                arr.add(new PdfString((String)names[Math.min((k4 + 1) * skip, names.length) - 1], null));
                dic.put(PdfName.LIMITS, arr);
                arr = new PdfArray();
                for (offset = k4 * 64; offset < end; ++offset) {
                    arr.add(kids[offset]);
                }
                dic.put(PdfName.KIDS, arr);
                kids[k4] = writer.addToBody(dic).getIndirectReference();
            }
            top2 = tt;
        }
    }

    private static PdfString iterateItems(PdfDictionary dic, HashMap<String, PdfObject> items, PdfString leftOverString) {
        block6: {
            PdfArray nn;
            block5: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.NAMES));
                if (nn == null) break block5;
                for (int k2 = 0; k2 < nn.size(); ++k2) {
                    PdfString s2;
                    if (leftOverString == null) {
                        s2 = (PdfString)PdfReader.getPdfObjectRelease(nn.getPdfObject(k2++));
                    } else {
                        s2 = leftOverString;
                        leftOverString = null;
                    }
                    if (k2 >= nn.size()) {
                        return s2;
                    }
                    items.put(PdfEncodings.convertToString(s2.getBytes(), null), nn.getPdfObject(k2));
                }
                break block6;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.KIDS));
            if (nn == null) break block6;
            for (int k3 = 0; k3 < nn.size(); ++k3) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease(nn.getPdfObject(k3));
                leftOverString = PdfNameTree.iterateItems(kid, items, leftOverString);
            }
        }
        return null;
    }

    public static HashMap<String, PdfObject> readTree(PdfDictionary dic) {
        HashMap<String, PdfObject> items = new HashMap<String, PdfObject>();
        if (dic != null) {
            PdfNameTree.iterateItems(dic, items, null);
        }
        return items;
    }
}

