/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.menu;

import com.thizzer.jtouchbar.JTouchBar;
import com.thizzer.jtouchbar.common.Image;
import com.thizzer.jtouchbar.item.TouchBarItem;
import com.thizzer.jtouchbar.item.view.TouchBarButton;
import com.thizzer.jtouchbar.item.view.TouchBarView;
import com.thizzer.jtouchbar.item.view.action.TouchBarViewAction;
import com.thizzer.jtouchbar.swt.JTouchBarSWT;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.DeviceSelectionDialog;
import gde.ui.dialog.GoogleEarthCustomizingDialog;
import gde.ui.dialog.PrintSelectionDialog;
import gde.ui.dialog.TimeSetDialog;
import gde.ui.tab.GraphicsComposite;
import gde.ui.tab.GraphicsWindow;
import gde.utils.FileUtils;
import gde.utils.ObjectKeyCompliance;
import gde.utils.ObjectKeyScanner;
import gde.utils.OperatingSystemHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MenuToolBar {
    static final Logger log = Logger.getLogger(MenuToolBar.class.getName());
    final String[] SCOPE_VALUES = Messages.getString("GDE_MSGT0196").split(";");
    StringBuffer toolBarSizes = new StringBuffer();
    Point toolSize;
    Point coolSize;
    CoolBar coolBar;
    CoolItem fileCoolItem;
    ToolBar fileToolBar;
    ToolItem copyToolItem;
    ToolItem printToolItem;
    ToolItem timeToolItem;
    ToolItem newToolItem;
    ToolItem openToolItem;
    ToolItem saveToolItem;
    ToolItem saveAsToolItem;
    ToolItem settingsToolItem;
    CoolItem deviceObjectCoolItem;
    ToolBar deviceObjectToolBar;
    ToolItem deviceSelectToolItem;
    ToolItem toolBoxToolItem;
    ToolItem prevDeviceToolItem;
    ToolItem nextDeviceToolItem;
    Composite objectSelectComposite;
    CCombo objectSelectCombo;
    ToolItem newObject;
    ToolItem deleteObject;
    ToolItem editObject;
    String oldObjectKey = null;
    boolean isObjectoriented = false;
    CoolItem zoomCoolItem;
    ToolBar zoomToolBar;
    ToolItem zoomWindowItem;
    ToolItem panItem;
    ToolItem fitIntoItem;
    ToolItem cutLeftItem;
    ToolItem cutRightItem;
    ToolItem scopePointsComboSep;
    Composite scopePointsComposite;
    CCombo scopePointsCombo;
    boolean isScopePointsCombo = true;
    int comboHeight = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
    CoolItem portCoolItem;
    ToolBar portToolBar;
    ToolItem portOpenCloseItem;
    int iconSet = 0;
    String toolTipOpen = "";
    String toolTipClose = "";
    CoolItem dataCoolItem;
    ToolBar dataToolBar;
    ToolItem nextChannel;
    ToolItem prevChannel;
    ToolItem prevRecord;
    ToolItem nextRecord;
    ToolItem separator;
    ToolItem deleteRecord;
    ToolItem editRecord;
    Composite channelSelectComposite;
    Composite recordSelectComposite;
    CCombo channelSelectCombo;
    CCombo recordSelectCombo;
    CoolItem helpCoolItem;
    ToolBar helpToolBar;
    ToolItem helpToolItem;
    CoolItem googleEarthCoolItem;
    ToolBar googleEarthToolBar;
    ToolItem googleEarthToolItem;
    ToolItem googleEarthConfigToolItem;
    String activeObjectKey;
    String language;
    String colorSchemaType;
    TouchBarButton touchBarButtonImport;
    final DataExplorer application;
    final Channels channels;
    final Settings settings;
    final FileHandler fileHandler;

    public MenuToolBar(DataExplorer parent, CoolBar menuCoolBar) {
        this.application = parent;
        this.coolBar = menuCoolBar;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.colorSchemaType = this.settings.getColorSchemaType();
        this.language = this.settings.getLocale().getLanguage();
        if (null == this.getClass().getClassLoader().getResourceAsStream("gde/resource/" + this.colorSchemaType + this.language + "/PortOpen.gif")) {
            this.language = "en";
        }
        this.fileHandler = new FileHandler();
        this.activeObjectKey = this.settings.getActiveObject();
    }

    public void create() {
        RowLayout comboCompositeLayout = new RowLayout();
        comboCompositeLayout.marginTop = 4;
        comboCompositeLayout.justify = true;
        comboCompositeLayout.center = true;
        this.fileCoolItem = new CoolItem(this.coolBar, 0);
        this.fileToolBar = new ToolBar((Composite)this.coolBar, 0);
        this.fileToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.fileToolBar.setForeground(this.application.COLOR_BACKGROUND);
        this.fileCoolItem.setControl((Control)this.fileToolBar);
        this.newToolItem = new ToolItem(this.fileToolBar, 0);
        this.newToolItem.setToolTipText(Messages.getString("GDE_MSGT0050"));
        this.newToolItem.setImage(SWTResourceManager.getImage("gde/resource/New.gif"));
        this.newToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/NewHot.gif"));
        this.newToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "newToolItem.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.application.getDeviceSelectionDialog().checkDataSaved()) {
                    MenuToolBar.this.application.getDeviceSelectionDialog().setupDataChannels(MenuToolBar.this.application.getActiveDevice());
                }
            }
        });
        this.openToolItem = new ToolItem(this.fileToolBar, 0);
        this.openToolItem.setToolTipText(Messages.getString("GDE_MSGT0051"));
        this.openToolItem.setImage(SWTResourceManager.getImage("gde/resource/Open.gif"));
        this.openToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/OpenHot.gif"));
        this.openToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "openToolItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.fileHandler.openFileDialog(Messages.getString("GDE_MSGT0004"));
            }
        });
        this.saveToolItem = new ToolItem(this.fileToolBar, 0);
        this.saveToolItem.setToolTipText(Messages.getString("GDE_MSGT0053"));
        this.saveToolItem.setImage(SWTResourceManager.getImage("gde/resource/Save.gif"));
        this.saveToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/SaveHot.gif"));
        this.saveToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "saveToolItem.widgetSelected, event=" + String.valueOf(evt));
                Channel activeChannel = MenuToolBar.this.channels.getActiveChannel();
                if (activeChannel != null) {
                    if (!activeChannel.isSaved()) {
                        MenuToolBar.this.fileHandler.saveOsdFile(Messages.getString("GDE_MSGT0006"), "");
                    } else {
                        MenuToolBar.this.fileHandler.saveOsdFile(Messages.getString("GDE_MSGT0007"), activeChannel.getFileName());
                    }
                }
            }
        });
        this.saveAsToolItem = new ToolItem(this.fileToolBar, 0);
        this.saveAsToolItem.setToolTipText(Messages.getString("GDE_MSGT0054"));
        this.saveAsToolItem.setImage(SWTResourceManager.getImage("gde/resource/SaveAs.gif"));
        this.saveAsToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/SaveAsHot.gif"));
        this.saveAsToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "saveAsToolItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.fileHandler.saveOsdFile(Messages.getString("GDE_MSGT0006"), "");
            }
        });
        this.settingsToolItem = new ToolItem(this.fileToolBar, 0);
        this.settingsToolItem.setToolTipText(Messages.getString("GDE_MSGT0055"));
        this.settingsToolItem.setImage(SWTResourceManager.getImage("gde/resource/Settings.gif"));
        this.settingsToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/SettingsHot.gif"));
        this.settingsToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "settingsToolItem.widgetSelected, event=" + String.valueOf(evt));
                DeviceDialog deviceDialog = MenuToolBar.this.application.getDeviceDialog();
                if (deviceDialog == null || deviceDialog.isDisposed()) {
                    MenuToolBar.this.application.openSettingsDialog();
                    MenuToolBar.this.application.setStatusMessage("");
                } else {
                    MenuToolBar.this.application.setStatusMessage(Messages.getString("GDE_MSGW0002"), 3);
                }
            }
        });
        this.copyToolItem = new ToolItem(this.fileToolBar, 0);
        this.copyToolItem.setToolTipText(Messages.getString("GDE_MSGT0073"));
        this.copyToolItem.setImage(SWTResourceManager.getImage("gde/resource/Copy.gif"));
        this.copyToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/CopyHot.gif"));
        this.copyToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "copyToolItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.application.copyTabContentAsImage();
            }
        });
        this.printToolItem = new ToolItem(this.fileToolBar, 0);
        this.printToolItem.setToolTipText(Messages.getString("GDE_MSGT0074"));
        this.printToolItem.setImage(SWTResourceManager.getImage("gde/resource/Print.gif"));
        this.printToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/PrintHot.gif"));
        this.printToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "printToolItem.widgetSelected, event=" + String.valueOf(evt));
                new PrintSelectionDialog(GDE.shell, 0).open();
            }
        });
        this.timeToolItem = new ToolItem(this.fileToolBar, 0);
        this.timeToolItem.setToolTipText(Messages.getString("GDE_MSGT0712"));
        this.timeToolItem.setImage(SWTResourceManager.getImage("gde/resource/Time.gif"));
        this.timeToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/TimeHot.gif"));
        this.timeToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "timeToolItem.widgetSelected, event=" + String.valueOf(evt));
                new TimeSetDialog(GDE.shell, 0).open(new Date().getTime());
            }
        });
        this.fileToolBar.pack();
        this.toolSize = this.fileToolBar.getSize();
        this.fileCoolItem.setControl((Control)this.fileToolBar);
        this.fileCoolItem.setSize(this.toolSize.x, this.toolSize.y);
        this.fileCoolItem.setMinimumSize(this.toolSize.x, this.toolSize.y);
        this.toolBarSizes.append(this.toolSize.x).append(":").append(this.toolSize.y).append(";");
        this.deviceObjectCoolItem = new CoolItem(this.coolBar, 0);
        this.deviceObjectToolBar = new ToolBar((Composite)this.coolBar, 0);
        this.deviceObjectToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.deviceObjectCoolItem.setControl((Control)this.deviceObjectToolBar);
        this.deviceSelectToolItem = new ToolItem(this.deviceObjectToolBar, 0);
        this.deviceSelectToolItem.setToolTipText(Messages.getString("GDE_MSGT0057"));
        this.deviceSelectToolItem.setImage(SWTResourceManager.getImage("gde/resource/DeviceSelection.gif"));
        this.deviceSelectToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/DeviceSelectionHot.gif"));
        this.deviceSelectToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "deviceToolItem.widgetSelected, event=" + String.valueOf(evt));
                DeviceSelectionDialog deviceSelection = MenuToolBar.this.application.getDeviceSelectionDialog();
                if (deviceSelection.checkDataSaved()) {
                    deviceSelection.open();
                }
            }
        });
        this.prevDeviceToolItem = new ToolItem(this.deviceObjectToolBar, 0);
        this.prevDeviceToolItem.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldLeft.gif"));
        this.prevDeviceToolItem.setToolTipText(Messages.getString("GDE_MSGT0058"));
        this.prevDeviceToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldLefHot.gif"));
        this.prevDeviceToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "prevDeviceToolItem.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.application.getActiveDevice() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() != null && !MenuToolBar.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                    DeviceSelectionDialog deviceSelect = MenuToolBar.this.application.getDeviceSelectionDialog();
                    if (deviceSelect.checkDataSaved()) {
                        int selection = deviceSelect.getDeviceConfigurations().indexOf(deviceSelect.getActiveConfig().getName());
                        int tmpSize = deviceSelect.getNumberOfActiveDevices();
                        DeviceConfiguration deviceConfig = selection > 0 && selection <= tmpSize ? deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(selection - 1)) : deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(tmpSize - 1));
                        if (MenuToolBar.this.application.getDeviceDialog() != null && !MenuToolBar.this.application.getDeviceDialog().isDisposed()) {
                            MenuToolBar.this.application.getDeviceDialog().dispose();
                        }
                        deviceSelect.setActiveConfig(deviceConfig);
                        deviceSelect.setupDevice();
                    }
                } else {
                    MenuToolBar.this.application.openMessageDialog(Messages.getString("GDE_MSGW0017"));
                }
            }
        });
        this.nextDeviceToolItem = new ToolItem(this.deviceObjectToolBar, 0);
        this.nextDeviceToolItem.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldRight.gif"));
        this.nextDeviceToolItem.setToolTipText(Messages.getString("GDE_MSGT0059"));
        this.nextDeviceToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldRightHot.gif"));
        this.nextDeviceToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "nextDeviceToolItem.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.application.getActiveDevice() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() != null && !MenuToolBar.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                    DeviceSelectionDialog deviceSelect = MenuToolBar.this.application.getDeviceSelectionDialog();
                    if (deviceSelect.checkDataSaved()) {
                        int selection = deviceSelect.getDeviceConfigurations().indexOf(deviceSelect.getActiveConfig().getName());
                        int tmpSize = deviceSelect.getNumberOfActiveDevices() - 1;
                        DeviceConfiguration deviceConfig = selection >= 0 && selection < tmpSize ? deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(selection + 1)) : deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(0));
                        if (MenuToolBar.this.application.getDeviceDialog() != null && !MenuToolBar.this.application.getDeviceDialog().isDisposed()) {
                            MenuToolBar.this.application.getDeviceDialog().dispose();
                        }
                        deviceSelect.setActiveConfig(deviceConfig);
                        deviceSelect.setupDevice();
                    }
                } else {
                    MenuToolBar.this.application.openMessageDialog(Messages.getString("GDE_MSGW0030"));
                }
            }
        });
        this.toolBoxToolItem = new ToolItem(this.deviceObjectToolBar, 0);
        this.toolBoxToolItem.setImage(SWTResourceManager.getImage("gde/resource/ToolBox.gif"));
        this.toolBoxToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/ToolBoxHot.gif"));
        this.toolBoxToolItem.setToolTipText(Messages.getString("GDE_MSGT0060"));
        this.toolBoxToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "toolBoxToolItem.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.application.getDeviceDialog() != null) {
                    if (MenuToolBar.this.application.getDeviceDialog().isDisposed()) {
                        MenuToolBar.this.application.getDeviceDialog().open();
                    } else {
                        MenuToolBar.this.application.getDeviceDialog().getDialogShell().setFocus();
                    }
                }
            }
        });
        ToolItem objectSelectComboSep = new ToolItem(this.deviceObjectToolBar, 2);
        this.objectSelectComposite = new Composite((Composite)this.deviceObjectToolBar, 0);
        this.objectSelectComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.objectSelectComposite.setLayout((Layout)comboCompositeLayout);
        this.objectSelectCombo = new CCombo(this.objectSelectComposite, 18440);
        this.objectSelectCombo.setLayoutData((Object)new RowData(200, this.comboHeight));
        this.objectSelectCombo.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 1, 0));
        this.objectSelectCombo.setItems(this.settings.getObjectList());
        this.objectSelectCombo.select(this.settings.getActiveObjectIndex());
        this.isObjectoriented = this.settings.getActiveObjectIndex() > 0;
        this.objectSelectCombo.setToolTipText(Messages.getString("GDE_MSGT0201"));
        this.objectSelectCombo.setEditable(false);
        this.objectSelectCombo.setBackground(this.application.COLOR_WHITE);
        this.objectSelectCombo.setForeground(this.application.COLOR_BLACK);
        this.objectSelectCombo.setVisibleItemCount(20);
        this.objectSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "objectSelectCombo.widgetSelected, event=" + String.valueOf(evt));
                String previousObjectKey = MenuToolBar.this.activeObjectKey;
                MenuToolBar.this.application.checkSaveObjectData();
                int selectionIndex = MenuToolBar.this.objectSelectCombo.getSelectionIndex();
                if (selectionIndex != 0) {
                    MenuToolBar.this.editObject.setEnabled(true);
                    MenuToolBar.this.deleteObject.setEnabled(true);
                    ObjectKeyCompliance.checkChannelForObjectKeyMissmatch(MenuToolBar.this.objectSelectCombo.getText());
                    MenuToolBar.this.isObjectoriented = true;
                    MenuToolBar.this.application.setObjectDescriptionTabVisible(true);
                    MenuToolBar.this.activeObjectKey = MenuToolBar.this.objectSelectCombo.getText();
                } else {
                    MenuToolBar.this.editObject.setEnabled(false);
                    MenuToolBar.this.deleteObject.setEnabled(false);
                    ObjectKeyCompliance.checkChannelForObjectKeyMissmatch("");
                    MenuToolBar.this.isObjectoriented = false;
                    MenuToolBar.this.application.setObjectDescriptionTabVisible(false);
                    MenuToolBar.this.activeObjectKey = "";
                }
                MenuToolBar.this.settings.setObjectList(MenuToolBar.this.objectSelectCombo.getItems(), selectionIndex);
                MenuToolBar.this.application.updateObjectDescriptionWindow();
                if (MenuToolBar.this.application.getActiveDevice() != null) {
                    MenuToolBar.this.application.updateTitleBar(MenuToolBar.this.activeObjectKey, MenuToolBar.this.application.getActiveDevice().getName(), MenuToolBar.this.application.getActiveDevice().getPort());
                }
                if (!previousObjectKey.equals(MenuToolBar.this.activeObjectKey)) {
                    MenuToolBar.this.application.getHistoExplorer().ifPresent(h -> h.resetHisto());
                }
            }
        });
        this.objectSelectCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                log.log(Level.FINEST, "recordSelectCombo.keyPressed, event=" + String.valueOf(evt));
                if (evt.character == '\r') {
                    MenuToolBar.this.objectSelectCombo.setEditable(false);
                    MenuToolBar.this.deviceObjectToolBar.setFocus();
                    String newObjKey = MenuToolBar.this.objectSelectCombo.getText();
                    log.log(Level.FINE, "newObjKey = " + newObjKey);
                    boolean isEditMode = MenuToolBar.this.editObject.getSelection();
                    MenuToolBar.this.processNewOrChangedObjectKey(newObjKey, isEditMode);
                    MenuToolBar.this.oldObjectKey = null;
                    MenuToolBar.this.newObject.setSelection(false);
                    MenuToolBar.this.editObject.setSelection(false);
                    MenuToolBar.this.activeObjectKey = MenuToolBar.this.objectSelectCombo.getText();
                    MenuToolBar.this.application.updateTitleBar(MenuToolBar.this.activeObjectKey, MenuToolBar.this.application.getActiveDevice().getName(), MenuToolBar.this.application.getActiveDevice().getPort());
                }
            }
        });
        this.objectSelectComposite.pack();
        objectSelectComboSep.setWidth(this.objectSelectComposite.getSize().x);
        objectSelectComboSep.setControl((Control)this.objectSelectComposite);
        this.newObject = new ToolItem(this.deviceObjectToolBar, 32);
        this.newObject.setImage(SWTResourceManager.getImage("gde/resource/NewObj.gif"));
        this.newObject.setToolTipText(Messages.getString("GDE_MSGT0202"));
        this.newObject.setHotImage(SWTResourceManager.getImage("gde/resource/NewObjHot.gif"));
        this.newObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "newObject.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.editObject.getSelection()) {
                    MenuToolBar.this.editObject.setSelection(false);
                    MenuToolBar.this.newObject.setSelection(false);
                    MenuToolBar.this.oldObjectKey = null;
                    MenuToolBar.this.objectSelectCombo.setItems(MenuToolBar.this.settings.getObjectList());
                    MenuToolBar.this.objectSelectCombo.select(MenuToolBar.this.isObjectoriented ? 1 : 0);
                    MenuToolBar.this.objectSelectCombo.setEditable(false);
                } else if (MenuToolBar.this.newObject.getSelection()) {
                    MenuToolBar.this.oldObjectKey = MenuToolBar.this.objectSelectCombo.getItems()[MenuToolBar.this.objectSelectCombo.getSelectionIndex()];
                    Vector<String> tmpObjects = new Vector<String>();
                    for (String tmpObject : MenuToolBar.this.settings.getObjectList()) {
                        tmpObjects.add(tmpObject);
                    }
                    tmpObjects.add("");
                    MenuToolBar.this.application.setObjectDescriptionTabVisible(true);
                    MenuToolBar.this.objectSelectCombo.setItems(tmpObjects.toArray(new String[1]));
                    MenuToolBar.this.objectSelectCombo.select(tmpObjects.size() - 1);
                    MenuToolBar.this.objectSelectCombo.setEditable(true);
                    MenuToolBar.this.objectSelectCombo.setFocus();
                } else {
                    MenuToolBar.this.objectSelectCombo.setEditable(false);
                    MenuToolBar.this.deviceObjectToolBar.setFocus();
                    String newObjKey = MenuToolBar.this.objectSelectCombo.getText();
                    log.log(Level.FINE, "newObjKey = " + newObjKey);
                    MenuToolBar.this.processNewOrChangedObjectKey(newObjKey, false);
                    MenuToolBar.this.oldObjectKey = null;
                    MenuToolBar.this.newObject.setSelection(false);
                    MenuToolBar.this.editObject.setSelection(false);
                    MenuToolBar.this.activeObjectKey = MenuToolBar.this.objectSelectCombo.getText();
                    MenuToolBar.this.application.updateTitleBar(MenuToolBar.this.activeObjectKey, MenuToolBar.this.application.getActiveDevice().getName(), MenuToolBar.this.application.getActiveDevice().getPort());
                }
            }
        });
        this.deleteObject = new ToolItem(this.deviceObjectToolBar, 0);
        this.deleteObject.setImage(SWTResourceManager.getImage("gde/resource/RemObj.gif"));
        this.deleteObject.setToolTipText(Messages.getString("GDE_MSGT0203"));
        this.deleteObject.setHotImage(SWTResourceManager.getImage("gde/resource/RemObjHot.gif"));
        if (this.objectSelectCombo.getItemCount() == 1) {
            this.deleteObject.setEnabled(false);
        }
        this.deleteObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "deleteObject.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.objectSelectCombo.getSelectionIndex() > 0 && 32 == MenuToolBar.this.application.openOkCancelMessageDialog(Messages.getString("GDE_MSGT0846"))) {
                    ObjectKeyCompliance.removeObjectKey(MenuToolBar.this.objectSelectCombo.getItems(), MenuToolBar.this.objectSelectCombo.getSelectionIndex());
                    MenuToolBar.this.setObjectListElements();
                    MenuToolBar.this.newObject.setSelection(false);
                    MenuToolBar.this.editObject.setSelection(false);
                    if (MenuToolBar.this.settings.getActiveObjectIndex() == 0) {
                        MenuToolBar.this.deleteObject.setEnabled(false);
                        MenuToolBar.this.editObject.setEnabled(false);
                    }
                    MenuToolBar.this.application.setObjectDescriptionTabVisible(MenuToolBar.this.isObjectoriented);
                    MenuToolBar.this.application.updateObjectDescriptionWindow();
                }
                MenuToolBar.this.application.updateTitleBar(MenuToolBar.this.getActiveObjectKey(), MenuToolBar.this.application.getActiveDevice().getName(), MenuToolBar.this.application.getActiveDevice().getPort());
            }
        });
        this.editObject = new ToolItem(this.deviceObjectToolBar, 32);
        this.editObject.setImage(SWTResourceManager.getImage("gde/resource/EditObj.gif"));
        this.editObject.setToolTipText(Messages.getString("GDE_MSGT0204"));
        this.editObject.setHotImage(SWTResourceManager.getImage("gde/resource/EditObjHot.gif"));
        if (this.objectSelectCombo.getItemCount() == 1) {
            this.editObject.setEnabled(false);
        }
        this.editObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "editObject.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.newObject.getSelection()) {
                    MenuToolBar.this.newObject.setSelection(false);
                    MenuToolBar.this.editObject.setSelection(false);
                    MenuToolBar.this.oldObjectKey = null;
                    MenuToolBar.this.objectSelectCombo.setItems(MenuToolBar.this.settings.getObjectList());
                    MenuToolBar.this.objectSelectCombo.select(MenuToolBar.this.isObjectoriented ? 1 : 0);
                    MenuToolBar.this.objectSelectCombo.setEditable(false);
                } else if (MenuToolBar.this.editObject.getSelection() && MenuToolBar.this.objectSelectCombo.getSelectionIndex() > 0) {
                    MenuToolBar.this.oldObjectKey = MenuToolBar.this.objectSelectCombo.getItems()[MenuToolBar.this.objectSelectCombo.getSelectionIndex()];
                    MenuToolBar.this.objectSelectCombo.setEditable(true);
                    MenuToolBar.this.objectSelectCombo.setFocus();
                } else {
                    MenuToolBar.this.objectSelectCombo.setEditable(false);
                    MenuToolBar.this.deviceObjectToolBar.setFocus();
                    String newObjKey = MenuToolBar.this.objectSelectCombo.getText();
                    log.log(Level.FINE, "newObjKey = " + newObjKey);
                    MenuToolBar.this.processNewOrChangedObjectKey(newObjKey, true);
                    MenuToolBar.this.oldObjectKey = null;
                    MenuToolBar.this.newObject.setSelection(false);
                    MenuToolBar.this.editObject.setSelection(false);
                    MenuToolBar.this.activeObjectKey = MenuToolBar.this.objectSelectCombo.getText();
                    MenuToolBar.this.application.updateTitleBar(MenuToolBar.this.activeObjectKey, MenuToolBar.this.application.getActiveDevice().getName(), MenuToolBar.this.application.getActiveDevice().getPort());
                }
            }
        });
        this.deviceObjectToolBar.pack();
        this.toolSize = this.deviceObjectToolBar.getSize();
        this.deviceObjectCoolItem.setControl((Control)this.deviceObjectToolBar);
        this.deviceObjectCoolItem.setSize(this.toolSize.x, this.toolSize.y);
        this.deviceObjectCoolItem.setMinimumSize(this.toolSize.x, this.toolSize.y);
        this.toolBarSizes.append(this.toolSize.x).append(":").append(this.toolSize.y).append(";");
        this.zoomCoolItem = new CoolItem(this.coolBar, 0);
        this.zoomToolBar = new ToolBar((Composite)this.coolBar, 0);
        this.zoomToolBar.setBackground(this.application.COLOR_BACKGROUND);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Border width = " + this.zoomToolBar.getBorderWidth());
        }
        this.zoomCoolItem.setControl((Control)this.zoomToolBar);
        this.zoomWindowItem = new ToolItem(this.zoomToolBar, 0);
        this.zoomWindowItem.setImage(SWTResourceManager.getImage("gde/resource/Zoom.gif"));
        this.zoomWindowItem.setHotImage(SWTResourceManager.getImage("gde/resource/ZoomHot.gif"));
        this.zoomWindowItem.setToolTipText(Messages.getString("GDE_MSGT0061"));
        this.zoomWindowItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "zoomWindowItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.ZOOM, true);
                MenuToolBar.this.scopePointsCombo.setEnabled(false);
            }
        });
        this.panItem = new ToolItem(this.zoomToolBar, 0);
        this.panItem.setImage(SWTResourceManager.getImage("gde/resource/Pan.gif"));
        this.panItem.setHotImage(SWTResourceManager.getImage("gde/resource/PanHot.gif"));
        this.panItem.setToolTipText(Messages.getString("GDE_MSGT0062"));
        this.panItem.setEnabled(false);
        this.panItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "resizeItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.PAN, true);
            }
        });
        this.cutLeftItem = new ToolItem(this.zoomToolBar, 0);
        this.cutLeftItem.setImage(SWTResourceManager.getImage("gde/resource/CutLeft.gif"));
        this.cutLeftItem.setToolTipText(Messages.getString("GDE_MSGT0063"));
        this.cutLeftItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "cutLeftItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.application.setCutModeActive(true, false);
            }
        });
        this.cutRightItem = new ToolItem(this.zoomToolBar, 0);
        this.cutRightItem.setImage(SWTResourceManager.getImage("gde/resource/CutRight.gif"));
        this.cutRightItem.setToolTipText(Messages.getString("GDE_MSGT0064"));
        this.cutRightItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "cutRightItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.application.setCutModeActive(false, true);
            }
        });
        this.fitIntoItem = new ToolItem(this.zoomToolBar, 0);
        this.fitIntoItem.setImage(SWTResourceManager.getImage("gde/resource/Expand.gif"));
        this.fitIntoItem.setHotImage(SWTResourceManager.getImage("gde/resource/ExpandHot.gif"));
        this.fitIntoItem.setToolTipText(Messages.getString("GDE_MSGT0065"));
        this.fitIntoItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "fitIntoItem.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.RESET, false);
            }
        });
        this.scopePointsComboSep = new ToolItem(this.zoomToolBar, 2);
        this.scopePointsComposite = new Composite((Composite)this.zoomToolBar, 0);
        this.scopePointsComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.scopePointsComposite.setLayout((Layout)comboCompositeLayout);
        this.scopePointsCombo = new CCombo(this.scopePointsComposite, 18440);
        this.scopePointsCombo.setLayoutData((Object)new RowData(GDE.IS_LINUX ? 80 : 60, this.comboHeight));
        this.scopePointsCombo.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 1, 0));
        this.scopePointsCombo.setItems(this.SCOPE_VALUES);
        this.scopePointsCombo.setBackground(this.application.COLOR_WHITE);
        this.scopePointsCombo.setForeground(this.application.COLOR_BLACK);
        this.scopePointsCombo.select(0);
        this.scopePointsCombo.setToolTipText(Messages.getString("GDE_MSGT0072"));
        this.scopePointsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "scopePointsCombo.widgetSelected, event=" + String.valueOf(evt));
                try {
                    Integer.valueOf(MenuToolBar.this.scopePointsCombo.getText().trim());
                    MenuToolBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.SCOPE, true);
                    MenuToolBar.this.zoomWindowItem.setEnabled(false);
                }
                catch (Exception e) {
                    MenuToolBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.RESET, false);
                }
            }
        });
        this.scopePointsComposite.pack();
        this.scopePointsComboSep.setWidth(this.scopePointsComposite.getSize().x);
        this.scopePointsComboSep.setControl((Control)this.scopePointsComposite);
        this.zoomToolBar.pack();
        this.toolSize = this.zoomToolBar.getSize();
        log.log(Level.FINE, "zoomToolBar.size = " + String.valueOf(this.toolSize));
        this.zoomCoolItem.setControl((Control)this.zoomToolBar);
        this.zoomCoolItem.setSize(this.toolSize.x, this.toolSize.y);
        this.zoomCoolItem.setMinimumSize(this.toolSize.x, this.toolSize.y);
        this.toolBarSizes.append(this.toolSize.x).append(":").append(this.toolSize.y).append(";");
        this.portCoolItem = new CoolItem(this.coolBar, 0);
        this.portToolBar = new ToolBar((Composite)this.coolBar, 0);
        this.portToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.portCoolItem.setControl((Control)this.portToolBar);
        this.portOpenCloseItem = new ToolItem(this.portToolBar, 0);
        this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0066"));
        this.portOpenCloseItem.setImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortOpen.gif"));
        this.portOpenCloseItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortOpenDisabled.gif"));
        this.portOpenCloseItem.setHotImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortOpenHot.gif"));
        this.portOpenCloseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "portOpenCloseItem.widgetSelected, event=" + String.valueOf(evt));
                IDevice activeDevice = MenuToolBar.this.application.getActiveDevice();
                if (activeDevice != null) {
                    activeDevice.open_closeCommPort();
                    if (activeDevice.getCommunicationPort() != null) {
                        if (activeDevice.getCommunicationPort().isConnected()) {
                            MenuToolBar.this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0067"));
                        } else {
                            MenuToolBar.this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0066"));
                            if (MenuToolBar.this.application.getTabSelectionIndex() >= 7) {
                                MenuToolBar.this.application.selectTab(c -> c instanceof GraphicsWindow && ((GraphicsWindow)((Object)c)).getGraphicsType().equals((Object)GraphicsWindow.GraphicsType.NORMAL));
                            }
                        }
                    }
                }
            }
        });
        this.portToolBar.pack();
        this.toolSize = this.portToolBar.getSize();
        log.log(Level.FINE, "portToolBar.size = " + String.valueOf(this.toolSize));
        this.portCoolItem.setControl((Control)this.portToolBar);
        this.portCoolItem.setSize(this.toolSize.x, this.toolSize.y);
        this.portCoolItem.setMinimumSize(this.toolSize.x, this.toolSize.y);
        this.toolBarSizes.append(this.toolSize.x).append(":").append(this.toolSize.y).append(";");
        this.dataCoolItem = new CoolItem(this.coolBar, 0);
        this.dataToolBar = new ToolBar((Composite)this.coolBar, 0);
        this.dataToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.dataCoolItem.setControl((Control)this.dataToolBar);
        ToolItem channelSelectComboSep = new ToolItem(this.dataToolBar, 2);
        this.channelSelectComposite = new Composite((Composite)this.dataToolBar, 0);
        this.channelSelectComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.channelSelectComposite.setLayout((Layout)comboCompositeLayout);
        this.channelSelectCombo = new CCombo(this.channelSelectComposite, 18440);
        this.channelSelectCombo.setLayoutData((Object)new RowData(185, this.comboHeight));
        this.channelSelectCombo.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 1, 0));
        this.channelSelectCombo.select(0);
        this.channelSelectCombo.setToolTipText(Messages.getString("GDE_MSGT0075"));
        this.channelSelectCombo.setEditable(false);
        this.channelSelectCombo.setVisibleItemCount(10);
        this.channelSelectCombo.setBackground(this.application.COLOR_WHITE);
        this.channelSelectCombo.setForeground(this.application.COLOR_BLACK);
        this.channelSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "kanalCombo.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.channels.switchChannel(MenuToolBar.this.channelSelectCombo.getText());
            }
        });
        this.channelSelectComposite.pack();
        channelSelectComboSep.setWidth(this.channelSelectComposite.getSize().x);
        channelSelectComboSep.setControl((Control)this.channelSelectComposite);
        this.prevChannel = new ToolItem(this.dataToolBar, 0);
        this.prevChannel.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldLeft.gif"));
        this.prevChannel.setToolTipText(Messages.getString("GDE_MSGT0076"));
        this.prevChannel.setEnabled(false);
        this.prevChannel.setHotImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldLefHot.gif"));
        this.prevChannel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "prevChannel.widgetSelected, event=" + String.valueOf(evt));
                int selectionIndex = MenuToolBar.this.channelSelectCombo.getSelectionIndex();
                if (selectionIndex > 0) {
                    MenuToolBar.this.channelSelectCombo.select(selectionIndex - 1);
                }
                if (selectionIndex == 1) {
                    MenuToolBar.this.prevChannel.setEnabled(false);
                }
                MenuToolBar.this.nextChannel.setEnabled(true);
                MenuToolBar.this.channels.switchChannel(MenuToolBar.this.channelSelectCombo.getText());
            }
        });
        this.nextChannel = new ToolItem(this.dataToolBar, 0);
        this.nextChannel.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldRight.gif"));
        this.nextChannel.setToolTipText(Messages.getString("GDE_MSGT0077"));
        this.nextChannel.setEnabled(false);
        this.nextChannel.setHotImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldRightHot.gif"));
        this.nextChannel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "nextChannel.widgetSelected, event=" + String.valueOf(evt));
                int selectionIndex = MenuToolBar.this.channelSelectCombo.getSelectionIndex();
                int maxIndex = MenuToolBar.this.channelSelectCombo.getItemCount() - 1;
                if (maxIndex <= 0) {
                    MenuToolBar.this.nextChannel.setEnabled(false);
                    MenuToolBar.this.prevChannel.setEnabled(false);
                } else {
                    if (selectionIndex < maxIndex) {
                        MenuToolBar.this.channelSelectCombo.select(selectionIndex + 1);
                    }
                    if (selectionIndex == maxIndex - 1) {
                        MenuToolBar.this.nextChannel.setEnabled(false);
                    }
                    MenuToolBar.this.prevChannel.setEnabled(true);
                }
                MenuToolBar.this.channels.switchChannel(MenuToolBar.this.channelSelectCombo.getText());
            }
        });
        ToolItem recordSelectComboSep = new ToolItem(this.dataToolBar, 2);
        this.recordSelectComposite = new Composite((Composite)this.dataToolBar, 0);
        this.recordSelectComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.recordSelectComposite.setLayout((Layout)comboCompositeLayout);
        this.recordSelectCombo = new CCombo(this.recordSelectComposite, 18432);
        this.recordSelectCombo.setLayoutData((Object)new RowData(260, this.comboHeight));
        this.recordSelectCombo.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 1, 0));
        this.recordSelectCombo.setItems(new String[]{" "});
        this.recordSelectCombo.setToolTipText(Messages.getString("GDE_MSGT0078"));
        this.recordSelectCombo.setTextLimit(40);
        this.recordSelectCombo.setVisibleItemCount(20);
        this.recordSelectCombo.setEditable(false);
        this.recordSelectCombo.setBackground(this.application.COLOR_WHITE);
        this.recordSelectCombo.setForeground(this.application.COLOR_BLACK);
        this.recordSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "recordSelectCombo.widgetSelected, event=" + String.valueOf(evt));
                Channel activeChannel = MenuToolBar.this.channels.getActiveChannel();
                if (activeChannel != null) {
                    activeChannel.switchRecordSet(MenuToolBar.this.recordSelectCombo.getText());
                }
            }
        });
        this.recordSelectCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                Channel activeChannel;
                log.log(Level.FINEST, "recordSelectCombo.keyPressed, event=" + String.valueOf(evt));
                if (evt.character == '\r' && (activeChannel = MenuToolBar.this.channels.getActiveChannel()) != null) {
                    String oldRecordSetName = activeChannel.getActiveRecordSet().getName();
                    String newRecordSetName = MenuToolBar.this.recordSelectCombo.getText();
                    log.log(Level.FINE, "newRecordSetName = " + newRecordSetName);
                    String[] recordSetNames = MenuToolBar.this.recordSelectCombo.getItems();
                    for (int i = 0; i < recordSetNames.length; ++i) {
                        if (!recordSetNames[i].equals(oldRecordSetName)) continue;
                        recordSetNames[i] = newRecordSetName;
                    }
                    MenuToolBar.this.recordSelectCombo.setItems(recordSetNames);
                    RecordSet recordSet = (RecordSet)MenuToolBar.this.channels.getActiveChannel().get(oldRecordSetName);
                    recordSet.setName(newRecordSetName);
                    recordSet.setUnsaved(RecordSet.UNSAVED_REASON_DATA);
                    activeChannel.put(newRecordSetName, recordSet);
                    activeChannel.remove(oldRecordSetName);
                    activeChannel.getRecordSetNames();
                    MenuToolBar.this.channels.getActiveChannel().switchRecordSet(newRecordSetName);
                }
            }
        });
        this.recordSelectComposite.pack();
        recordSelectComboSep.setWidth(this.recordSelectComposite.getSize().x);
        recordSelectComboSep.setControl((Control)this.recordSelectComposite);
        this.prevRecord = new ToolItem(this.dataToolBar, 0);
        this.prevRecord.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldLeft.gif"));
        this.prevRecord.setToolTipText(Messages.getString("GDE_MSGT0079"));
        this.prevRecord.setEnabled(false);
        this.prevRecord.setHotImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldLefHot.gif"));
        this.prevRecord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "prevRecord.widgetSelected, event=" + String.valueOf(evt));
                int selectionIndex = MenuToolBar.this.recordSelectCombo.getSelectionIndex();
                if (selectionIndex > 0) {
                    MenuToolBar.this.recordSelectCombo.select(selectionIndex - 1);
                }
                if (selectionIndex == 1) {
                    MenuToolBar.this.prevRecord.setEnabled(false);
                }
                MenuToolBar.this.nextRecord.setEnabled(true);
                MenuToolBar.this.channels.getActiveChannel().switchRecordSet(MenuToolBar.this.recordSelectCombo.getText());
            }
        });
        this.nextRecord = new ToolItem(this.dataToolBar, 0);
        this.nextRecord.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldRight.gif"));
        this.nextRecord.setToolTipText(Messages.getString("GDE_MSGT0080"));
        this.nextRecord.setEnabled(false);
        this.nextRecord.setHotImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldRightHot.gif"));
        this.nextRecord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "nextRecord.widgetSelected, event=" + String.valueOf(evt));
                int selectionIndex = MenuToolBar.this.recordSelectCombo.getSelectionIndex();
                int maxIndex = MenuToolBar.this.recordSelectCombo.getItemCount() - 1;
                if (maxIndex <= 0) {
                    MenuToolBar.this.nextRecord.setEnabled(false);
                    MenuToolBar.this.prevRecord.setEnabled(false);
                } else {
                    if (selectionIndex < maxIndex) {
                        MenuToolBar.this.recordSelectCombo.select(selectionIndex + 1);
                    }
                    if (selectionIndex == maxIndex - 1) {
                        MenuToolBar.this.nextRecord.setEnabled(false);
                    }
                    MenuToolBar.this.prevRecord.setEnabled(true);
                }
                MenuToolBar.this.channels.getActiveChannel().switchRecordSet(MenuToolBar.this.recordSelectCombo.getText());
            }
        });
        this.separator = new ToolItem(this.dataToolBar, 2);
        this.deleteRecord = new ToolItem(this.dataToolBar, 0);
        this.deleteRecord.setImage(SWTResourceManager.getImage("gde/resource/Delete.gif"));
        this.deleteRecord.setToolTipText(Messages.getString("GDE_MSGT0081"));
        this.deleteRecord.setHotImage(SWTResourceManager.getImage("gde/resource/DeleteHot.gif"));
        this.deleteRecord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RecordSet recordSet;
                log.log(Level.FINEST, "deleteRecord.widgetSelected, event=" + String.valueOf(evt));
                Channel activeChannel = MenuToolBar.this.channels.getActiveChannel();
                if (activeChannel != null && (recordSet = activeChannel.getActiveRecordSet()) != null) {
                    String deleteRecordSetName = recordSet.getName();
                    String newRecorKey = null;
                    int selectionIndex = MenuToolBar.this.recordSelectCombo.getSelectionIndex();
                    if (selectionIndex - 1 > 0) {
                        newRecorKey = MenuToolBar.this.recordSelectCombo.getItem(selectionIndex - 1);
                    } else if (selectionIndex - 1 == 0 && MenuToolBar.this.recordSelectCombo.getItemCount() > 2) {
                        newRecorKey = MenuToolBar.this.recordSelectCombo.getItem(selectionIndex + 1);
                    }
                    if (newRecorKey != null) {
                        activeChannel.setActiveRecordSet(newRecorKey);
                    }
                    ((RecordSet)activeChannel.get(deleteRecordSetName)).clear();
                    activeChannel.remove(deleteRecordSetName);
                    log.log(Level.FINE, "deleted " + deleteRecordSetName);
                    String[] recordSetNames = MenuToolBar.this.updateRecordSetSelectCombo();
                    if (recordSetNames.length > 0 && recordSetNames[0] != null && recordSetNames[0].length() > 1) {
                        activeChannel.switchRecordSet(recordSetNames[0]);
                    } else {
                        MenuToolBar.this.application.cleanHeaderAndCommentInGraphicsWindow();
                        MenuToolBar.this.application.updateAllTabs(true);
                    }
                }
            }
        });
        this.editRecord = new ToolItem(this.dataToolBar, 0);
        this.editRecord.setImage(SWTResourceManager.getImage("gde/resource/Edit.gif"));
        this.editRecord.setToolTipText(Messages.getString("GDE_MSGT0082"));
        this.editRecord.setHotImage(SWTResourceManager.getImage("gde/resource/EditHot.gif"));
        this.editRecord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "editAufnahme.widgetSelected, event=" + String.valueOf(evt));
                MenuToolBar.this.recordSelectCombo.setEditable(true);
                MenuToolBar.this.recordSelectCombo.setFocus();
            }
        });
        this.dataToolBar.pack();
        this.toolSize = this.dataToolBar.getSize();
        log.log(Level.FINE, "dataToolBar.size = " + String.valueOf(this.toolSize));
        this.dataCoolItem.setControl((Control)this.dataToolBar);
        this.dataCoolItem.setSize(this.toolSize.x, this.toolSize.y);
        this.dataCoolItem.setMinimumSize(this.toolSize.x, this.toolSize.y);
        this.toolBarSizes.append(this.toolSize.x).append(":").append(this.toolSize.y).append(";");
        this.googleEarthCoolItem = new CoolItem(this.coolBar, 0);
        this.googleEarthToolBar = new ToolBar((Composite)this.coolBar, 0);
        this.googleEarthToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.googleEarthCoolItem.setControl((Control)this.googleEarthToolBar);
        this.googleEarthToolItem = new ToolItem(this.googleEarthToolBar, 0);
        this.googleEarthToolItem.setToolTipText(Messages.getString("GDE_MSGT0229"));
        this.googleEarthToolItem.setImage(SWTResourceManager.getImage("gde/resource/Earth.gif"));
        this.googleEarthToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/EarthHot.gif"));
        this.googleEarthToolItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/EarthDisabled.gif"));
        this.googleEarthToolItem.setEnabled(false);
        this.googleEarthToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "googleEarthToolItem.widgetSelected, event=" + String.valueOf(evt));
                OperatingSystemHelper.launchGoogleEarth(MenuToolBar.this.application.getActiveDevice());
            }
        });
        this.googleEarthConfigToolItem = new ToolItem(this.googleEarthToolBar, 0);
        this.googleEarthConfigToolItem.setToolTipText(Messages.getString("GDE_MSGT0281"));
        this.googleEarthConfigToolItem.setImage(SWTResourceManager.getImage("gde/resource/EarthConfig.gif"));
        this.googleEarthConfigToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/EarthConfigHot.gif"));
        this.googleEarthConfigToolItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/EarthConfigDisabled.gif"));
        this.googleEarthConfigToolItem.setEnabled(false);
        this.googleEarthConfigToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "googleEarthConfigToolItem.widgetSelected, event=" + String.valueOf(evt));
                new GoogleEarthCustomizingDialog(MenuToolBar.this.application.getShell(), 34912).open();
            }
        });
        this.googleEarthToolBar.pack();
        this.toolSize = this.googleEarthToolBar.getSize();
        this.googleEarthCoolItem.setControl((Control)this.googleEarthToolBar);
        this.googleEarthCoolItem.setSize(this.toolSize.x, this.toolSize.y);
        this.googleEarthCoolItem.setMinimumSize(this.toolSize.x, this.toolSize.y);
        this.toolBarSizes.append(this.toolSize.x).append(":").append(this.toolSize.y).append(";");
        this.helpCoolItem = new CoolItem(this.coolBar, 0);
        this.helpToolBar = new ToolBar((Composite)this.coolBar, 0);
        this.helpToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.helpCoolItem.setControl((Control)this.helpToolBar);
        this.helpToolItem = new ToolItem(this.helpToolBar, 0);
        this.helpToolItem.setToolTipText(Messages.getString("GDE_MSGT0228"));
        this.helpToolItem.setImage(SWTResourceManager.getImage("gde/resource/Question.gif"));
        this.helpToolItem.setHotImage(SWTResourceManager.getImage("gde/resource/QuestionHot.gif"));
        this.helpToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "helpToolItem.widgetSelected, event=" + String.valueOf(evt));
                if (MenuToolBar.this.application.getActiveDevice().getDialog() != null && !MenuToolBar.this.application.getActiveDevice().getDialog().isDisposed()) {
                    MenuToolBar.this.application.getActiveDevice().getDialog().getDialogShell().notifyListeners(28, new Event());
                } else {
                    for (CTabItem tabItem : MenuToolBar.this.application.getTabFolder().getItems()) {
                        if (tabItem.isDisposed() || !tabItem.getControl().isVisible()) continue;
                        if (tabItem.getControl().isListening(28)) {
                            tabItem.getControl().notifyListeners(28, new Event());
                            break;
                        }
                        if (tabItem instanceof GraphicsWindow) {
                            ((GraphicsWindow)tabItem).getGraphicsComposite().notifyListeners(28, new Event());
                            continue;
                        }
                        if (!tabItem.getText().endsWith("Tool") || MenuToolBar.this.application.getActiveDevice() == null || !MenuToolBar.this.application.getActiveDevice().isUtilityDeviceTabRequested()) continue;
                        try {
                            MenuToolBar.this.application.openHelpDialog(FileUtils.getJarFileNameOfDevice(MenuToolBar.this.application.getActiveDevice().getDeviceConfiguration()), "HelpInfo.html");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.helpToolBar.pack();
        this.toolSize = this.helpToolBar.getSize();
        this.helpCoolItem.setControl((Control)this.helpToolBar);
        this.helpCoolItem.setSize(this.toolSize.x, this.toolSize.y);
        this.helpCoolItem.setMinimumSize(this.toolSize.x, this.toolSize.y);
        this.toolBarSizes.append(this.toolSize.x).append(":").append(this.toolSize.y).append(";");
        this.deviceObjectToolBar.setFocus();
        if (GDE.IS_MAC && GDE.IS_ARCH_DATA_MODEL_64 && this.settings.isMacTouchbarEnabled()) {
            try {
                this.createTouchBar();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createTouchBar() throws IOException {
        JTouchBar jTouchBar = new JTouchBar();
        jTouchBar.setCustomizationIdentifier("GDE_TouchBar");
        jTouchBar.addItem(new TouchBarItem("NSTouchBarItemIdentifierFlexibleSpace"));
        TouchBarButton touchBarButtonNew = new TouchBarButton();
        touchBarButtonNew.setAlternatTitle("New");
        touchBarButtonNew.setAction(new TouchBarViewAction(){

            public void onCall(TouchBarView view) {
                if (MenuToolBar.this.application.getDeviceSelectionDialog().checkDataSaved()) {
                    MenuToolBar.this.application.getDeviceSelectionDialog().setupDataChannels(MenuToolBar.this.application.getActiveDevice());
                }
            }
        });
        Image newImg = new Image(GDE.class.getClassLoader().getResourceAsStream("gde/resource/New.gif"));
        touchBarButtonNew.setImage(newImg);
        jTouchBar.addItem(new TouchBarItem("New", (TouchBarView)touchBarButtonNew, true));
        TouchBarButton touchBarButtonOpen = new TouchBarButton();
        touchBarButtonOpen.setAlternatTitle("Open");
        touchBarButtonOpen.setAction(new TouchBarViewAction(this){

            public void onCall(TouchBarView view) {
                new FileHandler().openFileDialog(Messages.getString("GDE_MSGT0004"));
            }
        });
        Image open = new Image(GDE.class.getClassLoader().getResourceAsStream("gde/resource/Open.gif"));
        touchBarButtonOpen.setImage(open);
        jTouchBar.addItem(new TouchBarItem("Open", (TouchBarView)touchBarButtonOpen, true));
        this.touchBarButtonImport = new TouchBarButton();
        this.touchBarButtonImport.setAlternatTitle("Import");
        this.touchBarButtonImport.setAction(new TouchBarViewAction(){

            public void onCall(TouchBarView view) {
                IDevice activeDevice = MenuToolBar.this.application.getActiveDevice();
                if (activeDevice != null) {
                    activeDevice.open_closeCommPort();
                    if (activeDevice.getCommunicationPort() != null) {
                        if (activeDevice.getCommunicationPort().isConnected()) {
                            MenuToolBar.this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0067"));
                        } else {
                            MenuToolBar.this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0066"));
                            if (MenuToolBar.this.application.getTabSelectionIndex() >= 7) {
                                MenuToolBar.this.application.selectTab(c -> c instanceof GraphicsWindow && ((GraphicsWindow)((Object)c)).getGraphicsType().equals((Object)GraphicsWindow.GraphicsType.NORMAL));
                            }
                        }
                    }
                }
            }
        });
        this.updateTouchBarImportButton("gde/resource/" + this.colorSchemaType + this.language + "/PortCloseHot.gif");
        jTouchBar.addItem(new TouchBarItem("Import", (TouchBarView)this.touchBarButtonImport, true));
        TouchBarButton touchBarButtonSave = new TouchBarButton();
        touchBarButtonSave.setAlternatTitle("Save");
        touchBarButtonSave.setAction(new TouchBarViewAction(this){

            public void onCall(TouchBarView view) {
                Channel activeChannel = Channels.getInstance().getActiveChannel();
                if (activeChannel != null) {
                    if (!activeChannel.isSaved()) {
                        new FileHandler().saveOsdFile(Messages.getString("GDE_MSGT0006"), "");
                    } else {
                        new FileHandler().saveOsdFile(Messages.getString("GDE_MSGT0007"), activeChannel.getFileName());
                    }
                }
            }
        });
        Image save = new Image(GDE.class.getClassLoader().getResourceAsStream("gde/resource/Save.gif"));
        touchBarButtonSave.setImage(save);
        jTouchBar.addItem(new TouchBarItem("Save", (TouchBarView)touchBarButtonSave, true));
        TouchBarButton touchBarButtonCopy = new TouchBarButton();
        touchBarButtonCopy.setAlternatTitle("Copy");
        touchBarButtonCopy.setAction(new TouchBarViewAction(){

            public void onCall(TouchBarView view) {
                MenuToolBar.this.application.copyTabContentAsImage();
            }
        });
        Image copy = new Image(GDE.class.getClassLoader().getResourceAsStream("gde/resource/Copy.gif"));
        touchBarButtonCopy.setImage(copy);
        jTouchBar.addItem(new TouchBarItem("Copy", (TouchBarView)touchBarButtonCopy, true));
        TouchBarButton touchBarButtonPrev = new TouchBarButton();
        touchBarButtonPrev.setAlternatTitle("Prev");
        touchBarButtonPrev.setAction(new TouchBarViewAction(){

            public void onCall(TouchBarView view) {
                if (MenuToolBar.this.application.getActiveDevice() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() != null && !MenuToolBar.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                    DeviceSelectionDialog deviceSelect = MenuToolBar.this.application.getDeviceSelectionDialog();
                    if (deviceSelect.checkDataSaved()) {
                        int selection = deviceSelect.getDeviceConfigurations().indexOf(deviceSelect.getActiveConfig().getName());
                        int tmpSize = deviceSelect.getNumberOfActiveDevices();
                        DeviceConfiguration deviceConfig = selection > 0 && selection <= tmpSize ? deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(selection - 1)) : deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(tmpSize - 1));
                        if (MenuToolBar.this.application.getDeviceDialog() != null && !MenuToolBar.this.application.getDeviceDialog().isDisposed()) {
                            MenuToolBar.this.application.getDeviceDialog().dispose();
                        }
                        deviceSelect.setActiveConfig(deviceConfig);
                        deviceSelect.setupDevice();
                    }
                } else {
                    MenuToolBar.this.application.openMessageDialog(Messages.getString("GDE_MSGW0017"));
                }
            }
        });
        Image back = new Image(GDE.class.getClassLoader().getResourceAsStream("gde/resource/ArrowWhiteGreenFieldLeft.gif"));
        touchBarButtonPrev.setImage(back);
        jTouchBar.addItem(new TouchBarItem("Prev", (TouchBarView)touchBarButtonPrev, true));
        TouchBarButton touchBarButtonNext = new TouchBarButton();
        touchBarButtonNext.setAlternatTitle("Next");
        touchBarButtonNext.setAction(new TouchBarViewAction(){

            public void onCall(TouchBarView view) {
                if (MenuToolBar.this.application.getActiveDevice() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() == null || MenuToolBar.this.application.getActiveDevice() != null && MenuToolBar.this.application.getActiveDevice().getCommunicationPort() != null && !MenuToolBar.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                    DeviceSelectionDialog deviceSelect = MenuToolBar.this.application.getDeviceSelectionDialog();
                    if (deviceSelect.checkDataSaved()) {
                        int selection = deviceSelect.getDeviceConfigurations().indexOf(deviceSelect.getActiveConfig().getName());
                        int tmpSize = deviceSelect.getNumberOfActiveDevices() - 1;
                        DeviceConfiguration deviceConfig = selection >= 0 && selection < tmpSize ? deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(selection + 1)) : deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(0));
                        if (MenuToolBar.this.application.getDeviceDialog() != null && !MenuToolBar.this.application.getDeviceDialog().isDisposed()) {
                            MenuToolBar.this.application.getDeviceDialog().dispose();
                        }
                        deviceSelect.setActiveConfig(deviceConfig);
                        deviceSelect.setupDevice();
                    }
                } else {
                    MenuToolBar.this.application.openMessageDialog(Messages.getString("GDE_MSGW0030"));
                }
            }
        });
        Image next = new Image(GDE.class.getClassLoader().getResourceAsStream("gde/resource/ArrowWhiteGreenFieldRight.gif"));
        touchBarButtonNext.setImage(next);
        jTouchBar.addItem(new TouchBarItem("Next", (TouchBarView)touchBarButtonNext, true));
        JTouchBarSWT.show((JTouchBar)jTouchBar, (Shell)GDE.shell);
    }

    public void addRecordSetName(String newRecordSetName) {
        final String recordSetKey = newRecordSetName;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Vector<String> newRecordSetItems = new Vector<String>(MenuToolBar.this.recordSelectCombo.getItems().length);
                String[] recordSetNames = MenuToolBar.this.recordSelectCombo.getItems();
                int index = MenuToolBar.this.recordSelectCombo.getSelectionIndex();
                for (String element : recordSetNames) {
                    if (element.length() <= 3) continue;
                    newRecordSetItems.add(element);
                }
                newRecordSetItems.add(recordSetKey);
                MenuToolBar.this.recordSelectCombo.setItems(newRecordSetItems.toArray(new String[1]));
                MenuToolBar.this.recordSelectCombo.select(index);
                MenuToolBar.this.updateRecordSetSelectCombo();
                MenuToolBar.this.updateChannelToolItems();
            }
        });
    }

    public void updateChannelSelector() {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.doUpdateChannelSelector();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MenuToolBar.this.doUpdateChannelSelector();
                }
            });
        }
    }

    void doUpdateChannelSelector() {
        int activeChannelNumber = 0;
        if (this.channels.size() > 0) {
            String[] channelNames = new String[this.channels.size()];
            String activeChannelName = this.channels.getActiveChannel().getName();
            for (int i = 0; i < channelNames.length; ++i) {
                channelNames[i] = ((Channel)this.channels.get(i + 1)).getName();
                if (!channelNames[i].equals(activeChannelName)) continue;
                activeChannelNumber = i;
            }
            this.channels.setChannelNames(channelNames);
            this.channelSelectCombo.setItems(channelNames);
        } else {
            this.channelSelectCombo.setItems(new String[]{""});
        }
        this.channelSelectCombo.select(activeChannelNumber);
        this.updateChannelToolItems();
    }

    public String[] updateRecordSetSelectCombo() {
        final String[] recordSetNames = this.channels.getActiveChannel().getRecordSetNames();
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.doUpdateRecordSetSelectCombo(recordSetNames);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MenuToolBar.this.doUpdateRecordSetSelectCombo(recordSetNames);
                }
            });
        }
        return recordSetNames;
    }

    void doUpdateRecordSetSelectCombo(String[] recordSetNames) {
        if (recordSetNames != null && recordSetNames.length > 0 && recordSetNames[0] != null) {
            Channel activeChannel = this.channels.getActiveChannel();
            String activeRecord = activeChannel.getActiveRecordSet() != null ? activeChannel.getActiveRecordSet().getName() : recordSetNames[0];
            this.recordSelectCombo.setItems(recordSetNames);
            for (int i = 0; i < recordSetNames.length; ++i) {
                if (!recordSetNames[i].equals(activeRecord)) continue;
                this.recordSelectCombo.select(i);
            }
        } else {
            this.recordSelectCombo.setItems(new String[0]);
            this.recordSelectCombo.setText("");
        }
        this.updateRecordToolItems();
    }

    public void updateRecordToolItems() {
        if (this.recordSelectCombo.isEnabled()) {
            int numberRecords = this.channels.getActiveChannel().getRecordSetNames().length;
            if (numberRecords <= 1) {
                this.nextRecord.setEnabled(false);
                this.prevRecord.setEnabled(false);
            } else {
                int index = this.recordSelectCombo.getSelectionIndex();
                int maxIndex = this.recordSelectCombo.getItemCount() - 1;
                if (numberRecords == 2 && index == 0) {
                    this.nextRecord.setEnabled(true);
                    this.prevRecord.setEnabled(false);
                } else if (numberRecords == 2 && index == 1) {
                    this.nextRecord.setEnabled(false);
                    this.prevRecord.setEnabled(true);
                }
                if (numberRecords >= 2 && index == 0) {
                    this.nextRecord.setEnabled(true);
                    this.prevRecord.setEnabled(false);
                } else if (numberRecords >= 2 && index == maxIndex) {
                    this.nextRecord.setEnabled(false);
                    this.prevRecord.setEnabled(true);
                } else {
                    this.nextRecord.setEnabled(true);
                    this.prevRecord.setEnabled(true);
                }
            }
        }
    }

    void doUpdateChannelToolItems() {
        if (this.channelSelectCombo.isEnabled()) {
            int numberChannels = this.channels.size();
            if (numberChannels <= 1) {
                this.nextChannel.setEnabled(false);
                this.prevChannel.setEnabled(false);
            } else {
                int index = this.channelSelectCombo.getSelectionIndex();
                int maxIndex = this.channelSelectCombo.getItemCount() - 1;
                if (numberChannels == 2 && index == 0) {
                    this.nextChannel.setEnabled(true);
                    this.prevChannel.setEnabled(false);
                } else if (numberChannels == 2 && index == 1) {
                    this.nextChannel.setEnabled(false);
                    this.prevChannel.setEnabled(true);
                }
                if (numberChannels >= 2 && index == 0) {
                    this.nextChannel.setEnabled(true);
                    this.prevChannel.setEnabled(false);
                } else if (numberChannels >= 2 && index == maxIndex) {
                    this.nextChannel.setEnabled(false);
                    this.prevChannel.setEnabled(true);
                } else {
                    this.nextChannel.setEnabled(true);
                    this.prevChannel.setEnabled(true);
                }
            }
        }
        if (this.application.getActiveChannel() != null && this.application.getActiveChannel().getType() == ChannelTypes.TYPE_OUTLET) {
            this.updateObjectSelector();
        }
    }

    public void updateChannelToolItems() {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.doUpdateChannelToolItems();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MenuToolBar.this.doUpdateChannelToolItems();
                }
            });
        }
    }

    public void setPortConnected(boolean isPortOpen) {
        if (!this.application.isDisposed()) {
            this.colorSchemaType = this.settings.getColorSchemaType();
            switch (this.iconSet) {
                default: {
                    if (isPortOpen) {
                        this.portOpenCloseItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortCloseDisabled.gif"));
                        this.portOpenCloseItem.setHotImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortClose.gif"));
                        this.portOpenCloseItem.setImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortCloseHot.gif"));
                        if (this.toolTipOpen != null && this.toolTipOpen.length() > 5) {
                            this.portOpenCloseItem.setToolTipText(this.toolTipOpen);
                        } else {
                            this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0067"));
                        }
                        if (this.touchBarButtonImport == null) break;
                        this.updateTouchBarImportButton("gde/resource/" + this.colorSchemaType + this.language + "/PortCloseHot.gif");
                        break;
                    }
                    this.portOpenCloseItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortOpenDisabled.gif"));
                    this.portOpenCloseItem.setHotImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortOpenHot.gif"));
                    this.portOpenCloseItem.setImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/PortOpen.gif"));
                    if (this.toolTipClose != null && this.toolTipClose.length() > 5) {
                        this.portOpenCloseItem.setToolTipText(this.toolTipClose);
                    } else {
                        this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0066"));
                    }
                    if (this.touchBarButtonImport == null) break;
                    this.updateTouchBarImportButton("gde/resource/" + this.colorSchemaType + this.language + "/PortOpen.gif");
                    break;
                }
                case 1: {
                    if (isPortOpen) {
                        this.portOpenCloseItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/StopGatherDisabled.gif"));
                        this.portOpenCloseItem.setHotImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/StopGatherHot.gif"));
                        this.portOpenCloseItem.setImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/StopGather.gif"));
                        if (this.toolTipOpen != null && this.toolTipOpen.length() > 5) {
                            this.portOpenCloseItem.setToolTipText(this.toolTipOpen);
                        } else {
                            this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0069"));
                        }
                        if (this.touchBarButtonImport == null) break;
                        this.updateTouchBarImportButton("gde/resource/" + this.colorSchemaType + this.language + "/StopGather.gif");
                        break;
                    }
                    this.portOpenCloseItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/StartGatherDisabled.gif"));
                    this.portOpenCloseItem.setHotImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/StartGather.gif"));
                    this.portOpenCloseItem.setImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/StartGatherHot.gif"));
                    if (this.toolTipClose != null && this.toolTipClose.length() > 5) {
                        this.portOpenCloseItem.setToolTipText(this.toolTipClose);
                    } else {
                        this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0068"));
                    }
                    if (this.touchBarButtonImport == null) break;
                    this.updateTouchBarImportButton("gde/resource/" + this.colorSchemaType + this.language + "/StartGatherHot.gif");
                    break;
                }
                case 2: {
                    if (isPortOpen) {
                        this.portOpenCloseItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/ImportActiveDisabled.gif"));
                        this.portOpenCloseItem.setHotImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/ImportActiveHot.gif"));
                        this.portOpenCloseItem.setImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/ImportActive.gif"));
                        if (this.toolTipOpen != null && this.toolTipOpen.length() > 5) {
                            this.portOpenCloseItem.setToolTipText(this.toolTipOpen);
                        } else {
                            this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0223"));
                        }
                        if (this.touchBarButtonImport == null) break;
                        this.updateTouchBarImportButton("gde/resource/" + this.colorSchemaType + this.language + "/ImportActive.gif");
                        break;
                    }
                    this.portOpenCloseItem.setDisabledImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/ImportDataDisabled.gif"));
                    this.portOpenCloseItem.setHotImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/ImportData.gif"));
                    this.portOpenCloseItem.setImage(SWTResourceManager.getImage("gde/resource/" + this.colorSchemaType + this.language + "/ImportDataHot.gif"));
                    if (this.toolTipClose != null && this.toolTipClose.length() > 5) {
                        this.portOpenCloseItem.setToolTipText(this.toolTipClose);
                    } else {
                        this.portOpenCloseItem.setToolTipText(Messages.getString("GDE_MSGT0223"));
                    }
                    if (this.touchBarButtonImport == null) break;
                    this.updateTouchBarImportButton("gde/resource/" + this.colorSchemaType + this.language + "/ImportDataHot.gif");
                }
            }
        }
    }

    private void updateTouchBarImportButton(String imageUrl) {
        try {
            this.touchBarButtonImport.setImage(new Image(GDE.class.getClassLoader().getResourceAsStream(imageUrl)));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setSerialPortIconSet(int newIconSet, String newToolTipOpen, String newToolTipClose) {
        this.iconSet = newIconSet;
        if (newToolTipOpen != null) {
            this.toolTipOpen = newToolTipOpen;
        }
        if (newToolTipClose != null) {
            this.toolTipClose = newToolTipClose;
        }
        this.setPortConnected(false);
    }

    public CCombo getChannelSelectCombo() {
        return this.channelSelectCombo;
    }

    public CCombo getRecordSelectCombo() {
        return this.recordSelectCombo;
    }

    public void enableDeviceSwitchButtons(boolean enabled) {
        this.prevDeviceToolItem.setEnabled(enabled);
        this.nextDeviceToolItem.setEnabled(enabled);
        this.updateChannelSelector();
    }

    public void enableChannelActions(boolean enabled) {
        this.prevChannel.setEnabled(enabled);
        this.nextChannel.setEnabled(enabled);
        this.channelSelectCombo.setEnabled(enabled);
        this.updateChannelSelector();
    }

    public void enableRecordSetActions(boolean enabled) {
        this.prevRecord.setEnabled(enabled);
        this.nextRecord.setEnabled(enabled);
        this.deleteRecord.setEnabled(enabled);
        this.editRecord.setEnabled(enabled);
        this.recordSelectCombo.setEnabled(enabled);
        this.updateRecordSetSelectCombo();
    }

    public void enablePanButton(boolean enable) {
        this.panItem.setEnabled(enable);
    }

    public void enableCutButtons(boolean enableLeft, boolean enableRight) {
        this.cutLeftItem.setEnabled(enableLeft);
        this.cutRightItem.setEnabled(enableRight);
    }

    public int getScopeModeLevelValue() {
        int sizeLastPoints = -1;
        try {
            sizeLastPoints = Integer.valueOf(this.scopePointsCombo.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sizeLastPoints;
    }

    public void resetZoomToolBar() {
        this.zoomWindowItem.setEnabled(true);
        this.panItem.setEnabled(false);
        this.scopePointsCombo.setEnabled(this.isScopePointsCombo);
        this.scopePointsCombo.select(0);
    }

    public String getCoolBarSizes() {
        return this.toolBarSizes.toString();
    }

    private boolean isObjectKeyConsistentWithDevices(String newObjectKey) {
        for (Map.Entry<String, DeviceConfiguration> entry : this.application.getDeviceSelectionDialog().getDeviceConfigurations().getAllConfigurations().entrySet()) {
            if (!entry.getKey().equals(newObjectKey) && !entry.getValue().getPureDeviceName(entry.getKey()).equals(newObjectKey)) continue;
            return false;
        }
        return true;
    }

    public void selectObjectKey(int actualSelectionIndex, String newObjectKey) {
        int searchSelectionIndex;
        boolean isContained = false;
        String[] objectKeys = this.objectSelectCombo.getItems();
        for (searchSelectionIndex = 0; searchSelectionIndex < objectKeys.length; ++searchSelectionIndex) {
            if (!newObjectKey.equals(objectKeys[searchSelectionIndex])) continue;
            this.objectSelectCombo.select(searchSelectionIndex);
            this.settings.setObjectList(this.settings.getObjectList(), searchSelectionIndex);
            isContained = true;
            break;
        }
        if (!isContained && searchSelectionIndex > actualSelectionIndex) {
            Vector<String> tmpObjects = new Vector<String>();
            for (String tmpObject : this.settings.getObjectList()) {
                tmpObjects.add(tmpObject);
            }
            tmpObjects.add(newObjectKey);
            this.settings.setObjectList(tmpObjects.toArray(new String[1]), newObjectKey);
            this.objectSelectCombo.setItems(this.settings.getObjectList());
            this.objectSelectCombo.select(this.settings.getActiveObjectIndex());
        }
        this.isObjectoriented = this.objectSelectCombo.getSelectionIndex() > 0;
        this.application.setObjectDescriptionTabVisible(this.isObjectoriented);
        this.application.updateObjectDescriptionWindow();
    }

    public void selectObjectKey(int index) {
        this.objectSelectCombo.select(index);
        this.objectSelectCombo.notifyListeners(13, new Event());
    }

    public void selectObjectKeyDeviceOriented() {
        this.objectSelectCombo.select(0);
        this.isObjectoriented = this.objectSelectCombo.getSelectionIndex() > 0;
    }

    public boolean isObjectoriented() {
        return this.isObjectoriented;
    }

    public String getActiveObjectKey() {
        return this.activeObjectKey;
    }

    public void updateObjectSelector() {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && activeChannel.size() > 0 && !activeChannel.getObjectKey().equals("")) {
            this.selectObjectKey(this.objectSelectCombo.getSelectionIndex(), activeChannel.getObjectKey());
        } else if (activeChannel != null && activeChannel.size() == 0) {
            this.objectSelectCombo.select(this.settings.getActiveObjectIndex());
        } else {
            this.selectObjectKeyDeviceOriented();
        }
        this.isObjectoriented = this.objectSelectCombo.getSelectionIndex() > 0;
    }

    public void setObjectList(String[] newObjectKeyList, String newObjectKey) {
        this.settings.setObjectList(newObjectKeyList, newObjectKey);
        this.objectSelectCombo.setItems(this.settings.getObjectList());
        this.objectSelectCombo.select(this.settings.getActiveObjectIndex());
        this.updateObjectSelector();
    }

    public void setObjectListElements() {
        this.objectSelectCombo.setItems(this.settings.getObjectList());
        int objectIndex = this.settings.getActiveObjectIndex();
        this.objectSelectCombo.select(objectIndex);
        if (objectIndex == 0) {
            this.isObjectoriented = false;
            this.activeObjectKey = "";
        } else {
            this.isObjectoriented = true;
            this.activeObjectKey = this.objectSelectCombo.getText();
        }
    }

    public String[] getObjectKeyList() {
        return this.objectSelectCombo.getItems();
    }

    public void enableScopePointsCombo(boolean enabled) {
        this.isScopePointsCombo = enabled;
        this.scopePointsCombo.setEnabled(enabled);
    }

    public void enableZoomToolBar(boolean enabled) {
        this.zoomToolBar.setEnabled(enabled);
    }

    public void updateGoogleEarthToolItem() {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.googleEarthToolItem.setEnabled(this.application.getActiveDevice().isActualRecordSetWithGpsData());
            this.googleEarthConfigToolItem.setEnabled(this.application.getActiveDevice().isActualRecordSetWithGpsData() && this.application.getActiveDevice().getGPS2KMZMeasurementOrdinal() >= 0);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MenuToolBar.this.googleEarthToolItem.setEnabled(MenuToolBar.this.application.getActiveDevice().isActualRecordSetWithGpsData());
                    MenuToolBar.this.googleEarthConfigToolItem.setEnabled(MenuToolBar.this.application.getActiveDevice().isActualRecordSetWithGpsData() && MenuToolBar.this.application.getActiveDevice().getGPS2KMZMeasurementOrdinal() >= 0);
                }
            });
        }
    }

    public boolean isObjectSelectorEditable() {
        return this.objectSelectCombo.getEditable();
    }

    private void processNewOrChangedObjectKey(String newObjKey, boolean isEditMode) {
        boolean isDuplicateKey = Arrays.asList(this.objectSelectCombo.getItems()).stream().anyMatch(x -> x.equalsIgnoreCase(newObjKey));
        if (!isDuplicateKey && newObjKey.length() >= 2 && this.isObjectKeyConsistentWithDevices(newObjKey)) {
            if (!isEditMode) {
                ObjectKeyCompliance.renameObjectKey("", newObjKey, this.objectSelectCombo.getItems());
            } else {
                log.log(Level.FINE, "oldObjectKey = " + this.oldObjectKey);
                if (this.oldObjectKey.length() >= 2) {
                    ObjectKeyCompliance.renameObjectKey(this.oldObjectKey, newObjKey, this.objectSelectCombo.getItems());
                }
            }
            this.setObjectListElements();
            this.oldObjectKey = null;
            if (this.settings.getActiveObjectIndex() >= 1) {
                this.deleteObject.setEnabled(true);
                this.editObject.setEnabled(true);
                this.application.updateObjectDescriptionWindow();
                new ObjectKeyScanner(newObjKey).start();
            }
        } else {
            Vector<String> tmpObjectKeys = new Vector<String>();
            for (String objectKey : this.objectSelectCombo.getItems()) {
                if (objectKey.length() < 2) continue;
                tmpObjectKeys.add(objectKey);
            }
            this.objectSelectCombo.setItems(tmpObjectKeys.toArray(new String[1]));
            this.objectSelectCombo.select(this.isObjectoriented ? 1 : 0);
            if (this.isObjectoriented && this.oldObjectKey != null && !this.oldObjectKey.isEmpty()) {
                this.objectSelectCombo.setText(this.oldObjectKey);
            } else {
                this.objectSelectCombo.select(this.isObjectoriented ? 1 : 0);
            }
            this.application.setObjectDescriptionTabVisible(this.isObjectoriented);
            this.application.updateObjectDescriptionWindow();
        }
    }

    public void updateColorSchema() {
        this.objectSelectComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.scopePointsComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.channelSelectComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.recordSelectComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.fileToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.deviceObjectToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.zoomToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.portToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.dataToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.googleEarthToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.helpToolBar.setBackground(this.application.COLOR_BACKGROUND);
        this.setPortConnected(false);
    }
}

