/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataBlockType;
import gde.device.DeviceConfiguration;
import gde.device.FormatTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.device.junsi.DataParserDuo;
import gde.device.junsi.UsbGathererThread;
import gde.device.junsi.iCharger;
import gde.device.junsi.modbus.ChargerDialog;
import gde.device.junsi.modbus.ChargerUsbPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.io.CSVSerialDataReaderWriter;
import gde.io.DataParser;
import gde.io.IDataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.Vector;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class iChargerUsb
extends iCharger
implements IDevice {
    protected final ChargerUsbPort usbPort;
    protected boolean isFileIO = false;
    protected boolean isSerialIO = false;
    protected UsbGathererThread usbGathererThread;
    protected ChargerDialog dialog;
    protected String batteryType_1 = "?";
    protected String batteryType_2 = "?";
    protected static int lastTime1_ms = 0;
    protected static int lastTime2_ms = 0;
    protected static double energySum1 = 0.0;
    protected static double energySum2 = 0.0;

    public iChargerUsb(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.junsi.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.BATTERIE_TYPES = BatteryTypesDuo.getValues();
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT2606"), Messages.getString((String)"GDE_MSGT2605"));
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2603"), Messages.getString((String)"GDE_MSGT2603"));
            }
            if (this.isFileIO) {
                this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            }
        }
        this.usbPort = new ChargerUsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    public iChargerUsb(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.junsi.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.BATTERIE_TYPES = BatteryTypesDuo.getValues();
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT2606"), Messages.getString((String)"GDE_MSGT2605"));
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2603"), Messages.getString((String)"GDE_MSGT2603"));
            }
            if (this.isFileIO) {
                this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            }
        }
        this.usbPort = new ChargerUsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    public ChargerUsbPort getUsbPort() {
        return this.usbPort;
    }

    public ChargerDialog getDialog() {
        return this.dialog;
    }

    @Override
    public int getLovDataByteSize() {
        return 77;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, offset + 5, convertBuffer, 0, deviceDataBufferSize);
            int actualTime_ms = DataParser.parse2Int((byte[])convertBuffer, (int)3);
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer), (double)actualTime_ms);
            offset += lovDataSize;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT2604", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT2604"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    iCharger.log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    if (!iChargerUsb.this.isSerialIO) {
                        iChargerUsb.this.open_closeCommPort();
                    } else {
                        iChargerUsb.this.importDeviceData();
                    }
                }
            });
        }
    }

    public boolean isDataGathererActive() {
        return this.usbGathererThread != null && this.usbGathererThread.isAlive();
    }

    @Override
    public void open_closeCommPort() {
        switch (this.application.getMenuBar().getSerialPortIconSet()) {
            case 2: {
                this.importDeviceData();
                break;
            }
            case 1: {
                if (this.usbPort == null) break;
                if (!this.usbPort.isConnected() || !this.isDataGathererActive()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break;
                        this.usbGathererThread = new UsbGathererThread(this.application, this, this.usbPort, activChannel.getNumber());
                        try {
                            if (this.usbGathererThread == null || !this.usbPort.isConnected()) break;
                            WaitTimer.delay((long)100L);
                            this.usbGathererThread.start();
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort == null || !this.usbPort.isConnected()) break;
                            this.usbPort.closeUsbPort(null);
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(e.getMessage());
                        try {
                            if (this.usbPort == null || !this.usbPort.isConnected()) break;
                            this.usbPort.closeUsbPort(null);
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                    break;
                }
                if (this.usbGathererThread != null) {
                    this.usbGathererThread.stopDataGatheringThread(false, null);
                }
                try {
                    WaitTimer.delay((long)1000L);
                    if (this.usbPort == null || !this.usbPort.isConnected()) break;
                    this.usbPort.closeUsbPort(false);
                    break;
                }
                catch (UsbException e) {
                    log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void importDeviceData() {
        if (!this.application.getDeviceSelectionDialog().checkDataSaved()) {
            return;
        }
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2600"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    iChargerUsb.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        iCharger.log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            CSVSerialDataReaderWriter.read((String)selectedImportFile, (IDevice)iChargerUsb.this, (String)"", (Integer)1, (IDataParser)new DataParserDuo(1, iChargerUsb.this.getDataBlockLeader(), iChargerUsb.this.getDataBlockSeparator().value(), null, null, iChargerUsb.this.getNoneCalculationMeasurementNames(1, iChargerUsb.this.getMeasurementNames(1)).length, iChargerUsb.this.getDataBlockFormat(InputTypes.FILE_IO), false, 2));
                        }
                        catch (Throwable e) {
                            iCharger.log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    iChargerUsb.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public String getBatteryType(byte[] databuffer) throws DataInconsitsentException {
        try {
            return this.BATTERIE_TYPES[databuffer[8]];
        }
        catch (Exception e) {
            throw new DataInconsitsentException("could not detect battery type !");
        }
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        int actualTime_ms = DataParser.parse2Int((byte[])dataBuffer, (int)3);
        double timeStep_h = 2.777777777777778E-4;
        if (dataBuffer[2] == 1) {
            if (actualTime_ms < lastTime1_ms) {
                lastTime1_ms = 0;
            }
            timeStep_h = (double)(actualTime_ms - lastTime1_ms) / 1000.0 / 3600.0;
            lastTime1_ms = actualTime_ms;
        } else {
            if (actualTime_ms < lastTime2_ms) {
                lastTime2_ms = 0;
            }
            timeStep_h = (double)(actualTime_ms - lastTime2_ms) / 1000.0 / 3600.0;
            lastTime2_ms = actualTime_ms;
        }
        block2 : switch (dataBuffer[7]) {
            default: {
                switch (dataBuffer[2]) {
                    default: {
                        try {
                            this.batteryType_1 = this.getBatteryType(dataBuffer);
                        }
                        catch (DataInconsitsentException e) {
                            this.batteryType_1 = "?";
                        }
                        break;
                    }
                    case 2: {
                        try {
                            this.batteryType_2 = this.getBatteryType(dataBuffer);
                            break;
                        }
                        catch (DataInconsitsentException e) {
                            this.batteryType_2 = "?";
                        }
                    }
                }
                points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                points[1] = DataParser.parse2UnsignedShort((byte[])dataBuffer, (int)12);
                points[2] = DataParser.parse2UnsignedShort((byte[])dataBuffer, (int)14);
                points[3] = DataParser.parse2Int((byte[])dataBuffer, (int)16);
                points[4] = Math.abs(points[0] * points[2] / 100);
                if (dataBuffer[2] == 1) {
                    if (points[3] != 0) {
                        points[5] = Double.valueOf(energySum1 += (double)points[4] * timeStep_h).intValue();
                    } else {
                        points[5] = 0;
                        energySum1 = 0.0;
                    }
                } else if (points[3] != 0) {
                    points[5] = Double.valueOf(energySum2 += (double)points[4] * timeStep_h).intValue();
                } else {
                    points[5] = 0;
                    energySum2 = 0.0;
                }
                points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                points[7] = DataParser.parse2Short((byte[])dataBuffer, (int)22);
                int i = 0;
                int j = 0;
                while (i < this.getNumberOfLithiumCells()) {
                    points[i + 9] = DataParser.parse2Short((byte[])dataBuffer, (int)(24 + j));
                    if (points[i + 9] > 0) {
                        maxVotage = points[i + 9] > maxVotage ? points[i + 9] : maxVotage;
                        minVotage = points[i + 9] < minVotage ? points[i + 9] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                points[8] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                break;
            }
            case -128: {
                int offset = 9 + this.getNumberOfLithiumCells();
                points[offset++] = DataParser.parse2UnsignedShort((byte[])dataBuffer, (int)8);
                switch (dataBuffer[2] == 2 ? this.batteryType_2 : this.batteryType_1) {
                    case "LiPo": 
                    case "LiIo": 
                    case "LiFe": 
                    case "LiHv": 
                    case "LTO": 
                    case "NiZn": {
                        points[offset++] = DataParser.parse2UnsignedShort((byte[])dataBuffer, (int)10);
                        int i = 0;
                        int j = 0;
                        while (i < this.getNumberOfLithiumCells()) {
                            points[i + offset] = DataParser.parse2UnsignedShort((byte[])dataBuffer, (int)(12 + j));
                            ++i;
                            j += 2;
                        }
                        break block2;
                    }
                }
            }
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        boolean isVariableIntervalTime;
        int numberOfNoneCalculationRecords = recordSet.getNoneCalculationRecordNames().length;
        int dataBufferSize = 4 * numberOfNoneCalculationRecords;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        double energy = 0.0;
        double timeStep_h = 2.777777777777778E-4;
        double lastTime_ms = 0.0;
        double actualTime_ms = 0.0;
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int riRecordOffset = 9 + this.getNumberOfLithiumCells();
        boolean bl = isVariableIntervalTime = !recordSet.isTimeStepConstant();
        if (isVariableIntervalTime) {
            int timeStampBufferSize = 4 * recordDataSize;
            int index = 0;
            for (int i = 0; i < recordDataSize; ++i) {
                index = i * dataBufferSize + timeStampBufferSize;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
                }
                System.arraycopy(dataBuffer, index, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + (convertBuffer[3] & 0xFF);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + (convertBuffer[7] & 0xFF);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + (convertBuffer[11] & 0xFF);
                points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + (convertBuffer[15] & 0xFF);
                points[4] = Math.abs(Double.valueOf((double)points[0] / 100.0 * (double)points[2]).intValue());
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + (convertBuffer[19] & 0xFF);
                points[7] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + (convertBuffer[23] & 0xFF);
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                int k = 0;
                int j = 0;
                while (j < this.getNumberOfLithiumCells()) {
                    points[j + 9] = ((convertBuffer[k + 24] & 0xFF) << 24) + ((convertBuffer[k + 25] & 0xFF) << 16) + ((convertBuffer[k + 26] & 0xFF) << 8) + (convertBuffer[k + 27] & 0xFF);
                    if (points[j + 9] > 0) {
                        maxVotage = points[j + 9] > maxVotage ? points[j + 9] : maxVotage;
                        minVotage = points[j + 9] < minVotage ? points[j + 9] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                int n = points[8] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                if (recordSet.size() == 9 + this.getNumberOfLithiumCells() * 2 + 2) {
                    j = 0;
                    while (j < this.getNumberOfLithiumCells() + 2 && j + riRecordOffset < recordSet.size()) {
                        points[j + riRecordOffset] = ((convertBuffer[k + 24] & 0xFF) << 24) + ((convertBuffer[k + 25] & 0xFF) << 16) + ((convertBuffer[k + 26] & 0xFF) << 8) + (convertBuffer[k + 27] & 0xFF);
                        ++j;
                        k += 4;
                    }
                }
                if ((actualTime_ms = (double)(((long)(dataBuffer[0 + i * 4] & 0xFF) << 24) + ((long)(dataBuffer[1 + i * 4] & 0xFF) << 16) + ((long)(dataBuffer[2 + i * 4] & 0xFF) << 8) + (long)(dataBuffer[3 + i * 4] & 0xFF)) / 10.0) < lastTime_ms) {
                    actualTime_ms = lastTime_ms + (recordSet.getTime_ms(recordSet.getRecordDataSize(true) - 2) - recordSet.getTime_ms(recordSet.getRecordDataSize(true) - 1));
                }
                if (points[3] == 0) {
                    energy = 0.0;
                }
                timeStep_h = (actualTime_ms - lastTime_ms) / 1000.0 / 3600.0;
                if (i != 0) {
                    energy += (double)points[4] * timeStep_h;
                }
                points[5] = Double.valueOf(energy).intValue();
                recordSet.addPoints(points, actualTime_ms);
                lastTime_ms = actualTime_ms;
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        } else {
            for (int i = 0; i < recordDataSize; ++i) {
                log.log(Level.FINER, i + " i*dataBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + (convertBuffer[3] & 0xFF);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + (convertBuffer[7] & 0xFF);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + (convertBuffer[11] & 0xFF);
                points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + (convertBuffer[15] & 0xFF);
                points[4] = Double.valueOf((double)points[0] / 100.0 * (double)points[2]).intValue();
                if (i != 0) {
                    energy += (double)points[4] * timeStep_h;
                }
                points[5] = Double.valueOf(energy).intValue();
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + (convertBuffer[19] & 0xFF);
                points[7] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + (convertBuffer[23] & 0xFF);
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                int k = 0;
                int j = 0;
                while (j < this.getNumberOfLithiumCells()) {
                    points[j + 9] = ((convertBuffer[k + 24] & 0xFF) << 24) + ((convertBuffer[k + 25] & 0xFF) << 16) + ((convertBuffer[k + 26] & 0xFF) << 8) + (convertBuffer[k + 27] & 0xFF);
                    if (points[j + 9] > 0) {
                        maxVotage = points[j + 9] > maxVotage ? points[j + 9] : maxVotage;
                        minVotage = points[j + 9] < minVotage ? points[j + 9] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                int n = points[8] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                if (recordSet.size() == 9 + this.getNumberOfLithiumCells() * 2 + 2) {
                    j = 0;
                    while (j < this.getNumberOfLithiumCells() + 2 && j + riRecordOffset < recordSet.size()) {
                        points[j + riRecordOffset] = ((convertBuffer[k + 24] & 0xFF) << 24) + ((convertBuffer[k + 25] & 0xFF) << 16) + ((convertBuffer[k + 26] & 0xFF) << 8) + (convertBuffer[k + 27] & 0xFF);
                        ++j;
                        k += 4;
                    }
                }
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordKeys = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (recordKeys.length - fileRecordsProperties.length == 1) {
            recordSet.remove(recordKeys[9 + this.getNumberOfLithiumCells() + 1]);
            recordKeys = recordSet.getRecordNames();
        } else if (recordKeys.length - fileRecordsProperties.length > 0) {
            int i;
            for (i = 0; i < fileRecordsProperties.length; ++i) {
                cleanedRecordNames.add(recordKeys[i]);
            }
            while (i < recordKeys.length) {
                recordSet.remove(recordKeys[i]);
                ++i;
            }
            recordKeys = cleanedRecordNames.toArray(new String[1]);
        }
        return recordKeys;
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
        Record recordPower = recordSet.get(4);
        Record recordEnergy = recordSet.get(5);
        if (recordSet.isRaw() && !recordPower.hasReasonableData() && !recordEnergy.hasReasonableData()) {
            try {
                int i;
                int displayableCounter = 0;
                Record recordCurrent = recordSet.get(0);
                Record recordVoltage = recordSet.get(2);
                Record recordCapacity = recordSet.get(3);
                Record recordBalance = recordSet.get(8);
                recordPower.clear();
                recordEnergy.clear();
                recordBalance.clear();
                double energy = 0.0;
                double lastTime_ms = 0.0;
                for (i = 0; i < recordCurrent.size(); ++i) {
                    int power = Math.abs(Double.valueOf((double)(recordVoltage.get(i) * recordCurrent.get(i)) / 100.0).intValue());
                    recordPower.add(Integer.valueOf(power));
                    if (recordCapacity.get(i) == 0) {
                        energy = 0.0;
                    }
                    if (i != 0) {
                        double timeStep_h = (recordSet.getTime_ms(i) - lastTime_ms) / 1000.0 / 3600.0;
                        energy += (double)power * timeStep_h;
                    }
                    recordEnergy.add(Integer.valueOf(Double.valueOf(energy).intValue()));
                    lastTime_ms = recordSet.getTime_ms(i);
                    int maxVotage = Integer.MIN_VALUE;
                    int minVotage = Integer.MAX_VALUE;
                    for (int j = 0; j < this.getNumberOfLithiumCells(); ++j) {
                        int value;
                        Record selectedRecord = recordSet.get(j + 9);
                        if (selectedRecord.size() <= i || (value = selectedRecord.get(i).intValue()) <= 0) continue;
                        maxVotage = value > maxVotage ? value : maxVotage;
                        minVotage = value < minVotage ? value : minVotage;
                    }
                    recordBalance.add(Integer.valueOf(maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0));
                }
                for (i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    if (!record.isActive() || !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                log.log(Level.FINE, "displayableCounter = " + displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (this.channels.getActiveChannel().getActiveRecordSet() == null || recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.updateVisibilityStatus(recordSet, true);
    }

    public String[] getNoneCalculationMeasurementNames(int channelConfigNumber, String[] validMeasurementNames) {
        Vector<String> tmpCalculationRecords = new Vector<String>();
        String[] deviceMeasurements = this.getMeasurementNames(channelConfigNumber);
        int deviceDataBlockSize = Math.abs(this.getDataBlockSize(FormatTypes.VALUE)) + this.getNumberOfLithiumCells() + 2;
        deviceDataBlockSize = this.getDataBlockSize(FormatTypes.VALUE) <= 0 ? deviceMeasurements.length : deviceDataBlockSize;
        for (int i = 0; i < deviceMeasurements.length && i < validMeasurementNames.length; ++i) {
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (measurement.isCalculation()) continue;
            tmpCalculationRecords.add(validMeasurementNames[i]);
        }
        while (tmpCalculationRecords.size() > deviceDataBlockSize) {
            tmpCalculationRecords.remove(deviceDataBlockSize);
        }
        return tmpCalculationRecords.toArray(new String[0]);
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{2, 3};
    }

    public long getTimeStamp(byte[] buffer) {
        log.finest(() -> StringHelper.byte2Hex2CharString((byte[])buffer, (int)3, (int)4));
        return DataParser.getUInt32((byte[])buffer, (int)3);
    }

    public void resetEnergySum(int channelnumber) {
        if (channelnumber == 1) {
            energySum1 = 0.0;
        } else {
            energySum2 = 0.0;
        }
    }

    public abstract int getDcInputVoltMin();

    public abstract int getDcInputVoltMax();

    public abstract int getDcInputCurrentMax();

    public abstract int getRegInputVoltMin();

    public abstract int getRegInputVoltMax();

    public abstract int getChargeCurrentMax4Channel();

    public abstract int getChargeCurrentMaxSyncChannels();

    public abstract int getDeviceChargePowerMax();

    public abstract int[] getChargePowerMax();

    public abstract int[] getDischargePowerMax();

    public abstract int[] getRegChannelVoltageLimits();

    public abstract int[] getRegChannelCurrentLimits();

    public abstract int getDigitalPowerVoltageMax();

    public static enum BatteryTypesDuo {
        BT_UNKNOWN("?"),
        BT_LIPO("LiPo"),
        BT_LIIO("LiIo"),
        BT_LIFE("LiFe"),
        BT_NIMH("NiMH"),
        BT_NICD("NiCd"),
        BT_PB("PB"),
        BT_NIZN("NiZn"),
        BT_LIHV("LiHV"),
        BT_UNKNOWN_("?");

        private String value;
        public static BatteryTypesDuo[] VALUES;

        private BatteryTypesDuo(String newValue) {
            this.value = newValue;
        }

        protected String getName() {
            return this.value;
        }

        public static String[] getValues() {
            StringBuilder sb = new StringBuilder();
            for (BatteryTypesDuo bt : BatteryTypesDuo.values()) {
                sb.append(bt.value).append(',');
            }
            return sb.toString().split(",");
        }

        static {
            VALUES = BatteryTypesDuo.values();
        }
    }
}

