/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldHermiteInterpolator<T extends FieldElement<T>> {
    private final List<T> abscissae = new ArrayList<T>();
    private final List<T[]> topDiagonal = new ArrayList<T[]>();
    private final List<T[]> bottomDiagonal = new ArrayList<T[]>();

    public void addSamplePoint(T x2, T[] ... value) throws ZeroException, MathArithmeticException, DimensionMismatchException, NullArgumentException {
        MathUtils.checkNotNull(x2);
        FieldElement factorial = (FieldElement)x2.getField().getOne();
        for (int i2 = 0; i2 < value.length; ++i2) {
            FieldElement[] y2 = (FieldElement[])value[i2].clone();
            if (i2 > 1) {
                factorial = (FieldElement)factorial.multiply(i2);
                FieldElement inv = (FieldElement)factorial.reciprocal();
                for (int j2 = 0; j2 < y2.length; ++j2) {
                    y2[j2] = y2[j2].multiply(inv);
                }
            }
            int n2 = this.abscissae.size();
            this.bottomDiagonal.add(n2 - i2, y2);
            FieldElement[] bottom0 = y2;
            for (int j3 = i2; j3 < n2; ++j3) {
                FieldElement[] bottom1 = (FieldElement[])this.bottomDiagonal.get(n2 - (j3 + 1));
                if (x2.equals(this.abscissae.get(n2 - (j3 + 1)))) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, x2);
                }
                FieldElement inv = (FieldElement)((FieldElement)x2.subtract(this.abscissae.get(n2 - (j3 + 1)))).reciprocal();
                for (int k2 = 0; k2 < y2.length; ++k2) {
                    bottom1[k2] = inv.multiply(bottom0[k2].subtract(bottom1[k2]));
                }
                bottom0 = bottom1;
            }
            this.topDiagonal.add((T[])bottom0.clone());
            this.abscissae.add(x2);
        }
    }

    public T[] value(T x2) throws NoDataException, NullArgumentException {
        MathUtils.checkNotNull(x2);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement[] value = (FieldElement[])MathArrays.buildArray(x2.getField(), ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement valueCoeff = (FieldElement)x2.getField().getOne();
        for (int i2 = 0; i2 < this.topDiagonal.size(); ++i2) {
            FieldElement[] dividedDifference = (FieldElement[])this.topDiagonal.get(i2);
            for (int k2 = 0; k2 < value.length; ++k2) {
                value[k2] = value[k2].add(dividedDifference[k2].multiply(valueCoeff));
            }
            FieldElement deltaX = (FieldElement)x2.subtract(this.abscissae.get(i2));
            valueCoeff = valueCoeff.multiply(deltaX);
        }
        return value;
    }

    public T[][] derivatives(T x2, int order) throws NoDataException, NullArgumentException {
        MathUtils.checkNotNull(x2);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement zero = (FieldElement)x2.getField().getZero();
        FieldElement one = (FieldElement)x2.getField().getOne();
        FieldElement[] tj = (FieldElement[])MathArrays.buildArray(x2.getField(), order + 1);
        tj[0] = zero;
        for (int i2 = 0; i2 < order; ++i2) {
            tj[i2 + 1] = tj[i2].add(one);
        }
        FieldElement[][] derivatives = (FieldElement[][])MathArrays.buildArray(x2.getField(), order + 1, ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement[] valueCoeff = (FieldElement[])MathArrays.buildArray(x2.getField(), order + 1);
        valueCoeff[0] = (FieldElement)x2.getField().getOne();
        for (int i3 = 0; i3 < this.topDiagonal.size(); ++i3) {
            FieldElement[] dividedDifference = (FieldElement[])this.topDiagonal.get(i3);
            FieldElement deltaX = (FieldElement)x2.subtract(this.abscissae.get(i3));
            for (int j2 = order; j2 >= 0; --j2) {
                for (int k2 = 0; k2 < derivatives[j2].length; ++k2) {
                    derivatives[j2][k2] = derivatives[j2][k2].add(dividedDifference[k2].multiply(valueCoeff[j2]));
                }
                valueCoeff[j2] = valueCoeff[j2].multiply(deltaX);
                if (j2 <= 0) continue;
                valueCoeff[j2] = valueCoeff[j2].add(tj[j2].multiply(valueCoeff[j2 - 1]));
            }
        }
        return derivatives;
    }
}

