/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.smmodellbau.UniLogDialog;
import gde.device.smmodellbau.UniLogLiveGatherer;
import gde.device.smmodellbau.UniLogSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CalculationThread;
import gde.utils.LinearRegression;
import gde.utils.QuasiLinearRegression;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UniLog
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(UniLog.class.getName());
    public static final String LOV_N_100_W = "n100W=";
    public static final String LOV_CURRENT_OFFSET = "Stromoffset=";
    public static final String LOV_NUMBER_MOTOR = "AnzahlMotoren=";
    public static final String LOV_NUMBER_CELLS = "AnzahlZellen=";
    public static final String LOV_RPM2_FACTOR = "DrehzahlFaktor=";
    public static final String LOV_CURRENT_INVERT = "StromInvertieren=";
    public static final String LOV_RPM_CHECKED = "RpmChecked=";
    public static final String LOV_A1_CHECKED = "A1Checked=";
    public static final String LOV_A2_CHECKED = "A2Checked=";
    public static final String LOV_A3_CHECKED = "A3Checked=";
    public static final String LOV_RPM_NAME = "RpmName=";
    public static final String LOV_A1_NAME = "A1Name=";
    public static final String LOV_A2_NAME = "A2Name=";
    public static final String LOV_A3_NAME = "A3Name=";
    public static final String LOV_RPM_OFFSET = "RpmOffset=";
    public static final String LOV_A1_OFFSET = "A1Offset=";
    public static final String LOV_A2_OFFSET = "A2Offset=";
    public static final String LOV_A3_OFFSET = "A3Offset=";
    public static final String LOV_RPM_FACTOR = "RpmFaktor=";
    public static final String LOV_A1_FACTOR = "A1Faktor=";
    public static final String LOV_A2_FACTOR = "A2Faktor=";
    public static final String LOV_A3_FACTOR = "A3Faktor=";
    public static final String LOV_RPM_UNIT = "RpmEinheit=";
    public static final String LOV_A1_UNIT = "A1Einheit=";
    public static final String LOV_A2_UNIT = " A2Einheit=";
    public static final String LOV_A3_UNIT = " A3Einheit=";
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_2 = new String[]{"Stromoffset=", "StromInvertieren="};
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_6 = new String[]{"AnzahlZellen="};
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_7 = new String[]{"RpmChecked=", "RpmName=", "RpmEinheit=", "RpmFaktor=", "RpmOffset=", "DrehzahlFaktor=", "AnzahlMotoren="};
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_8 = new String[]{"n100W="};
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_11 = new String[]{"A1Checked=", "A1Name=", "A1Einheit=", "A1Offset=", "A1Faktor="};
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_12 = new String[]{"A2Checked=", "A2Name=", " A2Einheit=", "A2Offset=", "A2Faktor="};
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_13 = new String[]{"A3Checked=", "A3Name=", " A3Einheit=", "A3Offset=", "A3Faktor="};
    public static final String A1_FACTOR = "a1_" + IDevice.FACTOR;
    public static final String A1_OFFSET = "a1_" + IDevice.OFFSET;
    public static final String A2_FACTOR = "a2_" + IDevice.FACTOR;
    public static final String A2_OFFSET = "a2_" + IDevice.OFFSET;
    public static final String A3_FACTOR = "a3_" + IDevice.FACTOR;
    public static final String A3_OFFSET = "a3_" + IDevice.OFFSET;
    public static final String NUMBER_CELLS = MeasurementPropertyTypes.NUMBER_CELLS.value();
    public static final String PROP_N_100_W = MeasurementPropertyTypes.PROP_N_100_W.value();
    public static final String IS_INVERT_CURRENT = MeasurementPropertyTypes.IS_INVERT_CURRENT.value();
    public static final String CURRENT_OFFSET = IDevice.OFFSET;
    public static final String NUMBER_MOTOR = MeasurementPropertyTypes.NUMBER_MOTOR.value();
    public static final String REVOLUTION_FACTOR = MeasurementPropertyTypes.REVOLUTION_FACTOR.value();
    public static final String RPM_FACTOR = IDevice.FACTOR;
    public static final String DO_SUBTRACT_FIRST = MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value();
    public static final String DO_SUBTRACT_LAST = MeasurementPropertyTypes.DO_SUBTRACT_LAST.value();
    public static final String FIRMEWARE_VERSION = "Firmware";
    public static final String SERIAL_NUMBER = "S/N";
    final DataExplorer application;
    final UniLogSerialPort serialPort;
    final UniLogDialog dialog;

    public UniLog(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.unilog.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = this.application != null ? new UniLogSerialPort(this, this.application) : new UniLogSerialPort(this, null);
        UniLogDialog uniLogDialog = this.dialog = this.application != null ? new UniLogDialog(this.application.getShell(), this) : new UniLogDialog(new Shell(Display.getDefault()), this);
        if (this.application != null && this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1376"), Messages.getString((String)"GDE_MSGT1375"));
        }
        UniLogSerialPort.TIME_OUT_MS = this.getReadTimeOut();
    }

    public UniLog(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.unilog.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = this.application != null ? new UniLogSerialPort(this, this.application) : new UniLogSerialPort(this, null);
        this.dialog = this.application != null ? new UniLogDialog(this.application.getShell(), this) : new UniLogDialog(new Shell(Display.getDefault()), this);
        this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1376"), Messages.getString((String)"GDE_MSGT1375"));
        UniLogSerialPort.TIME_OUT_MS = this.getReadTimeOut();
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        lov2osdMap.put(LOV_CURRENT_OFFSET, CURRENT_OFFSET + "=_DOUBLE");
        lov2osdMap.put(LOV_CURRENT_INVERT, IS_INVERT_CURRENT + "=_BOOLEAN");
        lov2osdMap.put(LOV_NUMBER_CELLS, NUMBER_CELLS + "=_INTEGER");
        lov2osdMap.put(LOV_RPM_CHECKED, "_isActive=_BOOLEAN");
        lov2osdMap.put(LOV_RPM_OFFSET, IDevice.OFFSET + "=_DOUBLE");
        lov2osdMap.put(LOV_RPM_FACTOR, IDevice.FACTOR + "=_DOUBLE");
        lov2osdMap.put(LOV_NUMBER_MOTOR, NUMBER_MOTOR);
        lov2osdMap.put(LOV_RPM2_FACTOR, REVOLUTION_FACTOR + "=_DOUBLE");
        lov2osdMap.put(LOV_N_100_W, PROP_N_100_W + "=_INTEGER");
        lov2osdMap.put(LOV_A1_CHECKED, "_isActive=_BOOLEAN");
        lov2osdMap.put(LOV_A2_CHECKED, "_isActive=_BOOLEAN");
        lov2osdMap.put(LOV_A3_CHECKED, "_isActive=_BOOLEAN");
        lov2osdMap.put(LOV_A1_NAME, "_name");
        lov2osdMap.put(LOV_A2_NAME, "_name");
        lov2osdMap.put(LOV_A3_NAME, "_name");
        lov2osdMap.put(LOV_A1_UNIT, "_unit");
        lov2osdMap.put(LOV_A2_UNIT, "_unit");
        lov2osdMap.put(LOV_A3_UNIT, "_unit");
        lov2osdMap.put(LOV_A1_OFFSET, IDevice.OFFSET + "=_DOUBLE");
        lov2osdMap.put(LOV_A2_OFFSET, IDevice.OFFSET + "=_DOUBLE");
        lov2osdMap.put(LOV_A3_OFFSET, IDevice.OFFSET + "=_DOUBLE");
        lov2osdMap.put(LOV_A1_FACTOR, IDevice.FACTOR + "=_DOUBLE");
        lov2osdMap.put(LOV_A2_FACTOR, IDevice.FACTOR + "=_DOUBLE");
        lov2osdMap.put(LOV_A3_FACTOR, IDevice.FACTOR + "=_DOUBLE");
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        Object recordSetInfo = "";
        for (int j = 0; j < this.getNumberOfMeasurements(channelNumber); ++j) {
            StringBuilder recordConfigData = new StringBuilder();
            if (j == 2) {
                configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_2);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_2) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            } else if (j == 6) {
                configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_6);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_6) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            } else if (j == 7) {
                configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_7);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_7) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            } else if (j == 8) {
                configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_8);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_8) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            } else if (j == 11) {
                configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_11);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_11) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            } else if (j == 12) {
                configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_12);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_12) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            } else if (j == 13) {
                configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_13);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_13) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            }
            recordSetInfo = (String)recordSetInfo + "RecordProperties : " + recordConfigData.toString() + "|:-:|";
        }
        return recordSetInfo;
    }

    public int getLovDataByteSize() {
        return 32;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int timeStep_ms = 0;
        int size = this.getLovDataByteSize();
        byte[] readBuffer = new byte[size];
        int[] points = new int[this.getNumberOfMeasurements(1)];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 2; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, i * size, readBuffer, 0, size);
            if (timeStep_ms == 0 && (timeStep_ms = timeStep_ms + ((readBuffer[3] & 0xFF) << 24) + ((readBuffer[2] & 0xFF) << 16) + ((readBuffer[1] & 0xFF) << 8) + (readBuffer[0] & 0xFF)) != 0) {
                recordSet.setTimeStep_ms((double)timeStep_ms);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "timeStep_ms = " + timeStep_ms);
                }
            }
            recordSet.addPoints(this.convertDataBytes(points, readBuffer));
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int a2Modus;
        StringBuilder sb = new StringBuilder();
        String lineSep = GDE.LINE_SEPARATOR;
        int tmpValue = 0;
        tmpValue = ((dataBuffer[7] & 0xFF) << 8) + (dataBuffer[6] & 0xFF) & 0xFFF;
        points[0] = tmpValue * 10;
        if (log.isLoggable(Level.FINE)) {
            sb.append("voltageReceiver [V] = " + points[0]).append(lineSep);
        }
        if ((tmpValue = ((dataBuffer[9] & 0xFF) << 8) + (dataBuffer[8] & 0xFF)) > 32768) {
            tmpValue -= 65536;
        }
        points[1] = tmpValue * 10;
        if (log.isLoggable(Level.FINE)) {
            sb.append("voltage [V] = " + points[1]).append(lineSep);
        }
        tmpValue = (tmpValue = ((dataBuffer[11] & 0xFF) << 8) + (dataBuffer[10] & 0xFF)) <= 55536 ? tmpValue : tmpValue - 65536;
        points[2] = tmpValue * 10;
        if (log.isLoggable(Level.FINE)) {
            sb.append("current [A] = " + points[2]).append(lineSep);
        }
        points[3] = 0;
        points[4] = 0;
        points[5] = 0;
        points[6] = 0;
        tmpValue = ((dataBuffer[13] & 0xFF) << 8) + (dataBuffer[12] & 0xFF);
        if (tmpValue > 50000) {
            tmpValue = (tmpValue - 50000) * 10 + 50000;
        }
        points[7] = tmpValue * 1000;
        if (log.isLoggable(Level.FINE)) {
            sb.append("revolution speed [1/min] = " + points[7]).append(lineSep);
        }
        points[8] = 0;
        tmpValue = ((dataBuffer[15] & 0xFF) << 8) + (dataBuffer[14] & 0xFF) + 20000;
        if (tmpValue > 32768) {
            tmpValue -= 65536;
        }
        points[9] = tmpValue * 100;
        if (log.isLoggable(Level.FINE)) {
            sb.append("height [m] = " + points[9]).append(lineSep);
        }
        points[10] = 0;
        int a1Modus = (dataBuffer[7] & 0xF0) >> 4;
        a1Modus = a1Modus > 3 ? 3 : a1Modus;
        tmpValue = ((dataBuffer[17] & 0xFF) << 8) + (dataBuffer[16] & 0xFF);
        if (tmpValue > 32768) {
            tmpValue -= 65536;
        }
        points[11] = tmpValue * 100;
        if (log.isLoggable(Level.FINE)) {
            sb.append("a1Modus = " + a1Modus).append(lineSep);
            if (a1Modus == 0) {
                sb.append("temperatur [\u00b0C] = " + points[12]).append(lineSep);
            } else if (a1Modus == 1) {
                sb.append("voltage [mV] = " + points[12]).append(lineSep);
            } else if (a1Modus == 2) {
                sb.append("speed 250 [km/h] = " + points[12]).append(lineSep);
            } else if (a1Modus == 3) {
                sb.append("speed 400 [km/h] = " + points[12]).append(lineSep);
            }
        }
        if ((a2Modus = (dataBuffer[4] & 0x30) >> 4) == 0 || a2Modus == 2) {
            tmpValue = ((dataBuffer[19] & 0xEF) << 8) + (dataBuffer[18] & 0xFF);
            tmpValue = tmpValue > 32768 ? tmpValue - 65536 : tmpValue;
            points[12] = tmpValue * 100;
        } else if (a2Modus == 1 || a2Modus == 3) {
            tmpValue = ((dataBuffer[19] & 0xFF) << 8) + (dataBuffer[18] & 0xFF);
            points[12] = tmpValue * 1000;
        }
        if (log.isLoggable(Level.FINE)) {
            sb.append("a2Modus = " + a2Modus).append(lineSep);
            if (a2Modus == 0) {
                sb.append("tempreature [\u00b0C] = " + points[12]).append(lineSep);
            } else if (a2Modus == 1) {
                sb.append("impulseTime [us] = " + points[12]).append(lineSep);
            } else if (a2Modus == 2) {
                sb.append("voltage [mV] = " + points[12]).append(lineSep);
            } else if (a2Modus == 3) {
                sb.append("capacity [mAh] = " + points[12]).append(lineSep);
            }
        }
        int a3Modus = (dataBuffer[4] & 0xC0) >> 6;
        tmpValue = ((dataBuffer[21] & 0xEF) << 8) + (dataBuffer[20] & 0xFF);
        if (a3Modus == 0 || a3Modus == 1 || a3Modus == 3) {
            if (tmpValue > 32768) {
                tmpValue -= 65536;
            }
            points[13] = tmpValue * 100;
        } else if (a3Modus == 2) {
            points[13] = tmpValue * 100;
        }
        if (log.isLoggable(Level.FINE)) {
            sb.append("a3Modus = " + a3Modus).append(lineSep);
            if (a3Modus == 0) {
                sb.append("external Temperature [\u00b0C] = " + points[13]).append(lineSep);
            } else if (a3Modus == 1) {
                sb.append("internal Temperature [\u00b0C] = " + points[13]).append(lineSep);
            } else if (a3Modus == 2) {
                sb.append("energy [Wmin] = " + points[13]).append(lineSep);
            } else if (a3Modus == 3) {
                sb.append("voltage [mV] = " + points[13]).append(lineSep);
            } else {
                sb.append("a3Value = " + points[13]).append(lineSep);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, sb.toString());
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 0;
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
            }
            recordSet.setTimeStep_ms((double)((Integer)timeStamps.lastElement()).intValue() / (double)(timeStamps.size() - 1) / 10.0);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            }
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[7] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[9] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
            points[11] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
            points[12] = ((convertBuffer[24] & 0xFF) << 24) + ((convertBuffer[25] & 0xFF) << 16) + ((convertBuffer[26] & 0xFF) << 8) + ((convertBuffer[27] & 0xFF) << 0);
            points[13] = ((convertBuffer[28] & 0xFF) << 24) + ((convertBuffer[29] & 0xFF) << 16) + ((convertBuffer[30] & 0xFF) << 8) + ((convertBuffer[31] & 0xFF) << 0);
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                double currentOffset = 0.0;
                double rpmFactor = 1.0;
                double numberMotor = 1.0;
                PropertyType property = null;
                switch (record.getOrdinal()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        property = record.getProperty(CURRENT_OFFSET);
                        currentOffset = property != null ? Double.valueOf(property.getValue()) : 0.0;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        property = record.getProperty(RPM_FACTOR);
                        rpmFactor = property != null ? Double.valueOf(property.getValue()) : 1.0;
                        property = record.getProperty(NUMBER_MOTOR);
                        numberMotor = property != null ? Double.valueOf(property.getValue()) : 1.0;
                        break;
                    }
                    case 9: {
                        property = record.getProperty(DO_SUBTRACT_FIRST);
                        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                        property = record.getProperty(DO_SUBTRACT_LAST);
                        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                        try {
                            if (subtractFirst) {
                                reduction = (double)record.getFirst().intValue() / 1000.0;
                                break;
                            }
                            if (!subtractLast) break;
                            reduction = (double)record.getLast().intValue() / 1000.0;
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, record.getParent().getName() + " " + record.getName() + " " + e.getMessage());
                        }
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        log.log(Level.WARNING, "exceed known record names");
                    }
                }
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + (((double)record.realGet(rowIndex).intValue() / 1000.0 + currentOffset) * rpmFactor / numberMotor - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public String[] prepareRawExportRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            String[] recordNames = recordSet.getRecordNames();
            int index = 1;
            for (int j = 0; index < dataTableRow.length && j < recordNames.length; ++j) {
                Record record = recordSet.get((Object)recordNames[j]);
                MeasurementType measurement = this.getMeasurement(recordSet.getChannelConfigNumber(), record.getOrdinal());
                if (measurement.isCalculation()) continue;
                dataTableRow[index] = String.format("%d", record.realGet(rowIndex));
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double newValue = value;
        PropertyType property = null;
        switch (record.getOrdinal()) {
            case 2: {
                newValue = value + record.getOffset();
                break;
            }
            case 7: {
                property = record.getProperty(NUMBER_MOTOR);
                double numberMotor = property != null ? Double.valueOf(property.getValue()) : 1.0;
                newValue = value * record.getFactor() / numberMotor;
                break;
            }
            case 9: {
                property = record.getProperty(DO_SUBTRACT_FIRST);
                boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                property = record.getProperty(DO_SUBTRACT_LAST);
                boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                try {
                    if (subtractFirst) {
                        newValue = value - (double)record.getFirst().intValue() / 1000.0;
                        break;
                    }
                    if (!subtractLast) break;
                    newValue = value - (double)record.getLast().intValue() / 1000.0;
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage());
                }
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                newValue = record.getFactor() * value + record.getOffset();
                break;
            }
        }
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double newValue = value;
        PropertyType property = null;
        switch (record.getOrdinal()) {
            case 2: {
                newValue = value - record.getOffset();
                break;
            }
            case 7: {
                property = record.getProperty(NUMBER_MOTOR);
                double numberMotor = property != null ? Double.valueOf(property.getValue()) : 1.0;
                newValue = value * numberMotor / record.getFactor();
                break;
            }
            case 9: {
                property = record.getProperty(DO_SUBTRACT_FIRST);
                boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                property = record.getProperty(DO_SUBTRACT_LAST);
                boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                try {
                    if (subtractFirst) {
                        newValue = value + (double)record.getFirst().intValue() / 1000.0;
                        break;
                    }
                    if (!subtractLast) break;
                    newValue = value + (double)record.getLast().intValue() / 1000.0;
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage());
                }
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                newValue = (value - record.getOffset()) / record.getFactor();
                break;
            }
        }
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        boolean configChanged = this.isChangePropery();
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + measurementNames[i]);
            }
            if (includeReasonableDataCheck) {
                boolean state = record.hasReasonableData();
                log.log(Level.TIME, record.getName() + " hasReasonableData " + state);
                record.setActive(Boolean.valueOf(state));
                record.setDisplayable(state);
                continue;
            }
            if (record.isActive() == measurement.isActive()) continue;
            record.setActive(Boolean.valueOf(measurement.isActive()));
            record.setVisible(measurement.isActive());
            record.setDisplayable(measurement.isActive());
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
        }
        if (!includeReasonableDataCheck) {
            boolean enabled = recordSet.get(2).isActive();
            recordSet.get(3).setDisplayable(enabled);
            enabled = recordSet.get(1).isActive() && recordSet.get(2).isActive();
            recordSet.get(4).setDisplayable(enabled);
            recordSet.get(5).setDisplayable(enabled);
            recordSet.get(6).setDisplayable(enabled);
            enabled = recordSet.get(1).isActive() && recordSet.get(2).isActive() && recordSet.get(7).isActive();
            recordSet.get(8).setDisplayable(enabled);
            recordSet.get(10).setDisplayable(recordSet.get(9).isActive());
        }
        this.setChangePropery(configChanged);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            int displayableCounter = 0;
            for (int i = 0; i < recordSet.size(); ++i) {
                Record tmpRecord = recordSet.get(i);
                if (!tmpRecord.isActive() || !tmpRecord.isDisplayable()) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "add to displayable counter: " + tmpRecord.getName());
                }
                ++displayableCounter;
            }
            Record record = recordSet.get(3);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "start data calculation for record = " + record.getName());
            }
            record.setDisplayable(false);
            record.clear();
            Record recordCurrent = recordSet.get(2);
            double timeStep_ms = recordCurrent.getAverageTimeStep_ms();
            Double capacity = 0.0;
            for (int i = 0; i < recordCurrent.size(); ++i) {
                capacity = i > 0 ? capacity + (double)recordCurrent.get(i).intValue() * timeStep_ms / 3600.0 : 0.0;
                record.add(Integer.valueOf(capacity.intValue()));
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "adding value = " + record.get(i));
            }
            if (recordCurrent.isDisplayable()) {
                record.setDisplayable(true);
                ++displayableCounter;
            }
            record = recordSet.get(4);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "start data calculation for record = " + record.getName());
            }
            record.setDisplayable(false);
            record.clear();
            Record recordVoltage = recordSet.get(1);
            recordCurrent = recordSet.get(2);
            for (int i = 0; i < recordVoltage.size(); ++i) {
                record.add(Integer.valueOf(Double.valueOf(1.0 * (double)recordVoltage.get(i).intValue() * (double)recordCurrent.get(i).intValue() / 1000.0).intValue()));
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "adding value = " + record.get(i));
            }
            if (recordVoltage.isDisplayable() && recordCurrent.isDisplayable()) {
                record.setDisplayable(true);
                ++displayableCounter;
            }
            record = recordSet.get(5);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "start data calculation for record = " + record.getName());
            }
            record.setDisplayable(false);
            record.clear();
            recordVoltage = recordSet.get(1);
            recordCurrent = recordSet.get(2);
            timeStep_ms = recordVoltage.getAverageTimeStep_ms();
            Double power = 0.0;
            for (int i = 0; i < recordVoltage.size(); ++i) {
                power = i > 0 ? power + (double)recordVoltage.get(i).intValue() / 1000.0 * ((double)recordCurrent.get(i).intValue() / 1000.0) * (timeStep_ms / 3600.0) : 0.0;
                record.add(Integer.valueOf(power.intValue()));
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "adding value = " + record.get(i));
            }
            if (recordVoltage.isDisplayable() && recordCurrent.isDisplayable()) {
                record.setDisplayable(true);
                ++displayableCounter;
            }
            record = recordSet.get(6);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "start data calculation for record = " + record.getName());
            }
            record.setDisplayable(false);
            record.clear();
            recordVoltage = recordSet.get(1);
            PropertyType property = record.getProperty(NUMBER_CELLS);
            int numberCells = property != null ? Integer.valueOf(property.getValue()) : 4;
            for (int i = 0; i < recordVoltage.size(); ++i) {
                record.add(Integer.valueOf(Double.valueOf((double)recordVoltage.get(i).intValue() / (double)numberCells).intValue()));
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "adding value = " + record.get(i));
            }
            if (recordVoltage.isDisplayable()) {
                record.setDisplayable(true);
                ++displayableCounter;
            }
            record = recordSet.get(8);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "start data calculation for record = " + record.getName());
            }
            record.setDisplayable(false);
            record.clear();
            Record recordRevolution = recordSet.get(7);
            property = recordRevolution.getProperty(RPM_FACTOR);
            double rpmFactor = property != null ? Double.valueOf(property.getValue()) : 1.0;
            property = recordRevolution.getProperty(NUMBER_MOTOR);
            double numberMotor = property != null ? Double.valueOf(property.getValue()) : 1.0;
            Record recordPower = recordSet.get(4);
            property = record.getProperty(PROP_N_100_W);
            int prop_n100W = property != null ? Integer.valueOf(property.getValue()) : 10000;
            recordCurrent = recordSet.get(2);
            Record recordA1 = recordSet.get(11);
            double eta = 0.0;
            for (int i = 0; i < recordRevolution.size(); ++i) {
                if (i > 1 && recordRevolution.get(i) > 100000 && recordCurrent.get(i) > 3000) {
                    if (prop_n100W == 99999) {
                        eta = Math.PI * 2 * this.translateValue(recordA1, (double)recordA1.get(i).intValue() / 1000.0) * ((double)recordRevolution.get(i).intValue() / 1000.0) / ((double)recordVoltage.get(i).intValue() / 1000.0 * ((double)recordCurrent.get(i).intValue() / 1000.0) * 60.0);
                        log.log(Level.INFO, String.format("(2 * %4.3f * %3.1fNcm * %5.0frpm) / (%3.1fV * %3.1fA * 60 * 100) = %4.2f", Math.PI, this.translateValue(recordA1, (double)recordA1.get(i).intValue() / 1000.0), (double)recordRevolution.get(i).intValue() / 1000.0, (double)recordVoltage.get(i).intValue() / 1000.0, (double)recordCurrent.get(i).intValue() / 1000.0, eta));
                    } else {
                        double motorPower = Math.pow((double)recordRevolution.get(i).intValue() * rpmFactor / numberMotor / 1000.0 * 4.64 / (double)prop_n100W, 3.0) * 1000.0;
                        eta = motorPower * 100.0 / (double)recordPower.get(i).intValue();
                        double d = eta > 100.0 ? (double)((Integer)record.lastElement()).intValue() / 1000.0 : (eta = eta < 0.0 ? 0.0 : eta);
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, String.format("current=%5.1f; recordRevolution=%5.0f; recordPower=%6.2f; motorPower=%6.2f eta=%5.1f", (double)recordCurrent.get(i).intValue() / 1000.0, (double)recordRevolution.get(i).intValue() / 1000.0, (double)recordPower.get(i).intValue() / 1000.0, motorPower / 1000.0, eta));
                        }
                    }
                    record.add(Integer.valueOf(Double.valueOf(eta * 1000.0).intValue()));
                } else {
                    record.add(Integer.valueOf(0));
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "adding value = " + record.get(i));
            }
            if (recordRevolution.isDisplayable() && recordPower.isDisplayable()) {
                record.setDisplayable(true);
                ++displayableCounter;
            }
            boolean isNoSlopeCalculationStarted = true;
            record = recordSet.get(10);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "start data calculation for record = " + record.getName());
            }
            record.setDisplayable(false);
            record.clear();
            property = record.getProperty(CalculationThread.REGRESSION_INTERVAL_SEC);
            int regressionInterval = property != null ? Integer.valueOf(property.getValue()) : 4;
            property = record.getProperty(CalculationThread.REGRESSION_TYPE);
            this.calculationThread = property == null || property.getValue().equals(CalculationThread.REGRESSION_TYPE_CURVE) ? new QuasiLinearRegression(recordSet, recordSet.get(9).getName(), recordSet.get(10).getName(), regressionInterval) : new LinearRegression(recordSet, recordSet.get(9).getName(), recordSet.get(10).getName(), regressionInterval);
            try {
                this.calculationThread.start();
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            if (recordSet.get(9).isDisplayable()) {
                isNoSlopeCalculationStarted = false;
                ++displayableCounter;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "displayableCounter = " + displayableCounter);
            }
            recordSet.setConfiguredDisplayable(displayableCounter);
            if (isNoSlopeCalculationStarted) {
                this.application.updateGraphicsWindow();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "finished data calculation for record = " + record.getName());
            }
        }
    }

    public UniLogDialog getDialog() {
        return this.dialog;
    }

    public UniLogSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION, NUMBER_CELLS, PROP_N_100_W, CalculationThread.REGRESSION_INTERVAL_SEC, CalculationThread.REGRESSION_TYPE};
    }

    public void updateInitialRecordSetComment(RecordSet recordSet) {
        recordSet.setRecordSetDescription(String.format("%s; \n%s : %s; %s : %s; ", recordSet.getRecordSetDescription(), SERIAL_NUMBER, this.getDialog().serialNumber, FIRMEWARE_VERSION, this.getDialog().unilogVersion));
    }

    public void invertRecordData(Record record) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < record.realSize(); ++i) {
            int value = record.get(i) * -1;
            record.set(i, Integer.valueOf(value));
            if (i != 0) {
                if (value > max) {
                    max = value;
                }
                if (value >= min) continue;
                min = value;
                continue;
            }
            min = max = value;
        }
        record.setMinMax(min, max);
    }

    public void open_closeCommPort() {
        if (this.serialPort != null) {
            if (!this.serialPort.isConnected()) {
                try {
                    Channel activChannel = Channels.getInstance().getActiveChannel();
                    if (activChannel != null) {
                        this.getDialog().liveThread = new UniLogLiveGatherer(this.application, this, this.serialPort, activChannel.getNumber(), this.getDialog());
                        this.getDialog().setButtonStateLiveGatherer(false);
                        this.getDialog().liveThread.start();
                    }
                }
                catch (SerialPortException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    this.getDialog().setButtonStateLiveGatherer(true);
                }
                catch (ApplicationConfigurationException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                    this.getDialog().setButtonStateLiveGatherer(true);
                    this.application.getDeviceSelectionDialog().open();
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, t.getMessage(), t);
                    this.getDialog().setButtonStateLiveGatherer(true);
                }
            } else {
                if (this.getDialog().liveThread != null) {
                    this.getDialog().liveThread.stopTimerThread();
                }
                if (this.getDialog().gatherThread != null) {
                    this.getDialog().gatherThread.setThreadStop();
                }
                this.serialPort.close();
                this.getDialog().setButtonStateLiveGatherer(true);
            }
        }
    }

    public void updateMeasurementByAnalogModi(byte[] dataBuffer, int channelConfigKey) {
        int a1Modus;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "visit updateMeasurementByAnalogModi");
        }
        a1Modus = (a1Modus = (dataBuffer[7] & 0xF0) >> 4) > 3 ? 3 : a1Modus;
        int a2Modus = (dataBuffer[4] & 0x30) >> 4;
        int a3Modus = (dataBuffer[4] & 0xC0) >> 6;
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("a1Modus = " + a1Modus).append(GDE.LINE_SEPARATOR);
            sb.append("a2Modus = " + a2Modus).append(GDE.LINE_SEPARATOR);
            sb.append("a3Modus = " + a3Modus).append(GDE.LINE_SEPARATOR);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, sb.toString());
            }
        }
        MeasurementType measurement = this.getMeasurement(channelConfigKey, 11);
        measurement.setName(UniLogDialog.A1_MODUS_NAMES[a1Modus].trim());
        measurement.setUnit(UniLogDialog.A1_MODUS_UNITS[a1Modus].trim());
        measurement = this.getMeasurement(channelConfigKey, 12);
        measurement.setName(UniLogDialog.A2_MODUS_NAMES[a2Modus].trim());
        measurement.setUnit(UniLogDialog.A2_MODUS_UNITS[a2Modus].trim());
        measurement = this.getMeasurement(channelConfigKey, 13);
        measurement.setName(UniLogDialog.A3_MODUS_NAMES[a3Modus].trim());
        measurement.setUnit(UniLogDialog.A3_MODUS_UNITS[a3Modus].trim());
    }
}

