/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.guard;

import gde.messages.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Reminder {
    private final ReminderType reminderType;
    private final double farLimit;
    private final double closeLimit;
    private final List<Double> decodedValues = new ArrayList<Double>();
    private final List<Integer> indices = new ArrayList<Integer>();
    private final int selectIndex;
    private final String selectText;

    public Reminder(ReminderType reminderType, double farLimit, double closeLimit, int selectIndex, String selectText) {
        this.reminderType = reminderType;
        this.farLimit = farLimit;
        this.closeLimit = closeLimit;
        this.selectIndex = selectIndex;
        this.selectText = selectText;
    }

    public boolean add(double decodedValue, int index) {
        this.indices.add(index);
        return this.decodedValues.add(decodedValue);
    }

    public ReminderType getReminderType() {
        return this.reminderType;
    }

    public double getFarLimit() {
        return this.farLimit;
    }

    public double getCloseLimit() {
        return this.closeLimit;
    }

    public List<Double> getDecodedValues() {
        return this.decodedValues;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public String getSelectText() {
        return this.selectText;
    }

    public String toString() {
        String values = Arrays.toString((Object[])this.decodedValues.toArray(new Double[0]));
        return this.reminderType.toString() + " farLimit/closeLimit/values=" + this.farLimit + "/" + this.closeLimit + "/" + values;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ReminderType {
        NONE{

            @Override
            public String localizedText() {
                return "";
            }
        }
        ,
        WHISKER{

            @Override
            public String localizedText() {
                return Messages.getString("GDE_MSGT0910");
            }
        }
        ,
        CLOSE{

            @Override
            public String localizedText() {
                return Messages.getString("GDE_MSGT0905");
            }
        }
        ,
        FAR{

            @Override
            public String localizedText() {
                return Messages.getString("GDE_MSGT0904");
            }
        };

        public static final ReminderType[] VALUES;

        public static ReminderType fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        public static ReminderType min(ReminderType a, ReminderType b) {
            if (a == NONE) {
                return b;
            }
            if (b == NONE) {
                return a;
            }
            return ReminderType.fromOrdinal(Math.min(a.ordinal(), b.ordinal()));
        }

        public static ReminderType max(ReminderType a, ReminderType b) {
            return ReminderType.fromOrdinal(Math.max(a.ordinal(), b.ordinal()));
        }

        public boolean isIncluded(int reminderLevel) {
            return reminderLevel >= this.ordinal();
        }

        public abstract String localizedText();

        static {
            VALUES = ReminderType.values();
        }
    }
}

