/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.guard;

import gde.Analyzer;
import gde.device.IChannelItem;
import gde.device.IDevice;
import gde.device.ScoreLabelTypes;
import gde.histo.cache.HistoVault;
import gde.histo.cache.VaultReaderWriter;
import gde.histo.config.HistoGraphicsTemplate;
import gde.histo.datasources.SourceFolders;
import gde.histo.datasources.VaultChecker;
import gde.histo.device.ChannelItems;
import gde.histo.exclusions.InclusionData;
import gde.histo.guard.Guardian;
import gde.histo.guard.ObjectVaultIndex;
import gde.histo.guard.Reminder;
import gde.histo.recordings.TrailSelector;
import gde.log.Level;
import gde.log.Logger;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class FleetMonitor {
    private static final String $CLASS_NAME = FleetMonitor.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final Analyzer analyzer;

    public FleetMonitor(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public HashMap<String, ObjectSummary> defineDeviceSummaries(String objectKey) {
        HashMap<String, ObjectSummary> deviceSummaries = new HashMap<String, ObjectSummary>();
        this.analyzer.getSettings().setActiveObjectKey(objectKey);
        ObjectVaultIndex objectVaultIndex = new ObjectVaultIndex(new String[]{objectKey}, this.analyzer.getDataAccess(), this.analyzer.getSettings());
        Set<String> indexedDeviceNames = objectVaultIndex.selectDeviceNames(new String[]{objectKey}, ObjectVaultIndex.DetailSelector.createDummyFilter());
        HashMap<String, IDevice> usedDevices = this.analyzer.getDeviceConfigurations().getAsDevices(indexedDeviceNames);
        log.log(Level.FINER, "devices", usedDevices);
        ObjectVaultIndex.DetailSelector detailSelector = ObjectVaultIndex.DetailSelector.createDeviceNameFilter(usedDevices.keySet());
        Function<ObjectVaultIndex.ObjectVaultIndexEntry, String> classifier = e -> e.vaultDeviceName;
        TreeMap<String, List<ObjectVaultIndex.VaultKeyPair>> vaultKeys = objectVaultIndex.selectGroupedVaultKeys(objectKey, detailSelector, classifier);
        for (Map.Entry<String, List<ObjectVaultIndex.VaultKeyPair>> e2 : vaultKeys.entrySet()) {
            List<ObjectVaultIndex.VaultKeyPair> vaults = e2.getValue();
            IDevice device = (IDevice)usedDevices.get(e2.getKey());
            int arbitraryChannelNumber = -1;
            this.analyzer.setArena(device, arbitraryChannelNumber, objectKey);
            Map<Integer, TreeSet<HistoVault>> channelVaults = this.getValidVaults(vaults);
            if (channelVaults.isEmpty()) continue;
            ObjectSummary objectSummary = ObjectSummary.createObjectSummary(channelVaults, this.analyzer);
            log.off(() -> objectSummary.toString());
            deviceSummaries.put(device.getName(), objectSummary);
        }
        return deviceSummaries;
    }

    private Map<Integer, TreeSet<HistoVault>> getValidVaults(List<ObjectVaultIndex.VaultKeyPair> vaults) {
        HashMap<Integer, TreeSet<HistoVault>> channelVaults = new HashMap<Integer, TreeSet<HistoVault>>();
        EnumSet<SourceFolders.DirectoryType> directoryTypes = SourceFolders.DirectoryType.getValidDirectoryTypes(this.analyzer.getActiveDevice(), this.analyzer.getSettings());
        SourceFolders sourceFolders = new SourceFolders(this.analyzer);
        sourceFolders.defineDirectories(s -> {});
        Predicate<HistoVault> checker = vault -> new VaultChecker(this.analyzer).isValidVault((HistoVault)vault, directoryTypes, sourceFolders);
        Comparator comparator = (v1, v2) -> Long.compare(v2.getLogStartTimestamp_ms(), v1.getLogStartTimestamp_ms());
        List<HistoVault> allVaults = new VaultReaderWriter(this.analyzer, Optional.empty()).loadFromCaches(vaults);
        for (HistoVault vault2 : allVaults) {
            int logChannelNumber = vault2.getLogChannelNumber();
            this.analyzer.setChannelNumber(logChannelNumber);
            if (!checker.test(vault2)) continue;
            if (channelVaults.get(logChannelNumber) == null) {
                channelVaults.put(logChannelNumber, new TreeSet(comparator));
            }
            ((TreeSet)channelVaults.get(logChannelNumber)).add(vault2);
        }
        log.log(Level.INFO, String.format("valid vaults size=%,7d in %d channels", channelVaults.values().stream().mapToInt(Collection::size).sum(), channelVaults.size()));
        return channelVaults;
    }

    static final class ObjectSummary {
        String objectKey;
        String vaultDeviceName;
        int vaultCount = 0;
        int channelCount = 0;
        long minFileLastModified = Long.MAX_VALUE;
        long maxFileLastModified = 0L;
        long minStartTimestampMs = Long.MAX_VALUE;
        long maxStartTimestampMs = 0L;
        int minDuration_MM = Integer.MAX_VALUE;
        int maxDuration_MM = 0;
        Reminder.ReminderType[] minReminders = new Reminder.ReminderType[]{Reminder.ReminderType.NONE, Reminder.ReminderType.NONE};
        Reminder.ReminderType[] maxReminders = new Reminder.ReminderType[]{Reminder.ReminderType.NONE, Reminder.ReminderType.NONE};

        ObjectSummary() {
        }

        public static final ObjectSummary createObjectSummary(Map<Integer, TreeSet<HistoVault>> channelVaults, Analyzer analyzer) {
            ObjectSummary oS = new ObjectSummary();
            oS.objectKey = analyzer.getSettings().getActiveObjectKey();
            oS.vaultDeviceName = analyzer.getActiveDevice().getName();
            for (Map.Entry<Integer, TreeSet<HistoVault>> e : channelVaults.entrySet()) {
                analyzer.setChannelNumber(e.getKey());
                HistoVault[] indexedVaults = e.getValue().toArray(new HistoVault[e.getValue().size()]);
                ObjectSummary channelSummary = ObjectSummary.createChannelSummary(analyzer, indexedVaults);
                oS.vaultCount += channelSummary.vaultCount;
                ++oS.channelCount;
                oS.minFileLastModified = Math.min(oS.minFileLastModified, channelSummary.minFileLastModified);
                oS.maxFileLastModified = Math.max(oS.maxFileLastModified, channelSummary.maxFileLastModified);
                oS.minStartTimestampMs = Math.min(oS.minStartTimestampMs, channelSummary.minStartTimestampMs);
                oS.maxStartTimestampMs = Math.max(oS.maxStartTimestampMs, channelSummary.maxStartTimestampMs);
                oS.minDuration_MM = Math.min(oS.minDuration_MM, channelSummary.minDuration_MM);
                oS.maxDuration_MM = Math.max(oS.maxDuration_MM, channelSummary.maxDuration_MM);
                oS.minReminders[0] = Reminder.ReminderType.min(oS.minReminders[0], oS.minReminders[0]);
                oS.maxReminders[1] = Reminder.ReminderType.max(oS.maxReminders[1], oS.maxReminders[1]);
                oS.minReminders[0] = Reminder.ReminderType.min(oS.minReminders[0], oS.minReminders[0]);
                oS.maxReminders[1] = Reminder.ReminderType.max(oS.maxReminders[1], oS.maxReminders[1]);
            }
            log.log(Level.INFO, "objectSummary", oS);
            return oS;
        }

        private static final ObjectSummary createChannelSummary(Analyzer analyzer, HistoVault[] indexedVaults) {
            ObjectSummary oS = new ObjectSummary();
            oS.objectKey = analyzer.getSettings().getActiveObjectKey();
            oS.vaultDeviceName = analyzer.getActiveDevice().getName();
            oS.vaultCount = indexedVaults.length;
            for (HistoVault v : indexedVaults) {
                oS.minFileLastModified = Math.min(oS.minFileLastModified, v.getLogFileLastModified());
                oS.maxFileLastModified = Math.max(oS.maxFileLastModified, v.getLogFileLastModified());
                oS.minStartTimestampMs = Math.min(oS.minStartTimestampMs, v.getLogStartTimestamp_ms());
                oS.maxStartTimestampMs = Math.max(oS.maxStartTimestampMs, v.getLogStartTimestamp_ms());
                oS.minDuration_MM = Math.min(oS.minDuration_MM, v.getScores().get(ScoreLabelTypes.DURATION_MM.ordinal()).getValue());
                oS.maxDuration_MM = Math.max(oS.maxDuration_MM, v.getScores().get(ScoreLabelTypes.DURATION_MM.ordinal()).getValue());
            }
            oS.channelCount = (int)Arrays.stream(indexedVaults).map(HistoVault::getLogChannelNumber).distinct().count();
            HistoGraphicsTemplate template = HistoGraphicsTemplate.createTransitoryTemplate(analyzer);
            template.load();
            boolean smartStatistics = Boolean.parseBoolean(template.getProperty("RecordSet_smartStatistics", "true"));
            InclusionData inclusionData = new InclusionData(Paths.get(analyzer.getSettings().getDataFilePath(), oS.objectKey), analyzer.getDataAccess());
            Reminder.ReminderType[] minReminders = new Reminder.ReminderType[]{Reminder.ReminderType.NONE, Reminder.ReminderType.NONE};
            Reminder.ReminderType[] maxReminders = new Reminder.ReminderType[]{Reminder.ReminderType.NONE, Reminder.ReminderType.NONE};
            int logLimit = analyzer.getSettings().getReminderCount();
            BiConsumer<Integer, IChannelItem> channelItemAction = (idx, itm) -> {
                boolean isActive = Boolean.parseBoolean(template.getRecordProperty(itm.getName(), "_isActive", "true"));
                boolean isIncluded = inclusionData.isIncluded(itm.getName(), true);
                if (!isActive || !isIncluded) {
                    return;
                }
                TrailSelector trailSelector = itm.createTrailSelector(analyzer, itm.getName(), smartStatistics);
                Reminder[] minMaxReminder = Guardian.defineMinMaxReminder(indexedVaults, itm, trailSelector, logLimit, analyzer.getSettings());
                if (minMaxReminder[0] != null) {
                    minMaxReminder[0] = minMaxReminder[0];
                    if (minMaxReminder[0].getReminderType().ordinal() > maxReminders[0].ordinal()) {
                        log.off(() -> "idx=" + idx + " " + itm.getName() + ":  low  warning increased " + String.valueOf((Object)minMaxReminder[0].getReminderType()));
                    }
                    minReminders[0] = Reminder.ReminderType.min(minReminders[0], minMaxReminder[0].getReminderType());
                    maxReminders[0] = Reminder.ReminderType.max(maxReminders[0], minMaxReminder[0].getReminderType());
                }
                if (minMaxReminder[1] != null) {
                    minMaxReminder[1] = minMaxReminder[0];
                    if (minMaxReminder[1].getReminderType().ordinal() > maxReminders[1].ordinal()) {
                        log.off(() -> "idx=" + idx + " " + itm.getName() + ":  high warning increased " + String.valueOf((Object)minMaxReminder[1].getReminderType()));
                    }
                    minReminders[1] = Reminder.ReminderType.min(minReminders[1], minMaxReminder[1].getReminderType());
                    maxReminders[1] = Reminder.ReminderType.max(maxReminders[1], minMaxReminder[1].getReminderType());
                }
            };
            ChannelItems channelItems = new ChannelItems(analyzer);
            channelItems.processItems(channelItemAction, channelItemAction, channelItemAction);
            oS.minReminders = minReminders;
            oS.maxReminders = maxReminders;
            return oS;
        }

        public String toString() {
            return "ObjectSummary [objectKey=" + this.objectKey + ", vaultDeviceName=" + this.vaultDeviceName + ", maxFileLastModified=" + this.maxFileLastModified + ", maxStartTimestampMs=" + this.maxStartTimestampMs + ", maxDuration_MM=" + this.maxDuration_MM + ", maxWarning=" + Arrays.toString((Object[])this.maxReminders) + ", vaultCount=" + this.vaultCount + ", channelCount=" + this.channelCount + "]";
        }
    }

    static final class ObjectDetail {
        String objectKey;
        String vaultDeviceName;
        int vaultChannelNumber;
        String logFilePath;
        long logFileLastModified;
        String logRecordsetBaseName;
        int logChannelNumber;
        long logStartTimestampMs;

        ObjectDetail() {
        }
    }
}

