/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.gpslocations;

import gde.DataAccess;
import gde.GDE;
import gde.histo.utils.GpsCoordinate;
import gde.log.Level;
import gde.log.Logger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class GeoCodes {
    static final String $CLASS_NAME = GeoCodes.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);

    public static String getOrAcquireLocation(GpsCoordinate gpsCoordinate, double locationRadius, DataAccess dataAccess) {
        if (GDE.EXECUTION_ENV != null) {
            return "";
        }
        String location = "";
        ((DataAccess.LocalAccess)dataAccess).checkAndCreateHistoLocations();
        GeoFiles geoFiles = new GeoFiles(dataAccess, locationRadius);
        try {
            String geoFileName = geoFiles.getGeoFileName(gpsCoordinate);
            if (dataAccess.existsGeoCodeFile(geoFileName)) {
                location = geoFiles.getLocation(geoFileName);
            } else {
                geoFileName = geoFiles.acquireValidatedGeoData(gpsCoordinate);
                if (dataAccess.existsGeoCodeFile(geoFileName)) {
                    location = geoFiles.getLocation(geoFileName);
                } else {
                    log.log(java.util.logging.Level.WARNING, "geoCode file not found");
                }
            }
        }
        catch (FileNotFoundException e) {
            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
        }
        return location;
    }

    private static final class GeoFiles {
        private final DataAccess dataAccess;
        private final double gpsLocationRadius;

        public GeoFiles(DataAccess dataAccess, double locationRadius) {
            this.dataAccess = dataAccess;
            this.gpsLocationRadius = locationRadius;
        }

        String getLocation(String fileName) {
            String location = "";
            try (InputStream inputStream = this.dataAccess.getGeoCodeInputStream(fileName);){
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
                GeoCodeProvider geoCodeProvider = GeoCodeProvider.get(doc);
                XPath xpath = XPathFactory.newInstance().newXPath();
                if (geoCodeProvider.isResponseOk(doc, xpath)) {
                    location = geoCodeProvider.getLocation(doc, xpath);
                }
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.WARNING, e.getMessage());
            }
            return location;
        }

        String getGeoFileName(GpsCoordinate gpsCoordinate) throws FileNotFoundException {
            List<String> fileNames = this.dataAccess.getGeoCodeFolderList();
            log.finer(() -> String.format("%04d files found in locationsDir %s", fileNames.size(), "Locations"));
            Comparator distanceComparator = (f1, f2) -> Double.compare(new GpsCoordinate((String)f1).getDistance(gpsCoordinate), new GpsCoordinate((String)f2).getDistance(gpsCoordinate));
            Predicate<String> minDistanceFilter = f -> new GpsCoordinate((String)f).getDistance(gpsCoordinate) < this.gpsLocationRadius;
            String closestFile = fileNames.parallelStream().filter(minDistanceFilter).min(distanceComparator).orElse("");
            log.log(Level.FINER, "closestFile", closestFile);
            return closestFile;
        }

        private String acquireValidatedGeoData(GpsCoordinate gpsCoordinate) {
            String geoFileName = GeoFiles.getGeoCodeFileName(gpsCoordinate);
            for (GeoCodeProvider geoCodeProvider : GeoCodeProvider.RANKED_VALUES) {
                this.loadGeoData(gpsCoordinate, geoCodeProvider);
                if (!this.dataAccess.existsGeoCodeFile(geoFileName)) continue;
                try (InputStream inputStream = this.dataAccess.getGeoCodeInputStream(geoFileName);){
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    if (geoCodeProvider.isResponseOk(doc, xpath) || geoCodeProvider.isResponseZero(doc, xpath)) break;
                    this.dataAccess.deleteGeoCodeFile(geoFileName);
                    log.log(java.util.logging.Level.FINER, "Empty file deleted", geoFileName);
                }
                catch (Exception e) {
                    this.dataAccess.deleteGeoCodeFile(geoFileName);
                    log.log(java.util.logging.Level.WARNING, "File deleted after IO / parser exception", e.getMessage());
                }
            }
            return geoFileName;
        }

        private void loadGeoData(GpsCoordinate gpsCoordinate, GeoCodeProvider geoCodeProvider) {
            if (GDE.EXECUTION_ENV != null) {
                return;
            }
            long milliTime = System.currentTimeMillis();
            String geoCodeFileName = GeoFiles.getGeoCodeFileName(gpsCoordinate);
            ((DataAccess.LocalAccess)this.dataAccess).checkAndCreateHistoLocations();
            try {
                URL requestUrl = geoCodeProvider.getRequestUrl(gpsCoordinate);
                try (InputStream inputStream = ((DataAccess.LocalAccess)this.dataAccess).getHttpsInputStream(requestUrl);
                     ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
                     FileOutputStream fileOutputStream = ((DataAccess.LocalAccess)this.dataAccess).getGeoCodeOutputStream(geoCodeFileName.toString());){
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, 0x100000L);
                    log.time(() -> "http read in " + (System.currentTimeMillis() - milliTime) + " ms!  gpsCoordinate=" + gpsCoordinate.toCsvString());
                }
                catch (Exception e1) {
                    log.log(java.util.logging.Level.WARNING, "saving geocodes from internet connection failed", e1.getMessage());
                }
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.WARNING, "internet connection failed, check network capability if location data required", e.getMessage());
            }
        }

        private static String getGeoCodeFileName(GpsCoordinate gpsCoordinate) {
            return gpsCoordinate.toAngularCoordinate();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GeoCodeProvider {
        GOOGLE_API(1, "GeocodeResponse"){

            @Override
            URL getRequestUrl(GpsCoordinate gpsCoordinate) {
                try {
                    String url = String.format(Locale.US, "https://maps.googleapis.com/maps/api/geocode/xml?latlng=%f,%f", gpsCoordinate.getLatitude(), gpsCoordinate.getLongitude());
                    return new URL(url);
                }
                catch (Exception e) {
                    throw new RuntimeException("Google malformed URL", e);
                }
            }

            @Override
            boolean isResponseOk(Document doc, XPath xpath) throws XPathExpressionException {
                String status = xpath.evaluate("/GeocodeResponse/status", doc, XPathConstants.STRING).toString();
                return "OK".equals(status);
            }

            @Override
            boolean isResponseZero(Document doc, XPath xpath) throws XPathExpressionException {
                String status = xpath.evaluate("/GeocodeResponse/status", doc, XPathConstants.STRING).toString();
                return "ZERO_RESULTS".equals(status);
            }

            @Override
            String getLocation(Document doc, XPath xpath) throws XPathExpressionException {
                XPathExpression expr = xpath.compile("/GeocodeResponse/result[type/text()='" + GeoCodeGoogle.STREET_ADDRESS.name().toLowerCase() + "']/formatted_address");
                String location = expr.evaluate(doc, XPathConstants.STRING).toString();
                log.log(java.util.logging.Level.FINER, "1st try formatted_address=", location);
                if (location.isEmpty()) {
                    NodeList nodes = (NodeList)xpath.evaluate("/GeocodeResponse/result/formatted_address", doc, XPathConstants.NODESET);
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        location = nodes.item(i).getTextContent();
                        if (location.isEmpty()) continue;
                        if (!log.isLoggable(java.util.logging.Level.FINER)) break;
                        log.log(java.util.logging.Level.FINER, "loop formatted_address=", nodes.item(i).getTextContent());
                        break;
                    }
                }
                return location.replace("Unnamed Road, ", "");
            }
        }
        ,
        OSM_NOMINATIM(0, "reversegeocode"){

            @Override
            URL getRequestUrl(GpsCoordinate gpsCoordinate) {
                try {
                    String url = String.format(Locale.US, "https://nominatim.openstreetmap.org/reverse?format=xml&lat=%f&lon=%f&zoom=18&addressdetails=1", gpsCoordinate.getLatitude(), gpsCoordinate.getLongitude());
                    log.log(Level.FINER, "OSM", url);
                    return new URL(url);
                }
                catch (Exception e) {
                    throw new RuntimeException("OSM malformed URL", e);
                }
            }

            @Override
            boolean isResponseOk(Document doc, XPath xpath) throws XPathExpressionException {
                String location = xpath.evaluate("/reversegeocode/result", doc, XPathConstants.STRING).toString();
                return !location.isEmpty();
            }

            @Override
            boolean isResponseZero(Document doc, XPath xpath) throws XPathExpressionException {
                String status = xpath.evaluate("/reversegeocode/error", doc, XPathConstants.STRING).toString();
                return "Unable to geocode".equals(status);
            }

            @Override
            String getLocation(Document doc, XPath xpath) throws XPathExpressionException {
                String location = xpath.evaluate("/reversegeocode/result", doc, XPathConstants.STRING).toString();
                log.log(java.util.logging.Level.FINER, "unmodified address=", location);
                return location;
            }
        };

        static final GeoCodeProvider[] VALUES;
        static final GeoCodeProvider[] RANKED_VALUES;
        private int rank;
        private String rootName;

        static GeoCodeProvider get(Document doc) {
            String nodeName = doc.getDocumentElement().getNodeName();
            if (nodeName.equals(GeoCodeProvider.OSM_NOMINATIM.rootName)) {
                return OSM_NOMINATIM;
            }
            if (nodeName.equals(GeoCodeProvider.GOOGLE_API.rootName)) {
                return GOOGLE_API;
            }
            throw new UnsupportedOperationException();
        }

        private GeoCodeProvider(int rank, String rootName) {
            this.rank = rank;
            this.rootName = rootName;
        }

        abstract URL getRequestUrl(GpsCoordinate var1);

        abstract boolean isResponseOk(Document var1, XPath var2) throws XPathExpressionException;

        abstract boolean isResponseZero(Document var1, XPath var2) throws XPathExpressionException;

        abstract String getLocation(Document var1, XPath var2) throws XPathExpressionException;

        static {
            VALUES = GeoCodeProvider.values();
            RANKED_VALUES = (GeoCodeProvider[])Arrays.stream(GeoCodeProvider.values()).sorted((p1, p2) -> Integer.compare(p1.rank, p2.rank)).toArray(GeoCodeProvider[]::new);
        }
    }

    public static enum GeoCodeGoogle {
        STREET_ADDRESS,
        ROUTE,
        POLITICAL,
        ADMINISTRATIVE_AREA_LEVEL_3,
        ADMINISTRATIVE_AREA_LEVEL_2;

        public static final GeoCodeGoogle[] VALUES;

        static {
            VALUES = GeoCodeGoogle.values();
        }
    }
}

