/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="data_types")
@XmlEnum
public enum DataTypes {
    INTEGER("Integer"),
    DOUBLE("Double"),
    BOOLEAN("Boolean"),
    STRING("String"),
    HEXADECIMAL("Hexadecimal");

    private final String value;

    private DataTypes(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static DataTypes fromValue(String v) {
        for (DataTypes c : DataTypes.values()) {
            if (!c.value.equalsIgnoreCase(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static String[] valuesAsStingArray() {
        StringBuilder sb = new StringBuilder();
        for (DataTypes element : DataTypes.values()) {
            sb.append(element.value).append(";");
        }
        return sb.toString().split(";");
    }
}

