/*
 * Decompiled with CFR 0.152.
 */
package gde.tools;

import gde.GDE;
import gde.exception.ApplicationConfigurationException;
import gde.log.Level;
import gde.log.LogFormatter;
import gde.utils.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class BuildCompleteHelpHtml {
    static Logger log = Logger.getLogger(BuildCompleteHelpHtml.class.getName());
    static Logger rootLogger;
    static String header_de;
    static String header_en;
    static String footer;
    static String supprtedDevices_de;
    static String supprtedDevices_en;
    static String filename_de;
    static String filename_en;
    static final String[] SUPPORTED_LANGUAGES;
    static final String[] SUPPORTED_LANGUAGE_HEADERS;
    static final String[] SUPPORTED_LANGUAGE_FILEPATHES;
    static final String[] SUPPORTED_LANGUAGE_DEVICES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, URISyntaxException, ApplicationConfigurationException {
        Object line = "*";
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            BuildCompleteHelpHtml.initLogger();
            URL url = BuildCompleteHelpHtml.class.getProtectionDomain().getCodeSource().getLocation();
            log.log(Level.INFO, "base URL = " + url.toString());
            Object baseFilePath = url.getFile();
            baseFilePath = ((String)baseFilePath).substring(1, ((String)baseFilePath).indexOf("DataExplorer") + "DataExplorer".length());
            String targetPath = (String)baseFilePath + "/doc/";
            baseFilePath = (String)baseFilePath + "/src/help";
            for (int i = 0; i < SUPPORTED_LANGUAGES.length; ++i) {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetPath + SUPPORTED_LANGUAGE_FILEPATHES[i]), "UTF-8"));
                writer.write(SUPPORTED_LANGUAGE_HEADERS[i]);
                String langFilePath = (String)baseFilePath + "/" + SUPPORTED_LANGUAGES[i];
                log.log(Level.INFO, "langFilePath = " + langFilePath);
                List<File> files = FileUtils.getFileListing(new File(langFilePath), 4);
                for (File file : files) {
                    if (!file.getAbsolutePath().toLowerCase().endsWith(".html") && !file.getAbsolutePath().toLowerCase().endsWith(".htm")) continue;
                    log.log(Level.INFO, "working with : " + String.valueOf(file));
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if (!((String)line).toUpperCase().contains("<DIV ID=\"CONTENT\"")) continue;
                        while ((line = reader.readLine()) != null && !((String)line).toUpperCase().contains("</DIV>")) {
                            if (((String)line).toUpperCase().contains("<IMG ")) {
                                line = ((String)line).substring(0, ((String)line).toUpperCase().indexOf("SRC=\"") + 5) + "../src/help/" + SUPPORTED_LANGUAGES[i] + "/" + ((String)line).substring(((String)line).toUpperCase().indexOf("SRC=\"") + 5);
                            }
                            if (((String)line).contains("&lt;&lt;==") || ((String)line).contains("==&gt;&gt;")) continue;
                            writer.write((String)line + "\n");
                        }
                    }
                    reader.close();
                }
                writer.write("<H1>" + SUPPORTED_LANGUAGE_DEVICES[i] + "</H1>\n");
                URL[] urls = ((URLClassLoader)GDE.getClassLoader()).getURLs();
                for (int j = 0; j < urls.length; ++j) {
                    Object pluginBaseFilePath = urls[j].getPath().substring(1, urls[j].getPath().indexOf("bin"));
                    if (!new File((String)(pluginBaseFilePath = (String)pluginBaseFilePath + "src/help")).exists() || ((String)pluginBaseFilePath).contains("DataExplorer") || ((String)pluginBaseFilePath).contains("Sample")) continue;
                    String pluginLangFilePath = (String)pluginBaseFilePath + "/" + SUPPORTED_LANGUAGES[i];
                    log.log(Level.INFO, "pluginLangFilePath = " + pluginLangFilePath);
                    files = FileUtils.getFileListing(new File(pluginLangFilePath), 5);
                    for (File file : files) {
                        if (!file.getAbsolutePath().toLowerCase().endsWith(".html") && !file.getAbsolutePath().toLowerCase().endsWith(".htm")) continue;
                        log.log(Level.INFO, "working with : " + String.valueOf(file));
                        String deviceName = ((String)pluginBaseFilePath).substring(0, ((String)pluginBaseFilePath).indexOf("/src/help"));
                        deviceName = deviceName.substring(deviceName.lastIndexOf(47) + 1);
                        writer.write("<H2>" + deviceName + "</H2>\n");
                        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            if (!((String)line).toUpperCase().contains("<BODY")) continue;
                            while ((line = reader.readLine()) != null && !((String)line).toUpperCase().contains("</BODY>")) {
                                if (((String)line).toUpperCase().contains("<IMG ")) {
                                    line = ((String)line).substring(0, ((String)line).toUpperCase().indexOf("SRC=\"") + 5) + "../../" + deviceName + "/src/help/" + SUPPORTED_LANGUAGES[i] + "/" + ((String)line).substring(((String)line).toUpperCase().indexOf("SRC=\"") + 5);
                                }
                                if (((String)line).contains("&lt;&lt;==") || ((String)line).contains("==&gt;&gt;")) continue;
                                writer.write((String)line + "\n");
                            }
                        }
                        reader.close();
                    }
                }
                writer.close();
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static void initLogger() {
        ConsoleHandler ch = new ConsoleHandler();
        LogFormatter lf = new LogFormatter();
        rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            rootLogger.removeHandler(handlers[index]);
        }
        rootLogger.setLevel(Level.ALL);
        rootLogger.addHandler(ch);
        ch.setFormatter(lf);
        ch.setLevel(Level.INFO);
    }

    static {
        header_de = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=utf-8\">\n<TITLE>DataExplorer - Benutzerhandbuch</TITLE>\n<META NAME=\"AUTHOR\" CONTENT=\"Winfried Br\u00fcgmann\">\n</HEAD>\n<BODY LANG=\"de-DE\" DIR=\"LTR\">\n<H0>DataExplorer - Benutzerhandbuch</H0>\n";
        header_en = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=utf-8\">\n<TITLE>DataExplorer - Users Guide</TITLE>\n<META NAME=\"AUTHOR\" CONTENT=\"Winfried Br\u00fcgmann\">\n</HEAD>\n<BODY LANG=\"en-US\" DIR=\"LTR\">\n<H0>DataExplorer - Users Guide</H0>\n";
        footer = "</BODY>\n</HTML>";
        supprtedDevices_de = "Aktuell unterst\u00fctzte Ger\u00e4te";
        supprtedDevices_en = "Actual Supported Devices";
        filename_de = "DataExplorer - Information und Hilfe.html";
        filename_en = "DataExplorer - Information and Help.html";
        SUPPORTED_LANGUAGES = new String[]{"de", "en"};
        SUPPORTED_LANGUAGE_HEADERS = new String[]{header_de, header_en};
        SUPPORTED_LANGUAGE_FILEPATHES = new String[]{filename_de, filename_en};
        SUPPORTED_LANGUAGE_DEVICES = new String[]{supprtedDevices_de, supprtedDevices_en};
    }
}

