/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.device.ChannelTypes;
import gde.device.MeasurementType;
import gde.device.ReferenceGroupType;
import gde.device.ScoreGroupType;
import gde.device.SettlementType;
import gde.device.TransitionGroupType;
import gde.device.TransitionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ChannelType", propOrder={"measurement", "settlements", "referenceGroups", "transitionGroups", "transitions", "scoreGroups"})
public class ChannelType {
    @XmlElement(name="Measurement", required=true)
    protected List<MeasurementType> measurement;
    @XmlElement(name="Settlements")
    @XmlJavaTypeAdapter(value=SettlementsAdapter.class)
    protected LinkedHashMap<Integer, SettlementType> settlements;
    @XmlElement(name="ReferenceGroups")
    @XmlJavaTypeAdapter(value=ReferenceGroupsAdapter.class)
    protected HashMap<Integer, ReferenceGroupType> referenceGroups;
    @XmlElement(name="TransitionGroups")
    @XmlJavaTypeAdapter(value=TransitionGroupsAdapter.class)
    protected HashMap<Integer, TransitionGroupType> transitionGroups;
    @XmlElement(name="Transitions")
    @XmlJavaTypeAdapter(value=TransitionsAdapter.class)
    protected HashMap<Integer, TransitionType> transitions;
    @XmlElement(name="ScoreGroups")
    @XmlJavaTypeAdapter(value=ScoreGroupsAdapter.class)
    protected LinkedHashMap<Integer, ScoreGroupType> scoreGroups;
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute(required=true)
    protected ChannelTypes type;
    @XmlTransient
    private boolean isWithMeasurementIds = false;

    public List<MeasurementType> getMeasurement() {
        if (this.measurement == null) {
            this.measurement = new ArrayList<MeasurementType>();
        }
        if (!this.isWithMeasurementIds) {
            this.measurement = new ArrayList<MeasurementType>(this.measurement){
                private static final long serialVersionUID = 7963660916422067131L;

                @Override
                public boolean add(MeasurementType e) {
                    ChannelType.this.isWithMeasurementIds = false;
                    return super.add(e);
                }

                @Override
                public boolean remove(Object o) {
                    ChannelType.this.isWithMeasurementIds = false;
                    return super.remove(o);
                }
            };
            int i = 0;
            while (i < this.measurement.size()) {
                MeasurementType measurementType = this.measurement.get(i);
                measurementType.measurementId = i++;
            }
            this.isWithMeasurementIds = true;
        }
        return this.measurement;
    }

    public LinkedHashMap<Integer, SettlementType> getSettlements() {
        if (this.settlements == null) {
            this.settlements = new LinkedHashMap();
        }
        return this.settlements;
    }

    public void setSettlements(LinkedHashMap<Integer, SettlementType> value) {
        this.settlements = value;
    }

    public HashMap<Integer, ReferenceGroupType> getReferenceGroups() {
        if (this.referenceGroups == null) {
            this.referenceGroups = new HashMap();
        }
        return this.referenceGroups;
    }

    public void setReferenceGroups(HashMap<Integer, ReferenceGroupType> value) {
        this.referenceGroups = value;
    }

    public HashMap<Integer, TransitionGroupType> getTransitionGroups() {
        if (this.transitionGroups == null) {
            this.transitionGroups = new HashMap();
        }
        return this.transitionGroups;
    }

    public void setTransitionGroups(HashMap<Integer, TransitionGroupType> value) {
        this.transitionGroups = value;
    }

    public HashMap<Integer, TransitionType> getTransitions() {
        if (this.transitions == null) {
            this.transitions = new HashMap();
        }
        return this.transitions;
    }

    public void setTransitions(HashMap<Integer, TransitionType> value) {
        this.transitions = value;
    }

    public LinkedHashMap<Integer, ScoreGroupType> getScoreGroups() {
        if (this.scoreGroups == null) {
            this.scoreGroups = new LinkedHashMap();
        }
        return this.scoreGroups;
    }

    public void setScoreGroups(LinkedHashMap<Integer, ScoreGroupType> value) {
        this.scoreGroups = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ChannelTypes getType() {
        return this.type;
    }

    public void setType(ChannelTypes value) {
        this.type = value;
    }

    public SettlementType getSettlementById(int settlementId) {
        return this.getSettlements().get(settlementId);
    }

    public ReferenceGroupType getReferenceGroupById(int ReferenceGroupId) {
        return this.getReferenceGroups().get(ReferenceGroupId);
    }

    public TransitionGroupType getTransitionGroupById(int transitionGroupId) {
        return this.getTransitionGroups().get(transitionGroupId);
    }

    public TransitionType getTransitionById(int transitionId) {
        return this.getTransitions().get(transitionId);
    }

    public ScoreGroupType getScoreGroupById(int scoreGroupId) {
        return this.getScoreGroups().get(scoreGroupId);
    }

    public static class ScoreGroupsAdapter
    extends XmlAdapter<ScoreGroups, LinkedHashMap<Integer, ScoreGroupType>> {
        @Override
        public LinkedHashMap<Integer, ScoreGroupType> unmarshal(ScoreGroups values) {
            LinkedHashMap<Integer, ScoreGroupType> map = new LinkedHashMap<Integer, ScoreGroupType>();
            if (values != null && values.scoreGroup != null) {
                for (ScoreGroupType value : values.scoreGroup) {
                    map.put(value.scoreGroupId, value);
                }
            }
            return map;
        }

        @Override
        public ScoreGroups marshal(LinkedHashMap<Integer, ScoreGroupType> map) {
            ScoreGroups aList = new ScoreGroups();
            aList.scoreGroup = map == null ? new ArrayList<ScoreGroupType>() : new ArrayList<ScoreGroupType>(map.values());
            return aList;
        }
    }

    public static class TransitionsAdapter
    extends XmlAdapter<Transitions, HashMap<Integer, TransitionType>> {
        @Override
        public HashMap<Integer, TransitionType> unmarshal(Transitions values) {
            HashMap<Integer, TransitionType> map = new HashMap<Integer, TransitionType>();
            if (values != null && values.transition != null) {
                for (TransitionType value : values.transition) {
                    map.put(value.transitionId, value);
                }
            }
            return map;
        }

        @Override
        public Transitions marshal(HashMap<Integer, TransitionType> map) {
            Transitions aList = new Transitions();
            aList.transition = map == null ? new ArrayList<TransitionType>() : new ArrayList<TransitionType>(map.values());
            return aList;
        }
    }

    public static class TransitionGroupsAdapter
    extends XmlAdapter<TransitionGroups, HashMap<Integer, TransitionGroupType>> {
        @Override
        public HashMap<Integer, TransitionGroupType> unmarshal(TransitionGroups values) {
            HashMap<Integer, TransitionGroupType> map = new HashMap<Integer, TransitionGroupType>();
            if (values != null && values.transitionGroup != null) {
                for (TransitionGroupType value : values.transitionGroup) {
                    map.put(value.transitionGroupId, value);
                }
            }
            return map;
        }

        @Override
        public TransitionGroups marshal(HashMap<Integer, TransitionGroupType> map) {
            TransitionGroups aList = new TransitionGroups();
            aList.transitionGroup = map == null ? new ArrayList<TransitionGroupType>() : new ArrayList<TransitionGroupType>(map.values());
            return aList;
        }
    }

    public static class ReferenceGroupsAdapter
    extends XmlAdapter<ReferenceGroups, HashMap<Integer, ReferenceGroupType>> {
        @Override
        public HashMap<Integer, ReferenceGroupType> unmarshal(ReferenceGroups values) {
            HashMap<Integer, ReferenceGroupType> map = new HashMap<Integer, ReferenceGroupType>();
            if (values != null && values.referenceGroup != null) {
                for (ReferenceGroupType value : values.referenceGroup) {
                    map.put(value.referenceGroupId, value);
                }
            }
            return map;
        }

        @Override
        public ReferenceGroups marshal(HashMap<Integer, ReferenceGroupType> map) {
            ReferenceGroups aList = new ReferenceGroups();
            aList.referenceGroup = map == null ? new ArrayList<ReferenceGroupType>() : new ArrayList<ReferenceGroupType>(map.values());
            return aList;
        }
    }

    public static class SettlementsAdapter
    extends XmlAdapter<Settlements, LinkedHashMap<Integer, SettlementType>> {
        @Override
        public LinkedHashMap<Integer, SettlementType> unmarshal(Settlements values) {
            LinkedHashMap<Integer, SettlementType> map = new LinkedHashMap<Integer, SettlementType>();
            if (values != null && values.settlement != null) {
                for (SettlementType value : values.settlement) {
                    map.put(value.settlementId, value);
                }
            }
            return map;
        }

        @Override
        public Settlements marshal(LinkedHashMap<Integer, SettlementType> map) {
            Settlements aList = new Settlements();
            aList.settlement = map == null ? new ArrayList<SettlementType>() : new ArrayList<SettlementType>(map.values());
            return aList;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"transition"})
    public static class Transitions {
        @XmlElement(name="Transition", required=true)
        protected List<TransitionType> transition;

        public List<TransitionType> getTransition() {
            if (this.transition == null) {
                this.transition = new ArrayList<TransitionType>();
            }
            return this.transition;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"transitionGroup"})
    public static class TransitionGroups {
        @XmlElement(name="TransitionGroup", required=true)
        protected List<TransitionGroupType> transitionGroup;

        public List<TransitionGroupType> getTransitionGroup() {
            if (this.transitionGroup == null) {
                this.transitionGroup = new ArrayList<TransitionGroupType>();
            }
            return this.transitionGroup;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"settlement"})
    public static class Settlements {
        @XmlElement(name="Settlement", required=true)
        protected List<SettlementType> settlement;

        public List<SettlementType> getSettlement() {
            if (this.settlement == null) {
                this.settlement = new ArrayList<SettlementType>();
            }
            return this.settlement;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"scoreGroup"})
    public static class ScoreGroups {
        @XmlElement(name="Scoregroup", required=true)
        protected List<ScoreGroupType> scoreGroup;

        public List<ScoreGroupType> getScoreGroup() {
            if (this.scoreGroup == null) {
                this.scoreGroup = new ArrayList<ScoreGroupType>();
            }
            return this.scoreGroup;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"referenceGroup"})
    public static class ReferenceGroups {
        @XmlElement(name="ReferenceGroup", required=true)
        protected List<ReferenceGroupType> referenceGroup;

        public List<ReferenceGroupType> getReferenceGroup() {
            if (this.referenceGroup == null) {
                this.referenceGroup = new ArrayList<ReferenceGroupType>();
            }
            return this.referenceGroup;
        }
    }
}

