/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.renschler.Picolario;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.CalculationThread;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class PicolarioConfigTab
extends Composite {
    static final Logger log = Logger.getLogger(PicolarioConfigTab.class.getName());
    Group heightAdaptionGroup;
    Label heightLabel;
    Button noAdaptionButton;
    Button reduceByDefinedValueButton;
    Button reduceByFirstValueButton;
    Button reduceByLastValueButton;
    CCombo heightOffset;
    CLabel slopeUnit;
    CLabel slopeName;
    CLabel heightUnit;
    CLabel calculationTypeLabel;
    CCombo slopeCalculationTypeCombo;
    CCombo regressionTime;
    Button makePersitentButton;
    boolean isConfigChanged;
    String heightDataUnit;
    boolean doNoAdation;
    boolean doHeightAdaption;
    boolean doSubtractFirst;
    boolean doSubtractLast;
    boolean doOffsetHeight;
    int heightOffsetSelection;
    double heightOffsetValue;
    String slopeDataUnit;
    String slopeTypeSelection;
    int slopeTimeSelection;
    final Picolario device;
    final DataExplorer application;
    final String configName;
    final int configNumber;

    public PicolarioConfigTab(CTabFolder parent, Picolario useDevice, String tabName) {
        super((Composite)parent, 0);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.isConfigChanged = false;
        this.heightDataUnit = "m";
        this.doNoAdation = false;
        this.doHeightAdaption = false;
        this.doSubtractFirst = true;
        this.doSubtractLast = false;
        this.doOffsetHeight = false;
        this.heightOffsetSelection = 7;
        this.heightOffsetValue = 100.0;
        this.slopeDataUnit = "m/s";
        this.slopeTypeSelection = CalculationThread.REGRESSION_TYPE_CURVE;
        this.device = useDevice;
        this.configName = tabName;
        this.configNumber = parent.getItemCount() + 1;
        this.application = DataExplorer.getInstance();
        this.initGUI();
        this.initialize();
    }

    private void initGUI() {
        try {
            FillLayout thisLayout = new FillLayout(256);
            this.setLayout((Layout)thisLayout);
            this.setSize(310, 210);
            this.setLayout(null);
            FillLayout composite1Layout = new FillLayout(256);
            this.setLayout((Layout)composite1Layout);
            this.heightAdaptionGroup = new Group((Composite)this, 0);
            this.heightAdaptionGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightAdaptionGroup.setLayout(null);
            this.heightAdaptionGroup.setText(Messages.getString((String)"GDE_MSGT1209"));
            this.noAdaptionButton = new Button((Composite)this.heightAdaptionGroup, 16400);
            this.noAdaptionButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.noAdaptionButton.setText(Messages.getString((String)"GDE_MSGT1210"));
            this.noAdaptionButton.setBounds(12, GDE.IS_MAC_COCOA ? 25 : 40, 186, 16);
            this.noAdaptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "noAdaptioButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.noAdaptionButton.setSelection(true);
                    PicolarioConfigTab.this.reduceByFirstValueButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByLastValueButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByDefinedValueButton.setSelection(false);
                    PicolarioConfigTab.this.doNoAdation = true;
                    PicolarioConfigTab.this.doSubtractFirst = false;
                    PicolarioConfigTab.this.doSubtractLast = false;
                    PicolarioConfigTab.this.doOffsetHeight = false;
                    PicolarioConfigTab.this.heightOffsetValue = 0.0;
                    PicolarioConfigTab.this.heightOffset.setText(Double.valueOf(PicolarioConfigTab.this.heightOffsetValue).toString());
                    PicolarioConfigTab.this.updateRecordProperties();
                }
            });
            this.reduceByFirstValueButton = new Button((Composite)this.heightAdaptionGroup, 16400);
            this.reduceByFirstValueButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reduceByFirstValueButton.setText(Messages.getString((String)"GDE_MSGT1211"));
            this.reduceByFirstValueButton.setSelection(this.doSubtractFirst);
            this.reduceByFirstValueButton.setBounds(12, GDE.IS_MAC_COCOA ? 46 : 61, 297, 16);
            this.reduceByFirstValueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "reduceByFirstValueButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.noAdaptionButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByFirstValueButton.setSelection(true);
                    PicolarioConfigTab.this.reduceByLastValueButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByDefinedValueButton.setSelection(false);
                    PicolarioConfigTab.this.doNoAdation = false;
                    PicolarioConfigTab.this.doSubtractFirst = true;
                    PicolarioConfigTab.this.doSubtractLast = false;
                    PicolarioConfigTab.this.doOffsetHeight = false;
                    PicolarioConfigTab.this.heightOffsetValue = 0.0;
                    PicolarioConfigTab.this.heightOffset.setText(Double.valueOf(PicolarioConfigTab.this.heightOffsetValue).toString());
                    PicolarioConfigTab.this.updateRecordProperties();
                }
            });
            this.reduceByLastValueButton = new Button((Composite)this.heightAdaptionGroup, 16400);
            this.reduceByLastValueButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reduceByLastValueButton.setBounds(12, GDE.IS_MAC_COCOA ? 65 : 80, 293, 18);
            this.reduceByLastValueButton.setText(Messages.getString((String)"GDE_MSGT1212"));
            this.reduceByLastValueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "reduceByLastValueButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.noAdaptionButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByFirstValueButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByLastValueButton.setSelection(true);
                    PicolarioConfigTab.this.reduceByDefinedValueButton.setSelection(false);
                    PicolarioConfigTab.this.doNoAdation = false;
                    PicolarioConfigTab.this.doSubtractFirst = false;
                    PicolarioConfigTab.this.doSubtractLast = true;
                    PicolarioConfigTab.this.doOffsetHeight = false;
                    PicolarioConfigTab.this.heightOffsetValue = 0.0;
                    PicolarioConfigTab.this.heightOffset.setText(Double.valueOf(PicolarioConfigTab.this.heightOffsetValue).toString());
                    PicolarioConfigTab.this.updateRecordProperties();
                }
            });
            this.reduceByDefinedValueButton = new Button((Composite)this.heightAdaptionGroup, 16400);
            this.reduceByDefinedValueButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reduceByDefinedValueButton.setText(Messages.getString((String)"GDE_MSGT1213"));
            this.reduceByDefinedValueButton.setSelection(this.doOffsetHeight);
            this.reduceByDefinedValueButton.setBounds(12, GDE.IS_MAC_COCOA ? 89 : 103, 143, 16);
            this.reduceByDefinedValueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "reduceByDefinedValueButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.noAdaptionButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByFirstValueButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByLastValueButton.setSelection(false);
                    PicolarioConfigTab.this.reduceByDefinedValueButton.setSelection(true);
                    PicolarioConfigTab.this.doNoAdation = false;
                    PicolarioConfigTab.this.doOffsetHeight = true;
                    PicolarioConfigTab.this.doSubtractFirst = false;
                    PicolarioConfigTab.this.doSubtractLast = false;
                    PicolarioConfigTab.this.heightOffsetValue = Double.valueOf(PicolarioConfigTab.this.heightOffset.getText());
                    PicolarioConfigTab.this.updateRecordProperties();
                }
            });
            this.heightOffset = new CCombo((Composite)this.heightAdaptionGroup, 2048);
            this.heightOffset.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            final String[] heightOffsetValues = new String[]{"200", "100", "50", "0", "-50", "-100", "-150", "-200", "-250", "-300", "-400", "-500", "-750", "-1000", "-1500"};
            this.heightOffset.setItems(heightOffsetValues);
            this.heightOffset.setText(String.format("%.1f", this.heightOffsetValue));
            for (int i = 0; i < heightOffsetValues.length; ++i) {
                if (!(Math.abs((double)Integer.valueOf(heightOffsetValues[i]).intValue() - this.heightOffsetValue) < 0.1)) continue;
                this.heightOffset.select(i);
            }
            this.heightOffset.setBounds(184, GDE.IS_MAC_COCOA ? 86 : 101, 116, GDE.IS_LINUX ? 22 : 20);
            this.heightOffset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    log.log(Level.FINEST, "heightOffset.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.heightOffsetValue = Double.valueOf(heightOffsetValues[PicolarioConfigTab.this.heightOffset.getSelectionIndex()]);
                    Channel activeChannel = Channels.getInstance().getActiveChannel();
                    if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
                        Record activeRecord = activeRecordSet.get(1);
                        activeRecord.setOffset(PicolarioConfigTab.this.heightOffsetValue);
                        PicolarioConfigTab.this.application.updateGraphicsWindow();
                        activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                    }
                    PicolarioConfigTab.this.isConfigChanged = true;
                    PicolarioConfigTab.this.makePersitentButton.setEnabled(PicolarioConfigTab.this.isConfigChanged);
                }
            });
            this.heightOffset.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    log.log(Level.FINEST, "heightOffset.keyPressed, event=" + String.valueOf(evt));
                    if (evt.character == '\r') {
                        try {
                            RecordSet activeRecordSet;
                            PicolarioConfigTab.this.heightOffsetValue = Double.valueOf(PicolarioConfigTab.this.heightOffset.getText().replace(',', '.'));
                            Channel activeChannel = Channels.getInstance().getActiveChannel();
                            if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
                                Record activeRecord = activeRecordSet.get(1);
                                activeRecord.setOffset(PicolarioConfigTab.this.heightOffsetValue);
                                PicolarioConfigTab.this.application.updateGraphicsWindow();
                                activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                            }
                        }
                        catch (NumberFormatException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                            PicolarioConfigTab.this.application.openMessageDialog(PicolarioConfigTab.this.getShell(), Messages.getString((String)"GDE_MSGE1200", (Object[])new Object[]{e.getMessage()}));
                        }
                        PicolarioConfigTab.this.isConfigChanged = true;
                        PicolarioConfigTab.this.makePersitentButton.setEnabled(PicolarioConfigTab.this.isConfigChanged);
                    }
                }
            });
            this.heightLabel = new Label((Composite)this.heightAdaptionGroup, 0);
            this.heightLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightLabel.setBounds(12, GDE.IS_MAC_COCOA ? 5 : 20, 76, 20);
            this.heightLabel.setText(Messages.getString((String)"GDE_MSGT1214"));
            this.heightUnit = new CLabel((Composite)this.heightAdaptionGroup, 0);
            this.heightUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightUnit.setBounds(90, GDE.IS_MAC_COCOA ? 3 : 18, 60, 20);
            this.heightUnit.setText("[m]");
            this.slopeName = new CLabel((Composite)this.heightAdaptionGroup, 0);
            this.slopeName.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.slopeName.setBounds(12, GDE.IS_MAC_COCOA ? 112 : 127, 76, 20);
            this.slopeName.setText(Messages.getString((String)"GDE_MSGT1216"));
            this.calculationTypeLabel = new CLabel((Composite)this.heightAdaptionGroup, 0);
            this.calculationTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.calculationTypeLabel.setBounds(15, GDE.IS_MAC_COCOA ? 136 : 151, 115, 20);
            this.calculationTypeLabel.setText(Messages.getString((String)"GDE_MSGT1215"));
            this.slopeUnit = new CLabel((Composite)this.heightAdaptionGroup, 0);
            this.slopeUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.slopeUnit.setBounds(90, GDE.IS_MAC_COCOA ? 112 : 127, 60, 20);
            this.slopeUnit.setText("[m/s]");
            this.slopeCalculationTypeCombo = new CCombo((Composite)this.heightAdaptionGroup, 2048);
            this.slopeCalculationTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.slopeCalculationTypeCombo.setBounds(130, GDE.IS_MAC_COCOA ? 135 : 150, 100, GDE.IS_LINUX ? 22 : 20);
            this.slopeCalculationTypeCombo.setItems(new String[]{" " + Messages.getString((String)"GDE_MSGT0262"), " " + Messages.getString((String)"GDE_MSGT0263")});
            this.slopeCalculationTypeCombo.setToolTipText(Messages.getString((String)"GDE_MSGT1217"));
            this.slopeCalculationTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    log.log(Level.FINEST, "slopeCalculationTypeCombo.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.slopeTypeSelection = PicolarioConfigTab.this.slopeCalculationTypeCombo.getSelectionIndex() == 1 ? CalculationThread.REGRESSION_TYPE_CURVE : CalculationThread.REGRESSION_TYPE_LINEAR;
                    Channel activeChannel = Channels.getInstance().getActiveChannel();
                    if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && activeRecordSet.isRaw()) {
                        Record activeRecord = activeRecordSet.get(2);
                        activeRecord.getProperty(CalculationThread.REGRESSION_TYPE).setValue((Object)PicolarioConfigTab.this.slopeTypeSelection);
                        activeRecord.setDisplayable(false);
                        activeRecordSet.setRecalculationRequired();
                        PicolarioConfigTab.this.device.makeInActiveDisplayable(activeRecordSet);
                        PicolarioConfigTab.this.application.updateStatisticsData();
                        PicolarioConfigTab.this.application.updateDataTable(activeRecordSet.getName(), true);
                        activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                    }
                    PicolarioConfigTab.this.isConfigChanged = true;
                    PicolarioConfigTab.this.makePersitentButton.setEnabled(PicolarioConfigTab.this.isConfigChanged);
                }
            });
            this.regressionTime = new CCombo((Composite)this.heightAdaptionGroup, 2048);
            this.regressionTime.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.regressionTime.setBounds(232, GDE.IS_MAC_COCOA ? 135 : 150, 70, GDE.IS_LINUX ? 22 : 20);
            this.regressionTime.setItems(new String[]{" 1 s", " 2 s", " 3 s", " 4 s", " 5 s", " 6 s", " 7 s", " 8 s", " 9 s", "10 s", "11 s", "12 s", "13 s", "14 s", "15 s", "16 s", "17 s", "18 s", "19 s", "20 s", "21 s", "22 s", "23 s", "24 s", "25 s", "26 s", "27 s", "28 s", "29 s", "30 s"});
            this.regressionTime.setToolTipText(Messages.getString((String)"GDE_MSGT1218"));
            this.regressionTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    log.log(Level.FINEST, "regressionTime.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.slopeTimeSelection = PicolarioConfigTab.this.regressionTime.getSelectionIndex() + 1;
                    Channel activeChannel = Channels.getInstance().getActiveChannel();
                    if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && activeRecordSet.isRaw()) {
                        Record activeRecord = activeRecordSet.get(2);
                        activeRecord.getProperty(CalculationThread.REGRESSION_INTERVAL_SEC).setValue((Object)("" + PicolarioConfigTab.this.slopeTimeSelection));
                        activeRecord.setDisplayable(false);
                        activeRecordSet.setRecalculationRequired();
                        PicolarioConfigTab.this.device.makeInActiveDisplayable(activeRecordSet);
                        PicolarioConfigTab.this.application.updateStatisticsData();
                        PicolarioConfigTab.this.application.updateDataTable(activeRecordSet.getName(), true);
                        activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                    }
                    PicolarioConfigTab.this.isConfigChanged = true;
                    PicolarioConfigTab.this.makePersitentButton.setEnabled(PicolarioConfigTab.this.isConfigChanged);
                }
            });
            this.makePersitentButton = new Button((Composite)this.heightAdaptionGroup, 0x1000008);
            this.makePersitentButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.makePersitentButton.setBounds(10, GDE.IS_MAC_COCOA ? 162 : 177, 295, 25);
            this.makePersitentButton.setText(Messages.getString((String)"GDE_MSGT1219"));
            this.makePersitentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "makePersitentButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioConfigTab.this.device.setMeasurementPropertyValue(PicolarioConfigTab.this.configNumber, 1, "do_no_adaption", DataTypes.BOOLEAN, PicolarioConfigTab.this.doNoAdation);
                    PicolarioConfigTab.this.device.setMeasurementPropertyValue(PicolarioConfigTab.this.configNumber, 1, Picolario.DO_SUBTRACT_FIRST, DataTypes.BOOLEAN, PicolarioConfigTab.this.doSubtractFirst);
                    PicolarioConfigTab.this.device.setMeasurementPropertyValue(PicolarioConfigTab.this.configNumber, 1, Picolario.DO_SUBTRACT_LAST, DataTypes.BOOLEAN, PicolarioConfigTab.this.doSubtractLast);
                    PicolarioConfigTab.this.device.setMeasurementPropertyValue(PicolarioConfigTab.this.configNumber, 1, "do_offset_height", DataTypes.BOOLEAN, PicolarioConfigTab.this.doOffsetHeight);
                    PicolarioConfigTab.this.device.setMeasurementPropertyValue(PicolarioConfigTab.this.configNumber, 1, IDevice.OFFSET, DataTypes.DOUBLE, PicolarioConfigTab.this.heightOffsetValue);
                    PicolarioConfigTab.this.device.setMeasurementPropertyValue(PicolarioConfigTab.this.configNumber, 2, CalculationThread.REGRESSION_TYPE, DataTypes.STRING, PicolarioConfigTab.this.slopeTypeSelection);
                    PicolarioConfigTab.this.device.setMeasurementPropertyValue(PicolarioConfigTab.this.configNumber, 2, CalculationThread.REGRESSION_INTERVAL_SEC, DataTypes.INTEGER, PicolarioConfigTab.this.slopeTimeSelection);
                    PicolarioConfigTab.this.device.setChangePropery(true);
                    PicolarioConfigTab.this.device.storeDeviceProperties();
                    PicolarioConfigTab.this.isConfigChanged = false;
                    PicolarioConfigTab.this.makePersitentButton.setEnabled(PicolarioConfigTab.this.isConfigChanged);
                }
            });
            this.layout();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void initEditable() {
        PropertyType property = null;
        Record record = null;
        int channelConfigNumber = Channels.getInstance().getActiveChannel().getNumber();
        RecordSet recordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
        if (recordSet != null) {
            record = recordSet.get(1);
            this.heightDataUnit = record.getUnit();
            log.log(Level.FINER, "heightDataUnit = " + this.heightDataUnit);
            property = record.getProperty("do_no_adaption");
            this.doNoAdation = Boolean.valueOf(property != null ? property.getValue() : "false");
            log.log(Level.FINER, "doHeightAdaption = " + this.doHeightAdaption);
            property = record.getProperty(Picolario.DO_SUBTRACT_FIRST);
            this.doSubtractFirst = Boolean.valueOf(property != null ? property.getValue() : "false");
            log.log(Level.FINER, "doSubtractFirst = " + this.doSubtractFirst);
            property = record.getProperty(Picolario.DO_SUBTRACT_LAST);
            this.doSubtractLast = Boolean.valueOf(property != null ? property.getValue() : "false");
            log.log(Level.FINER, "doSubtractLast = " + this.doSubtractLast);
            property = record.getProperty("do_offset_height");
            this.doOffsetHeight = this.heightOffsetValue != 0.0 && this.doHeightAdaption;
            log.log(Level.FINER, "doOffsetHeight = " + this.doOffsetHeight);
            property = record.getProperty(IDevice.OFFSET);
            this.heightOffsetValue = Double.valueOf(property != null ? property.getValue() : "0.0");
            log.log(Level.FINER, "heightOffsetValue = " + this.heightOffsetValue);
            record = recordSet.get(2);
            this.slopeDataUnit = record.getUnit();
            log.log(Level.FINER, "slopeDataUnit = " + this.slopeDataUnit);
            PropertyType typeSelection = record.getProperty(CalculationThread.REGRESSION_TYPE);
            this.slopeTypeSelection = typeSelection == null ? CalculationThread.REGRESSION_TYPE_CURVE : typeSelection.getValue();
            log.log(Level.FINER, "slopeTypeSelection = " + this.slopeTypeSelection);
            PropertyType timeSelection = record.getProperty(CalculationThread.REGRESSION_INTERVAL_SEC);
            this.slopeTimeSelection = timeSelection == null ? 4 : Integer.valueOf(timeSelection.getValue());
            log.log(Level.FINER, "slopeTimeSelection = " + this.slopeTimeSelection);
        } else {
            MeasurementType measurement = this.device.getMeasurement(channelConfigNumber, 1);
            this.heightDataUnit = measurement.getUnit();
            log.log(Level.FINER, "heightDataUnit = " + this.heightDataUnit);
            property = measurement.getProperty("do_no_adaption");
            this.doNoAdation = Boolean.valueOf(property != null ? property.getValue() : "false");
            log.log(Level.FINER, "doHeightAdaption = " + this.doHeightAdaption);
            property = measurement.getProperty(Picolario.DO_SUBTRACT_FIRST);
            this.doSubtractFirst = Boolean.valueOf(property != null ? property.getValue() : "true");
            log.log(Level.FINER, "doSubtractFirst = " + this.doSubtractFirst);
            property = measurement.getProperty(Picolario.DO_SUBTRACT_LAST);
            this.doSubtractLast = Boolean.valueOf(property != null ? property.getValue() : "false");
            log.log(Level.FINER, "doSubtractLast = " + this.doSubtractLast);
            property = measurement.getProperty("do_offset_height");
            this.doOffsetHeight = this.heightOffsetValue != 0.0 && this.doHeightAdaption;
            log.log(Level.FINER, "doOffsetHeight = " + this.doOffsetHeight);
            property = measurement.getProperty(IDevice.OFFSET);
            this.heightOffsetValue = Double.valueOf(property != null ? property.getValue() : "0.0");
            log.log(Level.FINER, "heightOffsetValue = " + this.heightOffsetValue);
            measurement = this.device.getMeasurement(channelConfigNumber, 2);
            this.slopeDataUnit = measurement.getUnit();
            log.log(Level.FINER, "slopeDataUnit = " + this.slopeDataUnit);
            PropertyType typeSelection = this.device.getMeasruementProperty(channelConfigNumber, 2, CalculationThread.REGRESSION_TYPE);
            this.slopeTypeSelection = typeSelection == null ? CalculationThread.REGRESSION_TYPE_CURVE : typeSelection.getValue();
            log.log(Level.FINER, "slopeTypeSelection = " + this.slopeTypeSelection);
            PropertyType timeSelection = this.device.getMeasruementProperty(channelConfigNumber, 2, CalculationThread.REGRESSION_INTERVAL_SEC);
            this.slopeTimeSelection = timeSelection == null ? 4 : Integer.valueOf(timeSelection.getValue());
            log.log(Level.FINER, "slopeTimeSelection = " + this.slopeTimeSelection);
        }
    }

    public int getReduceHeightSelectionType() {
        int selection = this.noAdaptionButton.getSelection() ? 1 : 0;
        selection += this.reduceByFirstValueButton.getSelection() ? 1 : 0;
        return selection += this.reduceByDefinedValueButton.getSelection() ? 1 : 0;
    }

    public int getReduceHeightSelection() {
        return Integer.valueOf(this.heightOffset.getText());
    }

    public double getHeightOffsetValue() {
        return this.heightOffsetValue;
    }

    public boolean isDoReduceHeight() {
        return this.doOffsetHeight;
    }

    public boolean isDoSubtractFirst() {
        return this.doSubtractFirst;
    }

    public boolean isDoSubtractLast() {
        return this.doSubtractLast;
    }

    public String getHeightDataUnit() {
        return this.heightDataUnit;
    }

    void updateRecordProperties() {
        RecordSet activeRecordSet;
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            Record activeRecord = activeRecordSet.get(1);
            PropertyType property = activeRecord.getProperty("do_no_adaption");
            if (property == null) {
                activeRecord.createProperty("do_no_adaption", DataTypes.BOOLEAN, (Object)this.doNoAdation);
            } else {
                property.setValue((Object)this.doNoAdation);
            }
            property = activeRecord.getProperty(Picolario.DO_SUBTRACT_FIRST);
            if (property == null) {
                activeRecord.createProperty(Picolario.DO_SUBTRACT_FIRST, DataTypes.BOOLEAN, (Object)this.doSubtractFirst);
            } else {
                property.setValue((Object)this.doSubtractFirst);
            }
            property = activeRecord.getProperty(Picolario.DO_SUBTRACT_LAST);
            if (property == null) {
                activeRecord.createProperty(Picolario.DO_SUBTRACT_LAST, DataTypes.BOOLEAN, (Object)this.doSubtractLast);
            } else {
                property.setValue((Object)this.doSubtractLast);
            }
            property = activeRecord.getProperty("do_offset_height");
            if (property == null) {
                activeRecord.createProperty("do_offset_height", DataTypes.BOOLEAN, (Object)this.doOffsetHeight);
            } else {
                property.setValue((Object)this.doOffsetHeight);
            }
            property = activeRecord.getProperty(IDevice.OFFSET);
            if (property == null) {
                activeRecord.createProperty(IDevice.OFFSET, DataTypes.DOUBLE, (Object)this.heightOffsetValue);
            } else {
                property.setValue((Object)this.heightOffsetValue);
            }
            this.application.updateGraphicsWindow();
            activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
        }
        this.isConfigChanged = true;
        this.makePersitentButton.setEnabled(this.isConfigChanged);
    }

    private void initialize() {
        this.initEditable();
        this.heightUnit.setText("[" + this.heightDataUnit + "]");
        this.noAdaptionButton.setSelection(this.doNoAdation);
        this.reduceByFirstValueButton.setSelection(this.doSubtractFirst);
        this.reduceByLastValueButton.setSelection(this.doSubtractLast);
        this.reduceByDefinedValueButton.setSelection(this.doOffsetHeight);
        this.heightOffset.setText(Double.valueOf(this.heightOffsetValue).toString());
        this.slopeUnit.setText("[" + this.slopeDataUnit + "]");
        this.regressionTime.select(this.slopeTimeSelection - 1);
        this.slopeCalculationTypeCombo.select(this.slopeTypeSelection.equals(CalculationThread.REGRESSION_TYPE_CURVE) ? 1 : 0);
        this.makePersitentButton.setEnabled(this.isConfigChanged);
    }
}

