/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.Analyzer;
import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTlogReader2;
import gde.device.graupner.PackageLoss;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;

public class HoTTlogReader
extends HoTTbinReader {
    static final Logger log = Logger.getLogger(HoTTlogReader.class.getName());
    protected static boolean isHoTTAdapter2 = false;
    protected static int[] points;
    protected static RcvLogParser rcvLogParser;
    protected static ChnLogParser chnLogParser;
    protected static VarLogParser varLogParser;
    protected static GpsLogParser gpsLogParser;
    protected static GamLogParser gamLogParser;
    protected static EamLogParser eamLogParser;
    protected static EscLogParser escLogParser;
    protected static EscLogParser esc2LogParser;
    protected static EscLogParser esc3LogParser;
    protected static EscLogParser esc4LogParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void read(String filePath, HoTTAdapter.PickerParameters newPickerParameters) throws Exception {
        String $METHOD_NAME = "read";
        pickerParameters = newPickerParameters;
        HashMap<String, String> fileInfoHeader = HoTTlogReader.getFileInfo(new File(filePath), newPickerParameters);
        detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(fileInfoHeader.get("DETECTED SENSOR"));
        File file = new File(fileInfoHeader.get("FilePath"));
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        HoTTAdapter device = (HoTTAdapter)application.getActiveDevice();
        isHoTTAdapter2 = application.getActiveDevice() instanceof HoTTAdapter2;
        int recordSetNumber = ((Channel)HoTTbinReader.channels.get((Object)1)).maxSize() + 1;
        Object recordSetName = "";
        String recordSetNameExtend = HoTTlogReader.getRecordSetExtend(file);
        Channel channel = null;
        HoTTbinReader.recordSetReceiver = null;
        HoTTbinReader.recordSetChannel = null;
        HoTTbinReader.recordSetGAM = null;
        HoTTbinReader.recordSetEAM = null;
        HoTTbinReader.recordSetVario = null;
        HoTTbinReader.recordSetGPS = null;
        HoTTbinReader.recordSetESC = null;
        HoTTbinReader.recordSetESC2 = null;
        HoTTbinReader.recordSetESC3 = null;
        HoTTbinReader.recordSetESC4 = null;
        long[] timeSteps_ms = new long[]{0L};
        int numberLogChannels = Integer.valueOf(fileInfoHeader.get("LOG NOB CHANNEL"));
        boolean isASCII = fileInfoHeader.get("LOG TYPE").contains("ASCII");
        int rawDataBlockSize = Integer.parseInt(fileInfoHeader.get("RAW_LOG_SIZE"));
        int asciiDataBlockSize = Integer.parseInt(fileInfoHeader.get("ASCII_LOG_SIZE"));
        HoTTbinReader.dataBlockSize = isASCII ? asciiDataBlockSize : rawDataBlockSize;
        HoTTbinReader.buf = new byte[HoTTbinReader.dataBlockSize];
        rcvLogParser = (RcvLogParser)HoTTAdapter.Sensor.RECEIVER.createLogParser(HoTTbinReader.pickerParameters, new int[10], timeSteps_ms, buf, numberLogChannels);
        varLogParser = (VarLogParser)HoTTAdapter.Sensor.VARIO.createLogParser(HoTTbinReader.pickerParameters, new int[13], timeSteps_ms, buf, numberLogChannels);
        gpsLogParser = (GpsLogParser)HoTTAdapter.Sensor.GPS.createLogParser(HoTTbinReader.pickerParameters, new int[24], timeSteps_ms, buf, numberLogChannels);
        gamLogParser = (GamLogParser)HoTTAdapter.Sensor.GAM.createLogParser(HoTTbinReader.pickerParameters, new int[26], timeSteps_ms, buf, numberLogChannels);
        eamLogParser = (EamLogParser)HoTTAdapter.Sensor.EAM.createLogParser(HoTTbinReader.pickerParameters, new int[31], timeSteps_ms, buf, numberLogChannels);
        escLogParser = (EscLogParser)HoTTAdapter.Sensor.ESC.createLogParser(HoTTbinReader.pickerParameters, new int[30], timeSteps_ms, buf, numberLogChannels);
        esc2LogParser = (EscLogParser)HoTTAdapter.Sensor.ESC.createLogParser(HoTTbinReader.pickerParameters, new int[30], timeSteps_ms, buf, numberLogChannels);
        esc3LogParser = (EscLogParser)HoTTAdapter.Sensor.ESC.createLogParser(HoTTbinReader.pickerParameters, new int[30], timeSteps_ms, buf, numberLogChannels);
        esc4LogParser = (EscLogParser)HoTTAdapter.Sensor.ESC.createLogParser(HoTTbinReader.pickerParameters, new int[30], timeSteps_ms, buf, numberLogChannels);
        int logTimeStep_ms = 1000 / Integer.valueOf(fileInfoHeader.get("COUNTER").split("/")[1].split(" ")[0]);
        HoTTbinReader.isTextModusSignaled = false;
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isEAMdetected = false;
        boolean isESCdetected = false;
        boolean isESC2detected = false;
        boolean isESC3detected = false;
        boolean isESC4detected = false;
        int logDataOffset = Integer.valueOf(fileInfoHeader.get("LOG DATA OFFSET"));
        long numberDatablocks = Long.parseLong(fileInfoHeader.get("LogCount"));
        long startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(fileInfoHeader.get("LOG START TIME"), HoTTbinReader.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks));
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = HoTTbinReader.application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        long sequenceNumber = 0L;
        long sequenceDelta = -1L;
        try {
            String packageLossPercentage;
            String newFileDescription;
            HoTTbinReader.recordSets.clear();
            channel = (Channel)HoTTbinReader.channels.get((Object)1);
            String string = newFileDescription = HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || HoTTbinReader.application.isObjectoriented() && !channel.getFileDescription().contains(HoTTbinReader.application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.RECEIVER.value() + recordSetNameExtend;
            HoTTbinReader.recordSetReceiver = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)1, (boolean)true, (boolean)true, (boolean)true);
            channel.put(recordSetName, (Object)HoTTbinReader.recordSetReceiver);
            HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.RECEIVER.value(), HoTTbinReader.recordSetReceiver);
            RecordSet tmpRecordSet = (RecordSet)channel.get(recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            if (HoTTbinReader.application.getMenuToolBar() != null) {
                channel.applyTemplate((String)recordSetName, false);
            }
            if (HoTTlogReader.pickerParameters.isChannelsChannelEnabled) {
                channel = (Channel)HoTTbinReader.channels.get((Object)6);
                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.CHANNEL.value() + recordSetNameExtend;
                HoTTbinReader.recordSetChannel = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)6, (boolean)true, (boolean)true, (boolean)true);
                numberLogChannels = HoTTbinReader.recordSetChannel.size() == 23 ? 16 : numberLogChannels;
                chnLogParser = (ChnLogParser)HoTTAdapter.Sensor.CHANNEL.createLogParser(HoTTbinReader.pickerParameters, new int[HoTTbinReader.recordSetChannel.size()], timeSteps_ms, buf, numberLogChannels);
                channel.put(recordSetName, (Object)HoTTbinReader.recordSetChannel);
                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.CHANNEL.value(), HoTTbinReader.recordSetChannel);
                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                if (HoTTbinReader.application.getMenuToolBar() != null) {
                    channel.applyTemplate((String)recordSetName, false);
                }
            }
            log.log(Level.INFO, fileInfoHeader.toString());
            data_in.skip(logDataOffset);
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(HoTTbinReader.buf);
                if (log.isLoggable(Level.FINE)) {
                    if (isASCII) {
                        log.logp(Level.FINE, HoTTbinReader.$CLASS_NAME, "read", new String(HoTTbinReader.buf));
                    } else {
                        log.logp(Level.FINE, HoTTbinReader.$CLASS_NAME, "read", StringHelper.byte2Hex4CharString((byte[])HoTTbinReader.buf, (int)HoTTbinReader.buf.length));
                    }
                }
                if (isASCII) {
                    HoTTlogReader.convertAscii2Raw(rawDataBlockSize, HoTTbinReader.buf);
                }
                if (HoTTbinReader.buf[24] == 31) {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "sensitivity data " + StringHelper.byte2Hex2CharString((byte[])HoTTlogReader2.buf, (int)30));
                    }
                    if (isASCII) {
                        timeSteps_ms[0] = timeSteps_ms[0] + (long)logTimeStep_ms;
                    } else {
                        if (sequenceDelta != -1L) {
                            sequenceDelta = DataParser.getUInt32((byte[])HoTTlogReader2.buf, (int)0) - sequenceNumber;
                            timeSteps_ms[0] = timeSteps_ms[0] + (long)logTimeStep_ms * sequenceDelta;
                        }
                        sequenceNumber = DataParser.getUInt32((byte[])HoTTlogReader2.buf, (int)0);
                    }
                } else {
                    if (log.isLoggable(Level.INFO)) {
                        if (HoTTlogReader2.buf[8] == 0 || HoTTlogReader2.buf[9] == 0) {
                            log.log(Level.INFO, String.format("HoTTlogReader2.buf[8] == 0x%02X HoTTlogReader2.buf[9] == 0x%02X", HoTTlogReader2.buf[8], HoTTlogReader2.buf[9]));
                        }
                        log.log(Level.INFO, String.format("sensor data 0x%02X %s", HoTTlogReader2.buf[26], StringHelper.byte2Hex2CharString((byte[])HoTTlogReader2.buf, (int)30)));
                    }
                    if (isASCII) {
                        timeSteps_ms[0] = timeSteps_ms[0] + (long)logTimeStep_ms;
                    } else {
                        sequenceDelta = sequenceDelta == -1L ? 0L : DataParser.getUInt32((byte[])HoTTlogReader2.buf, (int)0) - sequenceNumber;
                        timeSteps_ms[0] = timeSteps_ms[0] + (long)logTimeStep_ms * sequenceDelta;
                        sequenceNumber = DataParser.getUInt32((byte[])HoTTlogReader2.buf, (int)0);
                    }
                    rcvLogParser.trackPackageLoss(HoTTlogReader2.buf[8] != 0 && HoTTlogReader2.buf[9] != 0);
                    if (log.isLoggable(Level.FINEST)) {
                        log.logp(Level.FINEST, HoTTbinReader.$CLASS_NAME, "read", StringHelper.byte2Hex2CharString((byte[])new byte[]{HoTTbinReader.buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)HoTTbinReader.buf[7], (boolean)false));
                    }
                    HoTTlogReader.parseAddReceiver(HoTTbinReader.buf);
                    if (HoTTlogReader.pickerParameters.isChannelsChannelEnabled) {
                        HoTTlogReader.parseAddChannel(HoTTbinReader.buf);
                    }
                    switch ((byte)(HoTTbinReader.buf[26] & 0xFF)) {
                        case -112: {
                            if (HoTTbinReader.recordSetVario == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)2);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.VARIO.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetVario = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)2, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetVario);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.VARIO.value(), HoTTbinReader.recordSetVario);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddVario(HoTTbinReader.buf);
                            if (isVarioDetected) break;
                            HoTTAdapter.updateVarioTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, HoTTbinReader.recordSetVario);
                            isVarioDetected = true;
                            break;
                        }
                        case -96: {
                            if (HoTTbinReader.recordSetGPS == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)3);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.GPS.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetGPS = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)3, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetGPS);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.GPS.value(), HoTTbinReader.recordSetGPS);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddGPS(HoTTbinReader.buf, timeStep_ms);
                            if (isGPSdetected) break;
                            startTimeStamp_ms = HoTTAdapter.updateGpsTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, HoTTbinReader.recordSetGPS, startTimeStamp_ms);
                            isGPSdetected = true;
                            break;
                        }
                        case -48: {
                            if (HoTTbinReader.recordSetGAM == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)4);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.GAM.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetGAM = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)4, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetGAM);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.GAM.value(), HoTTbinReader.recordSetGAM);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddGAM(HoTTbinReader.buf);
                            break;
                        }
                        case -32: {
                            if (HoTTbinReader.recordSetEAM == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)5);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.EAM.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetEAM = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)5, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetEAM);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.EAM.value(), HoTTbinReader.recordSetEAM);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddEAM(HoTTbinReader.buf);
                            if (isEAMdetected) break;
                            HoTTAdapter.updateEAMTypeDependent(HoTTbinReader.buf[63] & 0xFF, device, HoTTbinReader.recordSetEAM);
                            isEAMdetected = true;
                            break;
                        }
                        case -64: {
                            if (HoTTbinReader.recordSetESC == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)7);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetESC = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)7, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetESC);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.ESC.value(), HoTTbinReader.recordSetESC);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddESC(HoTTbinReader.buf);
                            if (isESCdetected) break;
                            HoTTAdapter.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, HoTTbinReader.recordSetESC);
                            isESCdetected = true;
                            break;
                        }
                        case 80: {
                            if (HoTTbinReader.recordSetESC2 == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)8);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC2.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetESC2 = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)8, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetESC2);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.ESC2.value(), HoTTbinReader.recordSetESC2);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddESC2(HoTTbinReader.buf);
                            if (isESC2detected) break;
                            HoTTAdapter.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, HoTTbinReader.recordSetESC2);
                            isESC2detected = true;
                            break;
                        }
                        case 96: {
                            if (HoTTbinReader.recordSetESC3 == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)9);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC3.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetESC3 = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)9, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetESC3);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.ESC3.value(), HoTTbinReader.recordSetESC3);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddESC3(HoTTbinReader.buf);
                            if (isESC3detected) break;
                            HoTTAdapter.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, HoTTbinReader.recordSetESC3);
                            isESC3detected = true;
                            break;
                        }
                        case 112: {
                            if (HoTTbinReader.recordSetESC4 == null) {
                                channel = (Channel)HoTTbinReader.channels.get((Object)10);
                                channel.setFileDescription((String)(HoTTbinReader.application.isObjectoriented() ? date + " " + HoTTbinReader.application.getObjectKey() : date));
                                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC4.value() + recordSetNameExtend;
                                HoTTbinReader.recordSetESC4 = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)10, (boolean)true, (boolean)true, (boolean)true);
                                channel.put(recordSetName, (Object)HoTTbinReader.recordSetESC4);
                                HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.ESC4.value(), HoTTbinReader.recordSetESC4);
                                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                if (HoTTbinReader.application.getMenuToolBar() != null) {
                                    channel.applyTemplate((String)recordSetName, false);
                                }
                            }
                            HoTTlogReader.parseAddESC4(HoTTbinReader.buf);
                            if (isESC4detected) break;
                            HoTTAdapter.updateEscTypeDependent(HoTTbinReader.buf[65] & 0xFF, device, HoTTbinReader.recordSetESC4);
                            isESC4detected = true;
                        }
                    }
                    boolean bl = HoTTbinReader.isJustParsed = !rcvLogParser.updateLossStatistics();
                    if (i % progressIndicator == 0) {
                        GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                    }
                }
                ++i;
            }
            rcvLogParser.finalUpdateLossStatistics();
            String string2 = packageLossPercentage = HoTTbinReader.recordSetReceiver.getRecordDataSize(true) > 0 ? String.format("%.1f", HoTTlogReader.rcvLogParser.getLostPackages().percentage) : "100";
            if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                HoTTbinReader.detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            }
            HoTTbinReader.recordSetReceiver.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{rcvLogParser.getLossTotal(), HoTTlogReader.rcvLogParser.getLostPackages().lossTotal, packageLossPercentage, rcvLogParser.getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", detectedSensors.toString()));
            HoTTbinReader.log.logp(Level.WARNING, HoTTbinReader.$CLASS_NAME, "read", "skipped number receiver data due to package loss = " + HoTTlogReader.rcvLogParser.getLostPackages().lossTotal);
            HoTTbinReader.log.logp(Level.TIME, HoTTbinReader.$CLASS_NAME, "read", "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (GDE.isWithUi()) {
                for (RecordSet recordSet : HoTTbinReader.recordSets.values()) {
                    device.makeInActiveDisplayable(recordSet);
                    device.updateVisibilityStatus(recordSet, true);
                    recordSet.descriptionAppendFilename(file.getName());
                }
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    protected static synchronized void convertAscii2Raw(int rawDataBlockSize, byte[] buffer) {
        String[] splitInput = new String(buffer).split("\\|");
        byte[] rawBuf = new byte[rawDataBlockSize];
        if (splitInput.length != 7 || splitInput.length > 1 && splitInput[0].length() != 8) {
            log.log(Level.WARNING, "invalid string input '" + new String(buffer) + "'");
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            for (String part : splitInput) {
                log.log(Level.FINER, "'" + part + "'");
            }
        }
        int index = 4;
        for (String statuscByte : splitInput[1].split(",")) {
            rawBuf[index++] = (byte)Integer.parseInt(statuscByte.trim());
        }
        for (String recByte : splitInput[2].split(",")) {
            rawBuf[index++] = (byte)Integer.parseInt(recByte.trim(), 16);
        }
        for (String sensorInfoByte : splitInput[3].split(",")) {
            rawBuf[index++] = (byte)Integer.parseInt(sensorInfoByte.trim(), 16);
        }
        for (String sensorByte : splitInput[4].split(",")) {
            rawBuf[index++] = (byte)Integer.parseInt(sensorByte.trim(), 16);
        }
        for (String channelByte : splitInput[5].split(",")) {
            String ch = String.format("%04X", Integer.parseInt(channelByte.trim()));
            rawBuf[index++] = (byte)Integer.parseInt(ch.trim().substring(2), 16);
            rawBuf[index++] = (byte)Integer.parseInt(ch.trim().substring(0, 2), 16);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, StringHelper.byte2Hex4CharString((byte[])rawBuf, (int)rawBuf.length));
        }
        System.arraycopy(rawBuf, 0, buffer, 0, rawBuf.length);
    }

    protected static void printSensorValues(byte[] buffer, int[] values, int endIndex) {
        log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])buffer, (int)26, (int)38));
        StringBuilder sb = new StringBuilder().append(String.format("Sensor = 0x%X", buffer[26]));
        sb.append(String.format(" %d", values[endIndex - 1] / 1000));
        for (int i = 0; i < endIndex; ++i) {
            sb.append(String.format(" %6.3f", (double)values[i] / 1000.0));
        }
        log.log(Level.FINER, sb.toString());
    }

    protected static void parseAddReceiver(byte[] _buf) throws DataInconsitsentException {
        rcvLogParser.parse();
        recordSetReceiver.addPoints(rcvLogParser.getPoints(), (double)rcvLogParser.getTimeStep_ms());
    }

    protected static void parseAddVario(byte[] _buf) throws DataInconsitsentException {
        if (varLogParser.parse()) {
            recordSetVario.addPoints(varLogParser.getPoints(), (double)varLogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddGPS(byte[] _buf, long timeStep_ms) throws DataInconsitsentException {
        System.arraycopy(_buf, 0, buf, 0, _buf.length);
        HoTTlogReader.gpsLogParser.timeStep_ms = timeStep_ms;
        if (gpsLogParser.parse()) {
            recordSetGPS.addPoints(gpsLogParser.getPoints(), (double)gpsLogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddGAM(byte[] _buf) throws DataInconsitsentException {
        if (gamLogParser.parse()) {
            recordSetGAM.addPoints(gamLogParser.getPoints(), (double)gamLogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddEAM(byte[] _buf) throws DataInconsitsentException {
        if (eamLogParser.parse()) {
            recordSetEAM.addPoints(eamLogParser.getPoints(), (double)eamLogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddESC(byte[] _buf) throws DataInconsitsentException {
        if (escLogParser.parse(recordSetESC, escLogParser.getTimeStep_ms())) {
            recordSetESC.addPoints(escLogParser.getPoints(), (double)escLogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddESC2(byte[] _buf) throws DataInconsitsentException {
        if (esc2LogParser.parse(recordSetESC2, esc2LogParser.getTimeStep_ms())) {
            recordSetESC2.addPoints(esc2LogParser.getPoints(), (double)esc2LogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddESC3(byte[] _buf) throws DataInconsitsentException {
        if (esc3LogParser.parse(recordSetESC3, esc3LogParser.getTimeStep_ms())) {
            recordSetESC3.addPoints(esc3LogParser.getPoints(), (double)esc3LogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddESC4(byte[] _buf) throws DataInconsitsentException {
        if (esc4LogParser.parse(recordSetESC4, esc4LogParser.getTimeStep_ms())) {
            recordSetESC4.addPoints(esc4LogParser.getPoints(), (double)esc4LogParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddChannel(byte[] _buf) throws DataInconsitsentException {
        chnLogParser.parse();
        recordSetChannel.addPoints(chnLogParser.getPoints(), (double)chnLogParser.getTimeStep_ms());
    }

    public static abstract class LogParser {
        public static final int TIMESTEP_INDEX = 0;
        protected final HoTTAdapter.PickerParameters pickerParameters;
        protected final int[] points;
        protected final long[] timeSteps_ms;
        protected final HoTTAdapter.Sensor sensor;
        protected byte[] buf;

        protected LogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, HoTTAdapter.Sensor sensor) {
            this.pickerParameters = pickerParameters;
            this.points = points;
            this.timeSteps_ms = timeSteps_ms;
            this.sensor = sensor;
            this.buf = buffer;
        }

        protected abstract boolean parse();

        protected long getTimeStep_ms() {
            return this.timeSteps_ms[0];
        }

        public HoTTAdapter.Sensor getSensor() {
            return this.sensor;
        }

        public int[] getPoints() {
            return this.points;
        }

        public void migratePoints(int[] targetPoints) {
            throw new UnsupportedOperationException("required for HoTTbinReader2 only");
        }

        public String toString() {
            int maxLen = 11;
            return "LogParser [sensor=" + String.valueOf((Object)this.sensor) + ", timeStep_ms=" + this.getTimeStep_ms() + ", points=" + (this.points != null ? Arrays.toString(Arrays.copyOf(this.points, Math.min(this.points.length, 11))) : null) + "]";
        }
    }

    public static class RcvLogParser
    extends LogParser {
        private int tmpVoltageRx = 0;
        private int tmpTemperatureRx = 0;
        private int consecutiveLossCounter = 0;
        private PackageLoss lostPackages = new PackageLoss();
        protected final byte[] buf;

        protected RcvLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.RECEIVER);
            this.buf = buffer;
        }

        protected void parseTxRxOnly() {
            this.points[4] = this.buf[8] * -1000;
            this.points[5] = this.buf[9] * -1000;
        }

        @Override
        protected boolean parse() {
            this.tmpVoltageRx = this.buf[13] & 0xFF;
            this.tmpTemperatureRx = this.buf[14] & 0xFF;
            if (this.isPointsValid()) {
                this.points[1] = (this.buf[16] & 0xFF) * 1000;
                this.points[2] = HoTTbinReader.convertRxDbm2Strength(this.buf[9] & 0xFF) * 1000;
                this.points[3] = DataParser.parse2Short((byte[])this.buf, (int)18) * 1000;
                this.points[4] = this.buf[8] * -1000;
                this.points[5] = this.buf[9] * -1000;
                this.points[6] = (this.buf[13] & 0xFF) * 1000;
                this.points[7] = ((this.buf[14] & 0xFF) - 20) * 1000;
                this.points[8] = (this.buf[17] & 0xFF) * 1000;
                this.points[9] = (this.buf[25] & 0x40) > 0 || (this.buf[25] & 0x20) > 0 && HoTTbinReader.tmpTemperatureRx >= 70 ? (this.buf[25] & 0x60) * 1000 : 0;
            }
            if (log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder().append(String.format("Tx-dbm = -%d Rx-dbm = -%d", this.buf[8], this.buf[9]));
                for (int i = 0; i < 10; ++i) {
                    sb.append(String.format(" %6.3f", (double)this.points[i] / 1000.0));
                }
                log.log(Level.FINE, sb.toString());
            }
            return true;
        }

        public void trackPackageLoss(boolean isAvailable) {
            if (isAvailable) {
                this.pickerParameters.reverseChannelPackageLossCounter.add(1);
                this.points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
            } else {
                this.pickerParameters.reverseChannelPackageLossCounter.add(0);
                this.points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
                ++this.consecutiveLossCounter;
            }
            ++this.lostPackages.numberTrackedSamples;
        }

        public boolean updateLossStatistics() {
            if (this.consecutiveLossCounter > 0) {
                this.lostPackages.add(this.consecutiveLossCounter);
                this.consecutiveLossCounter = 0;
                return true;
            }
            return false;
        }

        public void finalUpdateLossStatistics() {
            this.lostPackages.percentage = (double)this.lostPackages.lossTotal * 100.0 / (double)(this.lostPackages.numberTrackedSamples - this.consecutiveLossCounter);
            log.log(Level.INFO, String.format("lostPackages = (%d) %d of %d percentage = %3.1f", this.lostPackages.lossTotal + this.consecutiveLossCounter, this.lostPackages.lossTotal, this.lostPackages.numberTrackedSamples, this.lostPackages.percentage));
        }

        public int getLossTotal() {
            return this.lostPackages.lossTotal + this.consecutiveLossCounter;
        }

        public int getConsecutiveLossCounter() {
            return this.consecutiveLossCounter;
        }

        public PackageLoss getLostPackages() {
            return this.lostPackages;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpVoltageRx > -1 && this.tmpVoltageRx < 100 && this.tmpTemperatureRx < 120;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            for (int j = 0; j < 10; ++j) {
                targetPoints[j] = this.points[j];
            }
            throw new UnsupportedOperationException("use in situ parsing");
        }

        @Override
        public String toString() {
            return super.toString() + "  [lossTotal=" + this.lostPackages.lossTotal + ", consecutiveLossCounter=" + this.consecutiveLossCounter + "]";
        }
    }

    public static class VarLogParser
    extends LogParser {
        private int tmpHeight = 0;
        private int tmpClimb10 = 0;

        protected VarLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.VARIO);
            this.buf = buffer;
            this.points[2] = 100000;
        }

        @Override
        protected boolean parse() {
            this.points[0] = (this.buf[16] & 0xFF) * 1000;
            this.tmpHeight = isHoTTAdapter2 ? DataParser.parse2Short((byte[])this.buf, (int)28) - 500 : DataParser.parse2Short((byte[])this.buf, (int)28);
            this.points[1] = this.tmpHeight * 1000;
            this.points[2] = (DataParser.parse2UnsignedShort((byte[])this.buf, (int)34) - 30000) * 10;
            this.tmpClimb10 = isHoTTAdapter2 ? (DataParser.parse2UnsignedShort((byte[])this.buf, (int)38) - 30000) * 10 : DataParser.parse2UnsignedShort((byte[])this.buf, (int)38) * 1000;
            this.points[3] = isHoTTAdapter2 ? (DataParser.parse2UnsignedShort((byte[])this.buf, (int)36) - 30000) * 10 : DataParser.parse2UnsignedShort((byte[])this.buf, (int)36) * 1000;
            this.points[4] = this.tmpClimb10;
            this.points[5] = (this.buf[13] & 0xFF) * 1000;
            this.points[6] = (this.buf[14] & 0xFF) * 1000;
            this.points[7] = (this.buf[27] & 0x3F) * 1000;
            if ((this.buf[65] & 0xFF) > 100 && (this.buf[65] & 0xFF) < 120) {
                try {
                    this.points[8] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this.buf[40], this.buf[41], this.buf[42], this.buf[44], this.buf[45]).trim());
                    this.points[9] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this.buf[47], this.buf[48], this.buf[49], this.buf[51], this.buf[52]).trim());
                    this.points[10] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this.buf[54], this.buf[55], this.buf[56], this.buf[58], this.buf[59]).trim());
                }
                catch (NumberFormatException e) {
                    byte[] tmpArray = new byte[21];
                    System.arraycopy(this.buf, 40, tmpArray, 0, tmpArray.length);
                    log.log(Level.WARNING, new String(tmpArray));
                }
                this.points[11] = (this.buf[64] & 0xFF) * 1000;
                this.points[12] = (this.buf[65] & 0xFF) * 1000;
            }
            if (log.isLoggable(Level.FINER)) {
                HoTTlogReader.printSensorValues(this.buf, this.points, 8);
            }
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.pickerParameters.altitudeClimbSensorSelection == HoTTAdapter.Sensor.VARIO.ordinal()) {
                System.arraycopy(this.points, 1, targetPoints, 10, 4);
            }
            System.arraycopy(this.points, 7, targetPoints, 14, 6);
        }
    }

    public static class GpsLogParser
    extends LogParser {
        private long timeStep_ms = 0L;
        private int tmpHeight = 0;
        private int tmpClimb1 = 0;
        private int tmpClimb3 = 0;
        private int tmpVelocity = 0;
        private int tmpLatitude = 0;
        private int tmpLongitude = 0;

        protected GpsLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.GPS);
            this.buf = buffer;
        }

        @Override
        protected boolean parse() {
            this.points[0] = (this.buf[16] & 0xFF) * 1000;
            this.tmpHeight = isHoTTAdapter2 ? DataParser.parse2Short((byte[])this.buf, (int)44) - 500 : DataParser.parse2Short((byte[])this.buf, (int)44);
            this.tmpClimb1 = isHoTTAdapter2 ? DataParser.parse2UnsignedShort((byte[])this.buf, (int)46) - 30000 : DataParser.parse2UnsignedShort((byte[])this.buf, (int)46);
            this.tmpClimb3 = isHoTTAdapter2 ? (this.buf[48] & 0xFF) - 120 : this.buf[48] & 0xFF;
            this.points[6] = this.tmpVelocity = DataParser.parse2UnsignedShort((byte[])this.buf, (int)30) * 1000;
            this.tmpLatitude = DataParser.parse2UnsignedShort((byte[])this.buf, (int)33) * 10000 + DataParser.parse2UnsignedShort((byte[])this.buf, (int)35);
            this.points[1] = this.tmpLatitude = this.buf[32] == 1 ? -1 * this.tmpLatitude : this.tmpLatitude;
            this.tmpLongitude = DataParser.parse2UnsignedShort((byte[])this.buf, (int)38) * 10000 + DataParser.parse2UnsignedShort((byte[])this.buf, (int)40);
            this.points[2] = this.tmpLongitude = this.buf[37] == 1 ? -1 * this.tmpLongitude : this.tmpLongitude;
            this.points[3] = this.tmpHeight * 1000;
            this.points[4] = isHoTTAdapter2 ? this.tmpClimb1 * 10 : this.tmpClimb1 * 1000;
            this.points[5] = this.tmpClimb3 * 1000;
            this.points[7] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)42) * 1000;
            this.points[8] = (this.buf[51] & 0xFF) * 1000;
            this.points[9] = 0;
            this.points[10] = (this.buf[13] & 0xFF) * 1000;
            this.points[11] = (this.buf[14] & 0xFF) * 1000;
            this.points[12] = (this.buf[49] & 0xFF) * 1000;
            switch (this.buf[50]) {
                case 45: {
                    this.points[13] = 0;
                    break;
                }
                case 50: {
                    this.points[13] = 2000;
                    break;
                }
                case 51: {
                    this.points[13] = 3000;
                    break;
                }
                case 68: {
                    this.points[13] = 4000;
                    break;
                }
                default: {
                    try {
                        this.points[13] = Integer.valueOf(String.format("%c", 0xFF & this.buf[50])) * 1000;
                        break;
                    }
                    catch (NumberFormatException e1) {
                        this.points[13] = 1000;
                    }
                }
            }
            this.points[14] = (this.buf[28] & 0xFF) * 1000;
            this.points[15] = (this.buf[51] & 0xFF) * 1000;
            if ((this.buf[65] & 0xFF) > 100) {
                this.points[16] = this.buf[52] * 1000;
                this.points[17] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)53) * 1000;
                this.points[19] = DataParser.parse2Short((byte[])this.buf, (int)55) * 1000;
                this.points[20] = DataParser.parse2Short((byte[])this.buf, (int)57) * 1000;
                this.points[21] = DataParser.parse2Short((byte[])this.buf, (int)59) * 1000;
                this.points[22] = (this.buf[61] & 0xFF) * 1000;
            } else if ((this.buf[65] & 0xFF) == 4) {
                this.points[16] = this.buf[60] * 1000;
                this.points[17] = 0;
                this.points[18] = this.buf[54] * 100;
                if (this.points[13] > 0) {
                    int tmpTime = this.buf[55] * 10000000 + this.buf[56] * 100000 + this.buf[57] * 1000 + this.buf[58] * 10;
                    if (tmpTime < this.points[19]) {
                        log.log(Level.WARNING, String.format("near time: %s %s", StringHelper.getFormatedTime((String)"HH:mm:ss.SSS", (long)(this.timeStep_ms - 3600000L)), HoTTAdapter.getFormattedTime(tmpTime)));
                    }
                    this.points[19] = tmpTime;
                    int tmpDate = ((this.buf[61] - 48) * 1000000 + (this.buf[63] - 48) * 10000 + (this.buf[62] - 48) * 100) * 10;
                    if (tmpDate < 0) {
                        log.log(Level.WARNING, String.format("near time: %s Sat-Fix %d #Sats %d %s - %c %c %c", StringHelper.getFormatedTime((String)"HH:mm:ss.SSS", (long)(this.timeStep_ms - 3600000L)), this.points[13] / 1000, this.points[12] / 1000, HoTTAdapter.getFormattedTime(this.points[19]), this.buf[61] & 0xFF, this.buf[63] & 0xFF, this.buf[62] & 0xFF));
                    }
                    this.points[20] = tmpDate;
                }
                this.points[21] = (DataParser.parse2Short((byte[])this.buf, (int)52) - 500) * 1000;
                this.points[22] = (this.buf[59] & 0xFF) * 1000;
            } else if ((this.buf[65] & 0xFF) == 0 || (this.buf[65] & 0xFF) == 1) {
                boolean version;
                boolean bl = version = this.points[23] == 1000 || this.buf[52] != 0 && this.buf[53] != 0 && this.buf[54] != 0;
                if (!version) {
                    this.points[16] = this.buf[52] * 1000;
                    this.points[17] = this.buf[53] * 1000;
                    this.points[18] = this.buf[54] * 1000;
                    this.points[19] = this.buf[55] * 10000000 + this.buf[56] * 100000 + this.buf[57] * 1000 + this.buf[58] * 10;
                    this.points[20] = 0;
                    this.points[21] = DataParser.parse2Short((byte[])this.buf, (int)59) * 1000;
                    this.points[22] = (this.buf[61] & 0xFF) * 1000;
                } else {
                    this.points[16] = DataParser.parse2Short((byte[])this.buf, (int)52) * 1000;
                    this.points[17] = 0;
                    this.points[18] = this.buf[54] * 1000;
                    this.points[19] = this.buf[55] * 10000000 + this.buf[56] * 100000 + this.buf[57] * 1000 + this.buf[58] * 10;
                    this.points[20] = 0;
                    this.points[21] = DataParser.parse2Short((byte[])this.buf, (int)59) * 1000;
                    this.points[22] = (this.buf[61] & 0xFF) * 1000;
                }
            } else {
                this.points[16] = this.buf[52] * 1000;
                this.points[17] = this.buf[53] * 1000;
                this.points[18] = this.buf[54] * 1000;
                this.points[19] = DataParser.parse2Short((byte[])this.buf, (int)55) * 1000;
                this.points[20] = DataParser.parse2Short((byte[])this.buf, (int)57) * 1000;
                this.points[21] = DataParser.parse2Short((byte[])this.buf, (int)59) * 1000;
                this.points[22] = (this.buf[61] & 0xFF) * 1000;
            }
            this.points[23] = (this.buf[65] & 0xFF) * 1000;
            if (log.isLoggable(Level.FINER)) {
                HoTTlogReader.printSensorValues(this.buf, this.points, 23);
            }
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            int k;
            if (this.pickerParameters.altitudeClimbSensorSelection == HoTTAdapter.Sensor.GPS.ordinal()) {
                System.arraycopy(this.points, 3, targetPoints, 10, 3);
            }
            targetPoints[20] = this.points[1];
            targetPoints[21] = this.points[2];
            for (k = 0; k < 4; ++k) {
                targetPoints[k + 22] = this.points[k + 6];
            }
            for (k = 0; k < 3; ++k) {
                targetPoints[k + 26] = this.points[k + 12];
            }
            for (k = 0; k < 9; ++k) {
                targetPoints[k + 29] = this.points[k + 15];
            }
        }
    }

    public static class GamLogParser
    extends LogParser {
        private int tmpHeight = 0;
        private int tmpClimb3 = 0;
        private int tmpVoltage1 = 0;
        private int tmpVoltage2 = 0;
        private int tmpCapacity = 0;

        protected GamLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.GAM);
            this.buf = buffer;
        }

        @Override
        protected boolean parse() {
            this.points[0] = (this.buf[16] & 0xFF) * 1000;
            this.tmpHeight = isHoTTAdapter2 ? DataParser.parse2Short((byte[])this.buf, (int)46) - 500 : DataParser.parse2Short((byte[])this.buf, (int)46);
            this.tmpClimb3 = isHoTTAdapter2 ? (this.buf[50] & 0xFF) - 120 : this.buf[50] & 0xFF;
            this.tmpVoltage1 = DataParser.parse2Short((byte[])this.buf, (int)35);
            this.tmpVoltage2 = DataParser.parse2Short((byte[])this.buf, (int)37);
            this.tmpCapacity = DataParser.parse2Short((byte[])this.buf, (int)55);
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            this.points[1] = DataParser.parse2Short((byte[])this.buf, (int)53) * 1000;
            this.points[2] = DataParser.parse2Short((byte[])this.buf, (int)51) * 1000;
            this.points[3] = this.tmpCapacity * 1000;
            this.points[4] = Double.valueOf((double)this.points[1] / 1000.0 * (double)this.points[2]).intValue();
            for (int j = 0; j < 6; ++j) {
                this.points[j + 6] = (this.buf[j + 29] & 0xFF) * 1000;
                if (this.points[j + 5] <= 0) continue;
                maxVotage = this.points[j + 6] > maxVotage ? this.points[j + 6] : maxVotage;
                minVotage = this.points[j + 6] < minVotage ? this.points[j + 6] : minVotage;
            }
            this.points[5] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? (maxVotage - minVotage) * 10 : 0;
            this.points[12] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)44) * 1000;
            this.points[13] = this.tmpHeight * 1000;
            this.points[14] = isHoTTAdapter2 ? (DataParser.parse2UnsignedShort((byte[])this.buf, (int)48) - 30000) * 10 : DataParser.parse2UnsignedShort((byte[])this.buf, (int)48) * 1000;
            this.points[15] = this.tmpClimb3 * 1000;
            this.points[16] = DataParser.parse2Short((byte[])this.buf, (int)42) * 1000;
            this.points[17] = this.tmpVoltage1 * 100;
            this.points[18] = this.tmpVoltage2 * 100;
            this.points[19] = ((this.buf[39] & 0xFF) - 20) * 1000;
            this.points[20] = ((this.buf[40] & 0xFF) - 20) * 1000;
            this.points[21] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)57) * 1000;
            this.points[22] = (this.buf[59] & 0xFF) * 1000;
            this.points[23] = (this.buf[60] & 0xFF) * 1000;
            this.points[24] = (this.buf[64] & 0xFF) * 1000;
            this.points[25] = ((this.buf[27] & 0xFF) + ((this.buf[28] & 0x7F) << 8)) * 1000;
            if (log.isLoggable(Level.FINER)) {
                HoTTlogReader.printSensorValues(this.buf, this.points, 26);
            }
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            int j;
            if (this.pickerParameters.altitudeClimbSensorSelection == HoTTAdapter.Sensor.GAM.ordinal()) {
                for (int k = 0; k < 3; ++k) {
                    targetPoints[k + 10] = this.points[k + 13];
                }
            }
            for (j = 0; j < 12; ++j) {
                targetPoints[j + 38] = this.points[j + 1];
            }
            for (j = 0; j < 10; ++j) {
                targetPoints[j + 50] = this.points[j + 16];
            }
        }
    }

    public static class EamLogParser
    extends LogParser {
        protected int tmpHeight;
        protected int tmpClimb3;
        protected int tmpVoltage1;
        protected int tmpVoltage2;
        protected int tmpCapacity;
        protected boolean isPowerBox = false;

        protected EamLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.EAM);
            this.buf = buffer;
        }

        @Override
        protected boolean parse() {
            this.points[0] = (this.buf[16] & 0xFF) * 1000;
            this.tmpHeight = isHoTTAdapter2 ? DataParser.parse2Short((byte[])this.buf, (int)49) - 500 : DataParser.parse2Short((byte[])this.buf, (int)49);
            this.tmpClimb3 = isHoTTAdapter2 ? (this.buf[59] & 0xFF) - 120 : this.buf[59] & 0xFF;
            this.tmpVoltage1 = DataParser.parse2Short((byte[])this.buf, (int)43);
            this.tmpVoltage2 = DataParser.parse2Short((byte[])this.buf, (int)45);
            this.tmpCapacity = DataParser.parse2Short((byte[])this.buf, (int)55);
            this.points[1] = DataParser.parse2Short((byte[])this.buf, (int)53) * 1000;
            this.points[2] = DataParser.parse2Short((byte[])this.buf, (int)51) * 1000;
            this.points[3] = this.tmpCapacity * 1000;
            this.points[4] = Double.valueOf((double)this.points[1] / 1000.0 * (double)this.points[2]).intValue();
            if (this.isPowerBox || (HoTTbinReader.buf[63] & 0xFF) == 64) {
                this.points[5] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)29) * 1000;
                this.points[6] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)35) * 1000;
                this.points[7] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)31) * 1000;
                this.points[8] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)33) * 1000;
                this.points[9] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)43) * 1000;
                this.points[10] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)39) * 1000;
                this.points[11] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)37) * 1000;
                this.points[12] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)45) * 1000;
                this.points[13] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)41) * 1000;
                this.points[14] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)60) * 1000;
                this.points[20] = this.tmpHeight * 1000;
                this.points[21] = isHoTTAdapter2 ? (DataParser.parse2UnsignedShort((byte[])this.buf, (int)57) - 30000) * 10 : DataParser.parse2UnsignedShort((byte[])this.buf, (int)57) * 1000;
                this.points[22] = this.tmpClimb3 * 1000;
                this.points[25] = ((this.buf[47] & 0xFF) - 20) * 1000;
                this.points[26] = ((this.buf[48] & 0xFF) - 20) * 1000;
                this.points[28] = (this.buf[63] & 0xFF) * 1000;
                this.isPowerBox = true;
            } else {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                for (int j = 0; j < 14; ++j) {
                    this.points[j + 6] = (this.buf[j + 29] & 0xFF) * 1000;
                    if (this.points[j + 6] <= 0) continue;
                    maxVotage = this.points[j + 6] > maxVotage ? this.points[j + 6] : maxVotage;
                    minVotage = this.points[j + 6] < minVotage ? this.points[j + 6] : minVotage;
                }
                this.points[5] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? (maxVotage - minVotage) * 10 : 0;
                this.points[20] = this.tmpHeight * 1000;
                this.points[21] = isHoTTAdapter2 ? (DataParser.parse2UnsignedShort((byte[])this.buf, (int)57) - 30000) * 10 : DataParser.parse2UnsignedShort((byte[])this.buf, (int)57) * 1000;
                this.points[22] = this.tmpClimb3 * 1000;
                this.points[23] = this.tmpVoltage1 * 100;
                this.points[24] = this.tmpVoltage2 * 100;
                this.points[25] = ((this.buf[47] & 0xFF) - 20) * 1000;
                this.points[26] = ((this.buf[48] & 0xFF) - 20) * 1000;
                this.points[27] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)60) * 1000;
                this.points[28] = ((this.buf[62] & 0xFF) * 60 + (this.buf[63] & 0xFF)) * 1000;
                this.points[29] = DataParser.parse2Short((byte[])this.buf, (int)64) * 1000;
                this.points[30] = ((this.buf[27] & 0xFF) + ((this.buf[28] & 0x7F) << 8)) * 1000;
            }
            if (log.isLoggable(Level.FINER)) {
                HoTTlogReader.printSensorValues(this.buf, this.points, 31);
            }
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.pickerParameters.altitudeClimbSensorSelection == HoTTAdapter.Sensor.EAM.ordinal()) {
                for (int j = 0; j < 3; ++j) {
                    targetPoints[j + 10] = this.points[j + 20];
                }
            }
            System.arraycopy(this.points, 1, targetPoints, 60, 19);
            System.arraycopy(this.points, 23, targetPoints, 79, 8);
        }
    }

    public static class EscLogParser
    extends LogParser {
        protected int tmpVoltage;
        protected int tmpCurrent;
        protected int tmpCapacity;
        protected int tmpRevolution;
        protected int tmpTemperatureFet;
        protected final boolean isChannelsChannel;

        protected EscLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.ESC);
            this.buf = buffer;
            this.isChannelsChannel = Analyzer.getInstance().getActiveChannel().getNumber() == 4;
        }

        protected EscLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, HoTTAdapter.Sensor sensor) {
            super(pickerParameters, points, timeSteps_ms, buffer, sensor);
            this.buf = buffer;
            this.isChannelsChannel = Analyzer.getInstance().getActiveChannel().getNumber() == 4;
        }

        @Override
        protected boolean parse() {
            return false;
        }

        protected boolean parse(RecordSet recordSet, long timeStep_ms) {
            this.points[0] = (this.buf[16] & 0xFF) * 1000;
            this.tmpVoltage = DataParser.parse2Short((byte[])this.buf, (int)29);
            this.tmpCurrent = DataParser.parse2Short((byte[])this.buf, (int)37);
            this.tmpCapacity = DataParser.parse2Short((byte[])this.buf, (int)33);
            this.tmpRevolution = DataParser.parse2UnsignedShort((byte[])this.buf, (int)41);
            this.tmpTemperatureFet = (this.buf[35] & 0xFF) - 20;
            if (!this.pickerParameters.isFilterEnabled || this.tmpVoltage > 0 && this.tmpVoltage < 1000 && this.tmpCurrent < 4000 && this.tmpCurrent > -10 && this.tmpRevolution > -1 && this.tmpRevolution < 20000 && (this.points[6] == 0 || this.points[6] / 1000 - this.tmpTemperatureFet <= 20)) {
                this.points[1] = this.tmpVoltage * 1000;
                this.points[2] = this.tmpCurrent * 1000;
                if (!this.pickerParameters.isFilterEnabled || recordSet.getRecordDataSize(true) <= 20 || this.tmpCapacity != 0 && Math.abs(this.tmpCapacity) <= this.points[3] / 1000 + this.tmpVoltage * this.tmpCurrent / 2500 + 2) {
                    this.points[3] = this.tmpCapacity * 1000;
                } else if (this.tmpCapacity != 0) {
                    HoTTlogReader2.log.log(Level.WARNING, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)timeStep_ms) + " - " + this.tmpCapacity + " - " + this.points[3] / 1000 + " + " + (this.tmpVoltage * this.tmpCurrent / 2500 + 2));
                }
                this.points[4] = Double.valueOf((double)this.points[1] / 1000.0 * (double)this.points[2]).intValue();
                this.points[5] = this.tmpRevolution * 1000;
                this.points[6] = this.tmpTemperatureFet * 1000;
                this.points[7] = ((this.buf[45] & 0xFF) - 20) * 1000;
                this.points[8] = DataParser.parse2Short((byte[])this.buf, (int)31) * 1000;
                this.points[9] = DataParser.parse2Short((byte[])this.buf, (int)39) * 1000;
                this.points[10] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)43) * 1000;
                this.points[11] = ((this.buf[36] & 0xFF) - 20) * 1000;
                this.points[12] = ((this.buf[46] & 0xFF) - 20) * 1000;
            }
            this.points[13] = ((this.buf[27] & 0xFF) + ((this.buf[28] & 0x7F) << 8)) * 1000;
            if ((this.buf[65] & 0xFF) == 3) {
                this.points[14] = DataParser.parse2Short((byte[])this.buf, (int)47) * 1000;
                this.points[15] = DataParser.parse2Short((byte[])this.buf, (int)49) * 1000;
                this.points[16] = (this.buf[51] & 0xFF) * 1000;
                this.points[17] = (this.buf[52] & 0xFF) * 1000;
                this.points[18] = (this.buf[53] & 0xFF) * 1000;
                this.points[19] = (this.buf[54] & 0xFF) * 1000;
                this.points[20] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)55) * 1000;
                this.points[21] = ((this.buf[57] & 0xFF) - 20) * 1000;
                this.points[22] = ((this.buf[58] & 0xFF) - 20) * 1000;
                this.points[23] = (this.buf[59] & 0xFF) * 1000;
                this.points[24] = ((this.buf[60] & 0xFF) - 20) * 1000;
                this.points[25] = DataParser.parse2Short((byte[])this.buf, (int)61) * 1000;
                this.points[26] = (this.buf[63] & 0xFF) * 1000;
                this.points[27] = (this.buf[64] & 0xFF) * 1000;
                this.points[28] = 0;
                this.points[29] = (this.buf[65] & 0xFF) * 1000;
            } else if ((this.buf[65] & 0xFF) >= 128) {
                this.points[14] = DataParser.parse2Short((byte[])this.buf, (int)47) * 1000;
                this.points[15] = DataParser.parse2Short((byte[])this.buf, (int)49) * 1000;
                this.points[16] = (this.buf[51] & 0xFF) * 1000;
                this.points[17] = (this.buf[52] & 0xFF) * 1000;
                this.points[18] = (this.buf[53] & 0xFF) * 1000;
                this.points[19] = (this.buf[54] & 0xFF) * 1000;
                this.points[20] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)55) * 1000;
                this.points[21] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)57) * 1000;
                this.points[22] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)59) * 1000;
                this.points[23] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)61) * 1000;
                this.points[24] = ((this.buf[63] & 0xFF) - 20) * 1000;
                this.points[25] = (this.buf[64] & 0xFF) * 1000;
                this.points[26] = 0;
                this.points[27] = 0;
                this.points[28] = 0;
                this.points[29] = (this.buf[65] & 0xFF) * 1000;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.buf, (int)this.buf.length));
            }
            if (log.isLoggable(Level.FINER)) {
                HoTTlogReader.printSensorValues(this.buf, this.points, 14);
            }
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.isChannelsChannel) {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 107] = this.points[j + 1];
                }
            } else {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 87] = this.points[j + 1];
                }
            }
        }
    }

    public static class ChnLogParser
    extends LogParser {
        protected final int numberUsedChannels;

        protected ChnLogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer, int numberUsedChannels) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.CHANNEL);
            this.buf = buffer;
            this.numberUsedChannels = numberUsedChannels;
        }

        @Override
        protected boolean parse() {
            this.points[0] = this.buf[7] * -1000;
            this.points[1] = this.buf[8] * -1000;
            this.points[2] = this.buf[9] * -1000;
            int i = 0;
            int j = 0;
            while (i < this.numberUsedChannels) {
                this.points[i + 3] = DataParser.parse2UnsignedShort((byte[])this.buf, (int)(66 + j)) / 2 * 1000;
                ++i;
                j += 2;
            }
            this.points[38] = this.buf[25] > 0 ? (this.buf[25] & 0xFF) * 1000 : 0;
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            int j;
            for (j = 4; j < 7; ++j) {
                targetPoints[j] = this.points[j];
            }
            for (j = 87; j < 107; ++j) {
                targetPoints[j] = this.points[j];
            }
            throw new UnsupportedOperationException("use in situ parsing");
        }
    }

    public static class Esc4LogParser
    extends EscLogParser {
        protected Esc4LogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.ESC4);
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.isChannelsChannel) {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 107] = this.points[j + 1];
                }
            } else {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 174] = this.points[j + 1];
                }
            }
        }
    }

    public static class Esc3LogParser
    extends EscLogParser {
        protected Esc3LogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.ESC3);
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.isChannelsChannel) {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 107] = this.points[j + 1];
                }
            } else {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 145] = this.points[j + 1];
                }
            }
        }
    }

    public static class Esc2LogParser
    extends EscLogParser {
        protected Esc2LogParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[] buffer) {
            super(pickerParameters, points, timeSteps_ms, buffer, HoTTAdapter.Sensor.ESC2);
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.isChannelsChannel) {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 107] = this.points[j + 1];
                }
            } else {
                for (int j = 0; j < 29; ++j) {
                    targetPoints[j + 116] = this.points[j + 1];
                }
            }
        }
    }
}

