/*
 * Decompiled with CFR 0.152.
 */
package gde.device.htronic;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.htronic.AkkuMasterC4;
import gde.device.htronic.AkkuMasterC4SerialPort;
import gde.device.htronic.AkkuMasterChannelTab;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class AkkuMasterC4Dialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(AkkuMasterC4Dialog.class.getName());
    static final String DEVICE_NAME = "Akkumaster C4";
    static final String AKKU_MASTER_HELP_DIR = "AkkuMaster";
    CLabel totalChargeCurrentText;
    CLabel totalDischargeCurrentText;
    CLabel totalChargeCurrentLabel;
    CLabel totalDischargeCurrentLabel;
    CLabel totalChargeCurrentUnit;
    CLabel totalDischargeCurrentUnit;
    Composite statusComposite;
    CLabel versionFrontplateTypeLabel;
    CLabel versionCurrentTypeLabel;
    CLabel versionDateLabel;
    CLabel versionNumberLabel;
    CLabel versionFrontplateTypeText;
    CLabel versionCurrentTypeText;
    CLabel versionDateText;
    CLabel versionNumberText;
    Composite versionComposite;
    CTabItem versionTabItem;
    CTabFolder tabFolder;
    Button closeButton;
    final Settings settings;
    final AkkuMasterC4 device;
    final AkkuMasterC4SerialPort serialPort;
    final Channels channels;
    AkkuMasterChannelTab channel1Tab;
    AkkuMasterChannelTab channel2Tab;
    AkkuMasterChannelTab channel3Tab;
    AkkuMasterChannelTab channel4Tab;
    int totalDischargeCurrent = 0;
    int totalChargeCurrent = 0;
    HashMap<String, String> version;
    Thread versionThread;
    final int numberChannels;
    final int maxCurrent = 2000;
    boolean isWarnedConnectError = false;

    public AkkuMasterC4Dialog(Shell parent, AkkuMasterC4 actualDevice) {
        super(parent);
        this.device = actualDevice;
        this.serialPort = actualDevice.getCommunicationPort();
        this.channels = Channels.getInstance();
        this.numberChannels = actualDevice.getChannelCount();
        this.settings = Settings.getInstance();
    }

    public void open() {
        this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
        this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
        log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
        if (this.dialogShell == null || this.dialogShell.isDisposed()) {
            String[] aChargeCurrent_mA;
            this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            if (this.isAlphaEnabled) {
                this.dialogShell.setAlpha(254);
            }
            this.dialogShell.setLayout(null);
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(440, 555);
            this.dialogShell.setText(DEVICE_NAME + Messages.getString((String)"GDE_MSGT0273"));
            this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
            this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent evt) {
                    log.log(Level.FINER, "dialogShell.mouseEnter, event=" + String.valueOf(evt));
                    AkkuMasterC4Dialog.this.fadeOutAplhaBlending(evt, AkkuMasterC4Dialog.this.getDialogShell().getClientArea(), 10, 10, 10, 15);
                }

                public void mouseHover(MouseEvent evt) {
                    log.log(Level.FINEST, "dialogShell.mouseHover, event=" + String.valueOf(evt));
                }

                public void mouseExit(MouseEvent evt) {
                    log.log(Level.FINER, "dialogShell.mouseExit, event=" + String.valueOf(evt));
                    AkkuMasterC4Dialog.this.fadeInAlpaBlending(evt, AkkuMasterC4Dialog.this.getDialogShell().getClientArea(), 10, 10, -10, 15);
                }
            });
            this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
            this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.tabFolder.setBounds(0, 0, 430, 425);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "tabFolder.widgetDisposed, event=" + String.valueOf(evt));
                    AkkuMasterC4Dialog.this.statusComposite.redraw();
                }
            });
            String[] aCapacity = new String[]{"100", "250", "500", "600", "800", "1000", "1250", "1500", "1750", "2000", "2500", "3000", "4000", "5000"};
            String[] aCellCount = new String[]{"1" + Messages.getString((String)"GDE_MSGT1185"), "2" + Messages.getString((String)"GDE_MSGT1148"), "3" + Messages.getString((String)"GDE_MSGT1148"), "4" + Messages.getString((String)"GDE_MSGT1148"), "5" + Messages.getString((String)"GDE_MSGT1148"), "6" + Messages.getString((String)"GDE_MSGT1148"), "7" + Messages.getString((String)"GDE_MSGT1148"), "8" + Messages.getString((String)"GDE_MSGT1148"), "9" + Messages.getString((String)"GDE_MSGT1148"), "10" + Messages.getString((String)"GDE_MSGT1148"), "11" + Messages.getString((String)"GDE_MSGT1148"), "12" + Messages.getString((String)"GDE_MSGT1148"), "13" + Messages.getString((String)"GDE_MSGT1148"), "14" + Messages.getString((String)"GDE_MSGT1148")};
            String[] aAkkuType = new String[]{"0 NiCa", "1 NiMh", "2 Pb"};
            String[] aProgramm = new String[]{Messages.getString((String)"GDE_MSGT1100"), Messages.getString((String)"GDE_MSGT1101"), Messages.getString((String)"GDE_MSGT1102"), Messages.getString((String)"GDE_MSGT1103"), Messages.getString((String)"GDE_MSGT1104"), Messages.getString((String)"GDE_MSGT1105"), Messages.getString((String)"GDE_MSGT1106"), Messages.getString((String)"GDE_MSGT1107"), Messages.getString((String)"GDE_MSGT1108")};
            String[] aDischargeCurrent_mA = aChargeCurrent_mA = new String[]{"50", "100", "150", "200", "250", "300", "400", "500", "750", "900", "1000", "1500", "2000"};
            if (this.numberChannels > 0) {
                this.channel1Tab = new AkkuMasterChannelTab(this, " 1 " + this.device.getChannelNameReplacement(1), AkkuMasterC4SerialPort.channel_1, this.serialPort, (Channel)this.channels.get((Object)1), aCapacity, aCellCount, aAkkuType, aProgramm, aChargeCurrent_mA, aDischargeCurrent_mA);
                this.channel1Tab.addChannelTab(this.tabFolder);
            }
            if (this.numberChannels > 1) {
                this.channel2Tab = new AkkuMasterChannelTab(this, " 2 " + this.device.getChannelNameReplacement(2), AkkuMasterC4SerialPort.channel_2, this.serialPort, (Channel)this.channels.get((Object)2), aCapacity, aCellCount, aAkkuType, aProgramm, aChargeCurrent_mA, aDischargeCurrent_mA);
                this.channel2Tab.addChannelTab(this.tabFolder);
            }
            if (this.numberChannels > 2) {
                this.channel3Tab = new AkkuMasterChannelTab(this, " 3 " + this.device.getChannelNameReplacement(3), AkkuMasterC4SerialPort.channel_3, this.serialPort, (Channel)this.channels.get((Object)3), aCapacity, aCellCount, aAkkuType, aProgramm, aChargeCurrent_mA, aDischargeCurrent_mA);
                this.channel3Tab.addChannelTab(this.tabFolder);
            }
            if (this.numberChannels > 3) {
                this.channel4Tab = new AkkuMasterChannelTab(this, " 4 " + this.device.getChannelNameReplacement(4), AkkuMasterC4SerialPort.channel_4, this.serialPort, (Channel)this.channels.get((Object)4), aCapacity, aCellCount, aAkkuType, aProgramm, aChargeCurrent_mA, aDischargeCurrent_mA);
                this.channel4Tab.addChannelTab(this.tabFolder);
            }
            this.versionTabItem = new CTabItem(this.tabFolder, 0);
            this.versionTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionTabItem.setText(Messages.getString((String)"GDE_MSGT1109"));
            this.versionComposite = new Composite((Composite)this.tabFolder, 0);
            this.versionComposite.setLayout(null);
            this.versionTabItem.setControl((Control)this.versionComposite);
            this.versionComposite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    log.log(Level.FINEST, "versionComposite.paintControl, event=" + String.valueOf(evt));
                    if (AkkuMasterC4Dialog.this.version != null) {
                        AkkuMasterC4Dialog.this.updateVersionText(String.format(":    %s", AkkuMasterC4Dialog.this.version.get(AkkuMasterC4SerialPort.VERSION_NUMBER)), String.format(":    %s", AkkuMasterC4Dialog.this.version.get(AkkuMasterC4SerialPort.VERSION_DATE)), String.format(":    %s", AkkuMasterC4Dialog.this.version.get(AkkuMasterC4SerialPort.VERSION_TYPE_CURRENT)), String.format(":    %s", AkkuMasterC4Dialog.this.version.get(AkkuMasterC4SerialPort.VERSION_TYPE_FRONT)));
                    } else {
                        AkkuMasterC4Dialog.this.updateVersionText(String.format(":    %s", Messages.getString((String)"GDE_MSGT0276")), String.format(":    %s", Messages.getString((String)"GDE_MSGT0276")), String.format(":    %s", Messages.getString((String)"GDE_MSGT0276")), String.format(":    %s", Messages.getString((String)"GDE_MSGT0276")));
                        AkkuMasterC4Dialog.this.startUpdateVersionThread();
                    }
                }
            });
            this.versionNumberLabel = new CLabel(this.versionComposite, 16384);
            this.versionNumberLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionNumberLabel.setBounds(25, 60, 150, 20);
            this.versionNumberLabel.setText(Messages.getString((String)"GDE_MSGT1122"));
            this.versionNumberText = new CLabel(this.versionComposite, 0);
            this.versionNumberText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionNumberText.setBounds(230, 63, 100, 20);
            this.versionDateLabel = new CLabel(this.versionComposite, 16384);
            this.versionDateLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionDateLabel.setBounds(25, 110, 150, 20);
            this.versionDateLabel.setText(Messages.getString((String)"GDE_MSGT1123"));
            this.versionDateText = new CLabel(this.versionComposite, 0);
            this.versionDateText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionDateText.setBounds(230, 113, 100, 20);
            this.versionCurrentTypeLabel = new CLabel(this.versionComposite, 16384);
            this.versionCurrentTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionCurrentTypeLabel.setBounds(25, 160, 150, 20);
            this.versionCurrentTypeLabel.setText(Messages.getString((String)"GDE_MSGT1124"));
            this.versionCurrentTypeText = new CLabel(this.versionComposite, 0);
            this.versionCurrentTypeText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionCurrentTypeText.setBounds(230, 163, 100, 20);
            this.versionFrontplateTypeLabel = new CLabel(this.versionComposite, 16384);
            this.versionFrontplateTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionFrontplateTypeLabel.setBounds(25, 210, 150, 20);
            this.versionFrontplateTypeLabel.setText(Messages.getString((String)"GDE_MSGT1125"));
            this.versionFrontplateTypeText = new CLabel(this.versionComposite, 0);
            this.versionFrontplateTypeText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.versionFrontplateTypeText.setBounds(230, 213, 100, 20);
            try {
                this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
            }
            catch (RuntimeException e) {
                this.tabFolder.setSelection(0);
            }
            this.statusComposite = new Composite((Composite)this.dialogShell, 0);
            this.statusComposite.setLayout(null);
            this.statusComposite.setBounds(0, 430, 430, 45);
            this.statusComposite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    log.log(Level.FINE, "statusComposite.paintCOntrol, event=" + String.valueOf(evt));
                    AkkuMasterC4Dialog.this.totalDischargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalDischargeCurrent));
                    AkkuMasterC4Dialog.this.totalChargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalChargeCurrent));
                }
            });
            this.statusComposite.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent evt) {
                    log.log(Level.WARNING, "statusComposite.focusGained, event=" + String.valueOf(evt));
                    AkkuMasterC4Dialog.this.totalDischargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalDischargeCurrent));
                    AkkuMasterC4Dialog.this.totalChargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalChargeCurrent));
                }
            });
            this.totalChargeCurrentLabel = new CLabel(this.statusComposite, 131072);
            this.totalChargeCurrentLabel.setText(Messages.getString((String)"GDE_MSGT1110"));
            this.totalChargeCurrentLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.totalChargeCurrentLabel.setBounds(20, 3, 190, 20);
            this.totalChargeCurrentText = new CLabel(this.statusComposite, 0x1020000);
            this.totalChargeCurrentText.setBounds(235, 3, 50, 20);
            this.totalChargeCurrentText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.totalChargeCurrentText.setText(String.format("%4d", this.totalChargeCurrent));
            this.totalChargeCurrentUnit = new CLabel(this.statusComposite, 16384);
            this.totalChargeCurrentUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.totalChargeCurrentUnit.setText(Messages.getString((String)"GDE_MSGT1113"));
            this.totalChargeCurrentUnit.setBounds(300, 3, 119, 20);
            this.totalDischargeCurrentLabel = new CLabel(this.statusComposite, 131072);
            this.totalDischargeCurrentLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.totalDischargeCurrentLabel.setText(Messages.getString((String)"GDE_MSGT1111"));
            this.totalDischargeCurrentLabel.setBounds(20, 25, 190, 20);
            this.totalDischargeCurrentText = new CLabel(this.statusComposite, 0x1020000);
            this.totalDischargeCurrentText.setBounds(235, 25, 50, 20);
            this.totalDischargeCurrentText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.totalDischargeCurrentText.setText(String.format("%4d", this.totalDischargeCurrent));
            this.totalDischargeCurrentUnit = new CLabel(this.statusComposite, 16384);
            this.totalDischargeCurrentUnit.setText(Messages.getString((String)"GDE_MSGT1112"));
            this.totalDischargeCurrentUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.totalDischargeCurrentUnit.setBounds(300, 25, 119, 20);
            this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.closeButton.setText(Messages.getString((String)"GDE_MSGT0188"));
            this.closeButton.setBounds(87, 485, 260, 30);
            this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "closeButton.widgetDisposed, event=" + String.valueOf(evt));
                    if (AkkuMasterC4Dialog.this.getChannelTab(1).isDataColletionActive() || AkkuMasterC4Dialog.this.getChannelTab(2).isDataColletionActive() || AkkuMasterC4Dialog.this.getChannelTab(3).isDataColletionActive() || AkkuMasterC4Dialog.this.getChannelTab(4).isDataColletionActive()) {
                        AkkuMasterC4Dialog.this.setClosePossible(false);
                    } else {
                        AkkuMasterC4Dialog.this.setClosePossible(true);
                    }
                    AkkuMasterC4Dialog.this.dispose();
                }
            });
            this.dialogShell.getShell().addListener(21, new Listener(){

                public void handleEvent(Event evt) {
                    log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                    if (!(AkkuMasterC4Dialog.this.getChannelTab(1).isDataColletionActive() || AkkuMasterC4Dialog.this.getChannelTab(2).isDataColletionActive() || AkkuMasterC4Dialog.this.getChannelTab(3).isDataColletionActive() || AkkuMasterC4Dialog.this.getChannelTab(4).isDataColletionActive())) {
                        Thread thread;
                        if (AkkuMasterC4Dialog.this.serialPort != null && AkkuMasterC4Dialog.this.serialPort.isConnected()) {
                            AkkuMasterC4Dialog.this.serialPort.close();
                        }
                        if ((thread = AkkuMasterC4Dialog.this.versionThread) != null && thread.isAlive()) {
                            thread.interrupt();
                        }
                        AkkuMasterC4Dialog.this.dispose();
                    } else {
                        evt.doit = false;
                    }
                }
            });
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                    if (AkkuMasterC4Dialog.this.isDataColletionActive()) {
                        AkkuMasterC4Dialog.this.channel1Tab.stopTimer();
                        AkkuMasterC4Dialog.this.channel2Tab.stopTimer();
                        AkkuMasterC4Dialog.this.channel3Tab.stopTimer();
                        AkkuMasterC4Dialog.this.channel4Tab.stopTimer();
                    }
                    AkkuMasterC4Dialog.this.serialPort.close();
                    AkkuMasterC4Dialog.this.dispose();
                }
            });
            this.dialogShell.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                    AkkuMasterC4Dialog.this.application.openHelpDialog(AkkuMasterC4Dialog.AKKU_MASTER_HELP_DIR, "HelpInfo.html");
                }
            });
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            AkkuMasterC4Dialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 220, 70));
            this.dialogShell.open();
            this.startUpdateVersionThread();
        } else {
            this.dialogShell.setVisible(true);
            this.dialogShell.setActive();
        }
        Display display = this.dialogShell.getDisplay();
        while (!this.dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void close() {
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            this.channel1Tab.stopTimer();
            this.channel2Tab.stopTimer();
            this.channel3Tab.stopTimer();
            this.channel4Tab.stopTimer();
            this.dialogShell.dispose();
        }
    }

    public boolean isDataColletionActive() {
        return this.channel1Tab.isCollectData() && this.channel1Tab.isCollectDataStopped() && this.channel2Tab.isCollectData() && this.channel2Tab.isCollectDataStopped() && this.channel3Tab.isCollectData() && this.channel3Tab.isCollectDataStopped() && this.channel4Tab.isCollectData() && this.channel4Tab.isCollectDataStopped();
    }

    public void addTotalDischargeCurrent(int newDeltaDischargeCurrent) {
        this.totalDischargeCurrent += newDeltaDischargeCurrent;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AkkuMasterC4Dialog.this.totalDischargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalDischargeCurrent));
                AkkuMasterC4Dialog.this.totalDischargeCurrentText.update();
                AkkuMasterC4Dialog.this.statusComposite.redraw();
                log.log(Level.FINE, "charge = " + AkkuMasterC4Dialog.this.totalChargeCurrent + ", discharge = " + AkkuMasterC4Dialog.this.totalDischargeCurrent);
            }
        });
    }

    public void subtractTotalDischargeCurrent(int newDeltaDischargeCurrent) {
        this.totalDischargeCurrent -= newDeltaDischargeCurrent;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AkkuMasterC4Dialog.this.totalDischargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalDischargeCurrent));
                AkkuMasterC4Dialog.this.totalDischargeCurrentText.update();
                AkkuMasterC4Dialog.this.statusComposite.redraw();
                log.log(Level.FINE, "charge = " + AkkuMasterC4Dialog.this.totalChargeCurrent + ", discharge = " + AkkuMasterC4Dialog.this.totalDischargeCurrent);
            }
        });
    }

    public void addTotalChargeCurrent(int newDeltaChargeCurrent) {
        this.totalChargeCurrent += newDeltaChargeCurrent;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AkkuMasterC4Dialog.this.totalChargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalChargeCurrent));
                AkkuMasterC4Dialog.this.totalChargeCurrentText.update();
                AkkuMasterC4Dialog.this.statusComposite.redraw();
                log.log(Level.FINE, "charge = " + AkkuMasterC4Dialog.this.totalChargeCurrent + ", discharge = " + AkkuMasterC4Dialog.this.totalDischargeCurrent);
            }
        });
    }

    public void subtractTotalChargeCurrent(int newDeltaChargeCurrent) {
        this.totalChargeCurrent -= newDeltaChargeCurrent;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AkkuMasterC4Dialog.this.totalChargeCurrentText.setText(String.format("%4d", AkkuMasterC4Dialog.this.totalChargeCurrent));
                AkkuMasterC4Dialog.this.totalChargeCurrentText.update();
                AkkuMasterC4Dialog.this.statusComposite.redraw();
                log.log(Level.FINE, "charge = " + AkkuMasterC4Dialog.this.totalChargeCurrent + ", discharge = " + AkkuMasterC4Dialog.this.totalDischargeCurrent);
            }
        });
    }

    public int getActiveCurrent() {
        return this.totalChargeCurrent + this.totalDischargeCurrent;
    }

    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    void startUpdateVersionThread() {
        try {
            if (!(this.serialPort == null || this.isWarnedConnectError || this.versionThread != null && this.versionThread.isAlive())) {
                this.versionThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (!AkkuMasterC4Dialog.this.serialPort.isConnected()) {
                                AkkuMasterC4Dialog.this.serialPort.open();
                            }
                            AkkuMasterC4Dialog.this.version = AkkuMasterC4Dialog.this.serialPort.getVersion();
                            AkkuMasterC4Dialog.this.getDialogShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AkkuMasterC4Dialog.this.versionComposite.redraw();
                                }
                            });
                        }
                        catch (Throwable e) {
                            AkkuMasterC4Dialog.this.application.openMessageDialog(AkkuMasterC4Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0024", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                            GDE.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AkkuMasterC4Dialog.this.dispose();
                                    AkkuMasterC4Dialog.this.application.getDeviceSelectionDialog().open();
                                }
                            });
                            return;
                        }
                    }
                };
                try {
                    this.versionThread.start();
                }
                catch (RuntimeException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            this.application.openMessageDialog(this.dialogShell, Messages.getString((String)"GDE_MSGE0025", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
            this.isWarnedConnectError = true;
        }
    }

    public AkkuMasterChannelTab getChannelTab(int number) {
        return switch (number) {
            case 4 -> this.channel4Tab;
            case 3 -> this.channel3Tab;
            case 2 -> this.channel2Tab;
            default -> this.channel1Tab;
        };
    }

    void updateVersionText(String useVersionNumberText, String useVersionDateText, String useVersionTypeText, String useVersionPanelText) {
        this.versionNumberText.setText(useVersionNumberText);
        this.versionDateText.setText(useVersionDateText);
        this.versionCurrentTypeText.setText(useVersionTypeText);
        this.versionFrontplateTypeText.setText(useVersionPanelText);
    }

    public AkkuMasterC4 getDevice() {
        return this.device;
    }
}

