/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.PropertyType;
import gde.device.smmodellbau.JLog2Dialog;
import gde.device.smmodellbau.JLog2SerialPort;
import gde.exception.DataInconsitsentException;
import gde.io.CSVSerialDataReaderWriter;
import gde.io.DataParser;
import gde.io.IDataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class JLog2
extends DeviceConfiguration
implements IDevice {
    protected static final Logger log = Logger.getLogger(JLog2.class.getName());
    static final String SM_JLOG2_CONFIG_TXT = "CONFIG.txt";
    protected final DataExplorer application;
    protected final Channels channels;
    protected final JLog2Dialog dialog;
    protected final JLog2SerialPort serialPort;

    public JLog2(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.jlog2.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.serialPort = this.application != null ? new JLog2SerialPort(this, this.application) : new JLog2SerialPort(this, null);
        this.dialog = new JLog2Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2804"), Messages.getString((String)"GDE_MSGT2804"));
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public JLog2(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.jlog2.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.serialPort = this.application != null ? new JLog2SerialPort(this, this.application) : new JLog2SerialPort(this, null);
        this.dialog = new JLog2Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2804"), Messages.getString((String)"GDE_MSGT2804"));
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)) * 4;
        int[] points = new int[recordSet.size()];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = 0;
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        double lastDateTime = 0.0;
        double sumTimeDelta = 0.0;
        double deltaTime = 0.0;
        int timeBufferSize = 10;
        byte[] timeBuffer = new byte[timeBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            lovDataSize = deviceDataBufferSize / 3;
            System.arraycopy(dataBuffer, offset, convertBuffer, 0, deviceDataBufferSize / 3);
            for (int j = deviceDataBufferSize / 3; j < deviceDataBufferSize; ++j) {
                convertBuffer[j] = dataBuffer[offset + j];
                ++lovDataSize;
                if (dataBuffer[offset + j] == 10 && dataBuffer[offset + j - 1] == 13) break;
            }
            System.arraycopy(convertBuffer, 0, timeBuffer, 0, timeBuffer.length);
            long dateTime = (long)(lastDateTime + 50.0);
            try {
                dateTime = Long.parseLong(String.format("%c%c%c%c%c%c000", Character.valueOf((char)timeBuffer[4]), Character.valueOf((char)timeBuffer[5]), Character.valueOf((char)timeBuffer[6]), Character.valueOf((char)timeBuffer[7]), Character.valueOf((char)timeBuffer[8]), Character.valueOf((char)timeBuffer[9])).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            deltaTime = lastDateTime == 0.0 ? 0.0 : (double)dateTime - lastDateTime;
            log.log(Level.FINE, String.format("%d; %4.1fd ms - %d : %s", i, deltaTime, dateTime, new String(timeBuffer).trim()));
            lastDateTime = dateTime;
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer), sumTimeDelta += deltaTime);
            offset += lovDataSize + 8;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    protected void setDataLineStartAndLength(byte[] dataBuffer, int[] refStartLength) {
        int crlfPos;
        int startPos;
        for (startPos = refStartLength[0] + refStartLength[1]; startPos < dataBuffer.length && (dataBuffer[startPos] != 36 || dataBuffer[startPos + 2] != 49 && dataBuffer[startPos + 3] != 49); ++startPos) {
        }
        for (crlfPos = refStartLength[0] = startPos; crlfPos < dataBuffer.length && (dataBuffer[crlfPos] != 13 || dataBuffer[crlfPos + 1] != 10); ++crlfPos) {
        }
        refStartLength[1] = crlfPos - startPos;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        DataParser data = new DataParser(this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), null, null, this.getDataBlockSize(InputTypes.FILE_IO), this.getDataBlockFormat(InputTypes.FILE_IO), true);
        int[] startLength = new int[]{0, 0};
        byte[] lineBuffer = null;
        try {
            this.setDataLineStartAndLength(dataBuffer, startLength);
            lineBuffer = new byte[startLength[1]];
            System.arraycopy(dataBuffer, startLength[0], lineBuffer, 0, startLength[1]);
            data.parse(new String(lineBuffer), 0);
            int[] values = data.getValues();
            for (int i = 0; i < values.length; ++i) {
                points[i] = values[i];
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = recordSet.isTimeStepConstant() ? 0 : 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
            log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        }
        for (i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            double offset = 0.0;
            double reduction = 0.0;
            double factor = 1.0;
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                offset = record.getOffset();
                reduction = record.getReduction();
                factor = record.getFactor();
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            } else if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        catch (Throwable e) {
            reduction = 0.0;
        }
        double newValue = (value - reduction) * factor + offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            } else if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        catch (Throwable e) {
            reduction = 0.0;
        }
        double newValue = (value - offset) / factor + reduction;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + measurementNames[i]);
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " hasReasonableData = " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "add to displayable counter: " + record.getName());
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        this.application.updateStatisticsData();
    }

    public JLog2Dialog getDialog() {
        return this.dialog;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public JLog2SerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public void open_closeCommPort() {
        switch (this.application.getMenuBar().getSerialPortIconSet()) {
            case 2: {
                this.importDeviceData();
                break;
            }
            case 1: {
                this.serialPort.isInterruptedByUser = true;
                if (this.dialog == null || this.dialog.isDisposed()) break;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JLog2.this.dialog.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2805"));
                    }
                });
            }
        }
    }

    public void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2800"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JLog2.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            Integer channelConfigNumber = JLog2.this.dialog != null && !JLog2.this.dialog.isDisposed() ? Integer.valueOf(JLog2.this.dialog.getTabFolderSelectionIndex() + 1) : null;
                            String recordNameExtend = selectedImportFile.substring(selectedImportFile.lastIndexOf(46) - 4, selectedImportFile.lastIndexOf(46));
                            CSVSerialDataReaderWriter.read((String)selectedImportFile, (IDevice)JLog2.this, (String)recordNameExtend, (Integer)channelConfigNumber, (IDataParser)new DataParser(JLog2.this.getDataBlockTimeUnitFactor(), JLog2.this.getDataBlockLeader(), JLog2.this.getDataBlockSeparator().value(), JLog2.this.getDataBlockCheckSumType(), JLog2.this.getDataBlockSize(InputTypes.FILE_IO)));
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    JLog2.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT2808", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT2808"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    JLog2.this.open_closeCommPort();
                }
            });
        }
    }

    public String getProcessName(byte[] buffer) {
        return this.getRecordSetStateNameReplacement(Integer.parseInt(new String(buffer).split(this.getDataBlockSeparator().value())[1]));
    }

    String getConfigurationFileDirecotry() {
        String searchPath = this.getDataBlockPreferredDataLocation().replace('\\', '/');
        if (!FileUtils.checkFileExist((String)(searchPath + "/CONFIG.txt"))) {
            searchPath = searchPath.substring(0, searchPath.lastIndexOf(47));
        }
        return searchPath;
    }
}

