/*
 * Decompiled with CFR 0.152.
 */
package gde.device.robbe;

import gde.comm.DeviceCommPort;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.robbe.PowerPeak;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PowerPeakSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = PowerPeakSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    static final byte[] RESET_CONFIG = new byte[]{12, 65, 55, 48, 48, 48, 48, 68, 56, 13};
    static final byte[] RESET = new byte[]{12, 67, 48, 48, 48, 48, 48, 68, 51, 13};
    static final byte[] READ_MEMORY_NAME = new byte[]{12, 56, 48, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_MEMORY_NAME = new byte[]{12, 48, 48};
    static final byte[] READ_MEMORY_SETUP = new byte[]{12, 56, 49, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_MEMORY_SETUP = new byte[]{12, 48, 49};
    static final byte[] READ_MEMORY_STEP_CHARGE_SETUP = new byte[]{12, 56, 50, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_STEP_CHARGE_SETUP = new byte[]{12, 48, 50};
    static final byte[] READ_MEMORY_CYCLE_DATA = new byte[]{12, 56, 51, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_CYCLE_DATA = new byte[]{12, 48, 51};
    static final byte[] READ_MEMORY_TRACE_DATA = new byte[]{12, 56, 52, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_TRACE_DATA = new byte[]{12, 48, 52};
    static final byte[] READ_TIRE_HEATER = new byte[]{12, 56, 53, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_TIRE_HEATER = new byte[]{12, 48, 53};
    static final byte[] READ_MOTOR_RUN = new byte[]{12, 56, 54, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_MOTOR_RUN = new byte[]{12, 48, 54};
    static final byte[] READ_CHANNEL_SETUP = new byte[]{12, 56, 55, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_CHANNEL_SETUP = new byte[]{12, 48, 55};
    static final byte[] READ_DEVICE_IDENTIFIER_NAME = new byte[]{12, 56, 56, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_DEVICE_IDENTIFIER_NAME = new byte[]{12, 48, 56};
    static final byte[] READ_GRAPHICS_DATA = new byte[]{12, 56, 57, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_GRAPHICS_DATA = new byte[]{12, 48, 57};
    static int SIZE_MEMORY_SETUP = 28;
    static final int SIZE_MEMORY_STEP_CHARGE_SETUP = 20;
    static int SIZE_MEMORY_TRACE = 6;
    static int SIZE_MEMORY_CYCLE = 121;
    static int SIZE_CHANNEL_1_SETUP = 16;
    static final int SIZE_CHANNEL_2_SETUP = 4;
    static final int SIZE_TIRE_HEATER_SETUP = 8;
    static final int SIZE_MOTOR_RUN_SETUP = 17;
    static final int xferErrorLimit = 15;
    boolean isInSync = false;
    boolean isDataMissmatchWarningWritten = false;
    int dataCheckSumOffset = 0;
    boolean isCmdMissmatchWarningWritten = false;
    int cmdCheckSumOffset = 0;

    public PowerPeakSerialPort(PowerPeak currentDevice, DataExplorer currentApplication) {
        super((IDevice)currentDevice, currentApplication);
    }

    public PowerPeakSerialPort(DeviceConfiguration deviceConfiguration) {
        super(deviceConfiguration);
    }

    public synchronized byte[] getData(boolean checkBeginEndSignature) throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
        byte[] answer = new byte[]{0};
        try {
            answer = new byte[data.length];
            answer = this.read(data, 3000);
            log.logp(Level.INFO, $CLASS_NAME, "getData", StringHelper.convert2CharString((byte[])answer));
            while (answer[0] != 12) {
                this.isInSync = false;
                for (int i = 1; i < answer.length; ++i) {
                    if (answer[i] != 12) continue;
                    System.arraycopy(answer, i, data, 0, data.length - i);
                    answer = new byte[i];
                    answer = this.read(answer, 1000);
                    log.logp(Level.INFO, $CLASS_NAME, "getData", StringHelper.convert2CharString((byte[])answer));
                    System.arraycopy(answer, 0, data, data.length - i, i);
                    this.isInSync = true;
                    log.logp(Level.INFO, $CLASS_NAME, "getData", "----> receive sync finished");
                    break;
                }
                if (this.isInSync) break;
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> unable to synchronize received data, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of transfer error exceed the acceptable limit of 15");
                }
                answer = new byte[data.length];
                answer = this.read(answer, 3000);
            }
            if (checkBeginEndSignature && (data[0] != 12 || data[data.length - 1] != 13)) {
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> data start or end does not match, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                data = this.getData(true);
            }
            if (checkBeginEndSignature && !this.isChecksumOK(data)) {
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> checksum error occured, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                data = this.getData(true);
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return data;
    }

    private synchronized boolean isChecksumOK(byte[] buffer) {
        int buffer_check_sum;
        String $METHOD_NAME = "isChecksumOK";
        boolean isOK = false;
        int length = buffer.length;
        int check_sum = Checksum.ADD((byte[])buffer, (int)1, (int)(length - 6));
        if (check_sum == (buffer_check_sum = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)buffer[length - 5]), Character.valueOf((char)buffer[length - 4]), Character.valueOf((char)buffer[length - 3]), Character.valueOf((char)buffer[length - 2])), 16)) || check_sum == buffer_check_sum - this.dataCheckSumOffset) {
            isOK = true;
        } else if (!this.isDataMissmatchWarningWritten) {
            log.logp(Level.WARNING, $CLASS_NAME, "isChecksumOK", "check sum missmatch detected, calculates check_sum = " + check_sum + "; delta to data contained delta = " + (buffer_check_sum - check_sum));
            log.logp(Level.WARNING, $CLASS_NAME, "isChecksumOK", StringHelper.convert2CharString((byte[])buffer));
            this.isDataMissmatchWarningWritten = true;
            this.dataCheckSumOffset = buffer_check_sum - check_sum;
            isOK = true;
        }
        return isOK;
    }
}

