/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;

public abstract class ExtendedColor
extends BaseColor {
    private static final long serialVersionUID = 2722660170712380080L;
    public static final int TYPE_RGB = 0;
    public static final int TYPE_GRAY = 1;
    public static final int TYPE_CMYK = 2;
    public static final int TYPE_SEPARATION = 3;
    public static final int TYPE_PATTERN = 4;
    public static final int TYPE_SHADING = 5;
    public static final int TYPE_DEVICEN = 6;
    public static final int TYPE_LAB = 7;
    protected int type;

    public ExtendedColor(int type2) {
        super(0, 0, 0);
        this.type = type2;
    }

    public ExtendedColor(int type2, float red, float green, float blue) {
        super(ExtendedColor.normalize(red), ExtendedColor.normalize(green), ExtendedColor.normalize(blue));
        this.type = type2;
    }

    public ExtendedColor(int type2, int red, int green, int blue, int alpha) {
        super(ExtendedColor.normalize((float)red / 255.0f), ExtendedColor.normalize((float)green / 255.0f), ExtendedColor.normalize((float)blue / 255.0f), ExtendedColor.normalize((float)alpha / 255.0f));
        this.type = type2;
    }

    public int getType() {
        return this.type;
    }

    public static int getType(BaseColor color) {
        if (color instanceof ExtendedColor) {
            return ((ExtendedColor)color).getType();
        }
        return 0;
    }

    static final float normalize(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }
}

