/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class PopupList {
    Shell shell;
    List list;
    int minimumWidth;

    public PopupList(Shell parent) {
        this(parent, 0);
    }

    public PopupList(Shell parent, int style) {
        int listStyle = 516;
        if ((style & 0x100) != 0) {
            listStyle |= 0x100;
        }
        this.shell = new Shell(parent, PopupList.checkStyle(style));
        this.list = new List(this.shell, listStyle);
        this.shell.addListener(27, e2 -> this.shell.setVisible(false));
        this.shell.addControlListener(ControlListener.controlResizedAdapter(e2 -> {
            Rectangle shellSize = this.shell.getClientArea();
            this.list.setSize(shellSize.width, shellSize.height);
        }));
        this.list.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e2) {
            }

            @Override
            public void mouseDown(MouseEvent e2) {
            }

            @Override
            public void mouseUp(MouseEvent e2) {
                PopupList.this.shell.setVisible(false);
            }
        });
        this.list.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e2) {
            }

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.character == '\r') {
                    PopupList.this.shell.setVisible(false);
                }
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 0x6000000;
        return style & mask;
    }

    public Font getFont() {
        return this.list.getFont();
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public String open(Rectangle rect) {
        Point listSize = this.list.computeSize(rect.width, -1, false);
        Rectangle screenSize = this.shell.getDisplay().getBounds();
        int spaceBelow = screenSize.height - (rect.y + rect.height) - 30;
        int spaceAbove = rect.y - 30;
        int y2 = 0;
        if (spaceAbove > spaceBelow && listSize.y > spaceBelow) {
            listSize.y = listSize.y > spaceAbove ? spaceAbove : (listSize.y += 2);
            y2 = rect.y - listSize.y;
        } else {
            listSize.y = listSize.y > spaceBelow ? spaceBelow : (listSize.y += 2);
            y2 = rect.y + rect.height;
        }
        listSize.x = rect.width;
        if (listSize.x < this.minimumWidth) {
            listSize.x = this.minimumWidth;
        }
        int x2 = rect.x + rect.width - listSize.x;
        this.shell.setBounds(x2, y2, listSize.x, listSize.y);
        this.shell.open();
        this.list.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        String result2 = null;
        if (!this.shell.isDisposed()) {
            String[] strings = this.list.getSelection();
            this.shell.dispose();
            if (strings.length != 0) {
                result2 = strings[0];
            }
        }
        return result2;
    }

    public void select(String string2) {
        String[] items = this.list.getItems();
        if (string2 != null) {
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2].startsWith(string2)) {
                    int index = this.list.indexOf(items[i2]);
                    this.list.select(index);
                    break;
                }
                ++i2;
            }
        }
    }

    public void setFont(Font font) {
        this.list.setFont(font);
    }

    public void setItems(String[] strings) {
        this.list.setItems(strings);
    }

    public void setMinimumWidth(int width) {
        if (width < 0) {
            SWT.error(5);
        }
        this.minimumWidth = width;
    }
}

