/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.constants.MarginBoxName;
import org.xhtmlrenderer.css.constants.PageElementPosition;
import org.xhtmlrenderer.css.extend.ContentFunction;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.newmatch.PageInfo;
import org.xhtmlrenderer.css.parser.FSFunction;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.EmptyStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.layout.CounterFunction;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.layout.Styleable;
import org.xhtmlrenderer.layout.WhitespaceStripper;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.newtable.TableColumn;
import org.xhtmlrenderer.newtable.TableRowBox;
import org.xhtmlrenderer.newtable.TableSectionBox;
import org.xhtmlrenderer.render.AnonymousBlockBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FloatedBoxData;
import org.xhtmlrenderer.render.InlineBox;

public class BoxBuilder {
    public static final int MARGIN_BOX_VERTICAL = 1;
    public static final int MARGIN_BOX_HORIZONTAL = 2;
    private static final int CONTENT_LIST_DOCUMENT = 1;
    private static final int CONTENT_LIST_MARGIN_BOX = 2;

    public static BlockBox createRootBox(LayoutContext c2, Document document) {
        Element root2 = document.getDocumentElement();
        CalculatedStyle style = c2.getSharedContext().getStyle(root2);
        BlockBox result2 = style.isTable() || style.isInlineTable() ? new TableBox() : new BlockBox();
        result2.setStyle(style);
        result2.setElement(root2);
        c2.resolveCounters(style);
        c2.pushLayer(result2);
        if (c2.isPrint()) {
            if (!style.isIdent(CSSName.PAGE, IdentValue.AUTO)) {
                c2.setPageName(style.getStringProperty(CSSName.PAGE));
            }
            c2.getRootLayer().addPage(c2);
        }
        return result2;
    }

    public static void createChildren(LayoutContext c2, BlockBox parent) {
        ArrayList children = new ArrayList();
        ChildBoxInfo info = new ChildBoxInfo();
        BoxBuilder.createChildren(c2, parent, parent.getElement(), children, info, false);
        boolean parentIsNestingTableContent = BoxBuilder.isNestingTableContent(parent.getStyle().getIdent(CSSName.DISPLAY));
        if (!parentIsNestingTableContent && !info.isContainsTableContent()) {
            BoxBuilder.resolveChildren(c2, parent, children, info);
        } else {
            BoxBuilder.stripAllWhitespace(children);
            if (parentIsNestingTableContent) {
                BoxBuilder.resolveTableContent(c2, parent, children, info);
            } else {
                BoxBuilder.resolveChildTableContent(c2, parent, children, info, IdentValue.TABLE_CELL);
            }
        }
    }

    public static TableBox createMarginTable(LayoutContext c2, PageInfo pageInfo, MarginBoxName[] names, int height, int direction) {
        if (!pageInfo.hasAny(names)) {
            return null;
        }
        Element source = c2.getRootLayer().getMaster().getElement();
        ChildBoxInfo info = new ChildBoxInfo();
        CalculatedStyle pageStyle = new EmptyStyle().deriveStyle(pageInfo.getPageStyle());
        CalculatedStyle tableStyle = pageStyle.deriveStyle(CascadedStyle.createLayoutStyle(new PropertyDeclaration[]{new PropertyDeclaration(CSSName.DISPLAY, new PropertyValue(IdentValue.TABLE), true, 1), new PropertyDeclaration(CSSName.WIDTH, new PropertyValue(2, 100.0f, "100%"), true, 1)}));
        TableBox result2 = (TableBox)BoxBuilder.createBlockBox(tableStyle, info, false);
        result2.setMarginAreaRoot(true);
        result2.setStyle(tableStyle);
        result2.setElement(source);
        result2.setAnonymous(true);
        result2.setChildrenContentType(2);
        CalculatedStyle tableSectionStyle = pageStyle.createAnonymousStyle(IdentValue.TABLE_ROW_GROUP);
        TableSectionBox section = (TableSectionBox)BoxBuilder.createBlockBox(tableSectionStyle, info, false);
        section.setStyle(tableSectionStyle);
        section.setElement(source);
        section.setAnonymous(true);
        section.setChildrenContentType(2);
        result2.addChild(section);
        TableRowBox row2 = null;
        if (direction == 2) {
            CalculatedStyle tableRowStyle = pageStyle.createAnonymousStyle(IdentValue.TABLE_ROW);
            row2 = (TableRowBox)BoxBuilder.createBlockBox(tableRowStyle, info, false);
            row2.setStyle(tableRowStyle);
            row2.setElement(source);
            row2.setAnonymous(true);
            row2.setChildrenContentType(2);
            row2.setHeightOverride(height);
            section.addChild(row2);
        }
        int cellCount = 0;
        boolean alwaysCreate = names.length > 1 && direction == 2;
        for (int i2 = 0; i2 < names.length; ++i2) {
            TableCellBox cell;
            CascadedStyle cellStyle = pageInfo.createMarginBoxStyle(names[i2], alwaysCreate);
            if (cellStyle == null || (cell = BoxBuilder.createMarginBox(c2, cellStyle, alwaysCreate)) == null) continue;
            if (direction == 1) {
                CalculatedStyle tableRowStyle = pageStyle.createAnonymousStyle(IdentValue.TABLE_ROW);
                row2 = (TableRowBox)BoxBuilder.createBlockBox(tableRowStyle, info, false);
                row2.setStyle(tableRowStyle);
                row2.setElement(source);
                row2.setAnonymous(true);
                row2.setChildrenContentType(2);
                row2.setHeightOverride(height);
                section.addChild(row2);
            }
            row2.addChild(cell);
            ++cellCount;
        }
        if (direction == 1 && cellCount > 0) {
            TableRowBox r2;
            int rHeight = 0;
            Iterator i3 = section.getChildIterator();
            while (i3.hasNext()) {
                r2 = (TableRowBox)i3.next();
                r2.setHeightOverride(height / cellCount);
                rHeight += r2.getHeightOverride();
            }
            i3 = section.getChildIterator();
            while (i3.hasNext() && rHeight < height) {
                r2 = (TableRowBox)i3.next();
                r2.setHeightOverride(r2.getHeightOverride() + 1);
                ++rHeight;
            }
        }
        return cellCount > 0 ? result2 : null;
    }

    private static TableCellBox createMarginBox(LayoutContext c2, CascadedStyle cascadedStyle, boolean alwaysCreate) {
        boolean hasContent = true;
        PropertyDeclaration contentDecl = cascadedStyle.propertyByName(CSSName.CONTENT);
        CalculatedStyle style = new EmptyStyle().deriveStyle(cascadedStyle);
        if (style.isDisplayNone() && !alwaysCreate) {
            return null;
        }
        if (style.isIdent(CSSName.CONTENT, IdentValue.NONE) || style.isIdent(CSSName.CONTENT, IdentValue.NORMAL)) {
            hasContent = false;
        }
        if (style.isAutoWidth() && !alwaysCreate && !hasContent) {
            return null;
        }
        ArrayList children = new ArrayList();
        ChildBoxInfo info = new ChildBoxInfo();
        info.setContainsTableContent(true);
        info.setLayoutRunningBlocks(true);
        TableCellBox result2 = new TableCellBox();
        result2.setAnonymous(true);
        result2.setStyle(style);
        result2.setElement(c2.getRootLayer().getMaster().getElement());
        if (hasContent && !style.isDisplayNone()) {
            children.addAll(BoxBuilder.createGeneratedMarginBoxContent(c2, c2.getRootLayer().getMaster().getElement(), (PropertyValue)contentDecl.getValue(), style, info));
            BoxBuilder.stripAllWhitespace(children);
        }
        if (children.size() == 0 && style.isAutoWidth() && !alwaysCreate) {
            return null;
        }
        BoxBuilder.resolveChildTableContent(c2, result2, children, info, IdentValue.TABLE_CELL);
        return result2;
    }

    private static void resolveChildren(LayoutContext c2, BlockBox owner, List children, ChildBoxInfo info) {
        if (children.size() > 0) {
            if (info.isContainsBlockLevelContent()) {
                BoxBuilder.insertAnonymousBlocks(c2.getSharedContext(), owner, children, info.isLayoutRunningBlocks());
                owner.setChildrenContentType(2);
            } else {
                WhitespaceStripper.stripInlineContent(children);
                if (children.size() > 0) {
                    owner.setInlineContent(children);
                    owner.setChildrenContentType(1);
                } else {
                    owner.setChildrenContentType(4);
                }
            }
        } else {
            owner.setChildrenContentType(4);
        }
    }

    private static boolean isAllProperTableNesting(IdentValue parentDisplay, List children) {
        for (Styleable child : children) {
            if (BoxBuilder.isProperTableNesting(parentDisplay, child.getStyle().getIdent(CSSName.DISPLAY))) continue;
            return false;
        }
        return true;
    }

    private static void resolveChildTableContent(LayoutContext c2, BlockBox parent, List children, ChildBoxInfo info, IdentValue target) {
        ArrayList<Styleable> childrenForAnonymous = new ArrayList<Styleable>();
        ArrayList<Styleable> childrenWithAnonymous = new ArrayList<Styleable>();
        IdentValue nextUp = BoxBuilder.getPreviousTableNestingLevel(target);
        for (Styleable styleable : children) {
            if (BoxBuilder.matchesTableLevel(target, styleable.getStyle().getIdent(CSSName.DISPLAY))) {
                childrenForAnonymous.add(styleable);
                continue;
            }
            if (childrenForAnonymous.size() > 0) {
                BoxBuilder.createAnonymousTableContent(c2, (BlockBox)childrenForAnonymous.get(0), nextUp, childrenForAnonymous, childrenWithAnonymous);
                childrenForAnonymous = new ArrayList();
            }
            childrenWithAnonymous.add(styleable);
        }
        if (childrenForAnonymous.size() > 0) {
            BoxBuilder.createAnonymousTableContent(c2, (BlockBox)childrenForAnonymous.get(0), nextUp, childrenForAnonymous, childrenWithAnonymous);
        }
        if (nextUp == IdentValue.TABLE) {
            BoxBuilder.rebalanceInlineContent(childrenWithAnonymous);
            info.setContainsBlockLevelContent(true);
            BoxBuilder.resolveChildren(c2, parent, childrenWithAnonymous, info);
        } else {
            BoxBuilder.resolveChildTableContent(c2, parent, childrenWithAnonymous, info, nextUp);
        }
    }

    private static boolean matchesTableLevel(IdentValue target, IdentValue value) {
        if (target == IdentValue.TABLE_ROW_GROUP) {
            return value == IdentValue.TABLE_ROW_GROUP || value == IdentValue.TABLE_HEADER_GROUP || value == IdentValue.TABLE_FOOTER_GROUP || value == IdentValue.TABLE_CAPTION;
        }
        return target == value;
    }

    private static void rebalanceInlineContent(List content) {
        HashMap<Element, InlineBox> boxesByElement = new HashMap<Element, InlineBox>();
        for (Styleable styleable : content) {
            if (!(styleable instanceof InlineBox)) continue;
            InlineBox iB = (InlineBox)styleable;
            Element elem = iB.getElement();
            if (!boxesByElement.containsKey(elem)) {
                iB.setStartsHere(true);
            }
            boxesByElement.put(elem, iB);
        }
        for (InlineBox iB : boxesByElement.values()) {
            iB.setEndsHere(true);
        }
    }

    private static void stripAllWhitespace(List content) {
        int start = 0;
        int current = 0;
        boolean started = false;
        for (current = 0; current < content.size(); ++current) {
            Styleable styleable = (Styleable)content.get(current);
            if (!styleable.getStyle().isLayedOutInInlineContext()) {
                if (started) {
                    int before = content.size();
                    WhitespaceStripper.stripInlineContent(content.subList(start, current));
                    int after = content.size();
                    current -= before - after;
                }
                started = false;
                continue;
            }
            if (started) continue;
            started = true;
            start = current;
        }
        if (started) {
            WhitespaceStripper.stripInlineContent(content.subList(start, current));
        }
    }

    private static void resolveTableContent(LayoutContext c2, BlockBox parent, List children, ChildBoxInfo info) {
        IdentValue parentDisplay = parent.getStyle().getIdent(CSSName.DISPLAY);
        IdentValue next = BoxBuilder.getNextTableNestingLevel(parentDisplay);
        if (next == null && parent.isAnonymous() && BoxBuilder.containsOrphanedTableContent(children)) {
            BoxBuilder.resolveChildTableContent(c2, parent, children, info, IdentValue.TABLE_CELL);
        } else if (next == null || BoxBuilder.isAllProperTableNesting(parentDisplay, children)) {
            if (parent.isAnonymous()) {
                BoxBuilder.rebalanceInlineContent(children);
            }
            BoxBuilder.resolveChildren(c2, parent, children, info);
        } else {
            ArrayList<Styleable> childrenForAnonymous = new ArrayList<Styleable>();
            ArrayList<Styleable> childrenWithAnonymous = new ArrayList<Styleable>();
            for (Styleable child : children) {
                IdentValue childDisplay = child.getStyle().getIdent(CSSName.DISPLAY);
                if (BoxBuilder.isProperTableNesting(parentDisplay, childDisplay)) {
                    if (childrenForAnonymous.size() > 0) {
                        BoxBuilder.createAnonymousTableContent(c2, parent, next, childrenForAnonymous, childrenWithAnonymous);
                        childrenForAnonymous = new ArrayList();
                    }
                    childrenWithAnonymous.add(child);
                    continue;
                }
                childrenForAnonymous.add(child);
            }
            if (childrenForAnonymous.size() > 0) {
                BoxBuilder.createAnonymousTableContent(c2, parent, next, childrenForAnonymous, childrenWithAnonymous);
            }
            info.setContainsBlockLevelContent(true);
            BoxBuilder.resolveChildren(c2, parent, childrenWithAnonymous, info);
        }
    }

    private static boolean containsOrphanedTableContent(List children) {
        for (Styleable child : children) {
            IdentValue display = child.getStyle().getIdent(CSSName.DISPLAY);
            if (display != IdentValue.TABLE_HEADER_GROUP && display != IdentValue.TABLE_ROW_GROUP && display != IdentValue.TABLE_FOOTER_GROUP && display != IdentValue.TABLE_ROW) continue;
            return true;
        }
        return false;
    }

    private static boolean isParentInline(BlockBox box) {
        CalculatedStyle parentStyle = box.getStyle().getParent();
        return parentStyle != null && parentStyle.isInline();
    }

    private static void createAnonymousTableContent(LayoutContext c2, BlockBox source, IdentValue next, List childrenForAnonymous, List childrenWithAnonymous) {
        ChildBoxInfo nested = BoxBuilder.lookForBlockContent(childrenForAnonymous);
        IdentValue anonDisplay = BoxBuilder.isParentInline(source) && next == IdentValue.TABLE ? IdentValue.INLINE_TABLE : next;
        CalculatedStyle anonStyle = source.getStyle().createAnonymousStyle(anonDisplay);
        BlockBox anonBox = BoxBuilder.createBlockBox(anonStyle, nested, false);
        anonBox.setStyle(anonStyle);
        anonBox.setAnonymous(true);
        anonBox.setElement(source.getElement());
        BoxBuilder.resolveTableContent(c2, anonBox, childrenForAnonymous, nested);
        if (next == IdentValue.TABLE) {
            childrenWithAnonymous.add(BoxBuilder.reorderTableContent(c2, (TableBox)anonBox));
        } else {
            childrenWithAnonymous.add(anonBox);
        }
    }

    private static BlockBox reorderTableContent(LayoutContext c2, TableBox table) {
        CalculatedStyle anonStyle;
        LinkedList<Box> topCaptions = new LinkedList<Box>();
        Box header = null;
        LinkedList<Box> bodies = new LinkedList<Box>();
        Box footer = null;
        LinkedList<Box> bottomCaptions = new LinkedList<Box>();
        Iterator i2 = table.getChildIterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            IdentValue display = b2.getStyle().getIdent(CSSName.DISPLAY);
            if (display == IdentValue.TABLE_CAPTION) {
                IdentValue side = b2.getStyle().getIdent(CSSName.CAPTION_SIDE);
                if (side == IdentValue.BOTTOM) {
                    bottomCaptions.add(b2);
                    continue;
                }
                topCaptions.add(b2);
                continue;
            }
            if (display == IdentValue.TABLE_HEADER_GROUP && header == null) {
                header = b2;
                continue;
            }
            if (display == IdentValue.TABLE_FOOTER_GROUP && footer == null) {
                footer = b2;
                continue;
            }
            bodies.add(b2);
        }
        table.removeAllChildren();
        if (header != null) {
            ((TableSectionBox)header).setHeader(true);
            table.addChild(header);
        }
        table.addAllChildren(bodies);
        if (footer != null) {
            ((TableSectionBox)footer).setFooter(true);
            table.addChild(footer);
        }
        if (topCaptions.size() == 0 && bottomCaptions.size() == 0) {
            return table;
        }
        if (table.getStyle().isFloated()) {
            CascadedStyle cascadedStyle = CascadedStyle.createLayoutStyle(new PropertyDeclaration[]{CascadedStyle.createLayoutPropertyDeclaration(CSSName.DISPLAY, IdentValue.BLOCK), CascadedStyle.createLayoutPropertyDeclaration(CSSName.FLOAT, table.getStyle().getIdent(CSSName.FLOAT))});
            anonStyle = table.getStyle().deriveStyle(cascadedStyle);
        } else {
            anonStyle = table.getStyle().createAnonymousStyle(IdentValue.BLOCK);
        }
        BlockBox anonBox = new BlockBox();
        anonBox.setStyle(anonStyle);
        anonBox.setAnonymous(true);
        anonBox.setFromCaptionedTable(true);
        anonBox.setElement(table.getElement());
        anonBox.setChildrenContentType(2);
        anonBox.addAllChildren(topCaptions);
        anonBox.addChild(table);
        anonBox.addAllChildren(bottomCaptions);
        if (table.getStyle().isFloated()) {
            anonBox.setFloatedBoxData(new FloatedBoxData());
            table.setFloatedBoxData(null);
            CascadedStyle original = c2.getSharedContext().getCss().getCascadedStyle(table.getElement(), false);
            CascadedStyle modified = CascadedStyle.createLayoutStyle(original, new PropertyDeclaration[]{CascadedStyle.createLayoutPropertyDeclaration(CSSName.FLOAT, IdentValue.NONE)});
            table.setStyle(table.getStyle().getParent().deriveStyle(modified));
        }
        return anonBox;
    }

    private static ChildBoxInfo lookForBlockContent(List styleables) {
        ChildBoxInfo result2 = new ChildBoxInfo();
        for (Styleable s2 : styleables) {
            if (s2.getStyle().isLayedOutInInlineContext()) continue;
            result2.setContainsBlockLevelContent(true);
            break;
        }
        return result2;
    }

    private static IdentValue getNextTableNestingLevel(IdentValue display) {
        if (display == IdentValue.TABLE || display == IdentValue.INLINE_TABLE) {
            return IdentValue.TABLE_ROW_GROUP;
        }
        if (display == IdentValue.TABLE_HEADER_GROUP || display == IdentValue.TABLE_ROW_GROUP || display == IdentValue.TABLE_FOOTER_GROUP) {
            return IdentValue.TABLE_ROW;
        }
        if (display == IdentValue.TABLE_ROW) {
            return IdentValue.TABLE_CELL;
        }
        return null;
    }

    private static IdentValue getPreviousTableNestingLevel(IdentValue display) {
        if (display == IdentValue.TABLE_CELL) {
            return IdentValue.TABLE_ROW;
        }
        if (display == IdentValue.TABLE_ROW) {
            return IdentValue.TABLE_ROW_GROUP;
        }
        if (display == IdentValue.TABLE_HEADER_GROUP || display == IdentValue.TABLE_ROW_GROUP || display == IdentValue.TABLE_FOOTER_GROUP) {
            return IdentValue.TABLE;
        }
        return null;
    }

    private static boolean isProperTableNesting(IdentValue parent, IdentValue child) {
        return parent == IdentValue.TABLE && (child == IdentValue.TABLE_HEADER_GROUP || child == IdentValue.TABLE_ROW_GROUP || child == IdentValue.TABLE_FOOTER_GROUP || child == IdentValue.TABLE_CAPTION) || (parent == IdentValue.TABLE_HEADER_GROUP || parent == IdentValue.TABLE_ROW_GROUP || parent == IdentValue.TABLE_FOOTER_GROUP) && child == IdentValue.TABLE_ROW || parent == IdentValue.TABLE_ROW && child == IdentValue.TABLE_CELL || parent == IdentValue.INLINE_TABLE && (child == IdentValue.TABLE_HEADER_GROUP || child == IdentValue.TABLE_ROW_GROUP || child == IdentValue.TABLE_FOOTER_GROUP);
    }

    private static boolean isNestingTableContent(IdentValue display) {
        return display == IdentValue.TABLE || display == IdentValue.INLINE_TABLE || display == IdentValue.TABLE_HEADER_GROUP || display == IdentValue.TABLE_ROW_GROUP || display == IdentValue.TABLE_FOOTER_GROUP || display == IdentValue.TABLE_ROW;
    }

    private static boolean isAttrFunction(FSFunction function) {
        List params;
        if (function.getName().equals("attr") && (params = function.getParameters()).size() == 1) {
            PropertyValue value = (PropertyValue)params.get(0);
            return value.getPrimitiveType() == 21;
        }
        return false;
    }

    public static boolean isElementFunction(FSFunction function) {
        if (function.getName().equals("element")) {
            List params = function.getParameters();
            if (params.size() < 1 || params.size() > 2) {
                return false;
            }
            boolean ok = true;
            PropertyValue value1 = (PropertyValue)params.get(0);
            boolean bl = ok = value1.getPrimitiveType() == 21;
            if (ok && params.size() == 2) {
                PropertyValue value2 = (PropertyValue)params.get(1);
                ok = value2.getPrimitiveType() == 21;
            }
            return ok;
        }
        return false;
    }

    private static CounterFunction makeCounterFunction(FSFunction function, LayoutContext c2, CalculatedStyle style) {
        if (function.getName().equals("counter")) {
            List params = function.getParameters();
            if (params.size() < 1 || params.size() > 2) {
                return null;
            }
            PropertyValue value = (PropertyValue)params.get(0);
            if (value.getPrimitiveType() != 21) {
                return null;
            }
            String s2 = value.getStringValue();
            if (s2.equals("page") || s2.equals("pages")) {
                return null;
            }
            String counter = value.getStringValue();
            IdentValue listStyleType = IdentValue.DECIMAL;
            if (params.size() == 2) {
                value = (PropertyValue)params.get(1);
                if (value.getPrimitiveType() != 21) {
                    return null;
                }
                IdentValue identValue = IdentValue.valueOf(value.getStringValue());
                if (identValue != null) {
                    value.setIdentValue(identValue);
                    listStyleType = identValue;
                }
            }
            int counterValue = c2.getCounterContext(style).getCurrentCounterValue(counter);
            return new CounterFunction(counterValue, listStyleType);
        }
        if (function.getName().equals("counters")) {
            List params = function.getParameters();
            if (params.size() < 2 || params.size() > 3) {
                return null;
            }
            PropertyValue value = (PropertyValue)params.get(0);
            if (value.getPrimitiveType() != 21) {
                return null;
            }
            String counter = value.getStringValue();
            value = (PropertyValue)params.get(1);
            if (value.getPrimitiveType() != 19) {
                return null;
            }
            String separator2 = value.getStringValue();
            IdentValue listStyleType = IdentValue.DECIMAL;
            if (params.size() == 3) {
                value = (PropertyValue)params.get(2);
                if (value.getPrimitiveType() != 21) {
                    return null;
                }
                IdentValue identValue = IdentValue.valueOf(value.getStringValue());
                if (identValue != null) {
                    value.setIdentValue(identValue);
                    listStyleType = identValue;
                }
            }
            List counterValues = c2.getCounterContext(style).getCurrentCounterValues(counter);
            return new CounterFunction(counterValues, separator2, listStyleType);
        }
        return null;
    }

    private static String getAttributeValue(FSFunction attrFunc, Element e2) {
        PropertyValue value = (PropertyValue)attrFunc.getParameters().get(0);
        return e2.getAttribute(value.getStringValue());
    }

    private static List createGeneratedContentList(LayoutContext c2, Element element, PropertyValue propValue, String peName, CalculatedStyle style, int mode, ChildBoxInfo info) {
        List values2 = propValue.getValues();
        if (values2 == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Styleable> result2 = new ArrayList<Styleable>(values2.size());
        for (PropertyValue value : values2) {
            FSDerivedValue dv;
            ContentFunction contentFunction = null;
            FSFunction function = null;
            String content = null;
            short type2 = value.getPrimitiveType();
            if (type2 == 19) {
                content = value.getStringValue();
            } else if (value.getPropertyValueType() == 7) {
                if (mode == 1 && BoxBuilder.isAttrFunction(value.getFunction())) {
                    content = BoxBuilder.getAttributeValue(value.getFunction(), element);
                } else {
                    CounterFunction cFunc = null;
                    if (mode == 1) {
                        cFunc = BoxBuilder.makeCounterFunction(value.getFunction(), c2, style);
                    }
                    if (cFunc != null) {
                        content = cFunc.evaluate();
                        contentFunction = null;
                        function = null;
                    } else if (mode == 2 && BoxBuilder.isElementFunction(value.getFunction())) {
                        BlockBox target = BoxBuilder.getRunningBlock(c2, value);
                        if (target != null) {
                            result2.add(target.copyOf());
                            info.setContainsBlockLevelContent(true);
                        }
                    } else {
                        contentFunction = c2.getContentFunctionFactory().lookupFunction(c2, value.getFunction());
                        if (contentFunction != null) {
                            function = value.getFunction();
                            if (contentFunction.isStatic()) {
                                content = contentFunction.calculate(c2, function);
                                contentFunction = null;
                                function = null;
                            } else {
                                content = contentFunction.getLayoutReplacementText();
                            }
                        }
                    }
                }
            } else if (type2 == 21 && (dv = style.valueByName(CSSName.QUOTES)) != IdentValue.NONE) {
                String[] quotes;
                IdentValue ident = value.getIdentValue();
                if (ident == IdentValue.OPEN_QUOTE) {
                    quotes = style.asStringArray(CSSName.QUOTES);
                    content = quotes[0];
                } else if (ident == IdentValue.CLOSE_QUOTE) {
                    quotes = style.asStringArray(CSSName.QUOTES);
                    content = quotes[1];
                }
            }
            if (content == null) continue;
            InlineBox iB = new InlineBox(content, null);
            iB.setContentFunction(contentFunction);
            iB.setFunction(function);
            iB.setElement(element);
            iB.setPseudoElementOrClass(peName);
            iB.setStartsHere(true);
            iB.setEndsHere(true);
            result2.add(iB);
        }
        return result2;
    }

    public static BlockBox getRunningBlock(LayoutContext c2, PropertyValue value) {
        List params = value.getFunction().getParameters();
        String ident = ((PropertyValue)params.get(0)).getStringValue();
        PageElementPosition position = null;
        if (params.size() == 2) {
            position = PageElementPosition.valueOf(((PropertyValue)params.get(1)).getStringValue());
        }
        if (position == null) {
            position = PageElementPosition.FIRST;
        }
        BlockBox target = c2.getRootDocumentLayer().getRunningBlock(ident, c2.getPage(), position);
        return target;
    }

    private static void insertGeneratedContent(LayoutContext c2, Element element, CalculatedStyle parentStyle, String peName, List children, ChildBoxInfo info) {
        CascadedStyle peStyle = c2.getCss().getPseudoElementStyle(element, peName);
        if (peStyle != null) {
            PropertyDeclaration contentDecl = peStyle.propertyByName(CSSName.CONTENT);
            PropertyDeclaration counterResetDecl = peStyle.propertyByName(CSSName.COUNTER_RESET);
            PropertyDeclaration counterIncrDecl = peStyle.propertyByName(CSSName.COUNTER_INCREMENT);
            CalculatedStyle calculatedStyle = null;
            if (contentDecl != null || counterResetDecl != null || counterIncrDecl != null) {
                calculatedStyle = parentStyle.deriveStyle(peStyle);
                if (calculatedStyle.isDisplayNone()) {
                    return;
                }
                if (calculatedStyle.isIdent(CSSName.CONTENT, IdentValue.NONE)) {
                    return;
                }
                if (calculatedStyle.isIdent(CSSName.CONTENT, IdentValue.NORMAL) && (peName.equals("before") || peName.equals("after"))) {
                    return;
                }
                if (calculatedStyle.isTable() || calculatedStyle.isTableRow() || calculatedStyle.isTableSection()) {
                    CascadedStyle newPeStyle = CascadedStyle.createLayoutStyle(peStyle, new PropertyDeclaration[]{CascadedStyle.createLayoutPropertyDeclaration(CSSName.DISPLAY, IdentValue.BLOCK)});
                    calculatedStyle = parentStyle.deriveStyle(newPeStyle);
                }
                c2.resolveCounters(calculatedStyle);
            }
            if (contentDecl != null) {
                CSSPrimitiveValue propValue = contentDecl.getValue();
                children.addAll(BoxBuilder.createGeneratedContent(c2, element, peName, calculatedStyle, (PropertyValue)propValue, info));
            }
        }
    }

    private static List createGeneratedContent(LayoutContext c2, Element element, String peName, CalculatedStyle style, PropertyValue property, ChildBoxInfo info) {
        if (style.isDisplayNone() || style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN) || style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN_GROUP)) {
            return Collections.EMPTY_LIST;
        }
        List inlineBoxes = BoxBuilder.createGeneratedContentList(c2, element, property, peName, style, 1, null);
        if (style.isInline()) {
            for (InlineBox iB : inlineBoxes) {
                iB.setStyle(style);
                iB.applyTextTransform();
            }
            return inlineBoxes;
        }
        CalculatedStyle anon = style.createAnonymousStyle(IdentValue.INLINE);
        for (InlineBox iB : inlineBoxes) {
            iB.setStyle(anon);
            iB.applyTextTransform();
            iB.setElement(null);
        }
        BlockBox result2 = BoxBuilder.createBlockBox(style, info, true);
        result2.setStyle(style);
        result2.setInlineContent(inlineBoxes);
        result2.setElement(element);
        result2.setChildrenContentType(1);
        result2.setPseudoElementOrClass(peName);
        if (!style.isLayedOutInInlineContext()) {
            info.setContainsBlockLevelContent(true);
        }
        return new ArrayList<BlockBox>(Collections.singletonList(result2));
    }

    private static List createGeneratedMarginBoxContent(LayoutContext c2, Element element, PropertyValue property, CalculatedStyle style, ChildBoxInfo info) {
        List result2 = BoxBuilder.createGeneratedContentList(c2, element, property, null, style, 2, info);
        CalculatedStyle anon = style.createAnonymousStyle(IdentValue.INLINE);
        for (Styleable s2 : result2) {
            if (!(s2 instanceof InlineBox)) continue;
            InlineBox iB = (InlineBox)s2;
            iB.setElement(null);
            iB.setStyle(anon);
            iB.applyTextTransform();
        }
        return result2;
    }

    private static BlockBox createBlockBox(CalculatedStyle style, ChildBoxInfo info, boolean generated) {
        if (style.isFloated() && !style.isAbsolute() && !style.isFixed()) {
            BlockBox result2 = style.isTable() || style.isInlineTable() ? new TableBox() : new BlockBox();
            result2.setFloatedBoxData(new FloatedBoxData());
            return result2;
        }
        if (style.isSpecifiedAsBlock()) {
            return new BlockBox();
        }
        if (!generated && (style.isTable() || style.isInlineTable())) {
            return new TableBox();
        }
        if (style.isTableCell()) {
            info.setContainsTableContent(true);
            return new TableCellBox();
        }
        if (!generated && style.isTableRow()) {
            info.setContainsTableContent(true);
            return new TableRowBox();
        }
        if (!generated && style.isTableSection()) {
            info.setContainsTableContent(true);
            return new TableSectionBox();
        }
        if (style.isTableCaption()) {
            info.setContainsTableContent(true);
            return new BlockBox();
        }
        return new BlockBox();
    }

    private static void addColumns(LayoutContext c2, TableBox table, TableColumn parent) {
        SharedContext sharedContext = c2.getSharedContext();
        boolean found = false;
        for (Node working = parent.getElement().getFirstChild(); working != null; working = working.getNextSibling()) {
            Element element;
            CalculatedStyle style;
            if (working.getNodeType() != 1 || !(style = sharedContext.getStyle(element = (Element)working)).isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN)) continue;
            found = true;
            TableColumn col = new TableColumn(element, style);
            col.setParent(parent);
            table.addStyleColumn(col);
        }
        if (!found) {
            table.addStyleColumn(parent);
        }
    }

    private static void addColumnOrColumnGroup(LayoutContext c2, TableBox table, Element e2, CalculatedStyle style) {
        if (style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN)) {
            table.addStyleColumn(new TableColumn(e2, style));
        } else {
            BoxBuilder.addColumns(c2, table, new TableColumn(e2, style));
        }
    }

    private static InlineBox createInlineBox(String text2, Element parent, CalculatedStyle parentStyle, Text node) {
        InlineBox result2 = new InlineBox(text2, node);
        if (parentStyle.isInline() && !(parent.getParentNode() instanceof Document)) {
            result2.setStyle(parentStyle);
            result2.setElement(parent);
        } else {
            result2.setStyle(parentStyle.createAnonymousStyle(IdentValue.INLINE));
        }
        result2.applyTextTransform();
        return result2;
    }

    private static void createChildren(LayoutContext c2, BlockBox blockParent, Element parent, List children, ChildBoxInfo info, boolean inline) {
        SharedContext sharedContext = c2.getSharedContext();
        CalculatedStyle parentStyle = sharedContext.getStyle(parent);
        BoxBuilder.insertGeneratedContent(c2, parent, parentStyle, "before", children, info);
        Node working = parent.getFirstChild();
        boolean needStartText = inline;
        boolean needEndText = inline;
        if (working != null) {
            InlineBox previousIB = null;
            do {
                InlineBox iB;
                Styleable child = null;
                short nodeType = working.getNodeType();
                if (nodeType == 1) {
                    TableBox table;
                    Node valueAttribute;
                    Element element = (Element)working;
                    CalculatedStyle style = sharedContext.getStyle(element);
                    if (style.isDisplayNone()) continue;
                    Integer start = null;
                    if ("ol".equals(working.getNodeName())) {
                        Node startAttribute = working.getAttributes().getNamedItem("start");
                        if (startAttribute != null) {
                            try {
                                start = new Integer(Integer.parseInt(startAttribute.getNodeValue()) - 1);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else if ("li".equals(working.getNodeName()) && (valueAttribute = working.getAttributes().getNamedItem("value")) != null) {
                        try {
                            start = new Integer(Integer.parseInt(valueAttribute.getNodeValue()) - 1);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    c2.resolveCounters(style, start);
                    if (style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN) || style.isIdent(CSSName.DISPLAY, IdentValue.TABLE_COLUMN_GROUP)) {
                        if (blockParent == null || !blockParent.getStyle().isTable() && !blockParent.getStyle().isInlineTable()) continue;
                        table = (TableBox)blockParent;
                        BoxBuilder.addColumnOrColumnGroup(c2, table, element, style);
                        continue;
                    }
                    if (style.isInline()) {
                        if (needStartText) {
                            needStartText = false;
                            InlineBox iB2 = BoxBuilder.createInlineBox("", parent, parentStyle, null);
                            iB2.setStartsHere(true);
                            iB2.setEndsHere(false);
                            children.add(iB2);
                            previousIB = iB2;
                        }
                        BoxBuilder.createChildren(c2, null, element, children, info, true);
                        if (inline) {
                            if (previousIB != null) {
                                previousIB.setEndsHere(false);
                            }
                            needEndText = true;
                        }
                    } else {
                        BlockBox block;
                        child = BoxBuilder.createBlockBox(style, info, false);
                        child.setStyle(style);
                        child.setElement(element);
                        if (style.isListItem()) {
                            block = (BlockBox)child;
                            block.setListCounter(c2.getCounterContext(style).getCurrentCounterValue("list-item"));
                        }
                        if (style.isTable() || style.isInlineTable()) {
                            table = (TableBox)child;
                            table.ensureChildren(c2);
                            child = BoxBuilder.reorderTableContent(c2, table);
                        }
                        if (!info.isContainsBlockLevelContent() && !style.isLayedOutInInlineContext()) {
                            info.setContainsBlockLevelContent(true);
                        }
                        if ((block = (BlockBox)child).getStyle().mayHaveFirstLine()) {
                            block.setFirstLineStyle(c2.getCss().getPseudoElementStyle(element, "first-line"));
                        }
                        if (block.getStyle().mayHaveFirstLetter()) {
                            block.setFirstLetterStyle(c2.getCss().getPseudoElementStyle(element, "first-letter"));
                        }
                        block.ensureChildren(c2);
                    }
                } else if (nodeType == 3 || nodeType == 4) {
                    needStartText = false;
                    needEndText = false;
                    Text textNode = (Text)working;
                    child = BoxBuilder.createInlineBox(textNode.getData(), parent, parentStyle, textNode);
                    iB = child;
                    iB.setEndsHere(true);
                    if (previousIB == null) {
                        iB.setStartsHere(true);
                    } else {
                        previousIB.setEndsHere(false);
                    }
                    previousIB = iB;
                } else if (nodeType == 5) {
                    EntityReference entityReference = (EntityReference)working;
                    child = BoxBuilder.createInlineBox(entityReference.getTextContent(), parent, parentStyle, null);
                    iB = child;
                    iB.setEndsHere(true);
                    if (previousIB == null) {
                        iB.setStartsHere(true);
                    } else {
                        previousIB.setEndsHere(false);
                    }
                    previousIB = iB;
                }
                if (child == null) continue;
                children.add(child);
            } while ((working = working.getNextSibling()) != null);
        }
        if (needStartText || needEndText) {
            InlineBox iB = BoxBuilder.createInlineBox("", parent, parentStyle, null);
            iB.setStartsHere(needStartText);
            iB.setEndsHere(needEndText);
            children.add(iB);
        }
        BoxBuilder.insertGeneratedContent(c2, parent, parentStyle, "after", children, info);
    }

    private static void insertAnonymousBlocks(SharedContext c2, Box parent, List children, boolean layoutRunningBlocks) {
        ArrayList<Styleable> inline = new ArrayList<Styleable>();
        LinkedList<InlineBox> parents = new LinkedList<InlineBox>();
        ArrayList savedParents = null;
        for (Styleable child : children) {
            if (!(!child.getStyle().isLayedOutInInlineContext() || layoutRunningBlocks && child.getStyle().isRunning())) {
                inline.add(child);
                if (!child.getStyle().isInline()) continue;
                InlineBox iB = (InlineBox)child;
                if (iB.isStartsHere()) {
                    parents.add(iB);
                }
                if (!iB.isEndsHere()) continue;
                parents.removeLast();
                continue;
            }
            if (inline.size() > 0) {
                BoxBuilder.createAnonymousBlock(c2, parent, inline, savedParents);
                inline = new ArrayList();
                savedParents = new ArrayList(parents);
            }
            parent.addChild((Box)child);
        }
        BoxBuilder.createAnonymousBlock(c2, parent, inline, savedParents);
    }

    private static void createAnonymousBlock(SharedContext c2, Box parent, List inline, List savedParents) {
        WhitespaceStripper.stripInlineContent(inline);
        if (inline.size() > 0) {
            AnonymousBlockBox anon = new AnonymousBlockBox(parent.getElement());
            anon.setStyle(parent.getStyle().createAnonymousStyle(IdentValue.BLOCK));
            anon.setAnonymous(true);
            if (savedParents != null && savedParents.size() > 0) {
                anon.setOpenInlineBoxes(savedParents);
            }
            parent.addChild(anon);
            anon.setChildrenContentType(1);
            anon.setInlineContent(inline);
        }
    }

    private static class ChildBoxInfo {
        private boolean _containsBlockLevelContent;
        private boolean _containsTableContent;
        private boolean _layoutRunningBlocks;

        public boolean isContainsBlockLevelContent() {
            return this._containsBlockLevelContent;
        }

        public void setContainsBlockLevelContent(boolean containsBlockLevelContent) {
            this._containsBlockLevelContent = containsBlockLevelContent;
        }

        public boolean isContainsTableContent() {
            return this._containsTableContent;
        }

        public void setContainsTableContent(boolean containsTableContent) {
            this._containsTableContent = containsTableContent;
        }

        public boolean isLayoutRunningBlocks() {
            return this._layoutRunningBlocks;
        }

        public void setLayoutRunningBlocks(boolean layoutRunningBlocks) {
            this._layoutRunningBlocks = layoutRunningBlocks;
        }
    }
}

