/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime;

import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationEventLocator;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.helpers.ValidationEventImpl;
import java.util.HashMap;
import org.glassfish.jaxb.core.v2.ClassFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Coordinator
implements ErrorHandler,
ValidationEventHandler {
    private final HashMap<Class<? extends XmlAdapter>, XmlAdapter> adapters = new HashMap();
    private static final ThreadLocal<Coordinator> activeTable = new ThreadLocal();
    private Coordinator old;

    public final XmlAdapter putAdapter(Class<? extends XmlAdapter> c2, XmlAdapter a2) {
        if (a2 == null) {
            return this.adapters.remove(c2);
        }
        return this.adapters.put(c2, a2);
    }

    public final <T extends XmlAdapter> T getAdapter(Class<T> key2) {
        XmlAdapter v2 = (XmlAdapter)key2.cast(this.adapters.get(key2));
        if (v2 == null) {
            v2 = (XmlAdapter)ClassFactory.create(key2);
            this.putAdapter(key2, v2);
        }
        return (T)v2;
    }

    public <T extends XmlAdapter> boolean containsAdapter(Class<T> type2) {
        return this.adapters.containsKey(type2);
    }

    protected final void pushCoordinator() {
        this.old = activeTable.get();
        activeTable.set(this);
    }

    protected final void popCoordinator() {
        if (this.old != null) {
            activeTable.set(this.old);
        } else {
            activeTable.remove();
        }
        this.old = null;
    }

    public static Coordinator _getInstance() {
        return activeTable.get();
    }

    protected abstract ValidationEventLocator getLocation();

    @Override
    public final void error(SAXParseException exception) throws SAXException {
        this.propagateEvent(1, exception);
    }

    @Override
    public final void warning(SAXParseException exception) throws SAXException {
        this.propagateEvent(0, exception);
    }

    @Override
    public final void fatalError(SAXParseException exception) throws SAXException {
        this.propagateEvent(2, exception);
    }

    private void propagateEvent(int severity, SAXParseException saxException) throws SAXException {
        ValidationEventImpl ve = new ValidationEventImpl(severity, saxException.getMessage(), this.getLocation());
        Exception e2 = saxException.getException();
        if (e2 != null) {
            ve.setLinkedException(e2);
        } else {
            ve.setLinkedException(saxException);
        }
        boolean result2 = this.handleEvent(ve);
        if (!result2) {
            throw saxException;
        }
    }
}

