/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbPort;
import javax.usb.UsbStringDescriptor;
import javax.usb.event.UsbDeviceListener;
import javax.usb.util.DefaultUsbControlIrp;
import org.usb4java.javax.AbstractDevice;
import org.usb4java.javax.DeviceListenerList;
import org.usb4java.javax.Port;
import org.usb4java.javax.Ports;
import org.usb4java.javax.RootHubConfiguration;
import org.usb4java.javax.UsbPorts;
import org.usb4java.javax.descriptors.SimpleUsbDeviceDescriptor;

final class RootHub
implements UsbHub,
UsbPorts<Port, AbstractDevice> {
    private static final String MANUFACTURER = "usb4java";
    private static final String PRODUCT = "root hub";
    private static final String SERIAL_NUMBER = "1.0.0";
    private final List<UsbConfiguration> configurations = new ArrayList<UsbConfiguration>(1);
    private final UsbDeviceDescriptor descriptor = new SimpleUsbDeviceDescriptor(18, 1, 257, 9, 0, 0, 8, -1, -1, 0, 1, 2, 3, 1);
    private final DeviceListenerList listeners = new DeviceListenerList();
    private final Ports rootPorts = new Ports(this);

    RootHub() {
        this.configurations.add(new RootHubConfiguration((UsbDevice)this));
    }

    public UsbPort getParentUsbPort() {
        return null;
    }

    public boolean isUsbHub() {
        return true;
    }

    public String getManufacturerString() {
        return MANUFACTURER;
    }

    public String getSerialNumberString() {
        return SERIAL_NUMBER;
    }

    public String getProductString() {
        return PRODUCT;
    }

    public Object getSpeed() {
        return UsbConst.DEVICE_SPEED_UNKNOWN;
    }

    public List<UsbConfiguration> getUsbConfigurations() {
        return this.configurations;
    }

    public UsbConfiguration getUsbConfiguration(byte number) {
        if (number != 1) {
            return null;
        }
        return this.configurations.get(0);
    }

    public boolean containsUsbConfiguration(byte number) {
        return number == 1;
    }

    public byte getActiveUsbConfigurationNumber() {
        return 1;
    }

    public UsbConfiguration getActiveUsbConfiguration() {
        return this.configurations.get(0);
    }

    public boolean isConfigured() {
        return true;
    }

    public UsbDeviceDescriptor getUsbDeviceDescriptor() {
        return this.descriptor;
    }

    public UsbStringDescriptor getUsbStringDescriptor(byte index) throws UsbException {
        throw new UsbException("Can't get USB string descriptor from virtual device");
    }

    public String getString(byte index) throws UsbException {
        throw new UsbException("Can't get string from virtual device");
    }

    public void syncSubmit(UsbControlIrp irp) throws UsbException {
        throw new UsbException("Can't syncSubmit on virtual device");
    }

    public void asyncSubmit(UsbControlIrp irp) throws UsbException {
        throw new UsbException("Can't asyncSubmit on virtual device");
    }

    public void syncSubmit(List list) throws UsbException {
        throw new UsbException("Can't syncSubmit on virtual device");
    }

    public void asyncSubmit(List list) throws UsbException {
        throw new UsbException("Can't asyncSubmit on virtual device");
    }

    public UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        return new DefaultUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
    }

    public void addUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.add(listener);
    }

    public void removeUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public byte getNumberOfPorts() {
        return this.rootPorts.getNumberOfPorts();
    }

    @Override
    public List<Port> getUsbPorts() {
        return this.rootPorts.getUsbPorts();
    }

    @Override
    public Port getUsbPort(byte number) {
        return this.rootPorts.getUsbPort(number);
    }

    @Override
    public List<AbstractDevice> getAttachedUsbDevices() {
        return this.rootPorts.getAttachedUsbDevices();
    }

    @Override
    public boolean isUsbDeviceAttached(AbstractDevice device) {
        return this.rootPorts.isUsbDeviceAttached(device);
    }

    public boolean isRootUsbHub() {
        return true;
    }

    @Override
    public void connectUsbDevice(AbstractDevice device) {
        this.rootPorts.connectUsbDevice(device);
    }

    @Override
    public void disconnectUsbDevice(AbstractDevice device) {
        this.rootPorts.disconnectUsbDevice(device);
    }

    public String toString() {
        return this.getManufacturerString() + " " + this.getProductString() + " " + this.getSerialNumberString();
    }
}

