/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class ClaimTestLibUsb {
    static final short idVendor = 1155;
    static final short idProduct = 22353;
    static final byte interfaceId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Context context = new Context();
        int result = LibUsb.init((Context)context);
        if (result < 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        DeviceList list = new DeviceList();
        result = LibUsb.getDeviceList((Context)context, (DeviceList)list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list", result);
        }
        try {
            for (Device device : list) {
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                if (result < 0) {
                    throw new LibUsbException("Unable to read device descriptor", result);
                }
                int address = LibUsb.getDeviceAddress((Device)device);
                int busNumber = LibUsb.getBusNumber((Device)device);
                System.out.format("Bus %03d, Device %03d: Vendor %04x, Product %04x%n", busNumber, address, descriptor.idVendor(), descriptor.idProduct());
                if (descriptor.idVendor() != 1155 || descriptor.idProduct() != 22353) continue;
                DeviceHandle handle = new DeviceHandle();
                result = LibUsb.open((Device)device, (DeviceHandle)handle);
                if (result < 0) {
                    System.out.println(String.format("Unable to open device: %s. Continuing without device handle.", LibUsb.strError((int)result)));
                    handle = null;
                }
                if ((result = LibUsb.detachKernelDriver((DeviceHandle)handle, (int)0)) != 0 && result != -12 && result != -5) {
                    System.out.println(new LibUsbException("Unable to detach kernel driver", result));
                }
                if ((result = LibUsb.claimInterface((DeviceHandle)handle, (int)0)) < 0) {
                    System.out.println(new LibUsbException(String.format("Unable to claim interface 0x%02X", (byte)0), result).getMessage());
                } else {
                    System.out.println(">>> interface claimed successful!");
                    result = LibUsb.releaseInterface((DeviceHandle)handle, (int)0);
                    if (result < 0) {
                        System.out.println(new LibUsbException(String.format("Unable to release interface 0x%02X", (byte)0), result).getMessage());
                    }
                }
                if (handle == null) continue;
                LibUsb.close((DeviceHandle)handle);
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        LibUsb.exit((Context)context);
    }
}

