/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.simple.extend.DefaultFormSubmissionListener;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.DeferredImageReplacedElement;
import org.xhtmlrenderer.swing.EmptyReplacedElement;
import org.xhtmlrenderer.swing.ImageReplacedElement;
import org.xhtmlrenderer.swing.ImageResourceLoader;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.swing.SwingReplacedElement;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class SwingReplacedElementFactory
implements ReplacedElementFactory {
    protected Map imageComponents;
    protected LinkedHashMap forms;
    private FormSubmissionListener formSubmissionListener;
    protected final RepaintListener repaintListener;
    private ImageResourceLoader imageResourceLoader;

    public SwingReplacedElementFactory() {
        this(ImageResourceLoader.NO_OP_REPAINT_LISTENER);
    }

    public SwingReplacedElementFactory(RepaintListener repaintListener) {
        this(repaintListener, new ImageResourceLoader());
    }

    public SwingReplacedElementFactory(RepaintListener listener2, ImageResourceLoader irl) {
        this.repaintListener = listener2;
        this.imageResourceLoader = irl;
        this.formSubmissionListener = new DefaultFormSubmissionListener();
    }

    @Override
    public ReplacedElement createReplacedElement(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        FormField formField;
        Element e2 = box.getElement();
        if (e2 == null) {
            return null;
        }
        if (context.getNamespaceHandler().isImageElement(e2)) {
            return this.replaceImage(uac, context, e2, cssWidth, cssHeight);
        }
        Element parentForm = this.getParentForm(e2, context);
        XhtmlForm form2 = this.getForm(parentForm);
        if (form2 == null) {
            form2 = new XhtmlForm(uac, parentForm, this.formSubmissionListener);
            this.addForm(parentForm, form2);
        }
        if ((formField = form2.addComponent(e2, context, box)) == null) {
            return null;
        }
        JComponent cc = formField.getComponent();
        if (cc == null) {
            return new EmptyReplacedElement(0, 0);
        }
        SwingReplacedElement result2 = new SwingReplacedElement(cc);
        result2.setIntrinsicSize(formField.getIntrinsicSize());
        if (context.isInteractive()) {
            ((Container)((Object)context.getCanvas())).add(cc);
        }
        return result2;
    }

    protected ReplacedElement replaceImage(UserAgentCallback uac, LayoutContext context, Element elem, int cssWidth, int cssHeight) {
        ReplacedElement re = null;
        String imageSrc = context.getNamespaceHandler().getImageSourceURI(elem);
        if (imageSrc == null || imageSrc.length() == 0) {
            XRLog.layout(Level.WARNING, "No source provided for img element.");
            re = this.newIrreplaceableImageElement(cssWidth, cssHeight);
        } else if (ImageUtil.isEmbeddedBase64Image(imageSrc)) {
            BufferedImage image = ImageUtil.loadEmbeddedBase64Image(imageSrc);
            if (image != null) {
                re = new ImageReplacedElement(image, cssWidth, cssHeight);
            }
        } else {
            String ruri = uac.resolveURI(imageSrc);
            re = this.lookupImageReplacedElement(elem, ruri, cssWidth, cssHeight);
            if (re == null) {
                XRLog.load(Level.FINE, "Swing: Image " + ruri + " requested at  to " + cssWidth + ", " + cssHeight);
                ImageResource imageResource = this.imageResourceLoader.get(ruri, cssWidth, cssHeight);
                re = imageResource.isLoaded() ? new ImageReplacedElement(((AWTFSImage)imageResource.getImage()).getImage(), cssWidth, cssHeight) : new DeferredImageReplacedElement(imageResource, this.repaintListener, cssWidth, cssHeight);
                this.storeImageReplacedElement(elem, re, ruri, cssWidth, cssHeight);
            }
        }
        return re;
    }

    private ReplacedElement lookupImageReplacedElement(Element elem, String ruri, int cssWidth, int cssHeight) {
        if (this.imageComponents == null) {
            return null;
        }
        CacheKey key2 = new CacheKey(elem, ruri, cssWidth, cssHeight);
        return (ReplacedElement)this.imageComponents.get(key2);
    }

    protected ReplacedElement newIrreplaceableImageElement(int cssWidth, int cssHeight) {
        ReplacedElement mre;
        try {
            BufferedImage missingImage = ImageUtil.createCompatibleBufferedImage(cssWidth, cssHeight, 1);
            Graphics2D g2 = missingImage.createGraphics();
            g2.setColor(Color.BLACK);
            g2.setBackground(Color.WHITE);
            g2.setFont(new Font("Serif", 0, 12));
            g2.drawString("Missing", 0, 12);
            g2.dispose();
            mre = new ImageReplacedElement(missingImage, cssWidth, cssHeight);
        }
        catch (Exception e2) {
            mre = new EmptyReplacedElement(cssWidth < 0 ? 0 : cssWidth, cssHeight < 0 ? 0 : cssHeight);
        }
        return mre;
    }

    protected void storeImageReplacedElement(Element e2, ReplacedElement cc, String uri, int cssWidth, int cssHeight) {
        if (this.imageComponents == null) {
            this.imageComponents = new HashMap();
        }
        CacheKey key2 = new CacheKey(e2, uri, cssWidth, cssHeight);
        this.imageComponents.put(key2, cc);
    }

    protected ReplacedElement lookupImageReplacedElement(Element e2, String uri) {
        return this.lookupImageReplacedElement(e2, uri, -1, -1);
    }

    protected void addForm(Element e2, XhtmlForm f2) {
        if (this.forms == null) {
            this.forms = new LinkedHashMap();
        }
        this.forms.put(e2, f2);
    }

    protected XhtmlForm getForm(Element e2) {
        if (this.forms == null) {
            return null;
        }
        return (XhtmlForm)this.forms.get(e2);
    }

    protected Element getParentForm(Element e2, LayoutContext context) {
        Node node = e2;
        while ((node = node.getParentNode()).getNodeType() == 1 && !context.getNamespaceHandler().isFormElement((Element)node)) {
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        return (Element)node;
    }

    @Override
    public void reset() {
        this.forms = null;
    }

    @Override
    public void remove(Element e2) {
        if (this.forms != null) {
            this.forms.remove(e2);
        }
        if (this.imageComponents != null) {
            this.imageComponents.remove(e2);
        }
    }

    @Override
    public void setFormSubmissionListener(FormSubmissionListener fsl) {
        this.formSubmissionListener = fsl;
    }

    private static class CacheKey {
        final Element elem;
        final String uri;
        final int width;
        final int height;

        public CacheKey(Element elem, String uri, int width, int height) {
            this.uri = uri;
            this.width = width;
            this.height = height;
            this.elem = elem;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o2;
            if (this.height != cacheKey.height) {
                return false;
            }
            if (this.width != cacheKey.width) {
                return false;
            }
            if (!this.elem.equals(cacheKey.elem)) {
                return false;
            }
            return this.uri.equals(cacheKey.uri);
        }

        public int hashCode() {
            int result2 = this.elem.hashCode();
            result2 = 31 * result2 + this.uri.hashCode();
            result2 = 31 * result2 + this.width;
            result2 = 31 * result2 + this.height;
            return result2;
        }
    }
}

