/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.internal.image.FileFormat;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    public int compression;
    List<ImageLoaderListener> imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
        this.compression = -1;
    }

    public ImageData[] load(InputStream stream) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        this.data = FileFormat.load(stream, this);
        return this.data;
    }

    /*
     * Loose catch block
     */
    public ImageData[] load(String filename) {
        if (filename == null) {
            SWT.error(4);
        }
        FileInputStream stream = null;
        stream = new FileInputStream(filename);
        ImageData[] imageDataArray = this.load(stream);
        try {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        catch (IOException iOException) {}
        return imageDataArray;
        catch (IOException e2) {
            try {
                SWT.error(39, e2);
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void save(OutputStream stream, int format) {
        if (stream == null) {
            SWT.error(4);
        }
        FileFormat.save(stream, format, this);
    }

    public void save(String filename, int format) {
        if (filename == null) {
            SWT.error(4);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filename);
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        this.save(stream, format);
        try {
            ((OutputStream)stream).close();
        }
        catch (IOException iOException) {}
    }

    public void addImageLoaderListener(ImageLoaderListener listener2) {
        if (listener2 == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            this.imageLoaderListeners = new ArrayList<ImageLoaderListener>();
        }
        this.imageLoaderListeners.add(listener2);
    }

    public void removeImageLoaderListener(ImageLoaderListener listener2) {
        if (listener2 == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            return;
        }
        this.imageLoaderListeners.remove(listener2);
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        int size = this.imageLoaderListeners.size();
        int i2 = 0;
        while (i2 < size) {
            ImageLoaderListener listener2 = this.imageLoaderListeners.get(i2);
            listener2.imageDataLoaded(event);
            ++i2;
        }
    }
}

