/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.data.Record;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.ObjectFactory;
import gde.device.PropertyType;
import gde.device.StatisticsType;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.ui.dialog.edit.MeasurementContextmenu;
import gde.ui.dialog.edit.PropertyTypeTabItem;
import gde.ui.dialog.edit.StatisticsTypeTabItem;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MeasurementTypeTabItem
extends CTabItem
implements Cloneable {
    static final Logger log = Logger.getLogger(MeasurementTypeTabItem.class.getName());
    final CTabFolder measurementsTabFolder;
    String tabName;
    Composite measurementsComposite;
    Label measurementNameLabel;
    Label measurementSymbolLabel;
    Label measurementUnitLabel;
    Label measurementEnableLabel;
    Text measurementNameText;
    Text measurementSymbolText;
    Text measurementUnitText;
    Button measurementActiveButton;
    CTabFolder channelConfigMeasurementPropertiesTabFolder;
    Button addMeasurementButton;
    Button removeMeasurementButton;
    Label measurementTypeLabel;
    Menu popupMenu;
    MeasurementContextmenu contextMenu;
    String measurementName;
    String measurementSymbol;
    String measurementUnit;
    boolean isMeasurementActive;
    CTabFolder measurementPropertiesTabFolder;
    CTabItem measurementPropertiesTabItem;
    StatisticsTypeTabItem statisticsTypeTabItem;
    DeviceConfiguration deviceConfig;
    int channelConfigNumber;
    MeasurementType measurementType;
    final DevicePropertiesEditor propsEditor;

    public MeasurementTypeTabItem(CTabFolder parent, int style, int index) {
        super(parent, style, index);
        this.measurementsTabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        this.tabName = " " + (index + 1) + " ";
        SWTResourceManager.registerResourceUser((Widget)this);
        this.initGUI();
    }

    public synchronized MeasurementTypeTabItem clone() {
        return new MeasurementTypeTabItem(this);
    }

    private MeasurementTypeTabItem(MeasurementTypeTabItem copyFrom) {
        super(copyFrom.measurementsTabFolder, 64);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.propsEditor = DevicePropertiesEditor.getInstance();
        this.measurementsTabFolder = copyFrom.measurementsTabFolder;
        this.measurementName = Messages.getString("GDE_MSGT0529");
        this.measurementSymbol = copyFrom.measurementSymbol;
        this.measurementUnit = copyFrom.measurementUnit;
        this.isMeasurementActive = copyFrom.isMeasurementActive;
        this.deviceConfig = this.propsEditor.deviceConfig;
        this.channelConfigNumber = copyFrom.channelConfigNumber;
        this.tabName = " " + String.valueOf(this.deviceConfig != null ? this.measurementName : Integer.valueOf(this.measurementsTabFolder.getItemCount())) + " ";
        this.initGUI();
        if (this.deviceConfig != null) {
            int i;
            this.measurementType = copyFrom.measurementType.clone();
            this.measurementType.setName(this.measurementName);
            this.deviceConfig.addMeasurement2Channel(this.channelConfigNumber, this.measurementType);
            if (this.statisticsTypeTabItem != null && this.measurementType.getStatistics() != null) {
                this.measurementType.getStatistics().removeTrigger();
                this.statisticsTypeTabItem.setStatisticsType(this.deviceConfig, this.measurementType.getStatistics(), this.channelConfigNumber);
            }
            int propertyCount = this.measurementPropertiesTabFolder != null ? this.measurementPropertiesTabFolder.getItemCount() : 0;
            int measurementPropertyCount = this.measurementType.getProperty().size();
            if (measurementPropertyCount > 0 && (this.measurementPropertiesTabItem == null || this.measurementPropertiesTabItem.isDisposed())) {
                this.measurementPropertiesTabItem = new CTabItem(this.channelConfigMeasurementPropertiesTabFolder, 64);
                this.measurementPropertiesTabItem.setText(Messages.getString("GDE_MSGT0530"));
                this.measurementPropertiesTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
                this.measurementPropertiesTabFolder = new CTabFolder((Composite)this.channelConfigMeasurementPropertiesTabFolder, 0);
                this.measurementPropertiesTabItem.setControl((Control)this.measurementPropertiesTabFolder);
            }
            if (propertyCount < measurementPropertyCount) {
                for (i = propertyCount; i < measurementPropertyCount; ++i) {
                    new PropertyTypeTabItem(this.measurementPropertiesTabFolder, 64, "*", this);
                }
            } else if (propertyCount > measurementPropertyCount) {
                for (i = measurementPropertyCount; i < propertyCount; ++i) {
                    this.measurementPropertiesTabFolder.getItem(0).dispose();
                }
            }
            for (i = 0; i < measurementPropertyCount; ++i) {
                boolean isNoneSpecified;
                PropertyTypeTabItem tabItem = (PropertyTypeTabItem)this.measurementPropertiesTabFolder.getItem(i);
                tabItem.setProperty(this.deviceConfig, this.measurementType.getProperty().get(i), isNoneSpecified, (String[])((isNoneSpecified = MeasurementPropertyTypes.isNoneSpecified(this.measurementType.getProperty().get(i).getName())) ? MeasurementPropertyTypes.valuesAsStingArray() : null), (String[])(isNoneSpecified ? DataTypes.valuesAsStingArray() : null), true);
                tabItem.setNameComboItems(MeasurementPropertyTypes.valuesAsStingArray());
            }
            if (measurementPropertyCount == 0) {
                if (this.measurementPropertiesTabFolder != null) {
                    this.measurementPropertiesTabFolder.dispose();
                    this.measurementPropertiesTabFolder = null;
                    if (this.measurementPropertiesTabItem != null) {
                        this.measurementPropertiesTabItem.dispose();
                        this.measurementPropertiesTabItem = null;
                    }
                }
            } else {
                this.measurementPropertiesTabFolder.setSelection(0);
            }
        }
        this.initialize();
    }

    public void setMeasurementTypeName(DeviceConfiguration useDeviceConfig, MeasurementType useMeasurementType, int useChannelConfigNumber) {
        this.deviceConfig = useDeviceConfig;
        this.measurementType = useMeasurementType;
        this.channelConfigNumber = useChannelConfigNumber;
        this.measurementName = this.measurementType.getName();
        this.setText(" " + this.measurementName + " ");
    }

    public void setMeasurementType(DeviceConfiguration useDeviceConfig, MeasurementType useMeasurementType, int useChannelConfigNumber) {
        this.deviceConfig = useDeviceConfig;
        this.measurementType = useMeasurementType;
        this.channelConfigNumber = useChannelConfigNumber;
        this.measurementName = this.measurementType.getName();
        this.measurementNameText.setText(this.measurementName);
        this.measurementSymbol = this.measurementType.getSymbol();
        this.measurementSymbolText.setText(this.measurementSymbol);
        this.measurementUnit = this.measurementType.getUnit();
        this.measurementUnitText.setText(this.measurementUnit);
        this.isMeasurementActive = this.measurementType.isActive();
        this.measurementActiveButton.setSelection(this.isMeasurementActive);
        this.setText(" " + this.measurementName + " ");
        this.measurementsComposite.redraw();
        if (this.measurementType.getStatistics() == null && this.statisticsTypeTabItem != null && !this.statisticsTypeTabItem.isDisposed()) {
            this.statisticsTypeTabItem.dispose();
        } else if (this.measurementType.getStatistics() != null && (this.statisticsTypeTabItem == null || this.statisticsTypeTabItem.isDisposed())) {
            this.statisticsTypeTabItem = this.createStatisticsTabItem();
        }
        if (this.measurementType.getStatistics() != null && this.statisticsTypeTabItem != null && !this.statisticsTypeTabItem.isDisposed()) {
            this.statisticsTypeTabItem.setStatisticsType(this.deviceConfig, this.measurementType.getStatistics(), this.channelConfigNumber);
        }
        int propertyCount = this.measurementPropertiesTabFolder != null ? this.measurementPropertiesTabFolder.getItemCount() : 0;
        int measurementPropertyCount = this.measurementType.getProperty().size();
        if (measurementPropertyCount > 0 && (this.measurementPropertiesTabItem == null || this.measurementPropertiesTabItem.isDisposed())) {
            this.measurementPropertiesTabItem = new CTabItem(this.channelConfigMeasurementPropertiesTabFolder, 64);
            this.measurementPropertiesTabItem.setText(Messages.getString("GDE_MSGT0530"));
            this.measurementPropertiesTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementPropertiesTabFolder = new CTabFolder((Composite)this.channelConfigMeasurementPropertiesTabFolder, 0);
            this.measurementPropertiesTabItem.setControl((Control)this.measurementPropertiesTabFolder);
        } else if (measurementPropertyCount == 0 && this.measurementPropertiesTabFolder != null) {
            for (CTabItem tmpPropertyTypeTabItem : this.measurementPropertiesTabFolder.getItems()) {
                ((PropertyTypeTabItem)tmpPropertyTypeTabItem).dispose();
            }
            this.measurementPropertiesTabItem.dispose();
        }
        if (propertyCount < measurementPropertyCount) {
            if (this.measurementPropertiesTabFolder == null || this.measurementPropertiesTabFolder.isDisposed()) {
                this.createMeasurementPropertyTabItemWithSubTabFolder();
            }
            for (int i = propertyCount; i < measurementPropertyCount; ++i) {
                new PropertyTypeTabItem(this.measurementPropertiesTabFolder, 64, "", this);
            }
        } else if (propertyCount > measurementPropertyCount && measurementPropertyCount > 0) {
            for (int i = measurementPropertyCount; i < propertyCount; ++i) {
                ((PropertyTypeTabItem)this.measurementPropertiesTabFolder.getItem(i - 1)).dispose();
            }
        }
        for (int i = 0; i < measurementPropertyCount; ++i) {
            boolean isNoneSpecified;
            PropertyTypeTabItem tabItem = (PropertyTypeTabItem)this.measurementPropertiesTabFolder.getItem(i);
            tabItem.setProperty(this.deviceConfig, this.measurementType.getProperty().get(i), isNoneSpecified, (String[])((isNoneSpecified = MeasurementPropertyTypes.isNoneSpecified(this.measurementType.getProperty().get(i).getName())) ? MeasurementPropertyTypes.valuesAsStingArray() : null), (String[])(isNoneSpecified ? DataTypes.valuesAsStingArray() : null), true);
            tabItem.setNameComboItems(MeasurementPropertyTypes.valuesAsStingArray());
        }
        if (measurementPropertyCount == 0) {
            if (this.measurementPropertiesTabFolder != null) {
                if (this.measurementPropertiesTabItem != null) {
                    this.measurementPropertiesTabItem.dispose();
                    this.measurementPropertiesTabItem = null;
                }
                this.measurementPropertiesTabFolder.dispose();
                this.measurementPropertiesTabFolder = null;
            }
        } else {
            this.measurementPropertiesTabFolder.setSelection(0);
        }
        this.initialize();
        SWTResourceManager.listResourceStatus(this.getClass().getSimpleName() + ".setMeasurementType()");
    }

    private void initGUI() {
        try {
            this.setText(this.tabName);
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementtypeTabItem.widgetDisposed, event=" + String.valueOf(evt));
                    MeasurementTypeTabItem.this.enableContextMenu(false);
                    if (MeasurementTypeTabItem.this.propsEditor.deviceConfig != null && MeasurementTypeTabItem.this.propsEditor.deviceConfig.isChangePropery()) {
                        MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.measurementsComposite = new Composite((Composite)this.measurementsTabFolder, 0);
            this.measurementsComposite.setLayout(null);
            this.setControl((Control)this.measurementsComposite);
            this.measurementsComposite.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "measurementsComposite.helpRequested " + String.valueOf(evt));
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A1.html#device_properties_measurement");
                }
            });
            this.measurementTypeLabel = new Label(this.measurementsComposite, 0);
            this.measurementTypeLabel.setText(Messages.getString("GDE_MSGT0542"));
            this.measurementTypeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementTypeLabel.setBounds(10, 10, 120, 20);
            this.addMeasurementButton = new Button(this.measurementsComposite, 0x1000008);
            this.addMeasurementButton.setText("+");
            this.addMeasurementButton.setToolTipText(Messages.getString("GDE_MSGT0548"));
            this.addMeasurementButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.addMeasurementButton.setBounds(170, 10, 20, 20);
            this.addMeasurementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "addMeasurementButton.widgetSelected, event=" + String.valueOf(evt));
                    MeasurementTypeTabItem.this.measurementsTabFolder.getItem(MeasurementTypeTabItem.this.measurementsTabFolder.getItemCount() - 1).setShowClose(false);
                    MeasurementTypeTabItem.this.measurementsTabFolder.setSelection((CTabItem)MeasurementTypeTabItem.this.clone());
                    MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                }
            });
            this.removeMeasurementButton = new Button(this.measurementsComposite, 0x1000008);
            this.removeMeasurementButton.setText("-");
            this.removeMeasurementButton.setToolTipText(Messages.getString("GDE_MSGT0600"));
            this.removeMeasurementButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.removeMeasurementButton.setBounds(200, 10, 20, 20);
            this.removeMeasurementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "removeMeasurementButton.widgetSelected, event=" + String.valueOf(evt));
                    if (MeasurementTypeTabItem.this.deviceConfig != null) {
                        MeasurementTypeTabItem.this.deviceConfig.removeMeasurementFromChannel(MeasurementTypeTabItem.this.channelConfigNumber, MeasurementTypeTabItem.this.measurementType);
                        MeasurementTypeTabItem.this.dispose();
                        MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.measurementNameLabel = new Label(this.measurementsComposite, 131072);
            this.measurementNameLabel.setText(Messages.getString("GDE_MSGT0549"));
            this.measurementNameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementNameLabel.setBounds(10, 40, 60, 20);
            this.measurementNameText = new Text(this.measurementsComposite, 2048);
            this.measurementNameText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementNameText.setBounds(80, 40, 145, 20);
            this.measurementNameText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementNameText.keyReleased, event=" + String.valueOf(evt));
                    MeasurementTypeTabItem.this.measurementName = MeasurementTypeTabItem.this.measurementNameText.getText();
                    if (MeasurementTypeTabItem.this.measurementType != null) {
                        MeasurementTypeTabItem.this.measurementType.setName(MeasurementTypeTabItem.this.measurementName);
                        MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    MeasurementTypeTabItem.this.tabName = " " + MeasurementTypeTabItem.this.measurementName + " ";
                    MeasurementTypeTabItem.this.setText((String)MeasurementTypeTabItem.this.tabName);
                }
            });
            this.measurementSymbolLabel = new Label(this.measurementsComposite, 131072);
            this.measurementSymbolLabel.setText(Messages.getString("GDE_MSGT0550"));
            this.measurementSymbolLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementSymbolLabel.setBounds(10, 65, 60, 20);
            this.measurementSymbolText = new Text(this.measurementsComposite, 2048);
            this.measurementSymbolText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementSymbolText.setBounds(80, 65, 40, 20);
            this.measurementSymbolText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementSymbolText.keyReleased, event=" + String.valueOf(evt));
                    MeasurementTypeTabItem.this.measurementSymbol = MeasurementTypeTabItem.this.measurementSymbolText.getText();
                    if (MeasurementTypeTabItem.this.measurementType != null) {
                        MeasurementTypeTabItem.this.measurementType.setSymbol(MeasurementTypeTabItem.this.measurementSymbol);
                        MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.measurementUnitLabel = new Label(this.measurementsComposite, 131072);
            this.measurementUnitLabel.setText(Messages.getString("GDE_MSGT0551"));
            this.measurementUnitLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementUnitLabel.setBounds(10, 90, 60, 20);
            this.measurementUnitText = new Text(this.measurementsComposite, 2048);
            this.measurementUnitText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementUnitText.setBounds(80, 90, 40, 20);
            this.measurementUnitText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementUnitText.keyReleased, event=" + String.valueOf(evt));
                    MeasurementTypeTabItem.this.measurementUnit = MeasurementTypeTabItem.this.measurementUnitText.getText();
                    if (MeasurementTypeTabItem.this.measurementType != null) {
                        MeasurementTypeTabItem.this.measurementType.setUnit(MeasurementTypeTabItem.this.measurementUnit);
                        MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.measurementEnableLabel = new Label(this.measurementsComposite, 131072);
            this.measurementEnableLabel.setText(Messages.getString("GDE_MSGT0531"));
            this.measurementEnableLabel.setToolTipText(Messages.getString("GDE_MSGT0532"));
            this.measurementEnableLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementEnableLabel.setBounds(3, 115, 67, 20);
            this.measurementActiveButton = new Button(this.measurementsComposite, 32);
            this.measurementActiveButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.measurementActiveButton.setBounds(80, 115, 20, 20);
            this.measurementActiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementEnableButton.widgetSelected, event=" + String.valueOf(evt));
                    MeasurementTypeTabItem.this.isMeasurementActive = MeasurementTypeTabItem.this.measurementActiveButton.getSelection();
                    if (MeasurementTypeTabItem.this.measurementType != null) {
                        MeasurementTypeTabItem.this.measurementType.setActive(MeasurementTypeTabItem.this.isMeasurementActive);
                        MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.channelConfigMeasurementPropertiesTabFolder = new CTabFolder(this.measurementsComposite, 2048);
            this.channelConfigMeasurementPropertiesTabFolder.setBounds(237, 0, 424, 274);
            this.channelConfigMeasurementPropertiesTabFolder.setSelection(0);
            this.channelConfigMeasurementPropertiesTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void restore(CTabFolderEvent evt) {
                    log.log(java.util.logging.Level.FINE, "channelConfigMeasurementPropertiesTabFolder.restore, event=" + String.valueOf(evt));
                    ((CTabItem)evt.item).getControl();
                }

                public void close(CTabFolderEvent evt) {
                    log.log(java.util.logging.Level.FINE, "channelConfigMeasurementPropertiesTabFolder.close, event=" + String.valueOf(evt));
                    CTabItem tabItem = (CTabItem)evt.item;
                    if (MeasurementTypeTabItem.this.deviceConfig != null) {
                        if (tabItem.getText().equals(Messages.getString("GDE_MSGT0350"))) {
                            MeasurementTypeTabItem.this.measurementType.setStatistics(null);
                            MeasurementTypeTabItem.this.deviceConfig.setChangePropery(true);
                        } else if (tabItem.getText().equals(Messages.getString("GDE_MSGT0530"))) {
                            for (int j = 0; j < MeasurementTypeTabItem.this.measurementType.getProperty().size(); ++j) {
                                MeasurementTypeTabItem.this.measurementType.getProperty().remove(j);
                                MeasurementTypeTabItem.this.deviceConfig.setChangePropery(true);
                            }
                            MeasurementTypeTabItem.this.deviceConfig.setChangePropery(true);
                        }
                        MeasurementTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    tabItem.dispose();
                }
            });
            this.measurementsComposite.layout();
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void enableContextMenu(boolean enable) {
        log.log(java.util.logging.Level.FINE, "MeasurementTypeTabItem.this.enableContextMenu " + enable);
        if (enable && (this.popupMenu == null || this.contextMenu == null)) {
            this.popupMenu = new Menu((Decorations)this.channelConfigMeasurementPropertiesTabFolder.getShell(), 8);
            this.contextMenu = new MeasurementContextmenu(this.popupMenu, this, this.channelConfigMeasurementPropertiesTabFolder);
            this.contextMenu.create();
            this.measurementsComposite.setMenu(this.popupMenu);
            this.measurementTypeLabel.setMenu(this.popupMenu);
            this.measurementNameLabel.setMenu(this.popupMenu);
            this.measurementSymbolLabel.setMenu(this.popupMenu);
            this.measurementUnitLabel.setMenu(this.popupMenu);
            this.measurementEnableLabel.setMenu(this.popupMenu);
            this.channelConfigMeasurementPropertiesTabFolder.setMenu(this.popupMenu);
        } else if (!enable && this.popupMenu != null) {
            this.popupMenu.dispose();
            this.popupMenu = null;
            this.contextMenu = null;
        }
    }

    private void createMeasurementPropertyTabItemWithSubTabFolder() {
        this.measurementPropertiesTabItem = new CTabItem(this.channelConfigMeasurementPropertiesTabFolder, 64);
        this.measurementPropertiesTabItem.setText(Messages.getString("GDE_MSGT0530"));
        this.measurementPropertiesTabItem.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.channelConfigMeasurementPropertiesTabFolder.setSelection(this.measurementPropertiesTabItem);
        this.measurementPropertiesTabFolder = new CTabFolder((Composite)this.channelConfigMeasurementPropertiesTabFolder, 0);
        this.measurementPropertiesTabItem.setControl((Control)this.measurementPropertiesTabFolder);
    }

    public PropertyTypeTabItem createMeasurementPropertyTabItem(String propertyTabItemName) {
        if (this.measurementPropertiesTabFolder == null || this.measurementPropertiesTabFolder.isDisposed()) {
            this.createMeasurementPropertyTabItemWithSubTabFolder();
        }
        PropertyTypeTabItem tmpPropertyTypeTabItem = new PropertyTypeTabItem(this.measurementPropertiesTabFolder, 64, propertyTabItemName, this);
        if (this.deviceConfig != null) {
            PropertyType tmpPropertyType = new ObjectFactory().createPropertyType();
            tmpPropertyType.setName(propertyTabItemName);
            switch (MeasurementPropertyTypes.fromValue(propertyTabItemName)) {
                case OFFSET: {
                    tmpPropertyType.setType(DataTypes.DOUBLE);
                    tmpPropertyType.setValue(Double.valueOf("0.0"));
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0535"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.DOUBLE.value()}, true);
                    break;
                }
                case FACTOR: {
                    tmpPropertyType.setType(DataTypes.DOUBLE);
                    tmpPropertyType.setValue(1.0);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0536"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.DOUBLE.value()}, true);
                    break;
                }
                case REDUCTION: {
                    tmpPropertyType.setType(DataTypes.DOUBLE);
                    tmpPropertyType.setValue(0.0);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0537"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.DOUBLE.value()}, true);
                    break;
                }
                case DO_SUBTRACT_FIRST: {
                    tmpPropertyType.setType(DataTypes.BOOLEAN);
                    tmpPropertyType.setValue(true);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0596"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.BOOLEAN.value()}, true);
                    break;
                }
                case DO_SUBTRACT_LAST: {
                    tmpPropertyType.setType(DataTypes.BOOLEAN);
                    tmpPropertyType.setValue(true);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0597"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.BOOLEAN.value()}, true);
                    break;
                }
                case REGRESSION_INTERVAL_SEC: {
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue(15);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0538"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case REGRESSION_TYPE_CURVE: {
                    tmpPropertyType.setName(MeasurementPropertyTypes.REGRESSION_TYPE.value());
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue(MeasurementPropertyTypes.REGRESSION_TYPE_CURVE.value());
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0539"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.STRING.value()}, true);
                    break;
                }
                case REGRESSION_TYPE_LINEAR: {
                    tmpPropertyType.setName(MeasurementPropertyTypes.REGRESSION_TYPE.value());
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue(MeasurementPropertyTypes.REGRESSION_TYPE_LINEAR.value());
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0540"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.STRING.value()}, true);
                    break;
                }
                case NUMBER_MOTOR: {
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue(1);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0541"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case NUMBER_CELLS: {
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue(3);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0543"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case PROP_N_100_W: {
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue(3400);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0544"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case IS_INVERT_CURRENT: {
                    tmpPropertyType.setType(DataTypes.BOOLEAN);
                    tmpPropertyType.setValue(false);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0545"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.BOOLEAN.value()}, true);
                    break;
                }
                case REVOLUTION_FACTOR: {
                    tmpPropertyType.setType(DataTypes.DOUBLE);
                    tmpPropertyType.setValue(1.0);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0546"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.DOUBLE.value()}, true);
                    break;
                }
                case SCALE_SYNC_REF_ORDINAL: {
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue(3400);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0607"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR: {
                    tmpPropertyType.setType(DataTypes.DOUBLE);
                    tmpPropertyType.setValue(2.0);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0608"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case GOOGLE_EARTH_VELOCITY_LOWER_LIMIT: {
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue(20);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0609"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case GOOGLE_EARTH_VELOCITY_UPPER_LIMIT: {
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue(100);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0610"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.INTEGER.value()}, true);
                    break;
                }
                case FILTER_FACTOR: {
                    tmpPropertyType.setType(DataTypes.DOUBLE);
                    tmpPropertyType.setValue(50.0);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0602"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.DOUBLE.value()}, true);
                    break;
                }
                case DATA_TYPE: {
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue(Record.DataType.DEFAULT.value());
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0680"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, false, null, new String[]{DataTypes.STRING.value()}, true);
                    break;
                }
                default: {
                    tmpPropertyType.setType(DataTypes.DOUBLE);
                    tmpPropertyType.setValue(1.0);
                    tmpPropertyType.setDescription(Messages.getString("GDE_MSGT0547"));
                    tmpPropertyTypeTabItem.setProperty(this.deviceConfig, tmpPropertyType, true, MeasurementPropertyTypes.valuesAsStingArray(), DataTypes.valuesAsStingArray(), true);
                }
            }
            this.measurementType.getProperty().add(tmpPropertyType);
            this.deviceConfig.setChangePropery(true);
            this.propsEditor.enableSaveButton(true);
        }
        if (this.channelConfigMeasurementPropertiesTabFolder.isVisible()) {
            this.channelConfigMeasurementPropertiesTabFolder.setSelection(this.measurementPropertiesTabItem);
            this.measurementPropertiesTabFolder.setSelection((CTabItem)tmpPropertyTypeTabItem);
        }
        return tmpPropertyTypeTabItem;
    }

    public StatisticsTypeTabItem createStatisticsTabItem() {
        StatisticsTypeTabItem tmpStatisticsTypeTabItem = this.statisticsTypeTabItem = new StatisticsTypeTabItem(this.channelConfigMeasurementPropertiesTabFolder, 320, Messages.getString("GDE_MSGT0350"), this);
        if (this.channelConfigMeasurementPropertiesTabFolder != null) {
            this.channelConfigMeasurementPropertiesTabFolder.setSelection((CTabItem)tmpStatisticsTypeTabItem);
        }
        if (this.measurementType.getStatistics() == null) {
            tmpStatisticsTypeTabItem.statisticsType = new StatisticsType();
            this.measurementType.setStatistics(tmpStatisticsTypeTabItem.statisticsType);
        }
        tmpStatisticsTypeTabItem.setStatisticsType(this.deviceConfig, this.measurementType.getStatistics(), this.channelConfigNumber);
        return tmpStatisticsTypeTabItem;
    }

    private void initialize() {
        if (this.measurementType != null) {
            this.measurementName = this.measurementType.getName();
            this.measurementNameText.setText(this.measurementName);
            this.measurementSymbol = this.measurementType.getSymbol();
            this.measurementSymbolText.setText(this.measurementSymbol);
            this.measurementUnit = this.measurementType.getUnit();
            this.measurementUnitText.setText(this.measurementUnit);
            this.isMeasurementActive = this.measurementType.isActive();
            this.measurementActiveButton.setSelection(this.isMeasurementActive);
        }
    }
}

