/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.data.RecordSet;
import gde.log.Level;
import gde.utils.LocalizedDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;

public class TimeSteps
extends Vector<Long> {
    static final String $CLASS_NAME = RecordSet.class.getName();
    static final long serialVersionUID = 26031957L;
    static final Logger log = Logger.getLogger(RecordSet.class.getName());
    final boolean isConstant;
    long startTimeStamp_ms = 0L;

    public TimeSteps(double newTimeStep_ms) {
        super(newTimeStep_ms < 0.0 ? 555 : 5);
        boolean bl = this.isConstant = newTimeStep_ms > 0.0;
        if (this.isConstant) {
            super.add(Double.valueOf(newTimeStep_ms * 10.0).longValue());
        }
        this.startTimeStamp_ms = new Date().getTime();
    }

    public TimeSteps(double newTimeStep_ms, int initialCapacity) {
        super(newTimeStep_ms < 0.0 ? initialCapacity : 5);
        boolean bl = this.isConstant = newTimeStep_ms > 0.0;
        if (this.isConstant) {
            super.add(Double.valueOf(newTimeStep_ms * 10.0).longValue());
        }
        this.startTimeStamp_ms = new Date().getTime();
    }

    private TimeSteps(TimeSteps toBeClonedTimeSteps) {
        super(toBeClonedTimeSteps);
        this.isConstant = toBeClonedTimeSteps.isConstant;
        this.startTimeStamp_ms = toBeClonedTimeSteps.startTimeStamp_ms;
    }

    private TimeSteps(TimeSteps toBeClonedTimeSteps, int index, boolean isFromBegin) {
        super(toBeClonedTimeSteps);
        this.clear();
        this.isConstant = toBeClonedTimeSteps.isConstant;
        if (!this.isConstant) {
            long l = this.startTimeStamp_ms = isFromBegin ? toBeClonedTimeSteps.startTimeStamp_ms + (Long)toBeClonedTimeSteps.get(index) / 10L : toBeClonedTimeSteps.startTimeStamp_ms;
            if (isFromBegin) {
                long cutOffVal = (Long)toBeClonedTimeSteps.get(index);
                for (int i = index; i < toBeClonedTimeSteps.elementCount; ++i) {
                    super.add((Long)toBeClonedTimeSteps.get(i) - cutOffVal);
                }
            } else {
                for (int i = 0; i < index; ++i) {
                    this.add((Long)toBeClonedTimeSteps.get(i));
                }
            }
        } else {
            this.startTimeStamp_ms = toBeClonedTimeSteps.startTimeStamp_ms;
            this.add((Long)toBeClonedTimeSteps.get(0));
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.toString());
        }
    }

    @Override
    public synchronized TimeSteps clone() {
        super.clone();
        return new TimeSteps(this);
    }

    public synchronized TimeSteps clone(int index, boolean isFromBegin) {
        return new TimeSteps(this, index, isFromBegin);
    }

    public double getDeltaTime(int indexStart, int indexEnd) {
        if (indexStart < 0) {
            log.log(Level.WARNING, "indexStart < 0 " + indexStart);
            indexStart = 0;
        }
        if (indexEnd > this.elementCount - 1) {
            log.log(Level.WARNING, "indexEnd > this.elementCount - 1 " + indexEnd);
            indexEnd = this.elementCount - 1;
        }
        indexEnd = indexEnd > this.elementCount - 1 ? this.elementCount - 1 : indexEnd;
        return (double)((Long)this.get(indexEnd) - (Long)this.get(indexStart)) / 10.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTime_ms(int index) {
        TimeSteps timeSteps = this;
        synchronized (timeSteps) {
            return this.isConstant ? (index == 0 ? 0.0 : (double)((Long)this.get(0)).longValue() / 10.0 * (double)index) : (index < 0 ? (double)((Long)this.firstElement()).longValue() : (index > this.elementCount - 1 ? (double)((Long)this.lastElement()).longValue() / 10.0 : (double)((Long)this.get(index)).longValue() / 10.0));
        }
    }

    public String getFormattedTime(LocalizedDateTime.DateTimePattern formatPattern, int index) {
        return String.format("%25s", LocalizedDateTime.getFormatedTime(formatPattern, this.startTimeStamp_ms + (long)this.getTime_ms(index)));
    }

    public String getFormattedDuration(LocalizedDateTime.DurationPattern formatPattern, int index) {
        return String.format("%25s", LocalizedDateTime.getFormatedDuration(formatPattern, (long)this.getTime_ms(index)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addRaw(long time_100ns) {
        TimeSteps timeSteps = this;
        synchronized (timeSteps) {
            return this.isConstant ? true : super.add(time_100ns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean add(double value_ms) {
        TimeSteps timeSteps = this;
        synchronized (timeSteps) {
            return this.isConstant ? true : super.add((long)(value_ms * 10.0));
        }
    }

    public double getAverageTimeStep_ms() {
        try {
            return this.isConstant ? this.getTime_ms(1) : (double)((Long)this.lastElement()).longValue() / (double)this.elementCount / 10.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getMinimumTimeStep_ms() {
        if (this.isConstant) {
            return (long)this.getTime_ms(1);
        }
        if (this.size() == 0) {
            return 0.0;
        }
        long minValue = (Long)this.get(0) - 0L;
        for (int i = 1; i < this.elementCount; ++i) {
            long diff = (Long)this.get(i) - (Long)this.get(i - 1);
            if (minValue <= diff) continue;
            minValue = diff;
        }
        log.log(Level.FINE, String.format("min=%d  avg=%f", minValue / 10L, this.getAverageTimeStep_ms()));
        return (double)minValue / 10.0;
    }

    public double getMaximumTimeStep_ms() {
        if (this.isConstant) {
            return (long)this.getTime_ms(1);
        }
        if (this.size() == 0) {
            return 0.0;
        }
        long maxValue = (Long)this.get(0) - 0L;
        for (int i = 1; i < this.elementCount; ++i) {
            long diff = (Long)this.get(i) - (Long)this.get(i - 1);
            if (maxValue >= diff) continue;
            maxValue = diff;
        }
        log.log(Level.FINE, String.format("max=%d  avg=%f", maxValue / 10L, this.getAverageTimeStep_ms()));
        return (double)maxValue / 10.0;
    }

    public double getSigmaTimeStep_ms() {
        if (this.isConstant) {
            return 0.0;
        }
        if (this.size() <= 1) {
            return 0.0;
        }
        long baseTimeSpan = (long)this.getAverageTimeStep_ms();
        double sqSum = ((Long)this.get(0) - 0L - baseTimeSpan) * ((Long)this.get(0) - 0L - baseTimeSpan);
        for (int i = 1; i < this.elementCount; ++i) {
            long diff = (Long)this.get(i) - (Long)this.get(i - 1);
            sqSum += (double)((diff - baseTimeSpan) * (diff - baseTimeSpan));
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("avg=%f  sigma=%f", this.getAverageTimeStep_ms(), Math.sqrt(sqSum / (double)(this.elementCount - 1)) / 10.0));
        }
        return Math.sqrt(sqSum / (double)(this.elementCount - 1)) / 10.0;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public double getMaxTime_ms() {
        double maxTime = 0.0;
        maxTime = this.isConstant ? (double)((Long)this.get(0)).longValue() / 10.0 : (this.elementCount > 1 ? (double)((Long)this.lastElement()).longValue() / 10.0 : 0.0);
        return maxTime;
    }

    public int[] findBoundingIndexes(double time_ms) {
        int index2;
        int index1 = 0;
        if (time_ms > 0.0 && this.elementCount > 0) {
            if (this.isConstant) {
                double position = time_ms / ((double)((Long)this.get(0)).longValue() / 10.0);
                index1 = (int)position;
                index2 = (int)(position + 0.5);
            } else {
                int value = Double.valueOf(time_ms * 10.0).intValue();
                for (index2 = 0; index2 < this.elementCount - 1; ++index2) {
                    if ((long)value == (Long)this.get(index2)) {
                        index1 = index2;
                        break;
                    }
                    if ((long)value < (Long)this.get(index2)) {
                        index1 = index2 > 0 ? index2 - 1 : 0;
                        break;
                    }
                    index1 = index2 + 1;
                }
            }
        }
        return new int[]{index1, index2};
    }

    public int findBestIndex(double time_ms) {
        int index = 0;
        if (time_ms > 0.0) {
            double position = 0.0;
            if (this.isConstant) {
                position = time_ms / ((double)((Long)this.get(0)).longValue() / 10.0);
                index = (int)(position + 0.5);
            } else {
                int value = Double.valueOf(time_ms * 10.0).intValue();
                index = (int)(time_ms / ((double)((Long)this.lastElement()).longValue() / (double)(this.elementCount - 1) / 10.0) / 2.0);
                int n = index = index < this.elementCount && (long)value < (Long)this.get(index) ? 0 : index;
                while (index < this.elementCount && (long)value > (Long)this.get(index)) {
                    ++index;
                }
                if (index + 1 <= this.elementCount && index > 0 && (long)value <= ((Long)this.get(index) + (Long)this.get(index - 1)) / 2L) {
                    --index;
                }
            }
        }
        return index;
    }

    public synchronized int getBestIndex(double time_ms, Comparator<Long> comparator) {
        int index = 0;
        if (!this.isEmpty()) {
            if (this.isConstant) {
                if (time_ms > 0.0) {
                    double position = time_ms / ((double)((Long)this.get(0)).longValue() / 10.0);
                    index = (int)(position + 0.5);
                }
            } else {
                long value_ms = (long)(time_ms * 10.0);
                int result = Collections.binarySearch(this, value_ms, comparator);
                if (result >= 0) {
                    index = result;
                } else {
                    index = Math.abs(result + 2);
                    if (index < this.size() - 1 && comparator.compare(value_ms, ((Long)this.get(index + 1) + (Long)this.get(index)) / 2L) > 0) {
                        ++index;
                    }
                }
            }
        }
        return index;
    }

    public void setStartTimeStamp(long newStartTimeStamp_ms) {
        this.startTimeStamp_ms = newStartTimeStamp_ms;
    }

    public long getStartTimeStamp() {
        return this.startTimeStamp_ms;
    }
}

