/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    NSTableColumn nsColumn;
    Tree parent;
    String toolTipText;
    String displayText;
    boolean movable;
    static final int MARGIN = 2;

    public TreeColumn(Tree parent, int style) {
        super(parent, TreeColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.columnCount);
    }

    public TreeColumn(Tree parent, int style, int index) {
        super(parent, TreeColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TreeColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsColumn.headerCell());
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    void drawInteriorWithFrame_inView(long id2, long sel, NSRect cellRect, long view) {
        NSRect destRect;
        NSColor color;
        double borderWidth;
        int columnIndex = this.parent.indexOf(this.nsColumn);
        NSRect headerRect = this.parent.headerView.headerRectOfColumn(columnIndex);
        double d = borderWidth = this.parent.hasBorder() ? 0.5 : 0.0;
        if (headerRect.x != cellRect.x || headerRect.width != cellRect.width) {
            if (this.parent.headerBackground != null) {
                NSGraphicsContext context = NSGraphicsContext.currentContext();
                context.saveGraphicsState();
                double[] colorRGB = this.parent.headerBackground;
                NSColor color2 = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 1.0);
                color2.setFill();
                NSRect rect = new NSRect();
                rect.x = cellRect.x;
                rect.y = headerRect.y + borderWidth;
                rect.width = cellRect.width;
                rect.height = headerRect.height - borderWidth - 0.5;
                NSBezierPath.fillRect(rect);
                context.restoreGraphicsState();
            }
            return;
        }
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        context.saveGraphicsState();
        int contentWidth = 0;
        NSSize stringSize = null;
        NSSize imageSize = null;
        NSAttributedString attrString = null;
        NSTableHeaderCell headerCell = this.nsColumn.headerCell();
        if (this.displayText != null) {
            Font font = Font.cocoa_new(this.display, headerCell.font());
            attrString = this.parent.createString(this.displayText, font, this.parent.headerForeground, 16384, false, (this.parent.state & 8) == 0, false);
            stringSize = attrString.size();
            contentWidth = (int)((double)contentWidth + Math.ceil(stringSize.width));
            if (this.image != null) {
                contentWidth += 2;
            }
        }
        if (this.parent.headerBackground != null) {
            context.saveGraphicsState();
            double[] colorRGB = this.parent.headerBackground;
            NSColor color1 = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 1.0);
            color1.setFill();
            NSRect rect = new NSRect();
            rect.x = headerRect.x;
            rect.y = headerRect.y + borderWidth;
            rect.width = headerRect.width;
            rect.height = headerRect.height - borderWidth - 0.5;
            NSBezierPath.fillRect(rect);
            if (this.parent.headerForeground != null) {
                colorRGB = this.parent.headerForeground;
                color = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 0.6f);
                color.setStroke();
            }
            NSBezierPath path2 = NSBezierPath.bezierPath();
            NSPoint pt = new NSPoint();
            pt.x = cellRect.x + cellRect.width - 0.5;
            pt.y = cellRect.y + 2.0;
            path2.moveToPoint(pt);
            pt.y += cellRect.y + cellRect.height - 4.0;
            path2.lineToPoint(pt);
            path2.stroke();
            context.restoreGraphicsState();
        }
        if (this.image != null) {
            imageSize = this.image.handle.size();
            contentWidth = (int)((double)contentWidth + Math.ceil(imageSize.width));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            boolean ascending;
            boolean bl = ascending = this.parent.sortDirection == 128;
            if (this.parent.headerBackground != null || this.parent.headerForeground != null) {
                NSRect sortIndicatorRect = headerCell.sortIndicatorRectForBounds(cellRect);
                context.saveGraphicsState();
                if (this.parent.headerForeground != null) {
                    double[] colorRGB = this.parent.headerForeground;
                    color = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 0.9f);
                    color.setStroke();
                }
                NSBezierPath path3 = NSBezierPath.bezierPath();
                path3.setLineWidth(1.5);
                NSPoint pt = new NSPoint();
                double y1 = sortIndicatorRect.y + sortIndicatorRect.height / 2.0 - 1.5;
                double y2 = sortIndicatorRect.y + sortIndicatorRect.height / 2.0 + 1.5;
                double x1 = sortIndicatorRect.x;
                double x2 = sortIndicatorRect.x + 3.0;
                double x3 = sortIndicatorRect.x + 6.0;
                if (ascending) {
                    pt.x = x1;
                    pt.y = y2;
                    path3.moveToPoint(pt);
                    pt.x = x2;
                    pt.y = y1;
                    path3.lineToPoint(pt);
                    pt.x = x3;
                    pt.y = y2;
                    path3.lineToPoint(pt);
                } else {
                    pt.x = x1;
                    pt.y = y1;
                    path3.moveToPoint(pt);
                    pt.x = x2;
                    pt.y = y2;
                    path3.lineToPoint(pt);
                    pt.x = x3;
                    pt.y = y1;
                    path3.lineToPoint(pt);
                }
                path3.stroke();
                context.restoreGraphicsState();
            } else {
                headerCell.drawSortIndicatorWithFrame(cellRect, new NSView(view), ascending, 0L);
            }
            NSRect sortRect = headerCell.sortIndicatorRectForBounds(cellRect);
            cellRect.width = Math.max(0.0, sortRect.x - cellRect.x);
        }
        int drawX = 0;
        drawX = (this.style & 0x1000000) != 0 ? (int)(cellRect.x + Math.max(2.0, (cellRect.width - (double)contentWidth) / 2.0)) : ((this.style & 0x20000) != 0 ? (int)(cellRect.x + Math.max(2.0, cellRect.width - (double)contentWidth - 2.0)) : (int)cellRect.x + 2);
        if (this.image != null) {
            destRect = new NSRect();
            destRect.x = drawX;
            destRect.y = cellRect.y;
            destRect.width = Math.min(imageSize.width, cellRect.width - 4.0);
            destRect.height = Math.min(imageSize.height, cellRect.height);
            boolean isFlipped = new NSView(view).isFlipped();
            if (isFlipped) {
                context.saveGraphicsState();
                NSAffineTransform transform2 = NSAffineTransform.transform();
                transform2.scaleXBy(1.0, -1.0);
                transform2.translateXBy(0.0, -(destRect.height + 2.0 * destRect.y));
                transform2.concat();
            }
            NSRect sourceRect = new NSRect();
            sourceRect.width = destRect.width;
            sourceRect.height = destRect.height;
            this.image.handle.drawInRect(destRect, sourceRect, 2L, 1.0);
            if (isFlipped) {
                context.restoreGraphicsState();
            }
            drawX = (int)((double)drawX + destRect.width);
        }
        if (this.displayText != null && this.displayText.length() > 0) {
            if (this.image != null) {
                drawX += 2;
            }
            destRect = new NSRect();
            destRect.x = drawX;
            destRect.y = cellRect.y;
            destRect.width = Math.min(stringSize.width, cellRect.x + cellRect.width - 2.0 - (double)drawX);
            destRect.height = Math.min(stringSize.height, cellRect.height);
            attrString.drawInRect(destRect);
        }
        if (attrString != null) {
            attrString.release();
        }
        context.restoreGraphicsState();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.movable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.nsColumn.resizingMask() != 0L;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int width = (int)this.nsColumn.width();
        if (width > 0) {
            ++width;
        }
        return width;
    }

    public void pack() {
        this.checkWidget();
        int width = 0;
        NSTableHeaderCell headerCell = this.nsColumn.headerCell();
        NSSize size = headerCell.cellSize();
        width = (int)((double)width + Math.ceil(size.width));
        if (this.image != null) {
            NSSize imageSize = this.image.handle.size();
            width = (int)((double)width + (Math.ceil(imageSize.width) + 2.0));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            NSRect sortRect = headerCell.sortIndicatorRectForBounds(new NSRect());
            width = (int)((double)width + Math.ceil(sortRect.width + 4.0));
        }
        GC gc = new GC(this.parent);
        width = Math.max(width, this.parent.calculateWidth(this.parent.items, this.parent.indexOf(this), gc, true));
        gc.dispose();
        this.setWidth(width);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsColumn != null) {
            this.nsColumn.headerCell().release();
            this.nsColumn.release();
        }
        this.nsColumn = null;
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener2);
        this.eventTable.unhook(11, listener2);
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        NSOutlineView outlineView = (NSOutlineView)this.parent.view;
        NSTableHeaderView headerView = outlineView.headerView();
        if (headerView == null) {
            return;
        }
        index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
        rect = outlineView.rectOfColumn(index);
        this.parent.view.setNeedsDisplayInRect(rect);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        NSTableHeaderView headerView = ((NSOutlineView)this.parent.view).headerView();
        if (headerView == null) {
            return;
        }
        int index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.movable = moveable;
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.nsColumn.setResizingMask(resizable ? 2 : 0);
    }

    @Override
    public void setText(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        super.setText(string2);
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        this.displayText = new String(buffer, 0, length);
        NSString title2 = NSString.stringWith(this.displayText);
        this.nsColumn.headerCell().setTitle(title2);
        NSTableHeaderView headerView = ((NSOutlineView)this.parent.view).headerView();
        if (headerView == null) {
            return;
        }
        int index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
    }

    public void setToolTipText(String string2) {
        this.checkWidget();
        this.toolTipText = string2;
        this.parent.checkToolTip(this);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width < 0) {
            return;
        }
        width = Math.max(0, width - 1);
        this.nsColumn.setWidth(width);
    }

    @Override
    String tooltipText() {
        return this.toolTipText;
    }
}

