/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableColumn
extends Accessible {
    public AccessibleTableColumn(Accessible accessible, int childID) {
        super(accessible);
        this.index = childID;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getLocation(AccessibleControlEvent e) {
                Accessible[] cells = AccessibleTableColumn.this.getColumnCells();
                AccessibleControlEvent event = new AccessibleControlEvent(this);
                event.childID = -1;
                event.width = -1;
                Accessible child = cells[0];
                int i2 = 0;
                while (i2 < child.accessibleControlListeners.size()) {
                    AccessibleControlListener listener2 = child.accessibleControlListeners.get(i2);
                    listener2.getLocation(event);
                    ++i2;
                }
                int height = 0;
                int width = 0;
                int j = 0;
                while (j < cells.length) {
                    NSValue sizeObj = (NSValue)cells[j].getSizeAttribute(-1);
                    NSSize size = sizeObj.sizeValue();
                    if (size.width > (double)width) {
                        width = (int)size.width;
                    }
                    height = (int)((double)height + size.height);
                    ++j;
                }
                e.x = event.x;
                e.y = event.y;
                e.width = width;
                e.height = height;
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                e.detail = 27;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            @Override
            public void getRowCount(AccessibleTableEvent e) {
                e.count = AccessibleTableColumn.this.getColumnCells().length;
            }

            @Override
            public void getRow(AccessibleTableEvent e) {
                int index = e.row;
                Accessible[] children = AccessibleTableColumn.this.getColumnCells();
                int count = children.length;
                if (index >= 0 && index < count) {
                    e.accessible = children[index];
                }
            }

            @Override
            public void getRows(AccessibleTableEvent e) {
                e.accessibles = AccessibleTableColumn.this.getColumnCells();
            }
        });
    }

    private Accessible[] getColumnCells() {
        int validRowCount = Math.max(1, this.parent.getRowCount());
        Accessible[] cells = new Accessible[validRowCount];
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i2 = 0;
        while (i2 < validRowCount) {
            event.column = this.index;
            event.row = i2;
            int j = 0;
            while (j < this.parent.accessibleTableListeners.size()) {
                AccessibleTableListener listener2 = this.parent.accessibleTableListeners.get(j);
                listener2.getCell(event);
                ++j;
            }
            cells[i2] = event.accessible;
            ++i2;
        }
        return cells;
    }
}

