/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

public class RectangularCholeskyDecomposition {
    private final RealMatrix root;
    private int rank;

    public RectangularCholeskyDecomposition(RealMatrix matrix) throws NonPositiveDefiniteMatrixException {
        this(matrix, 0.0);
    }

    public RectangularCholeskyDecomposition(RealMatrix matrix, double small) throws NonPositiveDefiniteMatrixException {
        int order = matrix.getRowDimension();
        double[][] c = matrix.getData();
        double[][] b = new double[order][order];
        int[] index = new int[order];
        for (int i2 = 0; i2 < order; ++i2) {
            index[i2] = i2;
        }
        int r = 0;
        boolean loop = true;
        while (loop) {
            double sqrt;
            int ir;
            int swapR = r;
            for (int i3 = r + 1; i3 < order; ++i3) {
                int ii = index[i3];
                int isr = index[swapR];
                if (!(c[ii][ii] > c[isr][isr])) continue;
                swapR = i3;
            }
            if (swapR != r) {
                int tmpIndex = index[r];
                index[r] = index[swapR];
                index[swapR] = tmpIndex;
                double[] tmpRow = b[r];
                b[r] = b[swapR];
                b[swapR] = tmpRow;
            }
            if (c[ir = index[r]][ir] <= small) {
                if (r == 0) {
                    throw new NonPositiveDefiniteMatrixException(c[ir][ir], ir, small);
                }
                for (int i4 = r; i4 < order; ++i4) {
                    if (!(c[index[i4]][index[i4]] < -small)) continue;
                    throw new NonPositiveDefiniteMatrixException(c[index[i4]][index[i4]], i4, small);
                }
                loop = false;
                continue;
            }
            b[r][r] = sqrt = FastMath.sqrt(c[ir][ir]);
            double inverse = 1.0 / sqrt;
            double inverse2 = 1.0 / c[ir][ir];
            for (int i5 = r + 1; i5 < order; ++i5) {
                double e;
                int ii = index[i5];
                b[i5][r] = e = inverse * c[ii][ir];
                double[] dArray = c[ii];
                int n = ii;
                dArray[n] = dArray[n] - c[ii][ir] * c[ii][ir] * inverse2;
                for (int j = r + 1; j < i5; ++j) {
                    double f;
                    int ij = index[j];
                    c[ii][ij] = f = c[ii][ij] - e * b[j][r];
                    c[ij][ii] = f;
                }
            }
            loop = ++r < order;
        }
        this.rank = r;
        this.root = MatrixUtils.createRealMatrix(order, r);
        for (int i6 = 0; i6 < order; ++i6) {
            for (int j = 0; j < r; ++j) {
                this.root.setEntry(index[i6], j, b[i6][j]);
            }
        }
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }
}

