/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.util;

import de.treichels.hott.util.LogFormatterKt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lde/treichels/hott/util/LogFormatter;", "Ljava/util/logging/Formatter;", "()V", "format", "", "record", "Ljava/util/logging/LogRecord;", "getStackTrace", "t", "", "Companion", "HoTT-Util"})
public final class LogFormatter
extends Formatter {
    private static final long start;
    public static final Companion Companion;

    @NotNull
    public final String getStackTrace(@NotNull Throwable t) {
        Intrinsics.checkParameterIsNotNull(t, "t");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "stringWriter.toString()");
        return string2;
    }

    @Override
    @NotNull
    public String format(@Nullable LogRecord record) {
        String string2;
        Object[] objectArray;
        if (record == null) {
            return "";
        }
        long now = record.getMillis() - start;
        Object[] parameters2 = record.getParameters();
        if (parameters2 == null || (objectArray = parameters2).length == 0) {
            String string3 = record.getMessage();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "record.message");
        } else {
            String string4 = MessageFormat.format(record.getMessage(), Arrays.copyOf(parameters2, parameters2.length));
            string2 = string4;
            Intrinsics.checkExpressionValueIsNotNull(string4, "MessageFormat.format(record.message, *parameters)");
        }
        String message2 = string2;
        String string5 = LogFormatterKt.getThreadById(record.getThreadID()).getName();
        Intrinsics.checkExpressionValueIsNotNull(string5, "getThreadById(record.threadID).name");
        String threadName = string5;
        String string6 = record.getSourceClassName();
        Intrinsics.checkExpressionValueIsNotNull(string6, "record.sourceClassName");
        String className = string6;
        String string7 = record.getSourceMethodName();
        Intrinsics.checkExpressionValueIsNotNull(string7, "record.sourceMethodName");
        String methodName = string7;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string8 = "----------------------------------------------------------%n%d [%s] %s.%s%n%s%n";
        Object[] objectArray2 = new Object[]{now, threadName, className, methodName, message2};
        String string9 = String.format(string8, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string9, "java.lang.String.format(format, *args)");
        String result2 = string9;
        Throwable throwable = record.getThrown();
        return throwable != null ? result2 + this.getStackTrace(throwable) : result2;
    }

    static {
        Companion = new Companion(null);
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkExpressionValueIsNotNull(runtimeMXBean, "ManagementFactory.getRuntimeMXBean()");
        start = runtimeMXBean.getStartTime();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/treichels/hott/util/LogFormatter$Companion;", "", "()V", "start", "", "HoTT-Util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

