/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.security.CertificateUtil;
import com.itextpdf.text.pdf.security.CrlClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrlClientOnline
implements CrlClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrlClientOnline.class);
    protected List<URL> urls = new ArrayList<URL>();

    public CrlClientOnline() {
    }

    public CrlClientOnline(String ... crls) {
        for (String url : crls) {
            this.addUrl(url);
        }
    }

    public CrlClientOnline(URL ... crls) {
        for (URL url : this.urls) {
            this.addUrl(url);
        }
    }

    public CrlClientOnline(Certificate[] chain) {
        for (int i2 = 0; i2 < chain.length; ++i2) {
            X509Certificate cert = (X509Certificate)chain[i2];
            LOGGER.info("Checking certificate: " + cert.getSubjectDN());
            try {
                this.addUrl(CertificateUtil.getCRLURL(cert));
                continue;
            }
            catch (CertificateParsingException e) {
                LOGGER.info("Skipped CRL url (certificate could not be parsed)");
            }
        }
    }

    protected void addUrl(String url) {
        try {
            this.addUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            LOGGER.info("Skipped CRL url (malformed): " + url);
        }
    }

    protected void addUrl(URL url) {
        if (this.urls.contains(url)) {
            LOGGER.info("Skipped CRL url (duplicate): " + url);
            return;
        }
        this.urls.add(url);
        LOGGER.info("Added CRL url: " + url);
    }

    @Override
    public Collection<byte[]> getEncoded(X509Certificate checkCert, String url) {
        if (checkCert == null) {
            return null;
        }
        ArrayList<URL> urllist = new ArrayList<URL>(this.urls);
        if (urllist.size() == 0) {
            LOGGER.info("Looking for CRL for certificate " + checkCert.getSubjectDN());
            try {
                if (url == null) {
                    url = CertificateUtil.getCRLURL(checkCert);
                }
                if (url == null) {
                    throw new NullPointerException();
                }
                urllist.add(new URL(url));
                LOGGER.info("Found CRL url: " + url);
            }
            catch (Exception e) {
                LOGGER.info("Skipped CRL url: " + e.getMessage());
            }
        }
        ArrayList<byte[]> ar = new ArrayList<byte[]>();
        for (URL urlt : urllist) {
            try {
                int n;
                LOGGER.info("Checking CRL: " + urlt);
                HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
                if (con.getResponseCode() / 100 != 2) {
                    throw new IOException(MessageLocalization.getComposedMessage("invalid.http.response.1", con.getResponseCode()));
                }
                InputStream inp = (InputStream)con.getContent();
                byte[] buf = new byte[1024];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((n = inp.read(buf, 0, buf.length)) > 0) {
                    bout.write(buf, 0, n);
                }
                inp.close();
                ar.add(bout.toByteArray());
                LOGGER.info("Added CRL found at: " + urlt);
            }
            catch (Exception e) {
                LOGGER.info("Skipped CRL: " + e.getMessage() + " for " + urlt);
            }
        }
        return ar;
    }
}

