/*
 * Decompiled with CFR 0.152.
 */
package gde.device.conrad;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.exception.TimeOutException;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VC800SerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = VC800SerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    boolean isInSync = false;
    static final int xferErrorLimit = 10;

    public VC800SerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[14];
        byte[] answer = new byte[14];
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            answer = this.read(answer, 5000);
            while ((answer[0] & 0xF0) != 16 && (answer[13] & 0xF0) != 224) {
                this.isInSync = false;
                for (int i = 0; i < answer.length; ++i) {
                    if ((answer[i] & 0xF0) != 224) continue;
                    System.arraycopy(answer, i + 1, data, 0, 13 - i);
                    answer = new byte[i + 1];
                    answer = this.read(answer, 3000);
                    System.arraycopy(answer, 0, data, 14 - i, i);
                    this.isInSync = true;
                    log.logp(gde.log.Level.FINE, $CLASS_NAME, "getData", "----> receive sync finished");
                    break;
                }
                if (this.isInSync) break;
                answer = new byte[14];
                answer = this.read(answer, 3000);
            }
            if ((answer[0] & 0xF0) != 16 || (answer[13] & 0xF0) != 224) {
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> data start or end does not match, number of errors = " + this.getXferErrors());
                this.addXferError();
                if (this.getXferErrors() > 0 && this.getXferErrors() % 10 == 0) {
                    log.logp(Level.WARNING, $CLASS_NAME, "getData", "Number of tranfer error exceed the acceptable limit! number errors = " + this.getXferErrors());
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW0045", (Object[])new Object[]{"SerialPortException", this.getXferErrors()}));
                }
                data = this.getData();
            } else {
                System.arraycopy(answer, 0, data, 0, 14);
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.log(gde.log.Level.SEVERE, e.getMessage());
            }
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return data;
    }
}

