/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.skyrc.HitecX1Red;
import gde.device.skyrc.IMaxB6RDX1UsbPort;
import gde.device.skyrc.Modster;
import gde.device.skyrc.ModsterSingleGathererThread;
import gde.device.skyrc.ModsterUsbPort;
import gde.exception.ApplicationConfigurationException;
import gde.messages.Messages;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;

public class ModsterSingle
extends Modster
implements IDevice {
    static final Logger log = Logger.getLogger(ModsterSingle.class.getName());
    ModsterUsbPort usbPort;
    ModsterSingleGathererThread dataGatherThread;

    public ModsterSingle(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
        this.usbPort = new ModsterUsbPort(this, this.application);
    }

    public ModsterSingle(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.usbPort = new ModsterUsbPort(this, this.application);
    }

    @Override
    public void open_closeCommPort() {
        block21: {
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block21;
                        this.dataGatherThread = new ModsterSingleGathererThread(this.application, this, this.usbPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.dataGatherThread != null && this.usbPort.isConnected()) {
                                this.systemInfo[0] = new HitecX1Red.SystemInfo(this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), IMaxB6RDX1UsbPort.QuerySystemInfo.CHANNEL_A.value()));
                                this.systemSetting[0] = new HitecX1Red.SystemSetting(this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), IMaxB6RDX1UsbPort.QuerySystemSetting.CHANNEL_A.value()));
                                WaitTimer.delay((long)100L);
                                this.dataGatherThread.start();
                            }
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0050"));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        this.dataGatherThread.stopDataGatheringThread(false, null);
                    }
                    try {
                        WaitTimer.delay((long)1000L);
                        if (this.usbPort != null && this.usbPort.isConnected()) {
                            this.usbPort.closeUsbPort(null);
                        }
                    }
                    catch (UsbException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }
}

