/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.Analyzer;
import gde.Explorer;
import gde.GDE;
import gde.TestAnalyzer;
import gde.data.AbstractRecord;
import gde.data.AbstractRecordSet;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.TimeSteps;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.TriggerType;
import gde.device.resource.DeviceXmlResource;
import gde.exception.DataInconsitsentException;
import gde.histo.transitions.GroupTransitions;
import gde.histo.transitions.TransitionCollector;
import gde.histo.transitions.TransitionTableMapper;
import gde.io.LogViewReader;
import gde.io.OsdReaderWriter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.tab.GraphicsWindow;
import gde.utils.CalculationThread;
import gde.utils.CellVoltageValues;
import gde.utils.LocalizedDateTime;
import gde.utils.StringHelper;
import gde.utils.TimeLine;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

public final class RecordSet
extends AbstractRecordSet {
    static final String $CLASS_NAME = RecordSet.class.getName();
    static final long serialVersionUID = 26031957L;
    static final Logger log = Logger.getLogger(RecordSet.class.getName());
    protected final Channels channels;
    protected final IDevice device;
    protected final Channel parent;
    String[] noneCalculationRecords = new String[0];
    int noneCalculationRecordsCount = -1;
    boolean isSaved = false;
    boolean isRaw = false;
    boolean isFromFile = false;
    boolean isRecalculation = true;
    int fileDataSize = 0;
    int fileDataBytes = 0;
    long fileDataPointer = 0L;
    int xScaleStep = 0;
    Rectangle drawAreaBounds;
    protected double maxValue = -2.147483648E9;
    protected double minValue = 2.147483647E9;
    boolean isUtilitySet = false;
    double maxTime = 0.0;
    int zoomLevel = 0;
    boolean isZoomMode = false;
    boolean isScopeMode = false;
    int scopeModeOffset;
    int scopeModeSize;
    public static final String[] propertyKeys = new String[]{"timeStep_ms", "startTimeStamp", "RecordSet_horizontalGridRecordOrdinal", "RecordSet_horizontalGridRecord", "RecordSet_timeGridType", "RecordSet_timeGridLineStyle", "RecordSet_timeGridColor", "RecordSet_horizontalGridType", "RecordSet_horizontalGridLineStyle", "RecordSet_horizontalGridColor", "RecordSet_smoothAtCurrentDrop", "RecordSet_smoothVoltageCurve", "RecordSet_voltageLimits"};
    int configuredDisplayable = 0;
    public static final String UNSAVED_REASON_GRAPHICS = Messages.getString("GDE_MSGT0130");
    public static final String UNSAVED_REASON_DATA = Messages.getString("GDE_MSGT0131");
    public static final String UNSAVED_REASON_CONFIGURATION = Messages.getString("GDE_MSGT0132");
    public static final String UNSAVED_REASON_COMMENT = Messages.getString("GDE_MSGT0611");
    private final Analyzer analyzer;
    Vector<String> unsaveReasons = new Vector();
    int changeCounter = 0;
    private GroupTransitions histoTransitions;
    private String recordKeyMeasurement = "";

    private RecordSet(Analyzer analyzer, int channelNumber, String recordSetName, String[] measurementNames, boolean isRawValue, boolean isFromFileValue) {
        super(analyzer.getActiveDevice(), recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 40), measurementNames, new TimeSteps(analyzer.getActiveDevice().getTimeStep_ms(), 55));
        this.analyzer = analyzer;
        this.channels = analyzer.getChannels();
        this.device = analyzer.getActiveDevice();
        this.parent = (Channel)this.channels.get(channelNumber);
        this.isRaw = isRawValue;
        this.isFromFile = isFromFileValue;
        this.visibleAndDisplayableRecords = new Vector();
        this.displayRecords = new Vector();
        this.scaleSyncedRecords = new AbstractRecordSet.SyncedRecords(2);
    }

    public RecordSet(Analyzer analyzer, String newChannelName, String newName, double newTimeStep_ms, GraphicsWindow.GraphicsType graphicsType) {
        super(analyzer.getActiveDevice(), newName.length() <= 40 ? newName : newName.substring(0, 30), new String[0]);
        this.analyzer = analyzer;
        this.channels = null;
        this.device = analyzer.getActiveDevice();
        this.parent = null;
        this.isRaw = true;
        this.isCompareSet = GraphicsWindow.GraphicsType.COMPARE == graphicsType;
        this.isUtilitySet = GraphicsWindow.GraphicsType.UTIL == graphicsType;
        this.visibleAndDisplayableRecords = new Vector();
        this.displayRecords = new Vector();
        this.scaleSyncedRecords = new AbstractRecordSet.SyncedRecords(2);
    }

    private RecordSet(RecordSet recordSet, int channelConfigurationNumber) {
        super(recordSet);
        int i;
        this.analyzer = recordSet.analyzer.getReplica();
        this.channels = recordSet.channels;
        this.device = recordSet.device;
        this.parent = (Channel)this.channels.get(channelConfigurationNumber);
        String[] oldRecordNames = recordSet.recordNames;
        if (log.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            for (String string : oldRecordNames) {
                sb.append(string).append(" ");
            }
            log.log(Level.FINER, "oldRecordNames = " + sb.toString());
        }
        String[] newRecordNames = this.device.getMeasurementNamesReplacements(channelConfigurationNumber);
        if (log.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            for (String string : newRecordNames) {
                sb.append(string).append(" ");
            }
            log.log(Level.FINER, "newRecordNames = " + sb.toString());
        }
        for (i = 0; i < newRecordNames.length; ++i) {
            if (oldRecordNames[i].equals(newRecordNames[i])) continue;
            this.put(newRecordNames[i], this.get(oldRecordNames[i]).clone(newRecordNames[i]));
            this.remove(oldRecordNames[i]);
        }
        this.recordNames = (String[])newRecordNames.clone();
        for (i = 0; i < this.recordNames.length; ++i) {
            Record tmpRecord = this.get(this.recordNames[i]);
            tmpRecord.setParent(this);
            tmpRecord.statistics = this.device.getMeasurementStatistic(channelConfigurationNumber, i);
            if (tmpRecord.statistics == null) {
                log.log(Level.WARNING, "tmpRecord.statistics == null");
            }
            TriggerType tmpTrigger = tmpRecord.statistics != null ? tmpRecord.statistics.getTrigger() : null;
            tmpRecord.triggerIsGreater = tmpTrigger != null ? Boolean.valueOf(tmpTrigger.isGreater()) : null;
            tmpRecord.triggerLevel = tmpTrigger != null ? tmpTrigger.getLevel() : null;
            Integer n = tmpRecord.minTriggerTimeSec = tmpTrigger != null ? tmpTrigger.getMinTimeSec() : null;
            if (recordSet.get(this.recordNames[i]) != null) {
                tmpRecord.setProperties(recordSet.get(this.recordNames[i]).getProperties());
                continue;
            }
            tmpRecord.setProperties(this.device.getProperties(channelConfigurationNumber, i));
        }
        this.timeStep_ms = recordSet.timeStep_ms.clone(0, true);
        this.description = recordSet.description;
        this.isSaved = false;
        this.isRaw = recordSet.isRaw;
        this.isFromFile = recordSet.isFromFile;
        this.drawAreaBounds = recordSet.drawAreaBounds;
        this.isCompareSet = recordSet.isCompareSet;
        this.maxTime = recordSet.maxTime;
        this.maxValue = recordSet.maxValue;
        this.minValue = recordSet.minValue;
        this.zoomLevel = recordSet.zoomLevel;
        this.isZoomMode = recordSet.isZoomMode;
        this.recordKeyMeasurement = recordSet.recordKeyMeasurement;
        this.timeGridType = recordSet.timeGridType;
        this.timeGrid = new Vector(recordSet.timeGrid);
        this.timeGridColor = recordSet.timeGridColor;
        this.timeGridLineStyle = recordSet.timeGridLineStyle;
        this.valueGridType = recordSet.valueGridType;
        this.valueGrid = new Vector(recordSet.valueGrid);
        this.valueGridColor = recordSet.valueGridColor;
        this.valueGridLineStyle = recordSet.valueGridLineStyle;
        this.valueGridRecordOrdinal = recordSet.valueGridRecordOrdinal;
        this.configuredDisplayable = recordSet.configuredDisplayable;
        this.visibleAndDisplayableRecords = new Vector();
        this.displayRecords = new Vector();
        this.scaleSyncedRecords = new AbstractRecordSet.SyncedRecords(this.recordNames.length);
        this.syncScaleOfSyncableRecords();
    }

    public RecordSet clone(int channelConfiguationNumber) {
        return new RecordSet(this, channelConfiguationNumber);
    }

    private RecordSet(RecordSet recordSet, int dataIndex, boolean isFromBegin) {
        super(recordSet, DeviceXmlResource.getInstance().getReplacements((String[])recordSet.recordNames.clone()));
        String[] splitDescription;
        this.analyzer = recordSet.analyzer.getReplica();
        this.channels = recordSet.channels;
        this.device = recordSet.device;
        this.parent = recordSet.parent;
        for (String recordKey : this.recordNames) {
            this.put(recordKey, this.get(recordKey).clone(dataIndex, isFromBegin));
        }
        if (recordSet.timeStep_ms != null) {
            this.timeStep_ms = recordSet.timeStep_ms.clone(dataIndex, isFromBegin);
        }
        this.description = isFromBegin && recordSet.timeStep_ms != null && this.timeStep_ms != null ? ((splitDescription = recordSet.description.split(StringHelper.getFormatedTime("yyyy-MM-dd, HH:mm:ss", recordSet.timeStep_ms.getStartTimeStamp()))).length > 1 ? splitDescription[0] + StringHelper.getFormatedTime("yyyy-MM-dd, HH:mm:ss", this.timeStep_ms.getStartTimeStamp()) + splitDescription[1] : (splitDescription.length > 0 ? splitDescription[0] + StringHelper.getFormatedTime("yyyy-MM-dd, HH:mm:ss", this.timeStep_ms.getStartTimeStamp()) : recordSet.description)) : recordSet.description;
        this.isSaved = false;
        this.isRaw = recordSet.isRaw;
        this.isFromFile = recordSet.isFromFile;
        this.drawAreaBounds = recordSet.drawAreaBounds;
        this.isCompareSet = recordSet.isCompareSet;
        this.maxTime = recordSet.maxTime;
        this.maxValue = recordSet.maxValue;
        this.minValue = recordSet.minValue;
        this.zoomLevel = 0;
        this.isZoomMode = false;
        this.recordKeyMeasurement = recordSet.recordKeyMeasurement;
        this.timeGridType = recordSet.timeGridType;
        this.timeGrid = new Vector(recordSet.timeGrid);
        this.timeGridColor = recordSet.timeGridColor;
        this.timeGridLineStyle = recordSet.timeGridLineStyle;
        this.valueGridType = recordSet.valueGridType;
        this.valueGrid = new Vector(recordSet.valueGrid);
        this.valueGridColor = recordSet.valueGridColor;
        this.valueGridLineStyle = recordSet.valueGridLineStyle;
        this.valueGridRecordOrdinal = recordSet.valueGridRecordOrdinal;
        this.configuredDisplayable = recordSet.configuredDisplayable;
        this.visibleAndDisplayableRecords = new Vector();
        this.displayRecords = new Vector();
        this.scaleSyncedRecords = new AbstractRecordSet.SyncedRecords(this.recordNames.length);
        this.device.updateVisibilityStatus(this, false);
    }

    public RecordSet clone(int dataIndex, boolean isFromBegin) {
        return new RecordSet(this, dataIndex, isFromBegin);
    }

    @Override
    public Record get(int recordOrdinal) {
        return (Record)super.get(recordOrdinal);
    }

    @Override
    public Record get(Object recordName) {
        return (Record)super.get(recordName);
    }

    public void remove(String recordKey) {
        super.remove(recordKey);
        if (this.recordNames != null) {
            this.removeRecordName(recordKey);
        }
    }

    public boolean checkAllRecordsDisplayable() {
        int displayableRecordEntries = 0;
        for (String recordKey : this.recordNames) {
            if (this.get(recordKey).isDisplayable()) {
                ++displayableRecordEntries;
            }
            log.log(Level.FINER, recordKey + " isDiplayable = " + this.get(recordKey).isDisplayable());
        }
        int targetDisplayable = this.configuredDisplayable == 0 ? this.size() : this.configuredDisplayable;
        log.log(Level.FINE, "targetDisplayable = " + targetDisplayable + " - displayableRecordEntries = " + displayableRecordEntries);
        return displayableRecordEntries >= targetDisplayable;
    }

    public synchronized void addPoints(int[] points) throws DataInconsitsentException {
        String $METHOD_NAME = "addPoints";
        if (points.length == this.size()) {
            for (int i = 0; i < points.length; ++i) {
                this.get(this.recordNames[i]).add(points[i]);
            }
            if (log.isLoggable(Level.FINEST)) {
                StringBuilder sb = new StringBuilder();
                for (int point : points) {
                    sb.append(point).append(" ");
                }
                log.logp(Level.FINEST, $CLASS_NAME, "addPoints", sb.toString());
            }
        } else {
            throw new DataInconsitsentException(Messages.getString("GDE_MSGE0035", new Object[]{this.getClass().getSimpleName(), "addPoints", points.length, this.size()}));
        }
        this.hasDisplayableData = true;
    }

    public synchronized void addPoints(int[] points, double time_ms) throws DataInconsitsentException {
        this.timeStep_ms.add(time_ms);
        this.addPoints(points);
    }

    public synchronized void addNoneCalculationRecordsPoints(int[] points) throws DataInconsitsentException {
        String $METHOD_NAME = "addNoneCalculationRecordsPoints";
        if (points.length <= this.getNoneCalculationRecordNames().length) {
            for (int i = 0; i < points.length; ++i) {
                try {
                    this.get(this.noneCalculationRecords[i]).add(points[i]);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, String.format("Record %s not found, matching recordName %s", this.noneCalculationRecords[i], this.get((int)i).name));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                StringBuilder sb = new StringBuilder();
                for (int point : points) {
                    sb.append(point).append(" ");
                }
                log.logp(Level.FINEST, $CLASS_NAME, "addNoneCalculationRecordsPoints", sb.toString());
            }
        } else {
            throw new DataInconsitsentException(Messages.getString("GDE_MSGE0036", new Object[]{this.getClass().getSimpleName(), "addNoneCalculationRecordsPoints"}));
        }
        this.hasDisplayableData = true;
    }

    public synchronized void addNoneCalculationRecordsPoints(int[] points, double time_ms) throws DataInconsitsentException {
        this.timeStep_ms.add(time_ms);
        this.addNoneCalculationRecordsPoints(points);
    }

    public GroupTransitions getHistoTransitions() {
        boolean isOutdated;
        boolean bl = isOutdated = this.histoTransitions != null && this.histoTransitions.isGatheringMode(this);
        if (this.histoTransitions == null || isOutdated) {
            this.histoTransitions = new TransitionCollector(this).defineTransitions(this.channels.getActiveChannelNumber());
        }
        return this.histoTransitions;
    }

    public String[] getDataTableRow(int index, boolean isAbsolute) {
        index = this.get(0).getIndex(index);
        String[] dataTableRow = new String[this.size() + 1];
        dataTableRow[0] = this.getFormatedTime_sec(index, isAbsolute);
        this.device.prepareDataTableRow(this, dataTableRow, index);
        if (this.analyzer.getSettings().isHistoActive() && this.analyzer.getSettings().isDataTableTransitions()) {
            String[] rowWithSettlements = new TransitionTableMapper(this, this.analyzer).defineRowWithSettlements(index, dataTableRow);
            return rowWithSettlements;
        }
        return dataTableRow;
    }

    public String[] getExportRow(int index, boolean isAbsolute) {
        index = this.get(0).getIndex(index);
        String[] exportRow = new String[this.size() + 1];
        exportRow[0] = this.getFormatedTime_sec(index, isAbsolute);
        return this.device.prepareExportRow(this, exportRow, index);
    }

    public String[] getRawExportRow(int index, boolean isAbsolute) {
        index = this.get(0).getIndex(index);
        String[] exportRow = new String[this.size() + 1];
        exportRow[0] = this.getFormatedTime_sec(index, isAbsolute);
        return this.device.prepareRawExportRow(this, exportRow, index);
    }

    public double getAverageTimeStep_ms() {
        return this.timeStep_ms != null ? this.timeStep_ms.getAverageTimeStep_ms() : (this.get((int)0).timeStep_ms != null ? this.get((int)0).timeStep_ms.getAverageTimeStep_ms() : -1.0);
    }

    public double getMinimumTimeStep_ms() {
        return this.timeStep_ms != null ? this.timeStep_ms.getMinimumTimeStep_ms() : (this.get((int)0).timeStep_ms != null ? this.get((int)0).timeStep_ms.getMinimumTimeStep_ms() : -1.0);
    }

    public double getMaximumTimeStep_ms() {
        return this.timeStep_ms != null ? this.timeStep_ms.getMaximumTimeStep_ms() : (this.get((int)0).timeStep_ms != null ? this.get((int)0).timeStep_ms.getMaximumTimeStep_ms() : -1.0);
    }

    public double getSigmaTimeStep_ms() {
        return this.timeStep_ms != null ? this.timeStep_ms.getSigmaTimeStep_ms() : (this.get((int)0).timeStep_ms != null ? this.get((int)0).timeStep_ms.getSigmaTimeStep_ms() : -1.0);
    }

    public boolean isTimeStepConstant() {
        return this.timeStep_ms.isConstant;
    }

    public String getFormatedTime_sec(int index, boolean isAbsolute) {
        if (isAbsolute) {
            return this.timeStep_ms.getFormattedTime(LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmmssSSS, index);
        }
        if (this.getMaxTime_ms() > 3.46896E11) {
            return this.timeStep_ms.getFormattedTime(LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmmssSSS, index);
        }
        LocalizedDateTime.DurationPattern formatString = this.getMaxTime_ms() <= 3600000.0 ? LocalizedDateTime.DurationPattern.mm_ss_SSS : (this.getMaxTime_ms() <= 8.64E7 ? LocalizedDateTime.DurationPattern.HH_mm_ss_SSS : (this.getMaxTime_ms() <= 2.592E9 ? LocalizedDateTime.DurationPattern.dd_HH_mm_ss_SSS : (this.getMaxTime_ms() <= 3.1536E10 ? LocalizedDateTime.DurationPattern.MM_dd_HH_mm_ss_SSS : LocalizedDateTime.DurationPattern.yy_MM_dd_HH_mm_ss_SSS)));
        return this.timeStep_ms.getFormattedDuration(formatString, index);
    }

    public long getTime(int index) {
        return (Long)this.timeStep_ms.get(index);
    }

    public void addTimeStep_ms(double timeValue) {
        this.timeStep_ms.add(timeValue);
    }

    public Record[] getRecordsSortedForDisplay() {
        int i;
        Record record2;
        Vector<Record> displayRecords = new Vector<Record>();
        for (Record record2 : this.getValues()) {
            if (record2.size() <= 0 || record2.ordinal != this.valueGridRecordOrdinal) continue;
            displayRecords.add(record2);
        }
        for (i = 0; i < this.size(); ++i) {
            record2 = this.get(i);
            if (record2.size() <= 0 || record2.ordinal == this.valueGridRecordOrdinal || !record2.isScaleSyncMaster()) continue;
            displayRecords.add(record2);
        }
        for (i = 0; i < this.size(); ++i) {
            record2 = this.get(i);
            if (record2.size() <= 0 || record2.ordinal == this.valueGridRecordOrdinal || record2.isScaleSyncMaster()) continue;
            displayRecords.add(record2);
        }
        return displayRecords.toArray(new Record[0]);
    }

    @Override
    public void updateVisibleAndDisplayableRecordsForTable() {
        this.visibleAndDisplayableRecords.removeAllElements();
        this.displayRecords.removeAllElements();
        for (int i = 0; i < this.size(); ++i) {
            Record record = this.get(i);
            if (record.isVisible && record.isDisplayable) {
                this.getVisibleAndDisplayableRecords().add(record);
            }
            this.getDisplayRecords().add(record);
        }
    }

    public Vector<Record> getVisibleAndDisplayableRecordsForTable() {
        return this.analyzer.getSettings().isPartialDataTable() ? this.visibleAndDisplayableRecords : this.displayRecords;
    }

    public Vector<Record> getVisibleAndDisplayableRecords() {
        return this.visibleAndDisplayableRecords;
    }

    public Vector<Record> getDisplayRecords() {
        return this.displayRecords;
    }

    public void addRecordName(String newRecordName) {
        String[] newRecordNames = new String[this.recordNames.length + 1];
        System.arraycopy(this.recordNames, 0, newRecordNames, 0, this.recordNames.length);
        newRecordNames[this.recordNames.length] = newRecordName;
        this.recordNames = newRecordNames;
    }

    public void removeRecordName(String deleteRecordName) {
        Vector<String> newRecordNames = new Vector<String>();
        for (String recordKey : this.recordNames) {
            if (recordKey.equals(deleteRecordName)) continue;
            newRecordNames.add(recordKey);
        }
        this.recordNames = newRecordNames.toArray(new String[0]);
    }

    public void replaceRecordName(Record oldRecord, String newRecordName) {
        for (int i = 0; i < this.recordNames.length; ++i) {
            if (!this.recordNames[i].equals(oldRecord.name)) continue;
            this.recordNames[i] = newRecordName;
        }
        if (this.get(newRecordName) == null) {
            this.put(newRecordName, oldRecord.clone(newRecordName));
            this.remove(oldRecord.name);
        }
    }

    public String[] getDisplayableAndVisibleRecordNames() {
        Vector<String> displayableAndVisibleRecords = new Vector<String>();
        for (String recordKey : this.recordNames) {
            if (!this.get((Object)recordKey).isDisplayable || !this.get((Object)recordKey).isVisible) continue;
            displayableAndVisibleRecords.add(recordKey);
        }
        return displayableAndVisibleRecords.toArray(new String[0]);
    }

    public String[] getVisibleRecordNames() {
        Vector<String> visibleRecords = new Vector<String>();
        for (String recordKey : this.recordNames) {
            if (!this.get(recordKey).isVisible()) continue;
            visibleRecords.add(recordKey);
        }
        return visibleRecords.toArray(new String[0]);
    }

    public int getNumberOfVisibleAndDisplayableRecords() {
        int visibleAndDisplayable = 0;
        for (String recordKey : this.recordNames) {
            if (!this.get((Object)recordKey).isVisible || !this.get((Object)recordKey).isDisplayable) continue;
            ++visibleAndDisplayable;
        }
        return visibleAndDisplayable;
    }

    public int getNumberOfDisplayableRecords() {
        int displayable = 0;
        for (String recordKey : this.recordNames) {
            if (!this.get((Object)recordKey).isDisplayable) continue;
            ++displayable;
        }
        return displayable;
    }

    public String[] getDisplayableRecordNames() {
        Vector<String> displayableRecords = new Vector<String>();
        for (String recordKey : this.recordNames) {
            if (!this.get(recordKey).isDisplayable()) continue;
            displayableRecords.add(recordKey);
        }
        return displayableRecords.toArray(new String[0]);
    }

    public String[] getActiveRecordNames() {
        Vector<String> activeRecords = new Vector<String>();
        for (String recordKey : this.recordNames) {
            if (!this.get(recordKey).isActive()) continue;
            activeRecords.add(recordKey);
        }
        return activeRecords.toArray(new String[0]);
    }

    public void setNoneCalculationRecordNames(String[] recordNames) {
        this.noneCalculationRecords = recordNames;
    }

    public String[] getNoneCalculationRecordNames() {
        if (this.noneCalculationRecords.length == 0) {
            this.noneCalculationRecords = this.device.getNoneCalculationMeasurementNames(this.parent.number, this.recordNames);
        }
        return this.noneCalculationRecords;
    }

    @Override
    public void clear() {
        super.clear();
        this.recordNames = new String[0];
        this.timeStep_ms = null;
        this.maxTime = 0.0;
        this.maxValue = -20000.0;
        this.minValue = 20000.0;
        this.resetZoomAndMeasurement();
    }

    public void cleanup() {
        this.timeStep_ms.clear();
        this.timeStep_ms.trimToSize();
        for (Record record : this.getValues()) {
            record.clear();
            record.trimToSize();
        }
    }

    public static RecordSet createRecordSet(String recordSetName, IDevice device, int channelConfigNumber, boolean isRaw, boolean isFromFile, boolean adjustObjectKey) {
        Analyzer analyzer = Analyzer.getInstance();
        if (!(analyzer instanceof Explorer) && !(analyzer instanceof TestAnalyzer)) {
            throw new UnsupportedOperationException("for UI-based tests only, not for histo tests");
        }
        return RecordSet.createRecordSet(recordSetName, analyzer, channelConfigNumber, isRaw, isFromFile, adjustObjectKey);
    }

    public static RecordSet createRecordSet(String recordSetName, Analyzer analyzer, int channelNumber, boolean isRaw, boolean isFromFile, boolean adjustObjectKey) {
        String shortRecordSetName = recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 40);
        IDevice device = analyzer.getActiveDevice();
        String[] recordNames = device.getMeasurementNamesReplacements(channelNumber);
        if (recordNames.length == 0) {
            channelNumber = 1;
            recordNames = device.getMeasurementNamesReplacements(1);
        }
        String[] recordSymbols = new String[recordNames.length];
        String[] recordUnits = new String[recordNames.length];
        for (int i = 0; i < recordNames.length; ++i) {
            MeasurementType measurement = device.getMeasurement(channelNumber, i);
            recordSymbols[i] = measurement.getSymbol();
            recordUnits[i] = measurement.getUnit();
        }
        return RecordSet.createRecordSet(shortRecordSetName, analyzer, channelNumber, recordNames, recordSymbols, recordUnits, isRaw, isFromFile, adjustObjectKey);
    }

    public static RecordSet createRecordSet(String recordSetName, IDevice device, int channelConfigNumber, String[] recordNames, String[] recordSymbols, String[] recordUnits, double newTimeStep_ms, boolean isRaw, boolean isFromFile, boolean adjustObjectKey) {
        Analyzer analyzer = Analyzer.getInstance();
        if (!(analyzer instanceof Explorer) && !(analyzer instanceof TestAnalyzer)) {
            throw new UnsupportedOperationException("for UI-based tests only, not for histo tests");
        }
        return RecordSet.createRecordSet(recordSetName, analyzer, channelConfigNumber, recordNames, recordSymbols, recordUnits, isRaw, isFromFile, adjustObjectKey);
    }

    public static RecordSet createRecordSet(String recordSetName, Analyzer analyzer, int channelNumber, String[] recordNames, String[] recordSymbols, String[] recordUnits, boolean isRaw, boolean isFromFile, boolean adjustObjectKey) {
        Channel activeChannel;
        String activeObjectKey;
        RecordSet newRecordSet = new RecordSet(analyzer, channelNumber, recordSetName, recordNames, isRaw, isFromFile);
        if (log.isLoggable(Level.FINE)) {
            RecordSet.printRecordNames("createRecordSet() " + newRecordSet.name + " - ", newRecordSet.getRecordNames());
        }
        IDevice device = analyzer.getActiveDevice();
        for (int i = 0; i < recordNames.length; ++i) {
            MeasurementType measurement = device.getMeasurement(channelNumber, i);
            Record tmpRecord = new Record(device, i, recordNames[i], recordSymbols[i], recordUnits[i], measurement.isActive(), measurement.getStatistics(), measurement.getProperty(), 55);
            tmpRecord.setColorDefaultsAndPosition(i);
            newRecordSet.put(recordNames[i], tmpRecord);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "added record for " + recordNames[i] + " - " + newRecordSet.size());
        }
        if (adjustObjectKey && !(activeObjectKey = analyzer.getSettings().getActiveObjectKey()).isEmpty() && (activeChannel = analyzer.getActiveChannel()) != null && !activeChannel.getObjectKey().equals(activeObjectKey)) {
            activeChannel.setObjectKey(activeObjectKey);
        }
        newRecordSet.syncScaleOfSyncableRecords();
        return newRecordSet;
    }

    public int getNumberVisibleWithAxisPosLeft() {
        int value = 0;
        for (String recordKey : this.recordNames) {
            Record record = this.get(recordKey);
            if (!record.isVisible || !record.isDisplayable || !record.isPositionLeft) continue;
            ++value;
        }
        return value;
    }

    @Override
    public IDevice getDevice() {
        return this.device != null ? this.device : this.analyzer.getActiveDevice();
    }

    @Override
    public int getChannelConfigNumber() {
        return this.parent != null ? this.parent.number : 1;
    }

    public String getChannelConfigName() {
        return this.parent != null ? this.parent.channelConfigName : "";
    }

    public boolean isChildOfActiveChannel() {
        boolean isChild = false;
        RecordSet uiRecordSet = (RecordSet)this.channels.getActiveChannel().get(this.name);
        if (uiRecordSet == this) {
            isChild = true;
        }
        return isChild;
    }

    @Override
    public Record put(String key, AbstractRecord record) {
        super.put(key, record);
        Record newRecord = this.get(key);
        newRecord.keyName = key;
        newRecord.parent = this;
        if (this.isCompareSet || this.isUtilitySet) {
            this.addRecordName(key);
            newRecord.name = key;
            newRecord.ordinal = this.size() - 1;
            if (this.realSize() > 1) {
                newRecord.setColorDefaultsAndPosition(this.realSize());
                newRecord.numberFormat = this.get((int)0).numberFormat;
                newRecord.df = (DecimalFormat)this.get((int)0).df.clone();
            } else {
                newRecord.setNumberFormat(-1);
            }
            newRecord.isPositionLeft = true;
        }
        return newRecord;
    }

    public void setTimeStep_ms(double newTimeStep_ms) {
        this.timeStep_ms = this.timeStep_ms == null || this.timeStep_ms.size() == 0 ? new TimeSteps(newTimeStep_ms) : this.timeStep_ms;
    }

    public void setNewTimeStep_ms(double newTimeStep_ms) {
        this.timeStep_ms = new TimeSteps(newTimeStep_ms);
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void setSaved(boolean newValue) {
        if (newValue) {
            this.unsaveReasons = new Vector();
        }
        this.isSaved = newValue;
    }

    public void setUnsaved(String unsavedReason) {
        if (!this.isCompareSet) {
            ++this.changeCounter;
            this.isSaved = false;
            if (!this.unsaveReasons.contains(unsavedReason)) {
                this.unsaveReasons.add(unsavedReason);
            }
        }
    }

    public boolean isRaw() {
        return this.isRaw;
    }

    public String getRecordSetDescription() {
        return this.description;
    }

    public void setRecordSetDescription(String newRecordSetDescription) {
        this.setUnsaved(UNSAVED_REASON_COMMENT);
        this.description = newRecordSetDescription;
    }

    public void descriptionAppendFilename(String fileName) {
        String tmpDescription = this.getRecordSetDescription();
        this.description = this.description.contains("\n") ? this.description.substring(0, this.description.indexOf(10)).trim() + Messages.getString("GDE_MSGT0681", new String[]{fileName}) + this.description.substring(tmpDescription.indexOf(10)) : this.description.trim() + Messages.getString("GDE_MSGT0681", new String[]{fileName});
    }

    public void checkAllDisplayable() {
        this.analyzer.getActiveDevice().makeInActiveDisplayable(this);
        this.isRecalculation = false;
        Thread dataLoadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Channel activeChannel;
                CalculationThread ct = RecordSet.this.device.getCalculationThread();
                try {
                    Thread.sleep(1000L);
                    while (ct != null && ct.isAlive()) {
                        log.log(Level.FINER, "CalculationThread isAlive");
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((activeChannel = RecordSet.this.channels.getActiveChannel()) != null && activeChannel.getFullQualifiedFileName() != null) {
                    activeChannel.checkAndLoadData();
                }
            }
        }, "DataLoadCheck");
        try {
            dataLoadThread.setPriority(3);
            dataLoadThread.start();
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void setAllDisplayable() {
        for (String recordKey : this.recordNames) {
            this.get(recordKey).setDisplayable(true);
        }
    }

    public void setAllVisibleAndDisplayable() {
        for (String recordKey : this.recordNames) {
            Record record = this.get(recordKey);
            record.setVisible(true);
            record.setDisplayable(true);
        }
        for (String recordKey : this.getNoneCalculationRecordNames()) {
            this.get(recordKey).setActive(true);
        }
    }

    public boolean isFromFile() {
        return this.isFromFile;
    }

    public int getRecordDataSize(boolean isReal) {
        int size = 0;
        if (isReal) {
            for (String recordKey : this.recordNames) {
                if (!this.get(recordKey).isActive()) continue;
                size = this.get(recordKey).realSize();
                break;
            }
        } else {
            for (String recordKey : this.recordNames) {
                if (!this.get(recordKey).isActive()) continue;
                size = this.get(recordKey).size();
                break;
            }
        }
        return size;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double newMaxValue) {
        this.maxValue = newMaxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double newMinValue) {
        this.minValue = newMinValue;
    }

    public void setCompareSetMaxScaleTime_ms(double newMaxTime) {
        this.maxTime = newMaxTime;
    }

    public double getCompareSetMaxScaleTime_ms() {
        return this.maxTime;
    }

    public boolean isZoomMode() {
        return this.isZoomMode;
    }

    public void setZoomMode(boolean zoomModeEnabled) {
        if (!zoomModeEnabled) {
            this.resetMeasurement();
            if (this.recordNames.length != 0) {
                for (Record record : this.getValues()) {
                    record.zoomOffset = 0;
                    record.zoomTimeOffset = 0.0;
                    record.drawTimeWidth = record.getMaxTime_ms();
                    record.minZoomScaleValue = record.minScaleValue;
                    record.maxZoomScaleValue = record.maxScaleValue;
                    log.log(Level.FINER, this.name + " zoomTimeOffset " + TimeLine.getFomatedTimeWithUnit(record.zoomTimeOffset) + " drawTimeWidth " + TimeLine.getFomatedTimeWithUnit(record.drawTimeWidth));
                }
            }
        } else if (!this.isZoomMode) {
            for (Record record : this.getValues()) {
                record.minZoomScaleValue = record.minScaleValue;
                record.maxZoomScaleValue = record.maxScaleValue;
            }
        }
        this.isZoomMode = zoomModeEnabled;
        this.isScopeMode = false;
    }

    public void resetZoomAndMeasurement() {
        this.setZoomMode(false);
        this.setMeasurementMode(this.recordKeyMeasurement, false);
        this.setDeltaMeasurementMode(this.recordKeyMeasurement, false);
    }

    public void setDisplayZoomBounds(Rectangle newDisplayZoomBounds) {
        for (Record record : this.getValues()) {
            record.setZoomBounds(newDisplayZoomBounds);
        }
    }

    public void setScopeSizeRecordPoints(int newScopeSize) {
        this.isScopeMode = true;
        this.scopeModeSize = newScopeSize;
    }

    public boolean isScopeMode() {
        return this.isScopeMode;
    }

    public int getScopeModeOffset() {
        return this.scopeModeOffset;
    }

    public void setScopeModeOffset(int newScopeModeOffset) {
        this.scopeModeOffset = newScopeModeOffset;
    }

    public int getScopeModeSize() {
        return this.scopeModeSize;
    }

    public double getStartTime() {
        double startTime = 0.0;
        if (this.isZoomMode) {
            startTime = this.analyzer.getSettings() != null && this.analyzer.getSettings().isTimeFormatAbsolute() && this.timeStep_ms != null ? (double)this.timeStep_ms.startTimeStamp_ms + this.get((int)0).zoomTimeOffset : this.get((int)0).zoomTimeOffset;
        } else if (this.isScopeMode) {
            startTime = this.analyzer.getSettings() != null && this.analyzer.getSettings().isTimeFormatAbsolute() && this.timeStep_ms != null ? (double)this.timeStep_ms.startTimeStamp_ms + this.timeStep_ms.getTime_ms(this.scopeModeOffset + 1) : this.timeStep_ms.getTime_ms(this.scopeModeOffset + 1);
        }
        return startTime;
    }

    public boolean isPanMode() {
        return this.isZoomMode;
    }

    public void shift(int xPercent, int yPercent) {
        for (Record record : this.getValues()) {
            double xShift_ms = record.drawTimeWidth * (double)xPercent / 100.0;
            if (record.zoomTimeOffset + xShift_ms <= 0.0) {
                record.zoomOffset = 0;
                record.zoomTimeOffset = 0.0;
            } else if (record.zoomTimeOffset + record.drawTimeWidth + xShift_ms > record.getMaxTime_ms()) {
                record.zoomTimeOffset = record.getMaxTime_ms() - record.drawTimeWidth;
                record.zoomOffset = record.findBestIndex(record.zoomTimeOffset);
            } else {
                record.zoomTimeOffset += xShift_ms;
                record.zoomOffset = record.findBestIndex(record.zoomTimeOffset);
            }
            double yShift = (record.getMaxScaleValue() - record.getMinScaleValue()) * (double)yPercent / 100.0;
            record.minZoomScaleValue = record.getMinScaleValue() + yShift;
            record.maxZoomScaleValue = record.getMaxScaleValue() + yShift;
        }
    }

    public int getTimeGridType() {
        return this.timeGridType;
    }

    public void setTimeGridType(int gridType) {
        this.timeGridType = gridType;
    }

    public Vector<Integer> getTimeGrid() {
        return this.timeGrid;
    }

    public void setTimeGrid(Vector<Integer> newTimeGrid) {
        this.timeGrid = new Vector<Integer>(newTimeGrid);
    }

    public Color getColorTimeGrid() {
        return this.timeGridColor;
    }

    public void setTimeGridColor(Color colorTimeGrid) {
        this.timeGridColor = colorTimeGrid;
    }

    public int getLineStyleTimeGrid() {
        return this.timeGridLineStyle;
    }

    public void setTimeGridLineStyle(int lineStyleTimeGrid) {
        this.timeGridLineStyle = lineStyleTimeGrid;
    }

    public int getConfiguredDisplayable() {
        return this.configuredDisplayable;
    }

    public void setConfiguredDisplayable(int newConfiguredDisplayableNumber) {
        log.log(Level.FINE, "configuredDisplayable = " + newConfiguredDisplayableNumber);
        this.configuredDisplayable = newConfiguredDisplayableNumber;
    }

    @Deprecated
    public String getValueGridRecordName() {
        boolean isOneOfSycableAndOneOfSynableVisible;
        String gridRecordName = this.valueGridRecordOrdinal == -1 || this.valueGridRecordOrdinal > this.getRecordNames().length - 1 ? "-" : this.getRecordNames()[this.valueGridRecordOrdinal];
        boolean bl = isOneOfSycableAndOneOfSynableVisible = this.valueGridRecordOrdinal >= 0 && this.isOneOfSyncableRecord(this.get(this.valueGridRecordOrdinal).getName()) && this.isOneSyncableVisible(this.getSyncMasterRecordOrdinal(gridRecordName));
        if (!(this.get(gridRecordName) == null || isOneOfSycableAndOneOfSynableVisible || this.get((Object)gridRecordName).isVisible && this.get((Object)gridRecordName).isDisplayable)) {
            gridRecordName = this.getFirstRecordName();
            log.log(Level.FINE, "gridRecordName = " + gridRecordName);
        }
        if (this.isCompareSet) {
            gridRecordName = this.realSize() == 0 ? "-" : this.getFirstRecordName();
            log.log(Level.FINE, "gridRecordName = " + gridRecordName);
        }
        return gridRecordName;
    }

    @Override
    public int getValueGridRecordOrdinal() {
        return this.isCompareSet ? this.get((int)0).ordinal : this.valueGridRecordOrdinal;
    }

    public boolean isRecalculation() {
        return this.isRecalculation;
    }

    public String getFirstRecordName() {
        return this.recordNames[0];
    }

    public void setRecalculationRequired() {
        this.isRecalculation = true;
        for (int i = 0; i < this.device.getNumberOfMeasurements(this.parent.number) && i < this.size(); ++i) {
            if (this.device.getMeasurement(this.parent.number, i).isCalculation()) {
                this.get(i).resetMinMax();
            }
            this.get(i).resetStatiticCalculationBase();
        }
    }

    public String getSerializeProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("timeStep_ms").append("=").append(this.timeStep_ms.isConstant ? this.getAverageTimeStep_ms() : -1.0).append("|-|");
        sb.append("startTimeStamp").append("=").append(this.timeStep_ms.getStartTimeStamp()).append("|-|");
        sb.append("RecordSet_timeGridType").append("=").append(this.timeGridType).append("|-|");
        sb.append("RecordSet_timeGridLineStyle").append("=").append(this.timeGridLineStyle).append("|-|");
        sb.append("RecordSet_timeGridColor").append("=").append(this.timeGridColor.getRed()).append(",").append(this.timeGridColor.getGreen()).append(",").append(this.timeGridColor.getBlue()).append("|-|");
        sb.append("RecordSet_horizontalGridRecordOrdinal").append("=").append(this.valueGridRecordOrdinal).append("|-|");
        sb.append("RecordSet_horizontalGridType").append("=").append(this.valueGridType).append("|-|");
        sb.append("RecordSet_horizontalGridLineStyle").append("=").append(this.valueGridLineStyle).append("|-|");
        sb.append("RecordSet_horizontalGridColor").append("=").append(this.valueGridColor.getRed()).append(",").append(this.valueGridColor.getGreen()).append(",").append(this.valueGridColor.getBlue()).append("|-|");
        sb.append("RecordSet_smoothAtCurrentDrop").append("=").append(this.isSmoothAtCurrentDrop).append("|-|");
        sb.append("RecordSet_smoothVoltageCurve").append("=").append(this.isSmoothVoltageCurve).append("|-|");
        sb.append("RecordSet_voltageLimits").append("=");
        for (int value : this.voltageLimits) {
            sb.append(value).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().endsWith("|-|") ? sb.substring(0, sb.lastIndexOf("|-|")) : sb.toString();
    }

    public void setDeserializedProperties(String serializedRecordSetProperties) {
        HashMap<String, String> recordSetProps = StringHelper.splitString(serializedRecordSetProperties, "|-|", propertyKeys);
        String tmpValue = null;
        try {
            tmpValue = recordSetProps.get("timeStep_ms");
            if (tmpValue != null && tmpValue.length() > 0) {
                this.timeStep_ms = new TimeSteps(Double.parseDouble(tmpValue.trim()));
            }
            if ((tmpValue = recordSetProps.get("startTimeStamp")) != null && tmpValue.length() > 0) {
                this.timeStep_ms.setStartTimeStamp(Long.parseLong(tmpValue));
            } else {
                String[] recordSetDescription = this.getRecordSetDescription();
                Pattern datePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
                Matcher dateMatcher = datePattern.matcher((CharSequence)recordSetDescription);
                Pattern timePattern = Pattern.compile("\\d{2}:\\d{2}:\\d{2}");
                Matcher timeMatcher = timePattern.matcher((CharSequence)recordSetDescription);
                if (dateMatcher.find() && timeMatcher.find()) {
                    String date = dateMatcher.group();
                    String time = timeMatcher.group();
                    log.logp(Level.FINE, $CLASS_NAME, "setDeserializedProperties", date + " " + time);
                    String[] strValueDate = date.split("-");
                    int year = Integer.parseInt(strValueDate[0]);
                    int month = Integer.parseInt(strValueDate[1]);
                    int day = Integer.parseInt(strValueDate[2]);
                    String[] strValueTime = time.split(":");
                    int hour = Integer.parseInt(strValueTime[0]);
                    int minute = Integer.parseInt(strValueTime[1]);
                    int second = Integer.parseInt(strValueTime[2]);
                    GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                    this.timeStep_ms.setStartTimeStamp(calendar.getTimeInMillis());
                }
            }
            tmpValue = recordSetProps.get("RecordSet_timeGridType");
            if (tmpValue != null && tmpValue.length() > 0) {
                this.timeGridType = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordSetProps.get("RecordSet_timeGridLineStyle")) != null && tmpValue.length() > 0) {
                this.timeGridLineStyle = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordSetProps.get("RecordSet_timeGridColor")) != null && tmpValue.length() > 5) {
                Color color = this.timeGridColor = GDE.isSystemDarkTheme ? DataExplorer.getInstance().COLOR_BLACK : SWTResourceManager.getColor(Integer.valueOf(tmpValue.split(",")[0]), Integer.valueOf(tmpValue.split(",")[1]), Integer.valueOf(tmpValue.split(",")[2]));
            }
            if ((tmpValue = recordSetProps.get("RecordSet_horizontalGridRecord")) != null && tmpValue.length() > 0) {
                for (String recordKey : this.recordNames) {
                    if (!recordKey.equals(tmpValue)) continue;
                    this.valueGridRecordOrdinal = this.get(recordKey).getOrdinal();
                    break;
                }
            }
            if ((tmpValue = recordSetProps.get("RecordSet_horizontalGridRecordOrdinal")) != null && tmpValue.length() > 0) {
                try {
                    this.valueGridRecordOrdinal = Integer.valueOf(tmpValue.trim());
                }
                catch (Exception e) {
                    this.valueGridRecordOrdinal = -1;
                }
            }
            if ((tmpValue = recordSetProps.get("RecordSet_horizontalGridType")) != null && tmpValue.length() > 0) {
                this.valueGridType = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordSetProps.get("RecordSet_horizontalGridLineStyle")) != null && tmpValue.length() > 0) {
                this.valueGridLineStyle = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordSetProps.get("RecordSet_horizontalGridColor")) != null && tmpValue.length() > 5) {
                Color color = this.valueGridColor = GDE.isSystemDarkTheme ? DataExplorer.getInstance().COLOR_BLACK : SWTResourceManager.getColor(Integer.valueOf(tmpValue.split(",")[0]), Integer.valueOf(tmpValue.split(",")[1]), Integer.valueOf(tmpValue.split(",")[2]));
            }
            if ((tmpValue = recordSetProps.get("RecordSet_smoothAtCurrentDrop")) != null && tmpValue.length() > 0) {
                this.isSmoothAtCurrentDrop = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordSetProps.get("RecordSet_smoothVoltageCurve")) != null && tmpValue.length() > 0) {
                this.isSmoothVoltageCurve = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordSetProps.get("RecordSet_voltageLimits")) != null && tmpValue.length() > 0) {
                String[] strVoltageValues = tmpValue.trim().split(",");
                for (int i = 0; i < strVoltageValues.length && i < this.voltageLimits.length; ++i) {
                    this.voltageLimits[i] = Integer.valueOf(strVoltageValues[i].trim());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString("GDE_MSGE0002") + "\n" + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public boolean isCutLeftEdgeEnabled() {
        try {
            return DataExplorer.getInstance().isWindowVisible(GraphicsWindow.GraphicsType.NORMAL) && this.isZoomMode && this.get((int)0).zoomTimeOffset == 0.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCutRightEdgeEnabled() {
        Record tmpRecord;
        try {
            tmpRecord = this.get(0);
        }
        catch (Exception e) {
            return false;
        }
        return DataExplorer.getInstance().isWindowVisible(GraphicsWindow.GraphicsType.NORMAL) && this.isZoomMode && tmpRecord.zoomTimeOffset + tmpRecord.drawTimeWidth >= tmpRecord.getMaxTime_ms();
    }

    public Vector<String> getUnsaveReasons() {
        return this.unsaveReasons;
    }

    public int getChangeCounter() {
        return this.changeCounter;
    }

    @Override
    public void syncScaleOfSyncableRecords() {
        if (this.isCompareSet) {
            return;
        }
        this.scaleSyncedRecords.initSyncedScales(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSyncRecordScale() {
        Iterator iterator = this.scaleSyncedRecords.keySet().iterator();
        while (iterator.hasNext()) {
            Record record;
            Record tmpRecord;
            int syncRecordOrdinal = (Integer)iterator.next();
            boolean isAffected = false;
            int tmpSyncMin = Integer.MAX_VALUE;
            int tmpSyncMax = Integer.MIN_VALUE;
            Iterator iterator2 = ((Vector)this.getScaleSyncedRecords().get(syncRecordOrdinal)).iterator();
            while (iterator2.hasNext()) {
                record = tmpRecord = (Record)iterator2.next();
                synchronized (record) {
                    if (tmpRecord.isVisible && tmpRecord.isDisplayable) {
                        isAffected = true;
                        int tmpMin = Double.valueOf((double)tmpRecord.getMinValue() * tmpRecord.syncMasterFactor).intValue();
                        int tmpMax = Double.valueOf((double)tmpRecord.getMaxValue() * tmpRecord.syncMasterFactor).intValue();
                        if (tmpMin != 0 || tmpMax != 0) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, tmpRecord.name + " tmpMin  = " + (double)tmpMin / 1000.0 + "; tmpMax  = " + (double)tmpMax / 1000.0);
                            }
                            if (tmpMin < tmpSyncMin) {
                                tmpSyncMin = tmpMin;
                            }
                            if (tmpMax > tmpSyncMax) {
                                tmpSyncMax = tmpMax;
                            }
                        }
                    }
                }
            }
            iterator2 = ((Vector)this.getScaleSyncedRecords().get(syncRecordOrdinal)).iterator();
            while (iterator2.hasNext()) {
                record = tmpRecord = (Record)iterator2.next();
                synchronized (record) {
                    if (this.isScopeMode) {
                        tmpRecord.scopeMin = tmpSyncMin;
                        tmpRecord.scopeMax = tmpSyncMax;
                    } else {
                        tmpRecord.syncMinValue = tmpSyncMin;
                        tmpRecord.syncMaxValue = tmpSyncMax;
                    }
                }
            }
            if (syncRecordOrdinal < this.realSize()) {
                Record syncRecord;
                Record record2 = syncRecord = this.get(syncRecordOrdinal);
                synchronized (record2) {
                    if (this.isScopeMode) {
                        syncRecord.scopeMin = tmpSyncMin;
                        syncRecord.scopeMax = tmpSyncMax;
                    } else {
                        syncRecord.syncMinValue = tmpSyncMin;
                        syncRecord.syncMaxValue = tmpSyncMax;
                    }
                }
            } else {
                log.log(Level.WARNING, String.format("Check device XML regarding <property name=\"scale_sync_ref_ordinal\" value=\"%d\" type=\"Integer\" />", syncRecordOrdinal));
            }
            if (!isAffected || !log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, this.get(syncRecordOrdinal).getSyncMasterName() + "; syncMin = " + (double)tmpSyncMin / 1000.0 + "; syncMax = " + (double)tmpSyncMax / 1000.0);
        }
    }

    private AbstractRecordSet.SyncedRecords<Record> getScaleSyncedRecords() {
        return this.scaleSyncedRecords;
    }

    public Vector<Record> getScaleSyncedRecords(int syncMasterRecordOrdinal) {
        return (Vector)this.scaleSyncedRecords.get(syncMasterRecordOrdinal);
    }

    public int getFileDataSize() {
        return this.fileDataSize;
    }

    public long getFileDataPointer() {
        return this.fileDataPointer;
    }

    public int getFileDataBytesSize() {
        return this.fileDataBytes;
    }

    public void setFileDataPointerAndSize(long newFileDataPointer, int newFileRecordDataSize, int newFileRecordSetDataBytes) {
        this.fileDataPointer = newFileDataPointer;
        this.fileDataSize = newFileRecordDataSize;
        this.fileDataBytes = newFileRecordSetDataBytes;
    }

    public boolean hasDisplayableData() {
        return this.hasDisplayableData;
    }

    public void setDisplayableData(boolean enable) {
        this.hasDisplayableData = enable;
    }

    public void loadFileData(String fullQualifiedFileName, boolean doShowProgress) {
        try {
            if (this.fileDataSize != 0 && this.fileDataPointer != 0L) {
                if (fullQualifiedFileName.endsWith("osd")) {
                    OsdReaderWriter.readRecordSetsData(this, fullQualifiedFileName, doShowProgress);
                } else if (fullQualifiedFileName.endsWith("lov")) {
                    LogViewReader.readRecordSetsData(this, fullQualifiedFileName, doShowProgress);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public int getXScale() {
        return this.xScaleStep;
    }

    public void setXScale(int value) {
        this.xScaleStep = value;
    }

    public int[] getVoltageLimits() {
        return this.voltageLimits;
    }

    public void setVoltageLimits() {
        this.setUnsaved(UNSAVED_REASON_GRAPHICS);
        this.voltageLimits = CellVoltageValues.getVoltageLimits();
    }

    public void setScopeMode(boolean enable) {
        this.isScopeMode = enable;
        if (enable) {
            for (String recordKey : this.recordNames) {
                Record record = this.get(recordKey);
                if (!record.isVisible || !record.isDisplayable) continue;
                int min = 0;
                int max = 0;
                for (int i = this.scopeModeOffset; i < record.realSize(); ++i) {
                    int value = record.realGet(i);
                    if (i == this.scopeModeOffset) {
                        min = max = value;
                        continue;
                    }
                    if (value > max) {
                        max = value;
                        continue;
                    }
                    if (value >= min) continue;
                    min = value;
                }
                log.log(Level.FINE, record.getName() + ": scopeMin = " + (double)min / 1000.0 + "; scopeMax = " + (double)max / 1000.0);
                record.setScopeMinMax(min, max);
            }
        }
    }

    public void setStartTimeStamp(long startTimeStamp) {
        if (this.timeStep_ms != null) {
            this.timeStep_ms.setStartTimeStamp(startTimeStamp);
        } else {
            log.log(Level.WARNING, "time step vector is null !");
        }
    }

    public long getStartTimeStamp() {
        return this.timeStep_ms != null ? this.timeStep_ms.getStartTimeStamp() : new Date().getTime();
    }

    public boolean containsGPSdata() {
        int sumGpsRelatedRecords = 0;
        for (Record record : this.getValues()) {
            if (record.dataType != Record.DataType.GPS_LATITUDE && record.dataType != Record.DataType.GPS_LONGITUDE && record.dataType != Record.DataType.GPS_ALTITUDE) continue;
            ++sumGpsRelatedRecords;
        }
        return sumGpsRelatedRecords >= 3;
    }

    public int getRecordOrdinalOfType(Record.DataType dataType) {
        for (Record record : this.getValues()) {
            if (record.dataType != dataType || !record.hasReasonableData()) continue;
            return record.ordinal;
        }
        return -1;
    }

    public int getRecordOrdinalOfDataType(Record.DataType dataType) {
        for (Record record : this.getValues()) {
            if (record.dataType != dataType) continue;
            return record.ordinal;
        }
        return -1;
    }

    public int findRecordOrdinalByUnit(String[] units) {
        for (Record record : this.getValues()) {
            for (String unit : units) {
                if (!record.getUnit().toLowerCase().contains(unit.toLowerCase()) || !record.hasReasonableData()) continue;
                return record.getOrdinal();
            }
        }
        return -1;
    }

    public int findRecordOrdinalByUnit(String[] units, int minBoundaryValue, int maxBoundaryValue) {
        for (Record record : this.getValues()) {
            if (record.getMinValue() / 1000 < minBoundaryValue || record.getMaxValue() / 1000 > maxBoundaryValue) continue;
            for (String unit : units) {
                if (!record.getUnit().toLowerCase().contains(unit.toLowerCase()) || !record.hasReasonableData()) continue;
                return record.getOrdinal();
            }
        }
        return -1;
    }

    public Collection<Record> getValues() {
        return this.values();
    }

    public void setMeasurementMode(String recordKey, boolean enabled) {
        Record record = this.get(recordKey);
        if (record != null) {
            record.setMeasurementMode(enabled);
            if (enabled) {
                Record oldRecord = this.get(this.recordKeyMeasurement);
                if (oldRecord != null && !oldRecord.equals(record)) {
                    oldRecord.setMeasurementMode(false);
                    oldRecord.setDeltaMeasurementMode(false);
                    oldRecord.setAvgMedianMeasurementMode(false);
                }
                this.recordKeyMeasurement = recordKey;
                record.setDeltaMeasurementMode(false);
                record.setAvgMedianMeasurementMode(false);
            }
        }
    }

    public void setDeltaMeasurementMode(String recordKey, boolean enabled) {
        Record record = this.get(recordKey);
        if (record != null) {
            record.setDeltaMeasurementMode(enabled);
            if (enabled) {
                Record oldRecord = this.get(this.recordKeyMeasurement);
                if (oldRecord != null && !oldRecord.equals(record)) {
                    oldRecord.setMeasurementMode(false);
                    oldRecord.setDeltaMeasurementMode(false);
                    oldRecord.setAvgMedianMeasurementMode(false);
                }
                this.recordKeyMeasurement = recordKey;
                record.setMeasurementMode(false);
                record.setAvgMedianMeasurementMode(false);
            }
        }
    }

    public void setAvgMedianMeasurementMode(String recordKey, boolean enabled) {
        Record record = this.get(recordKey);
        if (record != null) {
            record.setAvgMedianMeasurementMode(enabled);
            if (enabled) {
                Record oldRecord = this.get(this.recordKeyMeasurement);
                if (oldRecord != null && !oldRecord.equals(record)) {
                    oldRecord.setMeasurementMode(false);
                    oldRecord.setDeltaMeasurementMode(false);
                    oldRecord.setAvgMedianMeasurementMode(false);
                }
                this.recordKeyMeasurement = recordKey;
                record.setMeasurementMode(false);
                record.setDeltaMeasurementMode(false);
            }
        }
    }

    public void clearMeasurementModes() {
        Record record = this.get(this.recordKeyMeasurement);
        if (record != null) {
            record.setMeasurementMode(false);
            record.setDeltaMeasurementMode(false);
            record.setAvgMedianMeasurementMode(false);
        }
    }

    public boolean isMeasurementMode(String recordKey) {
        return this.get(recordKey) != null ? this.get(recordKey).isMeasurementMode() : false;
    }

    public boolean isDeltaMeasurementMode(String recordKey) {
        return this.get(recordKey) != null ? this.get(recordKey).isDeltaMeasurementMode() : false;
    }

    public boolean isAvgMedianMeasurementMode(String recordKey) {
        return this.get(recordKey) != null ? this.get(recordKey).isAvgMedianMeasurementMode() : false;
    }

    public void resetMeasurement() {
        this.setMeasurementMode(this.recordKeyMeasurement, false);
        this.setDeltaMeasurementMode(this.recordKeyMeasurement, false);
        this.setAvgMedianMeasurementMode(this.recordKeyMeasurement, false);
    }

    public String getRecordKeyMeasurement() {
        return this.recordKeyMeasurement;
    }

    public Rectangle getDrawAreaBounds() {
        return this.drawAreaBounds;
    }

    public void setDrawAreaBounds(Rectangle newDrawAreaBounds) {
        this.drawAreaBounds = newDrawAreaBounds;
        log.finest(() -> "drawAreaBounds = " + String.valueOf(this.drawAreaBounds));
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }
}

