/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt.dialogs;

import de.treichels.hott.decoder.HoTTSerialPort;
import de.treichels.hott.messages.Messages;
import de.treichels.hott.model.BaseModel;
import de.treichels.hott.serial.SerialPort;
import de.treichels.hott.util.Util;
import java.util.List;
import java.util.prefs.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class SelectFromTransmitterDialog
extends Dialog {
    private static final Preferences PREFS = Preferences.userNodeForPackage(SelectFromTransmitterDialog.class);
    private final List<String> portNames = SerialPort.Companion.getAvailablePorts();
    HoTTSerialPort port = null;
    BaseModel model = null;
    private Combo combo;
    Shell dialog;

    SelectFromTransmitterDialog(Shell parent) {
        super(parent, 0);
    }

    public BaseModel getModel() {
        return this.model;
    }

    protected abstract void getSelectionComponent(Composite var1);

    protected abstract void onCancel();

    protected abstract void onOpen();

    protected abstract void onReload();

    public Object open() {
        Shell shell = this.getParent();
        this.dialog = new Shell(shell, 67696);
        this.dialog.setText(Messages.getString("Open", new Object[0]));
        this.dialog.setSize(300, 400);
        GridLayout dialoglayout = new GridLayout();
        dialoglayout.numColumns = 1;
        this.dialog.setLayout(dialoglayout);
        Composite portSelection = new Composite(this.dialog, 0);
        portSelection.setLayoutData(new GridData(2, 1, true, false));
        RowLayout portLayout = new RowLayout();
        portLayout.center = true;
        portLayout.wrap = false;
        portSelection.setLayout(portLayout);
        Label label2 = new Label(portSelection, 0x1000000);
        label2.setText(Messages.getString("SerialPort", new Object[0]));
        this.combo = new Combo(portSelection, 8);
        this.getSelectionComponent(this.dialog);
        if (!this.portNames.isEmpty()) {
            for (String s : this.portNames) {
                this.combo.add(s);
            }
            String prefPort = PREFS.get("portName", this.portNames.get(0));
            if (!this.portNames.contains(prefPort)) {
                prefPort = this.portNames.get(0);
            }
            this.combo.setText(prefPort);
            this.portSelected(prefPort);
        }
        this.combo.addModifyListener(new PortListener());
        Composite buttonsComposite = new Composite(this.dialog, 0);
        buttonsComposite.setLayoutData(new GridData(3, 3, false, false));
        buttonsComposite.setLayout(new RowLayout());
        Button openButton = new Button(buttonsComposite, 8);
        openButton.setText(Messages.getString("Open", new Object[0]));
        Button cancelButton = new Button(buttonsComposite, 8);
        cancelButton.setText(Messages.getString("Cancel", new Object[0]));
        buttonsComposite.pack();
        openButton.addListener(13, new OpenListener());
        cancelButton.addListener(13, new CancelListener());
        this.dialog.open();
        Display display = shell.getDisplay();
        while (!this.dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.model;
    }

    private void portSelected(String portName) {
        if (portName != null && portName.length() > 0 && this.portNames.contains(portName)) {
            PREFS.put("portName", portName);
            this.port = new HoTTSerialPort(SerialPort.Companion.getPort(portName));
            this.onReload();
        }
    }

    void showError(Throwable t) {
        MessageBox mb = new MessageBox(this.getParent().getShell(), 0);
        mb.setText(t.getClass().getSimpleName());
        mb.setMessage(t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage());
        mb.open();
        if (Util.INSTANCE.getDEBUG()) {
            t.printStackTrace();
        }
    }

    private final class PortListener
    implements ModifyListener {
        private PortListener() {
        }

        @Override
        public void modifyText(ModifyEvent arg0) {
            SelectFromTransmitterDialog.this.portSelected(SelectFromTransmitterDialog.this.combo.getText());
        }
    }

    private final class OpenListener
    implements Listener {
        private OpenListener() {
        }

        @Override
        public void handleEvent(Event arg0) {
            SelectFromTransmitterDialog.this.onOpen();
            SelectFromTransmitterDialog.this.dialog.close();
        }
    }

    private final class CancelListener
    implements Listener {
        private CancelListener() {
        }

        @Override
        public void handleEvent(Event arg0) {
            SelectFromTransmitterDialog.this.onCancel();
            SelectFromTransmitterDialog.this.dialog.close();
        }
    }
}

