/* 
    Copyright (C) 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */


declare name "cptmelogold";
declare description "melo gold";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.10";
declare license "GPL 3.0 or later";


si = library("signals.lib");
ba = library("basics.lib");
ma = library("maths.lib");
en = library("envelopes.lib");
os = library("oscillators.lib");
no = library("noises.lib");
pm = library("physmodels.lib");
fi = library("effect.lib");

constant = environment {
  nchannels = 2;//number of channels
  nsteps = 16;//number of steps

  //envelope total=1
  envattack = 0.01;
  envdecay = 0.1;
  envrelease = 0.89;
};


freq  =  hgroup("[0]",hgroup("[5] key",vslider("[4][lv2:integer]key",60,0,127,1)));
shift(i) = hgroup("[0]",hgroup("[6] sequencer",vslider("[%shiftorder][lv2:integer]s %stepnh",0,-63,+63,1))) with {shiftorder = i+10; stepnh = i+1;};
egamount = hgroup("[0]",hgroup("[1]osc",vslider("[6]eg amount",0.200,0,1,0.001))) * (60 / bpm) ;
bpm =  hgroup("[0]",hgroup("[4][lv2: integer] bpm",vslider("[0][lv2: integer]bpm",120,1,500,1)));

//high- /lowpass
//
ctfreq = hgroup("[0]",hgroup("[3] filter",vslider("[0][unit:Hz][lv2:integer]lp/hp", 0, -5000, 5000, 1)));
//high- and lowpass calculation
lowpass(ctfreq) = fi.lowpass(1, (10000+ctfreq));
highpass(ctfreq) = fi.highpass(1, ( (ctfreq >0) * ctfreq)+1);


//resonance
//
resonancedepth  = hgroup("[0]",hgroup("[3] filter",vslider("[1]reson",0,0,2,0.01)));
//resonance calcultation
resonance = _<: (resonancedepth * pm.modeFilter(freq,egamount,0.02)),(_*(1-resonancedepth)) :>_;

//oscillators
//
vco123(stepn) = (vco1(stepn) +vco2(stepn))/2 with {
  vco1(i) = vco1slider * (os.square( ba.midikey2hz(freq + shift(i)) + (os.triangle(ba.midikey2hz(freq + shift(i)))*vco2slider) *moddepth));
  vco2(i) = vco2slider * (os.triangle(ba.midikey2hz(freq + shift(i)) + (os.square(ba.midikey2hz(freq + shift(i)))*vco1slider) *moddepth));

  vco1slider = hgroup("[0]",hgroup("[1]osc",vslider("[1]sq os", 1,0,5,0.01)));
  vco2slider = hgroup("[0]",hgroup("[1]osc",vslider("[2]tr os", 1,0,5,0.01)));
  noiseslider = hgroup("[0]",hgroup("[1]osc",vslider("[5]noise", 0,0,5,0.01)));

  moddepth    = hgroup("[0]",hgroup("[1]osc",vslider("[3]fm",0,0,200,0.1)));
};

//sequencer
//
sequencer = (_~asequence)  with {
  triggercheckbox(stepn) = hgroup("[1]",checkbox("[%stepnorder] %stepnh")) with {stepnorder = stepn+10; stepnh = stepn+1;};
  sequencerenable =  hgroup("[0]",hgroup("[7]ctrl",vslider("[1][lv2:integer]seq on",1,0,1,1)));
  playthrough = hgroup("[0]",hgroup("[7]ctrl",vslider("[1][lv2:integer]pl thr",1,0,1,1)));
  gain =  hgroup("[0]",hgroup("[1]osc",vslider("[0]gain",1,0,10,0.1)));

  selectplaythrough = select2(((playthrough == 0)& (sequencerenable == 0)),1,0);

  //all steps in parallel
  asequence =   (par(i,constant.nsteps,onestep(i))):>bargr:_*selectplaythrough;
  
  onestep(stepn) =  envelope(stepn)* vco123(stepn) * triggercheckbox(stepn)* gain;
  
  envelope(stepn) =  en.adsr(egamount*constant.envattack,egamount*constant.envdecay,1,egamount*constant.envrelease,seqpulse@(stepdelay*stepn));

  //output bargraph
 bargr = _<:attach(_,par(stepn,constant.nsteps,((envelope(stepn)>0):ceil)*(stepn+1)):>_ *selectplaythrough:hbargraph("[2]",0,constant.nsteps)) ;
  
  stepdelay = 60 / bpm * ma.SR;

  //pulse for each round
  pulselength = select2(sequencerenable,1, constant.nsteps*stepdelay);
  iseq(x) =  select2(x != x',0,x);
  seqpulse = (ba.period(pulselength)>0):iseq;
};

//manual trigger
//
manualtrigger = (par(stepn,constant.nsteps,mantrig(stepn)):>_) with {
  triggerenable =  hgroup("[0]",hgroup("[7]ctrl",vslider("[0]tri on",0,0,1,1)));
  triggercheckbox(stepn) = hgroup("[1]",checkbox("[%stepnorder] %stepnh")) with {stepnorder = stepn+10; stepnh = stepn+1;};
  
  mantrig(stepn) = envelope(stepn) *vco123(stepn) *triggerenable;

  envelope(stepn) = en.adsr(egamount*constant.envattack,egamount*constant.envdecay,1,egamount*constant.envrelease,triggercheckbox(stepn):ba.impulsify);
};

//process
//
process = par(i,constant.nchannels,_+(sequencer,manualtrigger:>_):lowpass(ctfreq): highpass(ctfreq) : resonance);
