/* marker.c generated by valac 0.56.17, the Vala compiler
 * generated from marker.vala, do not modify */

/* Marker facility functions

   Copyright (c) 2004-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;
typedef struct _MarkerPrivate MarkerPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef struct _ParamSpecMarker ParamSpecMarker;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Marker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MarkerPrivate * priv;
	Buffer* bp;
};

struct _MarkerClass {
	GTypeClass parent_class;
	void (*finalize) (Marker *self);
};

struct _MarkerPrivate {
	Marker* _next;
	gsize _o;
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _ParamSpecMarker {
	GParamSpec parent_instance;
};

static gint Marker_private_offset;
static gpointer marker_parent_class = NULL;
VALA_EXTERN Buffer* cur_bp;
VALA_EXTERN GList* mark_ring;
GList* mark_ring = NULL;

VALA_EXTERN gpointer marker_ref (gpointer instance);
VALA_EXTERN void marker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_marker (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_marker (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_marker (const GValue* value);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN void marker_unchain (Marker* self);
VALA_EXTERN gpointer undo_ref (gpointer instance);
VALA_EXTERN void undo_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_undo (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_undo (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_undo (const GValue* value);
VALA_EXTERN GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
VALA_EXTERN gpointer var_entry_ref (gpointer instance);
VALA_EXTERN void var_entry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_var_entry (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_var_entry (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_var_entry (const GValue* value);
VALA_EXTERN GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
VALA_EXTERN Marker* marker_get_next (Marker* self);
VALA_EXTERN void marker_set_next (Marker* self,
                      Marker* value);
VALA_EXTERN void marker_move (Marker* self,
                  Buffer* bp,
                  gsize o);
VALA_EXTERN void marker_set_o (Marker* self,
                   gsize value);
VALA_EXTERN Marker* marker_copy (Marker* m);
VALA_EXTERN Marker* marker_new (void);
VALA_EXTERN Marker* marker_construct (GType object_type);
VALA_EXTERN gsize marker_get_o (Marker* self);
VALA_EXTERN Marker* marker_point (void);
VALA_EXTERN gsize buffer_get_pt (Buffer* self);
static void marker_finalize (Marker * obj);
static GType marker_get_type_once (void);
VALA_EXTERN void push_mark (void);
VALA_EXTERN gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
VALA_EXTERN void pop_mark (void);
static void _marker_unref0_ (gpointer var);
VALA_EXTERN void set_mark (void);

static inline gpointer
marker_get_instance_private (Marker* self)
{
	return G_STRUCT_MEMBER_P (self, Marker_private_offset);
}

static gpointer
_marker_ref0 (gpointer self)
{
#line 30 "src/marker.vala"
	return self ? marker_ref (self) : NULL;
#line 250 "marker.c"
}

void
marker_unchain (Marker* self)
{
	Buffer* _tmp0_;
	Marker* prev = NULL;
#line 25 "src/marker.vala"
	g_return_if_fail (self != NULL);
#line 26 "src/marker.vala"
	_tmp0_ = self->bp;
#line 26 "src/marker.vala"
	if (_tmp0_ == NULL) {
#line 27 "src/marker.vala"
		return;
#line 266 "marker.c"
	}
#line 29 "src/marker.vala"
	prev = NULL;
#line 270 "marker.c"
	{
		Marker* m = NULL;
		Buffer* _tmp1_;
		Marker* _tmp2_;
		Marker* _tmp3_;
#line 30 "src/marker.vala"
		_tmp1_ = self->bp;
#line 30 "src/marker.vala"
		_tmp2_ = _tmp1_->markers;
#line 30 "src/marker.vala"
		_tmp3_ = _marker_ref0 (_tmp2_);
#line 30 "src/marker.vala"
		m = _tmp3_;
#line 284 "marker.c"
		{
			gboolean _tmp4_ = FALSE;
#line 30 "src/marker.vala"
			_tmp4_ = TRUE;
#line 30 "src/marker.vala"
			while (TRUE) {
#line 291 "marker.c"
				Marker* _tmp8_;
				Marker* _tmp9_;
				Marker* _tmp20_;
				Marker* _tmp21_;
#line 30 "src/marker.vala"
				if (!_tmp4_) {
#line 298 "marker.c"
					Marker* _tmp5_;
					Marker* _tmp6_;
					Marker* _tmp7_;
#line 30 "src/marker.vala"
					_tmp5_ = m;
#line 30 "src/marker.vala"
					_tmp6_ = _tmp5_->priv->_next;
#line 30 "src/marker.vala"
					_tmp7_ = _marker_ref0 (_tmp6_);
#line 30 "src/marker.vala"
					_marker_unref0 (m);
#line 30 "src/marker.vala"
					m = _tmp7_;
#line 312 "marker.c"
				}
#line 30 "src/marker.vala"
				_tmp4_ = FALSE;
#line 30 "src/marker.vala"
				_tmp8_ = m;
#line 30 "src/marker.vala"
				if (!(_tmp8_ != NULL)) {
#line 30 "src/marker.vala"
					break;
#line 322 "marker.c"
				}
#line 31 "src/marker.vala"
				_tmp9_ = m;
#line 31 "src/marker.vala"
				if (_tmp9_ == self) {
#line 328 "marker.c"
					Marker* _tmp10_;
					Marker* _tmp19_;
#line 32 "src/marker.vala"
					_tmp10_ = prev;
#line 32 "src/marker.vala"
					if (_tmp10_ != NULL) {
#line 335 "marker.c"
						Marker* _tmp11_;
						Marker* _tmp12_;
						Marker* _tmp13_;
#line 33 "src/marker.vala"
						_tmp11_ = prev;
#line 33 "src/marker.vala"
						_tmp12_ = m;
#line 33 "src/marker.vala"
						_tmp13_ = _tmp12_->priv->_next;
#line 33 "src/marker.vala"
						marker_set_next (_tmp11_, _tmp13_);
#line 347 "marker.c"
					} else {
						Marker* _tmp14_;
						Buffer* _tmp15_;
						Marker* _tmp16_;
						Marker* _tmp17_;
						Marker* _tmp18_;
#line 35 "src/marker.vala"
						_tmp14_ = m;
#line 35 "src/marker.vala"
						_tmp15_ = _tmp14_->bp;
#line 35 "src/marker.vala"
						_tmp16_ = m;
#line 35 "src/marker.vala"
						_tmp17_ = _tmp16_->priv->_next;
#line 35 "src/marker.vala"
						_tmp18_ = _marker_ref0 (_tmp17_);
#line 35 "src/marker.vala"
						_marker_unref0 (_tmp15_->markers);
#line 35 "src/marker.vala"
						_tmp15_->markers = _tmp18_;
#line 368 "marker.c"
					}
#line 37 "src/marker.vala"
					_tmp19_ = m;
#line 37 "src/marker.vala"
					_buffer_unref0 (_tmp19_->bp);
#line 37 "src/marker.vala"
					_tmp19_->bp = NULL;
#line 38 "src/marker.vala"
					break;
#line 378 "marker.c"
				}
#line 40 "src/marker.vala"
				_tmp20_ = m;
#line 40 "src/marker.vala"
				_tmp21_ = _marker_ref0 (_tmp20_);
#line 40 "src/marker.vala"
				_marker_unref0 (prev);
#line 40 "src/marker.vala"
				prev = _tmp21_;
#line 388 "marker.c"
			}
		}
#line 30 "src/marker.vala"
		_marker_unref0 (m);
#line 393 "marker.c"
	}
#line 25 "src/marker.vala"
	_marker_unref0 (prev);
#line 397 "marker.c"
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 50 "src/marker.vala"
	return self ? buffer_ref (self) : NULL;
#line 405 "marker.c"
}

void
marker_move (Marker* self,
             Buffer* bp,
             gsize o)
{
	Buffer* _tmp0_;
#line 44 "src/marker.vala"
	g_return_if_fail (self != NULL);
#line 44 "src/marker.vala"
	g_return_if_fail (bp != NULL);
#line 45 "src/marker.vala"
	_tmp0_ = self->bp;
#line 45 "src/marker.vala"
	if (bp != _tmp0_) {
#line 422 "marker.c"
		Buffer* _tmp1_;
		Marker* _tmp2_;
		Marker* _tmp3_;
#line 47 "src/marker.vala"
		marker_unchain (self);
#line 50 "src/marker.vala"
		_tmp1_ = _buffer_ref0 (bp);
#line 50 "src/marker.vala"
		_buffer_unref0 (self->bp);
#line 50 "src/marker.vala"
		self->bp = _tmp1_;
#line 53 "src/marker.vala"
		_tmp2_ = bp->markers;
#line 53 "src/marker.vala"
		marker_set_next (self, _tmp2_);
#line 54 "src/marker.vala"
		_tmp3_ = _marker_ref0 (self);
#line 54 "src/marker.vala"
		_marker_unref0 (bp->markers);
#line 54 "src/marker.vala"
		bp->markers = _tmp3_;
#line 444 "marker.c"
	}
#line 58 "src/marker.vala"
	marker_set_o (self, o);
#line 448 "marker.c"
}

Marker*
marker_copy (Marker* m)
{
	Marker* marker = NULL;
	Marker* result;
#line 62 "src/marker.vala"
	marker = NULL;
#line 63 "src/marker.vala"
	if (m != NULL) {
#line 460 "marker.c"
		Marker* _tmp0_;
		Marker* _tmp1_;
		Buffer* _tmp2_;
		gsize _tmp3_;
#line 64 "src/marker.vala"
		_tmp0_ = marker_new ();
#line 64 "src/marker.vala"
		_marker_unref0 (marker);
#line 64 "src/marker.vala"
		marker = _tmp0_;
#line 65 "src/marker.vala"
		_tmp1_ = marker;
#line 65 "src/marker.vala"
		_tmp2_ = m->bp;
#line 65 "src/marker.vala"
		_tmp3_ = m->priv->_o;
#line 65 "src/marker.vala"
		marker_move (_tmp1_, _tmp2_, _tmp3_);
#line 479 "marker.c"
	}
#line 67 "src/marker.vala"
	result = marker;
#line 67 "src/marker.vala"
	return result;
#line 485 "marker.c"
}

Marker*
marker_point (void)
{
	Marker* m = NULL;
	Marker* _tmp0_;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	Marker* result;
#line 71 "src/marker.vala"
	_tmp0_ = marker_new ();
#line 71 "src/marker.vala"
	m = _tmp0_;
#line 72 "src/marker.vala"
	_tmp1_ = cur_bp;
#line 72 "src/marker.vala"
	_tmp2_ = cur_bp;
#line 72 "src/marker.vala"
	_tmp3_ = buffer_get_pt (_tmp2_);
#line 72 "src/marker.vala"
	_tmp4_ = _tmp3_;
#line 72 "src/marker.vala"
	marker_move (m, _tmp1_, _tmp4_);
#line 73 "src/marker.vala"
	result = m;
#line 73 "src/marker.vala"
	return result;
#line 516 "marker.c"
}

Marker*
marker_construct (GType object_type)
{
	Marker* self = NULL;
#line 20 "src/marker.vala"
	self = (Marker*) g_type_create_instance (object_type);
#line 20 "src/marker.vala"
	return self;
#line 527 "marker.c"
}

Marker*
marker_new (void)
{
#line 20 "src/marker.vala"
	return marker_construct (TYPE_MARKER);
#line 535 "marker.c"
}

Marker*
marker_get_next (Marker* self)
{
	Marker* result;
	Marker* _tmp0_;
#line 21 "src/marker.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 21 "src/marker.vala"
	_tmp0_ = self->priv->_next;
#line 21 "src/marker.vala"
	result = _tmp0_;
#line 21 "src/marker.vala"
	return result;
#line 551 "marker.c"
}

void
marker_set_next (Marker* self,
                 Marker* value)
{
	Marker* _tmp0_;
#line 21 "src/marker.vala"
	g_return_if_fail (self != NULL);
#line 21 "src/marker.vala"
	_tmp0_ = _marker_ref0 (value);
#line 21 "src/marker.vala"
	_marker_unref0 (self->priv->_next);
#line 21 "src/marker.vala"
	self->priv->_next = _tmp0_;
#line 567 "marker.c"
}

gsize
marker_get_o (Marker* self)
{
	gsize result;
#line 22 "src/marker.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 22 "src/marker.vala"
	result = self->priv->_o;
#line 22 "src/marker.vala"
	return result;
#line 580 "marker.c"
}

void
marker_set_o (Marker* self,
              gsize value)
{
#line 22 "src/marker.vala"
	g_return_if_fail (self != NULL);
#line 22 "src/marker.vala"
	self->priv->_o = value;
#line 591 "marker.c"
}

static void
value_marker_init (GValue* value)
{
#line 20 "src/marker.vala"
	value->data[0].v_pointer = NULL;
#line 599 "marker.c"
}

static void
value_marker_free_value (GValue* value)
{
#line 20 "src/marker.vala"
	if (value->data[0].v_pointer) {
#line 20 "src/marker.vala"
		marker_unref (value->data[0].v_pointer);
#line 609 "marker.c"
	}
}

static void
value_marker_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
#line 20 "src/marker.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "src/marker.vala"
		dest_value->data[0].v_pointer = marker_ref (src_value->data[0].v_pointer);
#line 621 "marker.c"
	} else {
#line 20 "src/marker.vala"
		dest_value->data[0].v_pointer = NULL;
#line 625 "marker.c"
	}
}

static gpointer
value_marker_peek_pointer (const GValue* value)
{
#line 20 "src/marker.vala"
	return value->data[0].v_pointer;
#line 634 "marker.c"
}

static gchar*
value_marker_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
#line 20 "src/marker.vala"
	if (collect_values[0].v_pointer) {
#line 645 "marker.c"
		Marker * object;
		object = collect_values[0].v_pointer;
#line 20 "src/marker.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "src/marker.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 652 "marker.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "src/marker.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 656 "marker.c"
		}
#line 20 "src/marker.vala"
		value->data[0].v_pointer = marker_ref (object);
#line 660 "marker.c"
	} else {
#line 20 "src/marker.vala"
		value->data[0].v_pointer = NULL;
#line 664 "marker.c"
	}
#line 20 "src/marker.vala"
	return NULL;
#line 668 "marker.c"
}

static gchar*
value_marker_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Marker ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "src/marker.vala"
	if (!object_p) {
#line 20 "src/marker.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 683 "marker.c"
	}
#line 20 "src/marker.vala"
	if (!value->data[0].v_pointer) {
#line 20 "src/marker.vala"
		*object_p = NULL;
#line 689 "marker.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "src/marker.vala"
		*object_p = value->data[0].v_pointer;
#line 693 "marker.c"
	} else {
#line 20 "src/marker.vala"
		*object_p = marker_ref (value->data[0].v_pointer);
#line 697 "marker.c"
	}
#line 20 "src/marker.vala"
	return NULL;
#line 701 "marker.c"
}

GParamSpec*
param_spec_marker (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecMarker* spec;
#line 20 "src/marker.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MARKER), NULL);
#line 20 "src/marker.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "src/marker.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "src/marker.vala"
	return G_PARAM_SPEC (spec);
#line 720 "marker.c"
}

gpointer
value_get_marker (const GValue* value)
{
#line 20 "src/marker.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MARKER), NULL);
#line 20 "src/marker.vala"
	return value->data[0].v_pointer;
#line 730 "marker.c"
}

void
value_set_marker (GValue* value,
                  gpointer v_object)
{
	Marker * old;
#line 20 "src/marker.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MARKER));
#line 20 "src/marker.vala"
	old = value->data[0].v_pointer;
#line 20 "src/marker.vala"
	if (v_object) {
#line 20 "src/marker.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MARKER));
#line 20 "src/marker.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/marker.vala"
		value->data[0].v_pointer = v_object;
#line 20 "src/marker.vala"
		marker_ref (value->data[0].v_pointer);
#line 752 "marker.c"
	} else {
#line 20 "src/marker.vala"
		value->data[0].v_pointer = NULL;
#line 756 "marker.c"
	}
#line 20 "src/marker.vala"
	if (old) {
#line 20 "src/marker.vala"
		marker_unref (old);
#line 762 "marker.c"
	}
}

void
value_take_marker (GValue* value,
                   gpointer v_object)
{
	Marker * old;
#line 20 "src/marker.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MARKER));
#line 20 "src/marker.vala"
	old = value->data[0].v_pointer;
#line 20 "src/marker.vala"
	if (v_object) {
#line 20 "src/marker.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MARKER));
#line 20 "src/marker.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/marker.vala"
		value->data[0].v_pointer = v_object;
#line 783 "marker.c"
	} else {
#line 20 "src/marker.vala"
		value->data[0].v_pointer = NULL;
#line 787 "marker.c"
	}
#line 20 "src/marker.vala"
	if (old) {
#line 20 "src/marker.vala"
		marker_unref (old);
#line 793 "marker.c"
	}
}

static void
marker_class_init (MarkerClass * klass,
                   gpointer klass_data)
{
#line 20 "src/marker.vala"
	marker_parent_class = g_type_class_peek_parent (klass);
#line 20 "src/marker.vala"
	((MarkerClass *) klass)->finalize = marker_finalize;
#line 20 "src/marker.vala"
	g_type_class_adjust_private_offset (klass, &Marker_private_offset);
#line 807 "marker.c"
}

static void
marker_instance_init (Marker * self,
                      gpointer klass)
{
#line 20 "src/marker.vala"
	self->priv = marker_get_instance_private (self);
#line 20 "src/marker.vala"
	self->ref_count = 1;
#line 818 "marker.c"
}

static void
marker_finalize (Marker * obj)
{
	Marker * self;
#line 20 "src/marker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MARKER, Marker);
#line 20 "src/marker.vala"
	g_signal_handlers_destroy (self);
#line 21 "src/marker.vala"
	_marker_unref0 (self->priv->_next);
#line 23 "src/marker.vala"
	_buffer_unref0 (self->bp);
#line 833 "marker.c"
}

static GType
marker_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_marker_init, value_marker_free_value, value_marker_copy_value, value_marker_peek_pointer, "p", value_marker_collect_value, "p", value_marker_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) marker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Marker), 0, (GInstanceInitFunc) marker_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType marker_type_id;
	marker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Marker", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Marker_private_offset = g_type_add_instance_private (marker_type_id, sizeof (MarkerPrivate));
	return marker_type_id;
}

GType
marker_get_type (void)
{
	static volatile gsize marker_type_id__once = 0;
	if (g_once_init_enter (&marker_type_id__once)) {
		GType marker_type_id;
		marker_type_id = marker_get_type_once ();
		g_once_init_leave (&marker_type_id__once, marker_type_id);
	}
	return marker_type_id__once;
}

gpointer
marker_ref (gpointer instance)
{
	Marker * self;
	self = instance;
#line 20 "src/marker.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "src/marker.vala"
	return instance;
#line 869 "marker.c"
}

void
marker_unref (gpointer instance)
{
	Marker * self;
	self = instance;
#line 20 "src/marker.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "src/marker.vala"
		MARKER_GET_CLASS (self)->finalize (self);
#line 20 "src/marker.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 883 "marker.c"
	}
}

void
push_mark (void)
{
	Buffer* _tmp0_;
	Marker* _tmp1_;
#line 86 "src/marker.vala"
	_tmp0_ = cur_bp;
#line 86 "src/marker.vala"
	_tmp1_ = _tmp0_->mark;
#line 86 "src/marker.vala"
	if (_tmp1_ != NULL) {
#line 898 "marker.c"
		Buffer* _tmp2_;
		Marker* _tmp3_;
		Marker* _tmp4_;
#line 87 "src/marker.vala"
		_tmp2_ = cur_bp;
#line 87 "src/marker.vala"
		_tmp3_ = _tmp2_->mark;
#line 87 "src/marker.vala"
		_tmp4_ = marker_copy (_tmp3_);
#line 87 "src/marker.vala"
		mark_ring = g_list_append (mark_ring, _tmp4_);
#line 910 "marker.c"
	} else {
		Marker* m = NULL;
		Marker* _tmp5_;
		Marker* _tmp6_;
		Buffer* _tmp7_;
		Marker* _tmp8_;
		Marker* _tmp9_;
#line 89 "src/marker.vala"
		_tmp5_ = marker_new ();
#line 89 "src/marker.vala"
		m = _tmp5_;
#line 90 "src/marker.vala"
		_tmp6_ = m;
#line 90 "src/marker.vala"
		_tmp7_ = cur_bp;
#line 90 "src/marker.vala"
		marker_move (_tmp6_, _tmp7_, (gsize) 0);
#line 91 "src/marker.vala"
		_tmp8_ = m;
#line 91 "src/marker.vala"
		_tmp9_ = _marker_ref0 (_tmp8_);
#line 91 "src/marker.vala"
		mark_ring = g_list_append (mark_ring, _tmp9_);
#line 86 "src/marker.vala"
		_marker_unref0 (m);
#line 936 "marker.c"
	}
#line 94 "src/marker.vala"
	funcall ("set-mark", NULL, NULL);
#line 940 "marker.c"
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
#line 5230 "glib-2.0.vapi"
	l = self;
#line 5231 "glib-2.0.vapi"
	while (TRUE) {
#line 954 "marker.c"
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
#line 5231 "glib-2.0.vapi"
		_tmp0_ = l;
#line 5231 "glib-2.0.vapi"
		if (!(_tmp0_ != NULL)) {
#line 5231 "glib-2.0.vapi"
			break;
#line 964 "marker.c"
		}
#line 5232 "glib-2.0.vapi"
		_tmp1_ = l;
#line 5232 "glib-2.0.vapi"
		_tmp2_ = ((GList*) _tmp1_)->data;
#line 5232 "glib-2.0.vapi"
		if (_tmp2_ != data) {
#line 972 "marker.c"
			GList* _tmp3_;
			GList* _tmp4_;
#line 5233 "glib-2.0.vapi"
			_tmp3_ = l;
#line 5233 "glib-2.0.vapi"
			_tmp4_ = ((GList*) _tmp3_)->next;
#line 5233 "glib-2.0.vapi"
			l = _tmp4_;
#line 981 "marker.c"
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
#line 5235 "glib-2.0.vapi"
			_tmp5_ = l;
#line 5235 "glib-2.0.vapi"
			_tmp6_ = ((GList*) _tmp5_)->data;
#line 5235 "glib-2.0.vapi"
			func (_tmp6_);
#line 5236 "glib-2.0.vapi"
			_tmp7_ = l;
#line 5236 "glib-2.0.vapi"
			self = g_list_delete_link (self, (GList*) _tmp7_);
#line 5237 "glib-2.0.vapi"
			break;
#line 998 "marker.c"
		}
	}
#line 5240 "glib-2.0.vapi"
	result = self;
#line 5240 "glib-2.0.vapi"
	return result;
#line 1005 "marker.c"
}

static void
_marker_unref0_ (gpointer var)
{
#line 111 "src/marker.vala"
	(var == NULL) ? NULL : (var = (marker_unref (var), NULL));
#line 1013 "marker.c"
}

void
pop_mark (void)
{
	Marker* m = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	Marker* _tmp3_;
	Marker* _tmp4_;
	Marker* _tmp5_;
	Buffer* _tmp6_;
	Marker* buf_m = NULL;
	Marker* _tmp7_;
	Buffer* _tmp8_;
	Marker* _tmp9_;
	Marker* _tmp10_;
	Marker* _tmp11_;
	Marker* _tmp13_;
	Buffer* _tmp14_;
	Marker* _tmp15_;
	Marker* _tmp16_;
	Marker* _tmp17_;
	Marker* _tmp18_;
#line 99 "src/marker.vala"
	_tmp0_ = mark_ring;
#line 99 "src/marker.vala"
	_tmp1_ = mark_ring;
#line 99 "src/marker.vala"
	_tmp2_ = g_list_nth_data (_tmp0_, g_list_length (_tmp1_) - 1);
#line 99 "src/marker.vala"
	_tmp3_ = _marker_ref0 ((Marker*) _tmp2_);
#line 99 "src/marker.vala"
	m = _tmp3_;
#line 100 "src/marker.vala"
	_tmp4_ = m;
#line 100 "src/marker.vala"
	_vala_assert (_tmp4_ != NULL, "m != null");
#line 103 "src/marker.vala"
	_tmp5_ = m;
#line 103 "src/marker.vala"
	_tmp6_ = _tmp5_->bp;
#line 103 "src/marker.vala"
	_vala_assert (_tmp6_ != NULL, "m.bp != null");
#line 104 "src/marker.vala"
	_tmp7_ = m;
#line 104 "src/marker.vala"
	_tmp8_ = _tmp7_->bp;
#line 104 "src/marker.vala"
	_tmp9_ = _tmp8_->mark;
#line 104 "src/marker.vala"
	_tmp10_ = _marker_ref0 (_tmp9_);
#line 104 "src/marker.vala"
	buf_m = _tmp10_;
#line 105 "src/marker.vala"
	_tmp11_ = buf_m;
#line 105 "src/marker.vala"
	if (_tmp11_ != NULL) {
#line 1073 "marker.c"
		Marker* _tmp12_;
#line 106 "src/marker.vala"
		_tmp12_ = buf_m;
#line 106 "src/marker.vala"
		marker_unchain (_tmp12_);
#line 1079 "marker.c"
	}
#line 108 "src/marker.vala"
	_tmp13_ = m;
#line 108 "src/marker.vala"
	_tmp14_ = _tmp13_->bp;
#line 108 "src/marker.vala"
	_tmp15_ = m;
#line 108 "src/marker.vala"
	_tmp16_ = marker_copy (_tmp15_);
#line 108 "src/marker.vala"
	_marker_unref0 (_tmp14_->mark);
#line 108 "src/marker.vala"
	_tmp14_->mark = _tmp16_;
#line 110 "src/marker.vala"
	_tmp17_ = m;
#line 110 "src/marker.vala"
	marker_unchain (_tmp17_);
#line 111 "src/marker.vala"
	_tmp18_ = m;
#line 111 "src/marker.vala"
	mark_ring = vala_g_list_remove_full (mark_ring, _tmp18_, _marker_unref0_);
#line 98 "src/marker.vala"
	_marker_unref0 (buf_m);
#line 98 "src/marker.vala"
	_marker_unref0 (m);
#line 1105 "marker.c"
}

void
set_mark (void)
{
	Buffer* _tmp0_;
	Marker* _tmp1_;
#line 116 "src/marker.vala"
	_tmp0_ = cur_bp;
#line 116 "src/marker.vala"
	_tmp1_ = _tmp0_->mark;
#line 116 "src/marker.vala"
	if (_tmp1_ == NULL) {
#line 1119 "marker.c"
		Buffer* _tmp2_;
		Marker* _tmp3_;
#line 117 "src/marker.vala"
		_tmp2_ = cur_bp;
#line 117 "src/marker.vala"
		_tmp3_ = marker_point ();
#line 117 "src/marker.vala"
		_marker_unref0 (_tmp2_->mark);
#line 117 "src/marker.vala"
		_tmp2_->mark = _tmp3_;
#line 1130 "marker.c"
	} else {
		Buffer* _tmp4_;
		Marker* _tmp5_;
		Buffer* _tmp6_;
		Buffer* _tmp7_;
		gsize _tmp8_;
		gsize _tmp9_;
#line 119 "src/marker.vala"
		_tmp4_ = cur_bp;
#line 119 "src/marker.vala"
		_tmp5_ = _tmp4_->mark;
#line 119 "src/marker.vala"
		_tmp6_ = cur_bp;
#line 119 "src/marker.vala"
		_tmp7_ = cur_bp;
#line 119 "src/marker.vala"
		_tmp8_ = buffer_get_pt (_tmp7_);
#line 119 "src/marker.vala"
		_tmp9_ = _tmp8_;
#line 119 "src/marker.vala"
		marker_move (_tmp5_, _tmp6_, _tmp9_);
#line 1152 "marker.c"
	}
}

