--
-- This file is part of GNUnet
-- Copyright (C) 2014--2022 GNUnet e.V.
--
-- GNUnet is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- GNUnet is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- GNUnet; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- Everything in one big transaction
BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('datacache-0001', NULL, NULL);

-------------------- Schema ----------------------------

CREATE SCHEMA datacache;
COMMENT ON SCHEMA datacache IS 'gnunet-datacache data';

SET search_path TO datacache;

CREATE TABLE IF NOT EXISTS gn180dc (
  oid BIGINT GENERATED BY DEFAULT AS IDENTITY,
  type INT4 NOT NULL,
  ro INT4 NOT NULL,
  prox INT4 NOT NULL,
  expiration_time INT8 NOT NULL,
  key BYTEA NOT NULL CHECK(LENGTH(key)=64),
  trunc BYTEA NOT NULL CHECK(LENGTH(trunc)=32),
  value BYTEA NOT NULL,
  path BYTEA DEFAULT NULL);

CREATE INDEX IF NOT EXISTS idx_oid
  ON gn180dc (oid);
CREATE INDEX IF NOT EXISTS idx_key
  ON gn180dc (key);
CREATE INDEX IF NOT EXISTS idx_dt
  ON gn180dc (expiration_time);

COMMIT;
