/* valascanner.c generated by valac, the Vala compiler
 * generated from valascanner.vala, do not modify */

/* valascanner.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define VALA_SCANNER_TYPE_CONDITIONAL (vala_scanner_conditional_get_type ())
typedef struct _ValaScannerConditional ValaScannerConditional;
typedef enum  {
	VALA_SCANNER_STATE_PARENS,
	VALA_SCANNER_STATE_BRACE,
	VALA_SCANNER_STATE_BRACKET,
	VALA_SCANNER_STATE_TEMPLATE,
	VALA_SCANNER_STATE_TEMPLATE_PART,
	VALA_SCANNER_STATE_REGEX_LITERAL
} ValaScannerState;

#define VALA_SCANNER_TYPE_STATE (vala_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

struct _ValaScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

struct _ValaScannerPrivate {
	ValaSourceFile* _source_file;
	ValaTokenType previous;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaComment* _comment;
	ValaScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};

static gint ValaScanner_private_offset;
static gpointer vala_scanner_parent_class = NULL;

static GType vala_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self);
static void vala_scanner_conditional_free (ValaScannerConditional* self);
static GType vala_scanner_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_scanner_set_source_file (ValaScanner* self,
                                   ValaSourceFile* value);
static gboolean vala_scanner_in_template (ValaScanner* self);
static gboolean vala_scanner_in_template_part (ValaScanner* self);
static gboolean vala_scanner_in_regex_literal (ValaScanner* self);
static gboolean vala_scanner_is_ident_char (ValaScanner* self,
                                     gchar c);
static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self,
                                                        gint offset,
                                                        gint length);
static gboolean vala_scanner_matches (gchar* begin,
                               const gchar* keyword);
static ValaTokenType vala_scanner_read_number (ValaScanner* self);
static void _vala_array_add13 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void _vala_array_add14 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void _vala_array_add15 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void _vala_array_add16 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void vala_scanner_space (ValaScanner* self);
static void _vala_array_add17 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void _vala_array_add18 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void _vala_array_add19 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void _vala_array_add20 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static void _vala_array_add21 (ValaScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaScannerState value);
static gboolean vala_scanner_pp_whitespace (ValaScanner* self);
static void vala_scanner_pp_space (ValaScanner* self);
static gboolean vala_scanner_comment (ValaScanner* self,
                               gboolean file_comment);
static void vala_scanner_pp_directive (ValaScanner* self);
static void vala_scanner_parse_pp_if (ValaScanner* self);
static void vala_scanner_parse_pp_elif (ValaScanner* self);
static void vala_scanner_parse_pp_else (ValaScanner* self);
static void vala_scanner_parse_pp_endif (ValaScanner* self);
static void vala_scanner_pp_eol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_expression (ValaScanner* self);
static void _vala_array_add22 (ValaScannerConditional* * array,
                        gint* length,
                        gint* size,
                        const ValaScannerConditional* value);
static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self);
static gboolean vala_scanner_whitespace (ValaScanner* self);
static void vala_scanner_push_comment (ValaScanner* self,
                                const gchar* comment_item,
                                ValaSourceReference* source_reference,
                                gboolean file_comment);
static void vala_scanner_finalize (ValaScanner * obj);
static GType vala_scanner_get_type_once (void);

static inline gpointer
vala_scanner_get_instance_private (ValaScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValaScanner_private_offset);
}

static GType
vala_scanner_state_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_SCANNER_STATE_PARENS, "VALA_SCANNER_STATE_PARENS", "parens"}, {VALA_SCANNER_STATE_BRACE, "VALA_SCANNER_STATE_BRACE", "brace"}, {VALA_SCANNER_STATE_BRACKET, "VALA_SCANNER_STATE_BRACKET", "bracket"}, {VALA_SCANNER_STATE_TEMPLATE, "VALA_SCANNER_STATE_TEMPLATE", "template"}, {VALA_SCANNER_STATE_TEMPLATE_PART, "VALA_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {VALA_SCANNER_STATE_REGEX_LITERAL, "VALA_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {0, NULL, NULL}};
	GType vala_scanner_state_type_id;
	vala_scanner_state_type_id = g_enum_register_static ("ValaScannerState", values);
	return vala_scanner_state_type_id;
}

static GType
vala_scanner_state_get_type (void)
{
	static volatile gsize vala_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_state_type_id__volatile)) {
		GType vala_scanner_state_type_id;
		vala_scanner_state_type_id = vala_scanner_state_get_type_once ();
		g_once_init_leave (&vala_scanner_state_type_id__volatile, vala_scanner_state_type_id);
	}
	return vala_scanner_state_type_id__volatile;
}

ValaSourceFile*
vala_scanner_get_source_file (ValaScanner* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static void
vala_scanner_set_source_file (ValaScanner* self,
                              ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp0_;
}

ValaScanner*
vala_scanner_construct (GType object_type,
                        ValaSourceFile* source_file)
{
	ValaScanner* self = NULL;
	gchar* begin = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaScanner*) g_type_create_instance (object_type);
	vala_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	begin = _tmp0_;
	self->priv->end = begin + vala_source_file_get_mapped_length (source_file);
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}

ValaScanner*
vala_scanner_new (ValaSourceFile* source_file)
{
	return vala_scanner_construct (VALA_TYPE_SCANNER, source_file);
}

void
vala_scanner_seek (ValaScanner* self,
                   ValaSourceLocation* location)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	self->priv->line = _tmp2_.line;
	_tmp3_ = *location;
	self->priv->column = _tmp3_.column;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}

static gboolean
vala_scanner_in_template (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_scanner_in_template_part (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_scanner_in_regex_literal (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_scanner_is_ident_char (ValaScanner* self,
                            gchar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}

static ValaSourceReference*
vala_scanner_get_source_reference (ValaScanner* self,
                                   gint offset,
                                   gint length)
{
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	ValaSourceReference* _tmp5_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	vala_source_location_init (&_tmp2_, _tmp1_, self->priv->line, self->priv->column + offset);
	_tmp3_ = self->priv->current;
	vala_source_location_init (&_tmp4_, _tmp3_ + length, self->priv->line, (self->priv->column + offset) + length);
	_tmp5_ = vala_source_reference_new (_tmp0_, &_tmp2_, &_tmp4_);
	result = _tmp5_;
	return result;
}

ValaTokenType
vala_scanner_read_regex_token (ValaScanner* self,
                               ValaSourceLocation* token_begin,
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp112_;
	ValaTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '/':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				gboolean fl_i = FALSE;
				gboolean fl_s = FALSE;
				gboolean fl_m = FALSE;
				gboolean fl_x = FALSE;
				type = VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gchar* _tmp11_;
					gchar _tmp12_;
					gchar* _tmp19_;
					gchar _tmp20_;
					gchar* _tmp29_;
					gint _tmp30_;
					_tmp11_ = self->priv->current;
					_tmp12_ = _tmp11_[0];
					if (_tmp12_ == 'i') {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp13_;
						gchar _tmp14_;
						_tmp13_ = self->priv->current;
						_tmp14_ = _tmp13_[0];
						_tmp10_ = _tmp14_ == 's';
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp9_ = _tmp16_ == 'm';
					}
					if (_tmp9_) {
						_tmp8_ = TRUE;
					} else {
						gchar* _tmp17_;
						gchar _tmp18_;
						_tmp17_ = self->priv->current;
						_tmp18_ = _tmp17_[0];
						_tmp8_ = _tmp18_ == 'x';
					}
					if (!_tmp8_) {
						break;
					}
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_[0];
					switch (_tmp20_) {
						case 'i':
						{
							if (fl_i) {
								ValaSourceReference* _tmp21_;
								ValaSourceReference* _tmp22_;
								_tmp21_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp22_ = _tmp21_;
								vala_report_error (_tmp22_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp22_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							if (fl_s) {
								ValaSourceReference* _tmp23_;
								ValaSourceReference* _tmp24_;
								_tmp23_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp24_ = _tmp23_;
								vala_report_error (_tmp24_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp24_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							if (fl_m) {
								ValaSourceReference* _tmp25_;
								ValaSourceReference* _tmp26_;
								_tmp25_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp26_ = _tmp25_;
								vala_report_error (_tmp26_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp26_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							if (fl_x) {
								ValaSourceReference* _tmp27_;
								ValaSourceReference* _tmp28_;
								_tmp27_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp28_ = _tmp27_;
								vala_report_error (_tmp28_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp28_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp29_ = self->priv->current;
					self->priv->current = _tmp29_ + 1;
					_tmp30_ = token_length_in_chars;
					token_length_in_chars = _tmp30_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp99_ = FALSE;
				gchar* _tmp100_;
				gchar* _tmp101_;
				type = VALA_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp31_ = FALSE;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp36_;
					gchar _tmp37_;
					_tmp32_ = self->priv->current;
					_tmp33_ = self->priv->end;
					if (_tmp32_ < _tmp33_) {
						gchar* _tmp34_;
						gchar _tmp35_;
						_tmp34_ = self->priv->current;
						_tmp35_ = _tmp34_[0];
						_tmp31_ = _tmp35_ != '/';
					} else {
						_tmp31_ = FALSE;
					}
					if (!_tmp31_) {
						break;
					}
					_tmp36_ = self->priv->current;
					_tmp37_ = _tmp36_[0];
					if (_tmp37_ == '\\') {
						gchar* _tmp38_;
						gint _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar _tmp43_;
						_tmp38_ = self->priv->current;
						self->priv->current = _tmp38_ + 1;
						_tmp39_ = token_length_in_chars;
						token_length_in_chars = _tmp39_ + 1;
						_tmp40_ = self->priv->current;
						_tmp41_ = self->priv->end;
						if (_tmp40_ >= _tmp41_) {
							break;
						}
						_tmp42_ = self->priv->current;
						_tmp43_ = _tmp42_[0];
						switch (_tmp43_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'N':
							case 'r':
							case 'R':
							case 't':
							case 'v':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp44_;
								gint _tmp45_;
								_tmp44_ = self->priv->current;
								self->priv->current = _tmp44_ + 1;
								_tmp45_ = token_length_in_chars;
								token_length_in_chars = _tmp45_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp46_;
								gint _tmp47_;
								gint digit_length = 0;
								_tmp46_ = self->priv->current;
								self->priv->current = _tmp46_ + 1;
								_tmp47_ = token_length_in_chars;
								token_length_in_chars = _tmp47_ + 1;
								{
									gboolean _tmp48_ = FALSE;
									digit_length = 0;
									_tmp48_ = TRUE;
									while (TRUE) {
										gboolean _tmp50_ = FALSE;
										gchar* _tmp51_;
										gchar* _tmp52_;
										gchar* _tmp55_;
										gint _tmp56_;
										if (!_tmp48_) {
											gint _tmp49_;
											_tmp49_ = digit_length;
											digit_length = _tmp49_ + 1;
										}
										_tmp48_ = FALSE;
										_tmp51_ = self->priv->current;
										_tmp52_ = self->priv->end;
										if (_tmp51_ < _tmp52_) {
											gchar* _tmp53_;
											gchar _tmp54_;
											_tmp53_ = self->priv->current;
											_tmp54_ = _tmp53_[0];
											_tmp50_ = g_ascii_isxdigit (_tmp54_);
										} else {
											_tmp50_ = FALSE;
										}
										if (!_tmp50_) {
											break;
										}
										_tmp55_ = self->priv->current;
										self->priv->current = _tmp55_ + 1;
										_tmp56_ = token_length_in_chars;
										token_length_in_chars = _tmp56_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp57_;
									ValaSourceReference* _tmp58_;
									_tmp57_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp58_ = _tmp57_;
									vala_report_error (_tmp58_, "\\u used with no following hex digits");
									_vala_source_reference_unref0 (_tmp58_);
								} else {
									if (digit_length < 4) {
										ValaSourceReference* _tmp59_;
										ValaSourceReference* _tmp60_;
										_tmp59_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp60_ = _tmp59_;
										vala_report_error (_tmp60_, "incomplete universal character name");
										_vala_source_reference_unref0 (_tmp60_);
									}
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp61_;
								gint _tmp62_;
								gint digit_length = 0;
								gboolean empty = FALSE;
								gboolean _tmp74_ = FALSE;
								_tmp61_ = self->priv->current;
								self->priv->current = _tmp61_ + 1;
								_tmp62_ = token_length_in_chars;
								token_length_in_chars = _tmp62_ + 1;
								empty = TRUE;
								{
									gboolean _tmp63_ = FALSE;
									digit_length = 0;
									_tmp63_ = TRUE;
									while (TRUE) {
										gboolean _tmp64_ = FALSE;
										gchar* _tmp65_;
										gchar* _tmp66_;
										gchar* _tmp69_;
										gchar _tmp70_;
										gchar* _tmp72_;
										gint _tmp73_;
										if (!_tmp63_) {
										}
										_tmp63_ = FALSE;
										_tmp65_ = self->priv->current;
										_tmp66_ = self->priv->end;
										if (_tmp65_ < _tmp66_) {
											gchar* _tmp67_;
											gchar _tmp68_;
											_tmp67_ = self->priv->current;
											_tmp68_ = _tmp67_[0];
											_tmp64_ = g_ascii_isxdigit (_tmp68_);
										} else {
											_tmp64_ = FALSE;
										}
										if (!_tmp64_) {
											break;
										}
										_tmp69_ = self->priv->current;
										_tmp70_ = _tmp69_[0];
										if (_tmp70_ != '0') {
											gint _tmp71_;
											_tmp71_ = digit_length;
											digit_length = _tmp71_ + 1;
										} else {
											empty = FALSE;
										}
										_tmp72_ = self->priv->current;
										self->priv->current = _tmp72_ + 1;
										_tmp73_ = token_length_in_chars;
										token_length_in_chars = _tmp73_ + 1;
									}
								}
								if (empty) {
									_tmp74_ = digit_length < 1;
								} else {
									_tmp74_ = FALSE;
								}
								if (_tmp74_) {
									ValaSourceReference* _tmp75_;
									ValaSourceReference* _tmp76_;
									_tmp75_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp76_ = _tmp75_;
									vala_report_error (_tmp76_, "\\x used with no following hex digits");
									_vala_source_reference_unref0 (_tmp76_);
								} else {
									if (digit_length > 2) {
										ValaSourceReference* _tmp77_;
										ValaSourceReference* _tmp78_;
										_tmp77_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp78_ = _tmp77_;
										vala_report_error (_tmp78_, "hex escape sequence out of range");
										_vala_source_reference_unref0 (_tmp78_);
									}
								}
								break;
							}
							default:
							{
								gchar* _tmp79_;
								gchar _tmp80_;
								_tmp79_ = self->priv->current;
								_tmp80_ = _tmp79_[0];
								if (g_ascii_isdigit (_tmp80_)) {
									gchar* _tmp81_;
									gint _tmp82_;
									gchar* _tmp83_;
									gchar _tmp84_;
									_tmp81_ = self->priv->current;
									self->priv->current = _tmp81_ + 1;
									_tmp82_ = token_length_in_chars;
									token_length_in_chars = _tmp82_ + 1;
									_tmp83_ = self->priv->current;
									_tmp84_ = _tmp83_[0];
									if (g_ascii_isdigit (_tmp84_)) {
										gchar* _tmp85_;
										gint _tmp86_;
										_tmp85_ = self->priv->current;
										self->priv->current = _tmp85_ + 1;
										_tmp86_ = token_length_in_chars;
										token_length_in_chars = _tmp86_ + 1;
									}
								} else {
									ValaSourceReference* _tmp87_;
									ValaSourceReference* _tmp88_;
									_tmp87_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp88_ = _tmp87_;
									vala_report_error (_tmp88_, "invalid escape sequence");
									_vala_source_reference_unref0 (_tmp88_);
								}
								break;
							}
						}
					} else {
						gchar* _tmp89_;
						gchar _tmp90_;
						_tmp89_ = self->priv->current;
						_tmp90_ = _tmp89_[0];
						if (_tmp90_ == '\n') {
							break;
						} else {
							gunichar u = 0U;
							gchar* _tmp91_;
							gchar* _tmp92_;
							gchar* _tmp93_;
							_tmp91_ = self->priv->current;
							_tmp92_ = self->priv->end;
							_tmp93_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp91_, (gssize) ((glong) (_tmp92_ - _tmp93_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp94_;
								gint _tmp95_;
								_tmp94_ = self->priv->current;
								self->priv->current = _tmp94_ + g_unichar_to_utf8 (u, NULL);
								_tmp95_ = token_length_in_chars;
								token_length_in_chars = _tmp95_ + 1;
							} else {
								gchar* _tmp96_;
								ValaSourceReference* _tmp97_;
								ValaSourceReference* _tmp98_;
								_tmp96_ = self->priv->current;
								self->priv->current = _tmp96_ + 1;
								_tmp97_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp98_ = _tmp97_;
								vala_report_error (_tmp98_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp98_);
							}
						}
					}
				}
				_tmp100_ = self->priv->current;
				_tmp101_ = self->priv->end;
				if (_tmp100_ >= _tmp101_) {
					_tmp99_ = TRUE;
				} else {
					gchar* _tmp102_;
					gchar _tmp103_;
					_tmp102_ = self->priv->current;
					_tmp103_ = _tmp102_[0];
					_tmp99_ = _tmp103_ == '\n';
				}
				if (_tmp99_) {
					ValaSourceReference* _tmp104_;
					ValaSourceReference* _tmp105_;
					gint _tmp106_;
					ValaSourceLocation _tmp107_ = {0};
					ValaSourceLocation _tmp108_ = {0};
					ValaTokenType _tmp109_;
					_tmp104_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp105_ = _tmp104_;
					vala_report_error (_tmp105_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp105_);
					_tmp106_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp106_ - 1;
					_tmp109_ = vala_scanner_read_token (self, &_tmp107_, &_tmp108_);
					_vala_token_begin = _tmp107_;
					_vala_token_end = _tmp108_;
					result = _tmp109_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp110_;
		gchar* _tmp111_;
		_tmp110_ = self->priv->current;
		_tmp111_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp110_ - _tmp111_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp112_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp112_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

ValaTokenType
vala_scanner_get_identifier_or_keyword (gchar* begin,
                                        gint len)
{
	ValaTokenType result = 0;
	switch (len) {
		case 2:
		{
			gchar _tmp0_;
			_tmp0_ = begin[0];
			switch (_tmp0_) {
				case 'a':
				{
					if (vala_scanner_matches (begin, "as")) {
						result = VALA_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_scanner_matches (begin, "do")) {
						result = VALA_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar _tmp1_;
					_tmp1_ = begin[1];
					switch (_tmp1_) {
						case 'f':
						{
							result = VALA_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar _tmp2_;
			_tmp2_ = begin[0];
			switch (_tmp2_) {
				case 'f':
				{
					if (vala_scanner_matches (begin, "for")) {
						result = VALA_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					if (vala_scanner_matches (begin, "get")) {
						result = VALA_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_scanner_matches (begin, "new")) {
						result = VALA_TOKEN_TYPE_NEW;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_scanner_matches (begin, "out")) {
						result = VALA_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_scanner_matches (begin, "ref")) {
						result = VALA_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_scanner_matches (begin, "set")) {
						result = VALA_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_scanner_matches (begin, "try")) {
						result = VALA_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "var")) {
						result = VALA_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar _tmp3_;
			_tmp3_ = begin[0];
			switch (_tmp3_) {
				case 'b':
				{
					if (vala_scanner_matches (begin, "base")) {
						result = VALA_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_scanner_matches (begin, "case")) {
						result = VALA_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp4_;
					_tmp4_ = begin[1];
					switch (_tmp4_) {
						case 'l':
						{
							if (vala_scanner_matches (begin, "else")) {
								result = VALA_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							if (vala_scanner_matches (begin, "enum")) {
								result = VALA_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'l':
				{
					if (vala_scanner_matches (begin, "lock")) {
						result = VALA_TOKEN_TYPE_LOCK;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_scanner_matches (begin, "null")) {
						result = VALA_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar _tmp5_;
					_tmp5_ = begin[1];
					switch (_tmp5_) {
						case 'h':
						{
							if (vala_scanner_matches (begin, "this")) {
								result = VALA_TOKEN_TYPE_THIS;
								return result;
							}
							break;
						}
						case 'r':
						{
							if (vala_scanner_matches (begin, "true")) {
								result = VALA_TOKEN_TYPE_TRUE;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "void")) {
						result = VALA_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_scanner_matches (begin, "weak")) {
						result = VALA_TOKEN_TYPE_WEAK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar _tmp6_;
			_tmp6_ = begin[0];
			switch (_tmp6_) {
				case 'a':
				{
					if (vala_scanner_matches (begin, "async")) {
						result = VALA_TOKEN_TYPE_ASYNC;
						return result;
					}
					break;
				}
				case 'b':
				{
					if (vala_scanner_matches (begin, "break")) {
						result = VALA_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar _tmp7_;
					_tmp7_ = begin[1];
					switch (_tmp7_) {
						case 'a':
						{
							if (vala_scanner_matches (begin, "catch")) {
								result = VALA_TOKEN_TYPE_CATCH;
								return result;
							}
							break;
						}
						case 'l':
						{
							if (vala_scanner_matches (begin, "class")) {
								result = VALA_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_scanner_matches (begin, "const")) {
								result = VALA_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'f':
				{
					if (vala_scanner_matches (begin, "false")) {
						result = VALA_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_scanner_matches (begin, "owned")) {
						result = VALA_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_scanner_matches (begin, "throw")) {
						result = VALA_TOKEN_TYPE_THROW;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_scanner_matches (begin, "using")) {
						result = VALA_TOKEN_TYPE_USING;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_scanner_matches (begin, "while")) {
						result = VALA_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					if (vala_scanner_matches (begin, "yield")) {
						result = VALA_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar _tmp8_;
			_tmp8_ = begin[0];
			switch (_tmp8_) {
				case 'd':
				{
					if (vala_scanner_matches (begin, "delete")) {
						result = VALA_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'e':
				{
					if (vala_scanner_matches (begin, "extern")) {
						result = VALA_TOKEN_TYPE_EXTERN;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_scanner_matches (begin, "inline")) {
						result = VALA_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp9_;
					_tmp9_ = begin[1];
					switch (_tmp9_) {
						case 'a':
						{
							if (vala_scanner_matches (begin, "params")) {
								result = VALA_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							if (vala_scanner_matches (begin, "public")) {
								result = VALA_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					if (vala_scanner_matches (begin, "return")) {
						result = VALA_TOKEN_TYPE_RETURN;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar _tmp10_;
					_tmp10_ = begin[1];
					switch (_tmp10_) {
						case 'e':
						{
							if (vala_scanner_matches (begin, "sealed")) {
								result = VALA_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							gchar _tmp11_;
							_tmp11_ = begin[2];
							switch (_tmp11_) {
								case 'g':
								{
									if (vala_scanner_matches (begin, "signal")) {
										result = VALA_TOKEN_TYPE_SIGNAL;
										return result;
									}
									break;
								}
								case 'z':
								{
									if (vala_scanner_matches (begin, "sizeof")) {
										result = VALA_TOKEN_TYPE_SIZEOF;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 't':
						{
							gchar _tmp12_;
							_tmp12_ = begin[2];
							switch (_tmp12_) {
								case 'a':
								{
									if (vala_scanner_matches (begin, "static")) {
										result = VALA_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									if (vala_scanner_matches (begin, "struct")) {
										result = VALA_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 'w':
						{
							if (vala_scanner_matches (begin, "switch")) {
								result = VALA_TOKEN_TYPE_SWITCH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					gchar _tmp13_;
					_tmp13_ = begin[1];
					switch (_tmp13_) {
						case 'h':
						{
							if (vala_scanner_matches (begin, "throws")) {
								result = VALA_TOKEN_TYPE_THROWS;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_scanner_matches (begin, "typeof")) {
								result = VALA_TOKEN_TYPE_TYPEOF;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'u':
				{
					if (vala_scanner_matches (begin, "unlock")) {
						result = VALA_TOKEN_TYPE_UNLOCK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar _tmp14_;
			_tmp14_ = begin[0];
			switch (_tmp14_) {
				case 'd':
				{
					gchar _tmp15_;
					_tmp15_ = begin[1];
					switch (_tmp15_) {
						case 'e':
						{
							if (vala_scanner_matches (begin, "default")) {
								result = VALA_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_scanner_matches (begin, "dynamic")) {
								result = VALA_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_scanner_matches (begin, "ensures")) {
						result = VALA_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp16_;
					_tmp16_ = begin[1];
					switch (_tmp16_) {
						case 'i':
						{
							if (vala_scanner_matches (begin, "finally")) {
								result = VALA_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_scanner_matches (begin, "foreach")) {
								result = VALA_TOKEN_TYPE_FOREACH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					if (vala_scanner_matches (begin, "private")) {
						result = VALA_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_scanner_matches (begin, "unowned")) {
						result = VALA_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "virtual")) {
						result = VALA_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar _tmp17_;
			_tmp17_ = begin[0];
			switch (_tmp17_) {
				case 'a':
				{
					if (vala_scanner_matches (begin, "abstract")) {
						result = VALA_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_scanner_matches (begin, "continue")) {
						result = VALA_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_scanner_matches (begin, "delegate")) {
						result = VALA_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_scanner_matches (begin, "internal")) {
						result = VALA_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_scanner_matches (begin, "override")) {
						result = VALA_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_scanner_matches (begin, "requires")) {
						result = VALA_TOKEN_TYPE_REQUIRES;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "volatile")) {
						result = VALA_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar _tmp18_;
			_tmp18_ = begin[0];
			switch (_tmp18_) {
				case 'c':
				{
					if (vala_scanner_matches (begin, "construct")) {
						result = VALA_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_scanner_matches (begin, "interface")) {
						result = VALA_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_scanner_matches (begin, "namespace")) {
						result = VALA_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_scanner_matches (begin, "protected")) {
						result = VALA_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 11:
		{
			if (vala_scanner_matches (begin, "errordomain")) {
				result = VALA_TOKEN_TYPE_ERRORDOMAIN;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_TOKEN_TYPE_IDENTIFIER;
	return result;
}

static ValaTokenType
vala_scanner_read_number (ValaScanner* self)
{
	ValaTokenType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp39_ = FALSE;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	ValaTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	type = VALA_TOKEN_TYPE_INTEGER_LITERAL;
	_tmp3_ = self->priv->current;
	_tmp4_ = self->priv->end;
	if (_tmp3_ < (_tmp4_ - 2)) {
		gchar* _tmp5_;
		gchar _tmp6_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		_tmp2_ = _tmp6_ == '0';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[1];
		_tmp1_ = _tmp8_ == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[2];
		_tmp0_ = g_ascii_isxdigit (_tmp10_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp11_;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		while (TRUE) {
			gboolean _tmp12_ = FALSE;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp17_;
			_tmp13_ = self->priv->current;
			_tmp14_ = self->priv->end;
			if (_tmp13_ < _tmp14_) {
				gchar* _tmp15_;
				gchar _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_[0];
				_tmp12_ = g_ascii_isxdigit (_tmp16_);
			} else {
				_tmp12_ = FALSE;
			}
			if (!_tmp12_) {
				break;
			}
			_tmp17_ = self->priv->current;
			self->priv->current = _tmp17_ + 1;
		}
	} else {
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp23_;
			_tmp19_ = self->priv->current;
			_tmp20_ = self->priv->end;
			if (_tmp19_ < _tmp20_) {
				gchar* _tmp21_;
				gchar _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_[0];
				_tmp18_ = g_ascii_isdigit (_tmp22_);
			} else {
				_tmp18_ = FALSE;
			}
			if (!_tmp18_) {
				break;
			}
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + 1;
		}
	}
	_tmp26_ = self->priv->current;
	_tmp27_ = self->priv->end;
	if (_tmp26_ < (_tmp27_ - 1)) {
		gchar* _tmp28_;
		gchar _tmp29_;
		_tmp28_ = self->priv->current;
		_tmp29_ = _tmp28_[0];
		_tmp25_ = _tmp29_ == '.';
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gchar* _tmp30_;
		gchar _tmp31_;
		_tmp30_ = self->priv->current;
		_tmp31_ = _tmp30_[1];
		_tmp24_ = g_ascii_isdigit (_tmp31_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gchar* _tmp32_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp32_ = self->priv->current;
		self->priv->current = _tmp32_ + 1;
		while (TRUE) {
			gboolean _tmp33_ = FALSE;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp38_;
			_tmp34_ = self->priv->current;
			_tmp35_ = self->priv->end;
			if (_tmp34_ < _tmp35_) {
				gchar* _tmp36_;
				gchar _tmp37_;
				_tmp36_ = self->priv->current;
				_tmp37_ = _tmp36_[0];
				_tmp33_ = g_ascii_isdigit (_tmp37_);
			} else {
				_tmp33_ = FALSE;
			}
			if (!_tmp33_) {
				break;
			}
			_tmp38_ = self->priv->current;
			self->priv->current = _tmp38_ + 1;
		}
	}
	_tmp40_ = self->priv->current;
	_tmp41_ = self->priv->end;
	if (_tmp40_ < _tmp41_) {
		gchar* _tmp42_;
		gchar _tmp43_;
		_tmp42_ = self->priv->current;
		_tmp43_ = _tmp42_[0];
		_tmp39_ = g_ascii_tolower (_tmp43_) == 'e';
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
		gchar* _tmp46_;
		gchar* _tmp47_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp44_ = self->priv->current;
		self->priv->current = _tmp44_ + 1;
		_tmp46_ = self->priv->current;
		_tmp47_ = self->priv->end;
		if (_tmp46_ < _tmp47_) {
			gboolean _tmp48_ = FALSE;
			gchar* _tmp49_;
			gchar _tmp50_;
			_tmp49_ = self->priv->current;
			_tmp50_ = _tmp49_[0];
			if (_tmp50_ == '+') {
				_tmp48_ = TRUE;
			} else {
				gchar* _tmp51_;
				gchar _tmp52_;
				_tmp51_ = self->priv->current;
				_tmp52_ = _tmp51_[0];
				_tmp48_ = _tmp52_ == '-';
			}
			_tmp45_ = _tmp48_;
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			gchar* _tmp53_;
			_tmp53_ = self->priv->current;
			self->priv->current = _tmp53_ + 1;
		}
		while (TRUE) {
			gboolean _tmp54_ = FALSE;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp59_;
			_tmp55_ = self->priv->current;
			_tmp56_ = self->priv->end;
			if (_tmp55_ < _tmp56_) {
				gchar* _tmp57_;
				gchar _tmp58_;
				_tmp57_ = self->priv->current;
				_tmp58_ = _tmp57_[0];
				_tmp54_ = g_ascii_isdigit (_tmp58_);
			} else {
				_tmp54_ = FALSE;
			}
			if (!_tmp54_) {
				break;
			}
			_tmp59_ = self->priv->current;
			self->priv->current = _tmp59_ + 1;
		}
	}
	_tmp60_ = self->priv->current;
	_tmp61_ = self->priv->end;
	if (_tmp60_ < _tmp61_) {
		gboolean real_literal = FALSE;
		ValaTokenType _tmp62_;
		gchar* _tmp63_;
		gchar _tmp64_;
		gboolean _tmp88_ = FALSE;
		_tmp62_ = type;
		real_literal = _tmp62_ == VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp63_ = self->priv->current;
		_tmp64_ = _tmp63_[0];
		switch (_tmp64_) {
			case 'l':
			case 'L':
			{
				ValaTokenType _tmp65_;
				_tmp65_ = type;
				if (_tmp65_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp66_;
					gboolean _tmp67_ = FALSE;
					gchar* _tmp68_;
					gchar* _tmp69_;
					_tmp66_ = self->priv->current;
					self->priv->current = _tmp66_ + 1;
					_tmp68_ = self->priv->current;
					_tmp69_ = self->priv->end;
					if (_tmp68_ < _tmp69_) {
						gchar* _tmp70_;
						gchar _tmp71_;
						_tmp70_ = self->priv->current;
						_tmp71_ = _tmp70_[0];
						_tmp67_ = g_ascii_tolower (_tmp71_) == 'l';
					} else {
						_tmp67_ = FALSE;
					}
					if (_tmp67_) {
						gchar* _tmp72_;
						_tmp72_ = self->priv->current;
						self->priv->current = _tmp72_ + 1;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				ValaTokenType _tmp73_;
				_tmp73_ = type;
				if (_tmp73_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp74_;
					gboolean _tmp75_ = FALSE;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp74_ = self->priv->current;
					self->priv->current = _tmp74_ + 1;
					_tmp76_ = self->priv->current;
					_tmp77_ = self->priv->end;
					if (_tmp76_ < _tmp77_) {
						gchar* _tmp78_;
						gchar _tmp79_;
						_tmp78_ = self->priv->current;
						_tmp79_ = _tmp78_[0];
						_tmp75_ = g_ascii_tolower (_tmp79_) == 'l';
					} else {
						_tmp75_ = FALSE;
					}
					if (_tmp75_) {
						gchar* _tmp80_;
						gboolean _tmp81_ = FALSE;
						gchar* _tmp82_;
						gchar* _tmp83_;
						_tmp80_ = self->priv->current;
						self->priv->current = _tmp80_ + 1;
						_tmp82_ = self->priv->current;
						_tmp83_ = self->priv->end;
						if (_tmp82_ < _tmp83_) {
							gchar* _tmp84_;
							gchar _tmp85_;
							_tmp84_ = self->priv->current;
							_tmp85_ = _tmp84_[0];
							_tmp81_ = g_ascii_tolower (_tmp85_) == 'l';
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							gchar* _tmp86_;
							_tmp86_ = self->priv->current;
							self->priv->current = _tmp86_ + 1;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				gchar* _tmp87_;
				type = VALA_TOKEN_TYPE_REAL_LITERAL;
				_tmp87_ = self->priv->current;
				self->priv->current = _tmp87_ + 1;
				break;
			}
			default:
			break;
		}
		if (!real_literal) {
			gchar* _tmp89_;
			gchar _tmp90_;
			_tmp89_ = self->priv->current;
			_tmp90_ = _tmp89_[0];
			_tmp88_ = vala_scanner_is_ident_char (self, _tmp90_);
		} else {
			_tmp88_ = FALSE;
		}
		if (_tmp88_) {
			while (TRUE) {
				gboolean _tmp91_ = FALSE;
				gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp96_;
				_tmp92_ = self->priv->current;
				_tmp93_ = self->priv->end;
				if (_tmp92_ < _tmp93_) {
					gchar* _tmp94_;
					gchar _tmp95_;
					_tmp94_ = self->priv->current;
					_tmp95_ = _tmp94_[0];
					_tmp91_ = vala_scanner_is_ident_char (self, _tmp95_);
				} else {
					_tmp91_ = FALSE;
				}
				if (!_tmp91_) {
					break;
				}
				_tmp96_ = self->priv->current;
				self->priv->current = _tmp96_ + 1;
			}
			type = VALA_TOKEN_TYPE_IDENTIFIER;
		}
	}
	result = type;
	return result;
}

static void
_vala_array_add13 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add14 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add15 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add16 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaTokenType
vala_scanner_read_template_token (ValaScanner* self,
                                  ValaSourceLocation* token_begin,
                                  ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp115_;
	ValaTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '"':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				type = VALA_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar _tmp12_;
				_tmp8_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp8_ + 1;
				_tmp9_ = self->priv->current;
				self->priv->current = _tmp9_ + 1;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_[0];
				if (g_ascii_isalpha (_tmp12_)) {
					_tmp10_ = TRUE;
				} else {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == '_';
				}
				if (_tmp10_) {
					gint len = 0;
					ValaScannerState* _tmp22_;
					gint _tmp22__length1;
					len = 0;
					while (TRUE) {
						gboolean _tmp15_ = FALSE;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp20_;
						gint _tmp21_;
						_tmp16_ = self->priv->current;
						_tmp17_ = self->priv->end;
						if (_tmp16_ < _tmp17_) {
							gchar* _tmp18_;
							gchar _tmp19_;
							_tmp18_ = self->priv->current;
							_tmp19_ = _tmp18_[0];
							_tmp15_ = vala_scanner_is_ident_char (self, _tmp19_);
						} else {
							_tmp15_ = FALSE;
						}
						if (!_tmp15_) {
							break;
						}
						_tmp20_ = self->priv->current;
						self->priv->current = _tmp20_ + 1;
						_tmp21_ = len;
						len = _tmp21_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
					_tmp22_ = self->priv->state_stack;
					_tmp22__length1 = self->priv->state_stack_length1;
					_vala_array_add13 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp23_;
					gchar _tmp24_;
					_tmp23_ = self->priv->current;
					_tmp24_ = _tmp23_[0];
					if (_tmp24_ == '(') {
						gchar* _tmp25_;
						ValaScannerState* _tmp26_;
						gint _tmp26__length1;
						ValaSourceLocation _tmp27_ = {0};
						ValaSourceLocation _tmp28_ = {0};
						ValaTokenType _tmp29_;
						_tmp25_ = self->priv->current;
						self->priv->current = _tmp25_ + 1;
						self->priv->column = self->priv->column + 2;
						_tmp26_ = self->priv->state_stack;
						_tmp26__length1 = self->priv->state_stack_length1;
						_vala_array_add14 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
						_tmp29_ = vala_scanner_read_token (self, &_tmp27_, &_tmp28_);
						_vala_token_begin = _tmp27_;
						_vala_token_end = _tmp28_;
						result = _tmp29_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp30_;
						gchar _tmp31_;
						_tmp30_ = self->priv->current;
						_tmp31_ = _tmp30_[0];
						if (_tmp31_ == '$') {
							gchar* _tmp32_;
							ValaScannerState* _tmp33_;
							gint _tmp33__length1;
							type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp32_ = self->priv->current;
							self->priv->current = _tmp32_ + 1;
							_tmp33_ = self->priv->state_stack;
							_tmp33__length1 = self->priv->state_stack_length1;
							_vala_array_add15 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp34_;
							ValaSourceReference* _tmp35_;
							ValaSourceLocation _tmp36_ = {0};
							ValaSourceLocation _tmp37_ = {0};
							ValaTokenType _tmp38_;
							_tmp34_ = vala_scanner_get_source_reference (self, 1, 0);
							_tmp35_ = _tmp34_;
							vala_report_error (_tmp35_, "unexpected character");
							_vala_source_reference_unref0 (_tmp35_);
							_tmp38_ = vala_scanner_read_template_token (self, &_tmp36_, &_tmp37_);
							_vala_token_begin = _tmp36_;
							_vala_token_end = _tmp37_;
							result = _tmp38_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp104_;
				gchar* _tmp105_;
				ValaScannerState* _tmp112_;
				gint _tmp112__length1;
				type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_ = FALSE;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp47_;
					gchar _tmp48_;
					_tmp41_ = self->priv->current;
					_tmp42_ = self->priv->end;
					if (_tmp41_ < _tmp42_) {
						gchar* _tmp43_;
						gchar _tmp44_;
						_tmp43_ = self->priv->current;
						_tmp44_ = _tmp43_[0];
						_tmp40_ = _tmp44_ != '"';
					} else {
						_tmp40_ = FALSE;
					}
					if (_tmp40_) {
						gchar* _tmp45_;
						gchar _tmp46_;
						_tmp45_ = self->priv->current;
						_tmp46_ = _tmp45_[0];
						_tmp39_ = _tmp46_ != '$';
					} else {
						_tmp39_ = FALSE;
					}
					if (!_tmp39_) {
						break;
					}
					_tmp47_ = self->priv->current;
					_tmp48_ = _tmp47_[0];
					if (_tmp48_ == '\\') {
						gchar* _tmp49_;
						gint _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gchar _tmp54_;
						_tmp49_ = self->priv->current;
						self->priv->current = _tmp49_ + 1;
						_tmp50_ = token_length_in_chars;
						token_length_in_chars = _tmp50_ + 1;
						_tmp51_ = self->priv->current;
						_tmp52_ = self->priv->end;
						if (_tmp51_ >= _tmp52_) {
							break;
						}
						_tmp53_ = self->priv->current;
						_tmp54_ = _tmp53_[0];
						switch (_tmp54_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							{
								gchar* _tmp55_;
								gint _tmp56_;
								_tmp55_ = self->priv->current;
								self->priv->current = _tmp55_ + 1;
								_tmp56_ = token_length_in_chars;
								token_length_in_chars = _tmp56_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp57_;
								gint _tmp58_;
								gint digit_length = 0;
								_tmp57_ = self->priv->current;
								self->priv->current = _tmp57_ + 1;
								_tmp58_ = token_length_in_chars;
								token_length_in_chars = _tmp58_ + 1;
								{
									gboolean _tmp59_ = FALSE;
									digit_length = 0;
									_tmp59_ = TRUE;
									while (TRUE) {
										gboolean _tmp61_ = FALSE;
										gchar* _tmp62_;
										gchar* _tmp63_;
										gchar* _tmp66_;
										gint _tmp67_;
										if (!_tmp59_) {
											gint _tmp60_;
											_tmp60_ = digit_length;
											digit_length = _tmp60_ + 1;
										}
										_tmp59_ = FALSE;
										_tmp62_ = self->priv->current;
										_tmp63_ = self->priv->end;
										if (_tmp62_ < _tmp63_) {
											gchar* _tmp64_;
											gchar _tmp65_;
											_tmp64_ = self->priv->current;
											_tmp65_ = _tmp64_[0];
											_tmp61_ = g_ascii_isxdigit (_tmp65_);
										} else {
											_tmp61_ = FALSE;
										}
										if (!_tmp61_) {
											break;
										}
										_tmp66_ = self->priv->current;
										self->priv->current = _tmp66_ + 1;
										_tmp67_ = token_length_in_chars;
										token_length_in_chars = _tmp67_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp68_;
									ValaSourceReference* _tmp69_;
									_tmp68_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp69_ = _tmp68_;
									vala_report_error (_tmp69_, "\\u used with no following hex digits");
									_vala_source_reference_unref0 (_tmp69_);
								} else {
									if (digit_length < 4) {
										ValaSourceReference* _tmp70_;
										ValaSourceReference* _tmp71_;
										_tmp70_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp71_ = _tmp70_;
										vala_report_error (_tmp71_, "incomplete universal character name");
										_vala_source_reference_unref0 (_tmp71_);
									}
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp72_;
								gint _tmp73_;
								gint digit_length = 0;
								gboolean empty = FALSE;
								gboolean _tmp85_ = FALSE;
								_tmp72_ = self->priv->current;
								self->priv->current = _tmp72_ + 1;
								_tmp73_ = token_length_in_chars;
								token_length_in_chars = _tmp73_ + 1;
								empty = TRUE;
								{
									gboolean _tmp74_ = FALSE;
									digit_length = 0;
									_tmp74_ = TRUE;
									while (TRUE) {
										gboolean _tmp75_ = FALSE;
										gchar* _tmp76_;
										gchar* _tmp77_;
										gchar* _tmp80_;
										gchar _tmp81_;
										gchar* _tmp83_;
										gint _tmp84_;
										if (!_tmp74_) {
										}
										_tmp74_ = FALSE;
										_tmp76_ = self->priv->current;
										_tmp77_ = self->priv->end;
										if (_tmp76_ < _tmp77_) {
											gchar* _tmp78_;
											gchar _tmp79_;
											_tmp78_ = self->priv->current;
											_tmp79_ = _tmp78_[0];
											_tmp75_ = g_ascii_isxdigit (_tmp79_);
										} else {
											_tmp75_ = FALSE;
										}
										if (!_tmp75_) {
											break;
										}
										_tmp80_ = self->priv->current;
										_tmp81_ = _tmp80_[0];
										if (_tmp81_ != '0') {
											gint _tmp82_;
											_tmp82_ = digit_length;
											digit_length = _tmp82_ + 1;
										} else {
											empty = FALSE;
										}
										_tmp83_ = self->priv->current;
										self->priv->current = _tmp83_ + 1;
										_tmp84_ = token_length_in_chars;
										token_length_in_chars = _tmp84_ + 1;
									}
								}
								if (empty) {
									_tmp85_ = digit_length < 1;
								} else {
									_tmp85_ = FALSE;
								}
								if (_tmp85_) {
									ValaSourceReference* _tmp86_;
									ValaSourceReference* _tmp87_;
									_tmp86_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp87_ = _tmp86_;
									vala_report_error (_tmp87_, "\\x used with no following hex digits");
									_vala_source_reference_unref0 (_tmp87_);
								} else {
									if (digit_length > 2) {
										ValaSourceReference* _tmp88_;
										ValaSourceReference* _tmp89_;
										_tmp88_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp89_ = _tmp88_;
										vala_report_error (_tmp89_, "hex escape sequence out of range");
										_vala_source_reference_unref0 (_tmp89_);
									}
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp90_;
								ValaSourceReference* _tmp91_;
								_tmp90_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp91_ = _tmp90_;
								vala_report_error (_tmp91_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp91_);
								break;
							}
						}
					} else {
						gchar* _tmp92_;
						gchar _tmp93_;
						_tmp92_ = self->priv->current;
						_tmp93_ = _tmp92_[0];
						if (_tmp93_ == '\n') {
							gchar* _tmp94_;
							gint _tmp95_;
							_tmp94_ = self->priv->current;
							self->priv->current = _tmp94_ + 1;
							_tmp95_ = self->priv->line;
							self->priv->line = _tmp95_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u = 0U;
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp98_;
							_tmp96_ = self->priv->current;
							_tmp97_ = self->priv->end;
							_tmp98_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp96_, (gssize) ((glong) (_tmp97_ - _tmp98_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp99_;
								gint _tmp100_;
								_tmp99_ = self->priv->current;
								self->priv->current = _tmp99_ + g_unichar_to_utf8 (u, NULL);
								_tmp100_ = token_length_in_chars;
								token_length_in_chars = _tmp100_ + 1;
							} else {
								gchar* _tmp101_;
								ValaSourceReference* _tmp102_;
								ValaSourceReference* _tmp103_;
								_tmp101_ = self->priv->current;
								self->priv->current = _tmp101_ + 1;
								_tmp102_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp103_ = _tmp102_;
								vala_report_error (_tmp103_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp103_);
							}
						}
					}
				}
				_tmp104_ = self->priv->current;
				_tmp105_ = self->priv->end;
				if (_tmp104_ >= _tmp105_) {
					ValaSourceReference* _tmp106_;
					ValaSourceReference* _tmp107_;
					gint _tmp108_;
					ValaSourceLocation _tmp109_ = {0};
					ValaSourceLocation _tmp110_ = {0};
					ValaTokenType _tmp111_;
					_tmp106_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp107_ = _tmp106_;
					vala_report_error (_tmp107_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp107_);
					_tmp108_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp108_ - 1;
					_tmp111_ = vala_scanner_read_token (self, &_tmp109_, &_tmp110_);
					_vala_token_begin = _tmp109_;
					_vala_token_end = _tmp110_;
					result = _tmp111_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp112_ = self->priv->state_stack;
				_tmp112__length1 = self->priv->state_stack_length1;
				_vala_array_add16 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp113_;
		gchar* _tmp114_;
		_tmp113_ = self->priv->current;
		_tmp114_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp113_ - _tmp114_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp115_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp115_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static void
_vala_array_add17 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add18 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add19 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add20 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add21 (ValaScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaTokenType
vala_scanner_read_token (ValaScanner* self,
                         ValaSourceLocation* token_begin,
                         ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint token_length_in_chars = 0;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp329_;
	ValaTokenType _tmp330_;
	ValaTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (vala_scanner_in_template (self)) {
		ValaSourceLocation _tmp0_ = {0};
		ValaSourceLocation _tmp1_ = {0};
		ValaTokenType _tmp2_;
		_tmp2_ = vala_scanner_read_template_token (self, &_tmp0_, &_tmp1_);
		_vala_token_begin = _tmp0_;
		_vala_token_end = _tmp1_;
		result = _tmp2_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		if (vala_scanner_in_template_part (self)) {
			gint _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp3_ - 1;
			_tmp4_ = self->priv->current;
			vala_source_location_init (&_vala_token_begin, _tmp4_, self->priv->line, self->priv->column);
			_tmp5_ = self->priv->current;
			vala_source_location_init (&_vala_token_end, _tmp5_, self->priv->line, self->priv->column - 1);
			result = VALA_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (vala_scanner_in_regex_literal (self)) {
				ValaSourceLocation _tmp6_ = {0};
				ValaSourceLocation _tmp7_ = {0};
				ValaTokenType _tmp8_;
				_tmp8_ = vala_scanner_read_regex_token (self, &_tmp6_, &_tmp7_);
				_vala_token_begin = _tmp6_;
				_vala_token_end = _tmp7_;
				result = _tmp8_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	vala_scanner_space (self);
	_tmp9_ = self->priv->current;
	begin = _tmp9_;
	_tmp10_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp10_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp11_ = self->priv->current;
	_tmp12_ = self->priv->end;
	if (_tmp11_ >= _tmp12_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp13_ = FALSE;
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		if (g_ascii_isalpha (_tmp15_)) {
			_tmp13_ = TRUE;
		} else {
			gchar* _tmp16_;
			gchar _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_[0];
			_tmp13_ = _tmp17_ == '_';
		}
		if (_tmp13_) {
			gint len = 0;
			gchar* _tmp25_;
			len = 0;
			while (TRUE) {
				gboolean _tmp18_ = FALSE;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp23_;
				gint _tmp24_;
				_tmp19_ = self->priv->current;
				_tmp20_ = self->priv->end;
				if (_tmp19_ < _tmp20_) {
					gchar* _tmp21_;
					gchar _tmp22_;
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					_tmp18_ = vala_scanner_is_ident_char (self, _tmp22_);
				} else {
					_tmp18_ = FALSE;
				}
				if (!_tmp18_) {
					break;
				}
				_tmp23_ = self->priv->current;
				self->priv->current = _tmp23_ + 1;
				_tmp24_ = len;
				len = _tmp24_ + 1;
			}
			_tmp25_ = begin;
			type = vala_scanner_get_identifier_or_keyword (_tmp25_, len);
		} else {
			gchar* _tmp26_;
			gchar _tmp27_;
			_tmp26_ = self->priv->current;
			_tmp27_ = _tmp26_[0];
			if (_tmp27_ == '@') {
				gboolean _tmp28_ = FALSE;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp29_ = self->priv->current;
				_tmp30_ = self->priv->end;
				if (_tmp29_ < (_tmp30_ - 1)) {
					gchar* _tmp31_;
					gchar _tmp32_;
					_tmp31_ = self->priv->current;
					_tmp32_ = _tmp31_[1];
					_tmp28_ = _tmp32_ == '"';
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					gchar* _tmp33_;
					ValaScannerState* _tmp34_;
					gint _tmp34__length1;
					type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp33_ = self->priv->current;
					self->priv->current = _tmp33_ + 2;
					_tmp34_ = self->priv->state_stack;
					_tmp34__length1 = self->priv->state_stack_length1;
					_vala_array_add17 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp35_;
					gchar* _tmp36_;
					gint len = 0;
					_tmp35_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp35_ + 1;
					_tmp36_ = self->priv->current;
					self->priv->current = _tmp36_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp37_ = FALSE;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp42_;
						gint _tmp43_;
						_tmp38_ = self->priv->current;
						_tmp39_ = self->priv->end;
						if (_tmp38_ < _tmp39_) {
							gchar* _tmp40_;
							gchar _tmp41_;
							_tmp40_ = self->priv->current;
							_tmp41_ = _tmp40_[0];
							_tmp37_ = vala_scanner_is_ident_char (self, _tmp41_);
						} else {
							_tmp37_ = FALSE;
						}
						if (!_tmp37_) {
							break;
						}
						_tmp42_ = self->priv->current;
						self->priv->current = _tmp42_ + 1;
						_tmp43_ = len;
						len = _tmp43_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp44_;
				gchar _tmp45_;
				_tmp44_ = self->priv->current;
				_tmp45_ = _tmp44_[0];
				if (g_ascii_isdigit (_tmp45_)) {
					type = vala_scanner_read_number (self);
				} else {
					gchar* _tmp46_;
					gchar _tmp47_;
					_tmp46_ = self->priv->current;
					_tmp47_ = _tmp46_[0];
					switch (_tmp47_) {
						case '{':
						{
							gchar* _tmp48_;
							ValaScannerState* _tmp49_;
							gint _tmp49__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACE;
							_tmp48_ = self->priv->current;
							self->priv->current = _tmp48_ + 1;
							_tmp49_ = self->priv->state_stack;
							_tmp49__length1 = self->priv->state_stack_length1;
							_vala_array_add18 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACE);
							break;
						}
						case '}':
						{
							gchar* _tmp50_;
							ValaScannerState* _tmp51_;
							gint _tmp51__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACE;
							_tmp50_ = self->priv->current;
							self->priv->current = _tmp50_ + 1;
							_tmp51_ = self->priv->state_stack;
							_tmp51__length1 = self->priv->state_stack_length1;
							if (_tmp51__length1 > 0) {
								gint _tmp52_;
								_tmp52_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp52_ - 1;
							}
							break;
						}
						case '(':
						{
							gchar* _tmp53_;
							ValaScannerState* _tmp54_;
							gint _tmp54__length1;
							type = VALA_TOKEN_TYPE_OPEN_PARENS;
							_tmp53_ = self->priv->current;
							self->priv->current = _tmp53_ + 1;
							_tmp54_ = self->priv->state_stack;
							_tmp54__length1 = self->priv->state_stack_length1;
							_vala_array_add19 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
							break;
						}
						case ')':
						{
							gchar* _tmp55_;
							ValaScannerState* _tmp56_;
							gint _tmp56__length1;
							type = VALA_TOKEN_TYPE_CLOSE_PARENS;
							_tmp55_ = self->priv->current;
							self->priv->current = _tmp55_ + 1;
							_tmp56_ = self->priv->state_stack;
							_tmp56__length1 = self->priv->state_stack_length1;
							if (_tmp56__length1 > 0) {
								gint _tmp57_;
								_tmp57_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp57_ - 1;
							}
							if (vala_scanner_in_template (self)) {
								type = VALA_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp58_;
							ValaScannerState* _tmp59_;
							gint _tmp59__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACKET;
							_tmp58_ = self->priv->current;
							self->priv->current = _tmp58_ + 1;
							_tmp59_ = self->priv->state_stack;
							_tmp59__length1 = self->priv->state_stack_length1;
							_vala_array_add20 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACKET);
							break;
						}
						case ']':
						{
							gchar* _tmp60_;
							ValaScannerState* _tmp61_;
							gint _tmp61__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp60_ = self->priv->current;
							self->priv->current = _tmp60_ + 1;
							_tmp61_ = self->priv->state_stack;
							_tmp61__length1 = self->priv->state_stack_length1;
							if (_tmp61__length1 > 0) {
								gint _tmp62_;
								_tmp62_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp62_ - 1;
							}
							break;
						}
						case '.':
						{
							gchar* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							type = VALA_TOKEN_TYPE_DOT;
							_tmp63_ = self->priv->current;
							self->priv->current = _tmp63_ + 1;
							_tmp64_ = self->priv->current;
							_tmp65_ = self->priv->end;
							if (_tmp64_ < (_tmp65_ - 1)) {
								gboolean _tmp66_ = FALSE;
								gchar* _tmp67_;
								gchar _tmp68_;
								_tmp67_ = self->priv->current;
								_tmp68_ = _tmp67_[0];
								if (_tmp68_ == '.') {
									gchar* _tmp69_;
									gchar _tmp70_;
									_tmp69_ = self->priv->current;
									_tmp70_ = _tmp69_[1];
									_tmp66_ = _tmp70_ == '.';
								} else {
									_tmp66_ = FALSE;
								}
								if (_tmp66_) {
									gchar* _tmp71_;
									type = VALA_TOKEN_TYPE_ELLIPSIS;
									_tmp71_ = self->priv->current;
									self->priv->current = _tmp71_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp72_;
							gboolean _tmp73_ = FALSE;
							gchar* _tmp74_;
							gchar* _tmp75_;
							type = VALA_TOKEN_TYPE_COLON;
							_tmp72_ = self->priv->current;
							self->priv->current = _tmp72_ + 1;
							_tmp74_ = self->priv->current;
							_tmp75_ = self->priv->end;
							if (_tmp74_ < _tmp75_) {
								gchar* _tmp76_;
								gchar _tmp77_;
								_tmp76_ = self->priv->current;
								_tmp77_ = _tmp76_[0];
								_tmp73_ = _tmp77_ == ':';
							} else {
								_tmp73_ = FALSE;
							}
							if (_tmp73_) {
								gchar* _tmp78_;
								type = VALA_TOKEN_TYPE_DOUBLE_COLON;
								_tmp78_ = self->priv->current;
								self->priv->current = _tmp78_ + 1;
							}
							break;
						}
						case ',':
						{
							gchar* _tmp79_;
							type = VALA_TOKEN_TYPE_COMMA;
							_tmp79_ = self->priv->current;
							self->priv->current = _tmp79_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp80_;
							type = VALA_TOKEN_TYPE_SEMICOLON;
							_tmp80_ = self->priv->current;
							self->priv->current = _tmp80_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp81_;
							type = VALA_TOKEN_TYPE_HASH;
							_tmp81_ = self->priv->current;
							self->priv->current = _tmp81_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp82_;
							gboolean _tmp83_ = FALSE;
							gchar* _tmp84_;
							gchar* _tmp85_;
							type = VALA_TOKEN_TYPE_INTERR;
							_tmp82_ = self->priv->current;
							self->priv->current = _tmp82_ + 1;
							_tmp84_ = self->priv->current;
							_tmp85_ = self->priv->end;
							if (_tmp84_ < _tmp85_) {
								gchar* _tmp86_;
								gchar _tmp87_;
								_tmp86_ = self->priv->current;
								_tmp87_ = _tmp86_[0];
								_tmp83_ = _tmp87_ == '?';
							} else {
								_tmp83_ = FALSE;
							}
							if (_tmp83_) {
								gchar* _tmp88_;
								type = VALA_TOKEN_TYPE_OP_COALESCING;
								_tmp88_ = self->priv->current;
								self->priv->current = _tmp88_ + 1;
							}
							break;
						}
						case '|':
						{
							gchar* _tmp89_;
							gchar* _tmp90_;
							gchar* _tmp91_;
							type = VALA_TOKEN_TYPE_BITWISE_OR;
							_tmp89_ = self->priv->current;
							self->priv->current = _tmp89_ + 1;
							_tmp90_ = self->priv->current;
							_tmp91_ = self->priv->end;
							if (_tmp90_ < _tmp91_) {
								gchar* _tmp92_;
								gchar _tmp93_;
								_tmp92_ = self->priv->current;
								_tmp93_ = _tmp92_[0];
								switch (_tmp93_) {
									case '=':
									{
										gchar* _tmp94_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp94_ = self->priv->current;
										self->priv->current = _tmp94_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp95_;
										type = VALA_TOKEN_TYPE_OP_OR;
										_tmp95_ = self->priv->current;
										self->priv->current = _tmp95_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp98_;
							type = VALA_TOKEN_TYPE_BITWISE_AND;
							_tmp96_ = self->priv->current;
							self->priv->current = _tmp96_ + 1;
							_tmp97_ = self->priv->current;
							_tmp98_ = self->priv->end;
							if (_tmp97_ < _tmp98_) {
								gchar* _tmp99_;
								gchar _tmp100_;
								_tmp99_ = self->priv->current;
								_tmp100_ = _tmp99_[0];
								switch (_tmp100_) {
									case '=':
									{
										gchar* _tmp101_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp101_ = self->priv->current;
										self->priv->current = _tmp101_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp102_;
										type = VALA_TOKEN_TYPE_OP_AND;
										_tmp102_ = self->priv->current;
										self->priv->current = _tmp102_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp103_;
							gboolean _tmp104_ = FALSE;
							gchar* _tmp105_;
							gchar* _tmp106_;
							type = VALA_TOKEN_TYPE_CARRET;
							_tmp103_ = self->priv->current;
							self->priv->current = _tmp103_ + 1;
							_tmp105_ = self->priv->current;
							_tmp106_ = self->priv->end;
							if (_tmp105_ < _tmp106_) {
								gchar* _tmp107_;
								gchar _tmp108_;
								_tmp107_ = self->priv->current;
								_tmp108_ = _tmp107_[0];
								_tmp104_ = _tmp108_ == '=';
							} else {
								_tmp104_ = FALSE;
							}
							if (_tmp104_) {
								gchar* _tmp109_;
								type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp109_ = self->priv->current;
								self->priv->current = _tmp109_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp110_;
							type = VALA_TOKEN_TYPE_TILDE;
							_tmp110_ = self->priv->current;
							self->priv->current = _tmp110_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp111_;
							gchar* _tmp112_;
							gchar* _tmp113_;
							type = VALA_TOKEN_TYPE_ASSIGN;
							_tmp111_ = self->priv->current;
							self->priv->current = _tmp111_ + 1;
							_tmp112_ = self->priv->current;
							_tmp113_ = self->priv->end;
							if (_tmp112_ < _tmp113_) {
								gchar* _tmp114_;
								gchar _tmp115_;
								_tmp114_ = self->priv->current;
								_tmp115_ = _tmp114_[0];
								switch (_tmp115_) {
									case '=':
									{
										gchar* _tmp116_;
										type = VALA_TOKEN_TYPE_OP_EQ;
										_tmp116_ = self->priv->current;
										self->priv->current = _tmp116_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp117_;
										type = VALA_TOKEN_TYPE_LAMBDA;
										_tmp117_ = self->priv->current;
										self->priv->current = _tmp117_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp118_;
							gchar* _tmp119_;
							gchar* _tmp120_;
							type = VALA_TOKEN_TYPE_OP_LT;
							_tmp118_ = self->priv->current;
							self->priv->current = _tmp118_ + 1;
							_tmp119_ = self->priv->current;
							_tmp120_ = self->priv->end;
							if (_tmp119_ < _tmp120_) {
								gchar* _tmp121_;
								gchar _tmp122_;
								_tmp121_ = self->priv->current;
								_tmp122_ = _tmp121_[0];
								switch (_tmp122_) {
									case '=':
									{
										gchar* _tmp123_;
										type = VALA_TOKEN_TYPE_OP_LE;
										_tmp123_ = self->priv->current;
										self->priv->current = _tmp123_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp124_;
										gboolean _tmp125_ = FALSE;
										gchar* _tmp126_;
										gchar* _tmp127_;
										type = VALA_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp124_ = self->priv->current;
										self->priv->current = _tmp124_ + 1;
										_tmp126_ = self->priv->current;
										_tmp127_ = self->priv->end;
										if (_tmp126_ < _tmp127_) {
											gchar* _tmp128_;
											gchar _tmp129_;
											_tmp128_ = self->priv->current;
											_tmp129_ = _tmp128_[0];
											_tmp125_ = _tmp129_ == '=';
										} else {
											_tmp125_ = FALSE;
										}
										if (_tmp125_) {
											gchar* _tmp130_;
											type = VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp130_ = self->priv->current;
											self->priv->current = _tmp130_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp131_;
							gboolean _tmp132_ = FALSE;
							gchar* _tmp133_;
							gchar* _tmp134_;
							type = VALA_TOKEN_TYPE_OP_GT;
							_tmp131_ = self->priv->current;
							self->priv->current = _tmp131_ + 1;
							_tmp133_ = self->priv->current;
							_tmp134_ = self->priv->end;
							if (_tmp133_ < _tmp134_) {
								gchar* _tmp135_;
								gchar _tmp136_;
								_tmp135_ = self->priv->current;
								_tmp136_ = _tmp135_[0];
								_tmp132_ = _tmp136_ == '=';
							} else {
								_tmp132_ = FALSE;
							}
							if (_tmp132_) {
								gchar* _tmp137_;
								type = VALA_TOKEN_TYPE_OP_GE;
								_tmp137_ = self->priv->current;
								self->priv->current = _tmp137_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp138_;
							gboolean _tmp139_ = FALSE;
							gchar* _tmp140_;
							gchar* _tmp141_;
							type = VALA_TOKEN_TYPE_OP_NEG;
							_tmp138_ = self->priv->current;
							self->priv->current = _tmp138_ + 1;
							_tmp140_ = self->priv->current;
							_tmp141_ = self->priv->end;
							if (_tmp140_ < _tmp141_) {
								gchar* _tmp142_;
								gchar _tmp143_;
								_tmp142_ = self->priv->current;
								_tmp143_ = _tmp142_[0];
								_tmp139_ = _tmp143_ == '=';
							} else {
								_tmp139_ = FALSE;
							}
							if (_tmp139_) {
								gchar* _tmp144_;
								type = VALA_TOKEN_TYPE_OP_NE;
								_tmp144_ = self->priv->current;
								self->priv->current = _tmp144_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp145_;
							gchar* _tmp146_;
							gchar* _tmp147_;
							type = VALA_TOKEN_TYPE_PLUS;
							_tmp145_ = self->priv->current;
							self->priv->current = _tmp145_ + 1;
							_tmp146_ = self->priv->current;
							_tmp147_ = self->priv->end;
							if (_tmp146_ < _tmp147_) {
								gchar* _tmp148_;
								gchar _tmp149_;
								_tmp148_ = self->priv->current;
								_tmp149_ = _tmp148_[0];
								switch (_tmp149_) {
									case '=':
									{
										gchar* _tmp150_;
										type = VALA_TOKEN_TYPE_ASSIGN_ADD;
										_tmp150_ = self->priv->current;
										self->priv->current = _tmp150_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp151_;
										type = VALA_TOKEN_TYPE_OP_INC;
										_tmp151_ = self->priv->current;
										self->priv->current = _tmp151_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp152_;
							gchar* _tmp153_;
							gchar* _tmp154_;
							type = VALA_TOKEN_TYPE_MINUS;
							_tmp152_ = self->priv->current;
							self->priv->current = _tmp152_ + 1;
							_tmp153_ = self->priv->current;
							_tmp154_ = self->priv->end;
							if (_tmp153_ < _tmp154_) {
								gchar* _tmp155_;
								gchar _tmp156_;
								_tmp155_ = self->priv->current;
								_tmp156_ = _tmp155_[0];
								switch (_tmp156_) {
									case '=':
									{
										gchar* _tmp157_;
										type = VALA_TOKEN_TYPE_ASSIGN_SUB;
										_tmp157_ = self->priv->current;
										self->priv->current = _tmp157_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp158_;
										type = VALA_TOKEN_TYPE_OP_DEC;
										_tmp158_ = self->priv->current;
										self->priv->current = _tmp158_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp159_;
										type = VALA_TOKEN_TYPE_OP_PTR;
										_tmp159_ = self->priv->current;
										self->priv->current = _tmp159_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp160_;
							gboolean _tmp161_ = FALSE;
							gchar* _tmp162_;
							gchar* _tmp163_;
							type = VALA_TOKEN_TYPE_STAR;
							_tmp160_ = self->priv->current;
							self->priv->current = _tmp160_ + 1;
							_tmp162_ = self->priv->current;
							_tmp163_ = self->priv->end;
							if (_tmp162_ < _tmp163_) {
								gchar* _tmp164_;
								gchar _tmp165_;
								_tmp164_ = self->priv->current;
								_tmp165_ = _tmp164_[0];
								_tmp161_ = _tmp165_ == '=';
							} else {
								_tmp161_ = FALSE;
							}
							if (_tmp161_) {
								gchar* _tmp166_;
								type = VALA_TOKEN_TYPE_ASSIGN_MUL;
								_tmp166_ = self->priv->current;
								self->priv->current = _tmp166_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaTokenType _tmp167_;
							_tmp167_ = self->priv->previous;
							switch (_tmp167_) {
								case VALA_TOKEN_TYPE_ASSIGN:
								case VALA_TOKEN_TYPE_COMMA:
								case VALA_TOKEN_TYPE_MINUS:
								case VALA_TOKEN_TYPE_OP_AND:
								case VALA_TOKEN_TYPE_OP_COALESCING:
								case VALA_TOKEN_TYPE_OP_EQ:
								case VALA_TOKEN_TYPE_OP_GE:
								case VALA_TOKEN_TYPE_OP_GT:
								case VALA_TOKEN_TYPE_OP_LE:
								case VALA_TOKEN_TYPE_OP_LT:
								case VALA_TOKEN_TYPE_OP_NE:
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_OP_OR:
								case VALA_TOKEN_TYPE_OPEN_BRACE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_PLUS:
								case VALA_TOKEN_TYPE_RETURN:
								{
									ValaScannerState* _tmp168_;
									gint _tmp168__length1;
									gchar* _tmp169_;
									type = VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp168_ = self->priv->state_stack;
									_tmp168__length1 = self->priv->state_stack_length1;
									_vala_array_add21 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_REGEX_LITERAL);
									_tmp169_ = self->priv->current;
									self->priv->current = _tmp169_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp170_;
									gboolean _tmp171_ = FALSE;
									gchar* _tmp172_;
									gchar* _tmp173_;
									type = VALA_TOKEN_TYPE_DIV;
									_tmp170_ = self->priv->current;
									self->priv->current = _tmp170_ + 1;
									_tmp172_ = self->priv->current;
									_tmp173_ = self->priv->end;
									if (_tmp172_ < _tmp173_) {
										gchar* _tmp174_;
										gchar _tmp175_;
										_tmp174_ = self->priv->current;
										_tmp175_ = _tmp174_[0];
										_tmp171_ = _tmp175_ == '=';
									} else {
										_tmp171_ = FALSE;
									}
									if (_tmp171_) {
										gchar* _tmp176_;
										type = VALA_TOKEN_TYPE_ASSIGN_DIV;
										_tmp176_ = self->priv->current;
										self->priv->current = _tmp176_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp177_;
							gboolean _tmp178_ = FALSE;
							gchar* _tmp179_;
							gchar* _tmp180_;
							type = VALA_TOKEN_TYPE_PERCENT;
							_tmp177_ = self->priv->current;
							self->priv->current = _tmp177_ + 1;
							_tmp179_ = self->priv->current;
							_tmp180_ = self->priv->end;
							if (_tmp179_ < _tmp180_) {
								gchar* _tmp181_;
								gchar _tmp182_;
								_tmp181_ = self->priv->current;
								_tmp182_ = _tmp181_[0];
								_tmp178_ = _tmp182_ == '=';
							} else {
								_tmp178_ = FALSE;
							}
							if (_tmp178_) {
								gchar* _tmp183_;
								type = VALA_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp183_ = self->priv->current;
								self->priv->current = _tmp183_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp184_;
							gchar _tmp185_;
							gchar* _tmp230_;
							gchar* _tmp305_;
							gchar* _tmp306_;
							_tmp184_ = begin;
							_tmp185_ = _tmp184_[0];
							if (_tmp185_ == '\'') {
								type = VALA_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp186_ = FALSE;
								gboolean _tmp187_ = FALSE;
								gchar* _tmp188_;
								gchar* _tmp189_;
								_tmp188_ = self->priv->current;
								_tmp189_ = self->priv->end;
								if (_tmp188_ < (_tmp189_ - 6)) {
									gchar* _tmp190_;
									gchar _tmp191_;
									_tmp190_ = begin;
									_tmp191_ = _tmp190_[1];
									_tmp187_ = _tmp191_ == '"';
								} else {
									_tmp187_ = FALSE;
								}
								if (_tmp187_) {
									gchar* _tmp192_;
									gchar _tmp193_;
									_tmp192_ = begin;
									_tmp193_ = _tmp192_[2];
									_tmp186_ = _tmp193_ == '"';
								} else {
									_tmp186_ = FALSE;
								}
								if (_tmp186_) {
									gchar* _tmp194_;
									gboolean _tmp219_ = FALSE;
									gboolean _tmp220_ = FALSE;
									gchar* _tmp221_;
									gchar _tmp222_;
									type = VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp194_ = self->priv->current;
									self->priv->current = _tmp194_ + 3;
									while (TRUE) {
										gchar* _tmp195_;
										gchar* _tmp196_;
										gboolean _tmp197_ = FALSE;
										gboolean _tmp198_ = FALSE;
										gboolean _tmp199_ = FALSE;
										gchar* _tmp200_;
										gchar _tmp201_;
										_tmp195_ = self->priv->current;
										_tmp196_ = self->priv->end;
										if (!(_tmp195_ < (_tmp196_ - 4))) {
											break;
										}
										_tmp200_ = self->priv->current;
										_tmp201_ = _tmp200_[0];
										if (_tmp201_ == '"') {
											gchar* _tmp202_;
											gchar _tmp203_;
											_tmp202_ = self->priv->current;
											_tmp203_ = _tmp202_[1];
											_tmp199_ = _tmp203_ == '"';
										} else {
											_tmp199_ = FALSE;
										}
										if (_tmp199_) {
											gchar* _tmp204_;
											gchar _tmp205_;
											_tmp204_ = self->priv->current;
											_tmp205_ = _tmp204_[2];
											_tmp198_ = _tmp205_ == '"';
										} else {
											_tmp198_ = FALSE;
										}
										if (_tmp198_) {
											gchar* _tmp206_;
											gchar _tmp207_;
											_tmp206_ = self->priv->current;
											_tmp207_ = _tmp206_[3];
											_tmp197_ = _tmp207_ != '"';
										} else {
											_tmp197_ = FALSE;
										}
										if (_tmp197_) {
											break;
										} else {
											gchar* _tmp208_;
											gchar _tmp209_;
											_tmp208_ = self->priv->current;
											_tmp209_ = _tmp208_[0];
											if (_tmp209_ == '\n') {
												gchar* _tmp210_;
												gint _tmp211_;
												_tmp210_ = self->priv->current;
												self->priv->current = _tmp210_ + 1;
												_tmp211_ = self->priv->line;
												self->priv->line = _tmp211_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u = 0U;
												gchar* _tmp212_;
												gchar* _tmp213_;
												gchar* _tmp214_;
												_tmp212_ = self->priv->current;
												_tmp213_ = self->priv->end;
												_tmp214_ = self->priv->current;
												u = g_utf8_get_char_validated ((const gchar*) _tmp212_, (gssize) ((glong) (_tmp213_ - _tmp214_)));
												if (u != ((gunichar) -1)) {
													gchar* _tmp215_;
													gint _tmp216_;
													_tmp215_ = self->priv->current;
													self->priv->current = _tmp215_ + g_unichar_to_utf8 (u, NULL);
													_tmp216_ = token_length_in_chars;
													token_length_in_chars = _tmp216_ + 1;
												} else {
													ValaSourceReference* _tmp217_;
													ValaSourceReference* _tmp218_;
													_tmp217_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp218_ = _tmp217_;
													vala_report_error (_tmp218_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp218_);
												}
											}
										}
									}
									_tmp221_ = self->priv->current;
									_tmp222_ = _tmp221_[0];
									if (_tmp222_ == '"') {
										gchar* _tmp223_;
										gchar _tmp224_;
										_tmp223_ = self->priv->current;
										_tmp224_ = _tmp223_[1];
										_tmp220_ = _tmp224_ == '"';
									} else {
										_tmp220_ = FALSE;
									}
									if (_tmp220_) {
										gchar* _tmp225_;
										gchar _tmp226_;
										_tmp225_ = self->priv->current;
										_tmp226_ = _tmp225_[2];
										_tmp219_ = _tmp226_ == '"';
									} else {
										_tmp219_ = FALSE;
									}
									if (_tmp219_) {
										gchar* _tmp227_;
										_tmp227_ = self->priv->current;
										self->priv->current = _tmp227_ + 3;
									} else {
										ValaSourceReference* _tmp228_;
										ValaSourceReference* _tmp229_;
										_tmp228_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp229_ = _tmp228_;
										vala_report_error (_tmp229_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp229_);
									}
									break;
								} else {
									type = VALA_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp230_ = self->priv->current;
							self->priv->current = _tmp230_ + 1;
							while (TRUE) {
								gboolean _tmp231_ = FALSE;
								gchar* _tmp232_;
								gchar* _tmp233_;
								gchar* _tmp238_;
								gchar _tmp239_;
								gboolean _tmp295_ = FALSE;
								gboolean _tmp296_ = FALSE;
								gchar* _tmp297_;
								gchar* _tmp298_;
								_tmp232_ = self->priv->current;
								_tmp233_ = self->priv->end;
								if (_tmp232_ < _tmp233_) {
									gchar* _tmp234_;
									gchar _tmp235_;
									gchar* _tmp236_;
									gchar _tmp237_;
									_tmp234_ = self->priv->current;
									_tmp235_ = _tmp234_[0];
									_tmp236_ = begin;
									_tmp237_ = _tmp236_[0];
									_tmp231_ = _tmp235_ != _tmp237_;
								} else {
									_tmp231_ = FALSE;
								}
								if (!_tmp231_) {
									break;
								}
								_tmp238_ = self->priv->current;
								_tmp239_ = _tmp238_[0];
								if (_tmp239_ == '\\') {
									gchar* _tmp240_;
									gint _tmp241_;
									gchar* _tmp242_;
									gchar* _tmp243_;
									gchar* _tmp244_;
									gchar _tmp245_;
									_tmp240_ = self->priv->current;
									self->priv->current = _tmp240_ + 1;
									_tmp241_ = token_length_in_chars;
									token_length_in_chars = _tmp241_ + 1;
									_tmp242_ = self->priv->current;
									_tmp243_ = self->priv->end;
									if (_tmp242_ >= _tmp243_) {
										break;
									}
									_tmp244_ = self->priv->current;
									_tmp245_ = _tmp244_[0];
									switch (_tmp245_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case 'v':
										case '$':
										{
											gchar* _tmp246_;
											gint _tmp247_;
											_tmp246_ = self->priv->current;
											self->priv->current = _tmp246_ + 1;
											_tmp247_ = token_length_in_chars;
											token_length_in_chars = _tmp247_ + 1;
											break;
										}
										case 'u':
										{
											gchar* _tmp248_;
											gint _tmp249_;
											gint digit_length = 0;
											_tmp248_ = self->priv->current;
											self->priv->current = _tmp248_ + 1;
											_tmp249_ = token_length_in_chars;
											token_length_in_chars = _tmp249_ + 1;
											{
												gboolean _tmp250_ = FALSE;
												digit_length = 0;
												_tmp250_ = TRUE;
												while (TRUE) {
													gboolean _tmp252_ = FALSE;
													gchar* _tmp253_;
													gchar* _tmp254_;
													gchar* _tmp257_;
													gint _tmp258_;
													if (!_tmp250_) {
														gint _tmp251_;
														_tmp251_ = digit_length;
														digit_length = _tmp251_ + 1;
													}
													_tmp250_ = FALSE;
													_tmp253_ = self->priv->current;
													_tmp254_ = self->priv->end;
													if (_tmp253_ < _tmp254_) {
														gchar* _tmp255_;
														gchar _tmp256_;
														_tmp255_ = self->priv->current;
														_tmp256_ = _tmp255_[0];
														_tmp252_ = g_ascii_isxdigit (_tmp256_);
													} else {
														_tmp252_ = FALSE;
													}
													if (!_tmp252_) {
														break;
													}
													_tmp257_ = self->priv->current;
													self->priv->current = _tmp257_ + 1;
													_tmp258_ = token_length_in_chars;
													token_length_in_chars = _tmp258_ + 1;
												}
											}
											if (digit_length < 1) {
												ValaSourceReference* _tmp259_;
												ValaSourceReference* _tmp260_;
												_tmp259_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp260_ = _tmp259_;
												vala_report_error (_tmp260_, "\\u used with no following hex digits");
												_vala_source_reference_unref0 (_tmp260_);
											} else {
												if (digit_length < 4) {
													ValaSourceReference* _tmp261_;
													ValaSourceReference* _tmp262_;
													_tmp261_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp262_ = _tmp261_;
													vala_report_error (_tmp262_, "incomplete universal character name");
													_vala_source_reference_unref0 (_tmp262_);
												}
											}
											break;
										}
										case 'x':
										{
											gchar* _tmp263_;
											gint _tmp264_;
											gint digit_length = 0;
											gboolean empty = FALSE;
											gboolean _tmp276_ = FALSE;
											_tmp263_ = self->priv->current;
											self->priv->current = _tmp263_ + 1;
											_tmp264_ = token_length_in_chars;
											token_length_in_chars = _tmp264_ + 1;
											empty = TRUE;
											{
												gboolean _tmp265_ = FALSE;
												digit_length = 0;
												_tmp265_ = TRUE;
												while (TRUE) {
													gboolean _tmp266_ = FALSE;
													gchar* _tmp267_;
													gchar* _tmp268_;
													gchar* _tmp271_;
													gchar _tmp272_;
													gchar* _tmp274_;
													gint _tmp275_;
													if (!_tmp265_) {
													}
													_tmp265_ = FALSE;
													_tmp267_ = self->priv->current;
													_tmp268_ = self->priv->end;
													if (_tmp267_ < _tmp268_) {
														gchar* _tmp269_;
														gchar _tmp270_;
														_tmp269_ = self->priv->current;
														_tmp270_ = _tmp269_[0];
														_tmp266_ = g_ascii_isxdigit (_tmp270_);
													} else {
														_tmp266_ = FALSE;
													}
													if (!_tmp266_) {
														break;
													}
													_tmp271_ = self->priv->current;
													_tmp272_ = _tmp271_[0];
													if (_tmp272_ != '0') {
														gint _tmp273_;
														_tmp273_ = digit_length;
														digit_length = _tmp273_ + 1;
													} else {
														empty = FALSE;
													}
													_tmp274_ = self->priv->current;
													self->priv->current = _tmp274_ + 1;
													_tmp275_ = token_length_in_chars;
													token_length_in_chars = _tmp275_ + 1;
												}
											}
											if (empty) {
												_tmp276_ = digit_length < 1;
											} else {
												_tmp276_ = FALSE;
											}
											if (_tmp276_) {
												ValaSourceReference* _tmp277_;
												ValaSourceReference* _tmp278_;
												_tmp277_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp278_ = _tmp277_;
												vala_report_error (_tmp278_, "\\x used with no following hex digits");
												_vala_source_reference_unref0 (_tmp278_);
											} else {
												if (digit_length > 2) {
													ValaSourceReference* _tmp279_;
													ValaSourceReference* _tmp280_;
													_tmp279_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp280_ = _tmp279_;
													vala_report_error (_tmp280_, "hex escape sequence out of range");
													_vala_source_reference_unref0 (_tmp280_);
												}
											}
											break;
										}
										default:
										{
											ValaSourceReference* _tmp281_;
											ValaSourceReference* _tmp282_;
											_tmp281_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp282_ = _tmp281_;
											vala_report_error (_tmp282_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp282_);
											break;
										}
									}
								} else {
									gchar* _tmp283_;
									gchar _tmp284_;
									_tmp283_ = self->priv->current;
									_tmp284_ = _tmp283_[0];
									if (_tmp284_ == '\n') {
										gchar* _tmp285_;
										gint _tmp286_;
										_tmp285_ = self->priv->current;
										self->priv->current = _tmp285_ + 1;
										_tmp286_ = self->priv->line;
										self->priv->line = _tmp286_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u = 0U;
										gchar* _tmp287_;
										gchar* _tmp288_;
										gchar* _tmp289_;
										_tmp287_ = self->priv->current;
										_tmp288_ = self->priv->end;
										_tmp289_ = self->priv->current;
										u = g_utf8_get_char_validated ((const gchar*) _tmp287_, (gssize) ((glong) (_tmp288_ - _tmp289_)));
										if (u != ((gunichar) -1)) {
											gchar* _tmp290_;
											gint _tmp291_;
											_tmp290_ = self->priv->current;
											self->priv->current = _tmp290_ + g_unichar_to_utf8 (u, NULL);
											_tmp291_ = token_length_in_chars;
											token_length_in_chars = _tmp291_ + 1;
										} else {
											gchar* _tmp292_;
											ValaSourceReference* _tmp293_;
											ValaSourceReference* _tmp294_;
											_tmp292_ = self->priv->current;
											self->priv->current = _tmp292_ + 1;
											_tmp293_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp294_ = _tmp293_;
											vala_report_error (_tmp294_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp294_);
										}
									}
								}
								_tmp297_ = self->priv->current;
								_tmp298_ = self->priv->end;
								if (_tmp297_ < _tmp298_) {
									gchar* _tmp299_;
									gchar _tmp300_;
									_tmp299_ = begin;
									_tmp300_ = _tmp299_[0];
									_tmp296_ = _tmp300_ == '\'';
								} else {
									_tmp296_ = FALSE;
								}
								if (_tmp296_) {
									gchar* _tmp301_;
									gchar _tmp302_;
									_tmp301_ = self->priv->current;
									_tmp302_ = _tmp301_[0];
									_tmp295_ = _tmp302_ != '\'';
								} else {
									_tmp295_ = FALSE;
								}
								if (_tmp295_) {
									ValaSourceReference* _tmp303_;
									ValaSourceReference* _tmp304_;
									_tmp303_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp304_ = _tmp303_;
									vala_report_error (_tmp304_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp304_);
								}
							}
							_tmp305_ = self->priv->current;
							_tmp306_ = self->priv->end;
							if (_tmp305_ < _tmp306_) {
								gchar* _tmp307_;
								_tmp307_ = self->priv->current;
								self->priv->current = _tmp307_ + 1;
							} else {
								ValaSourceReference* _tmp308_;
								ValaSourceReference* _tmp309_;
								gchar* _tmp310_;
								gchar _tmp311_;
								gchar* _tmp312_;
								gchar* _tmp313_;
								_tmp308_ = vala_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp309_ = _tmp308_;
								_tmp310_ = begin;
								_tmp311_ = _tmp310_[0];
								_tmp312_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp311_);
								_tmp313_ = _tmp312_;
								vala_report_error (_tmp309_, _tmp313_);
								_g_free0 (_tmp313_);
								_vala_source_reference_unref0 (_tmp309_);
							}
							break;
						}
						default:
						{
							gunichar u = 0U;
							gchar* _tmp314_;
							gchar* _tmp315_;
							gchar* _tmp316_;
							gint _tmp323_;
							ValaSourceLocation _tmp324_ = {0};
							ValaSourceLocation _tmp325_ = {0};
							ValaTokenType _tmp326_;
							_tmp314_ = self->priv->current;
							_tmp315_ = self->priv->end;
							_tmp316_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp314_, (gssize) ((glong) (_tmp315_ - _tmp316_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp317_;
								ValaSourceReference* _tmp318_;
								ValaSourceReference* _tmp319_;
								_tmp317_ = self->priv->current;
								self->priv->current = _tmp317_ + g_unichar_to_utf8 (u, NULL);
								_tmp318_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp319_ = _tmp318_;
								vala_report_error (_tmp319_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp319_);
							} else {
								gchar* _tmp320_;
								ValaSourceReference* _tmp321_;
								ValaSourceReference* _tmp322_;
								_tmp320_ = self->priv->current;
								self->priv->current = _tmp320_ + 1;
								_tmp321_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp322_ = _tmp321_;
								vala_report_error (_tmp322_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp322_);
							}
							_tmp323_ = self->priv->column;
							self->priv->column = _tmp323_ + 1;
							_tmp326_ = vala_scanner_read_token (self, &_tmp324_, &_tmp325_);
							_vala_token_begin = _tmp324_;
							_vala_token_end = _tmp325_;
							result = _tmp326_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp327_;
		gchar* _tmp328_;
		_tmp327_ = self->priv->current;
		_tmp328_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp327_ - _tmp328_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp329_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp329_, self->priv->line, self->priv->column - 1);
	_tmp330_ = type;
	self->priv->previous = _tmp330_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static gboolean
vala_scanner_matches (gchar* begin,
                      const gchar* keyword)
{
	gchar* keyword_array = NULL;
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	_tmp1_ = _tmp0_;
	len = (glong) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar _tmp4_;
				gchar* _tmp5_;
				gchar _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((glong) i) < len)) {
					break;
				}
				_tmp4_ = begin[i];
				_tmp5_ = keyword_array;
				_tmp6_ = _tmp5_[i];
				if (_tmp4_ != _tmp6_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_scanner_pp_whitespace (ValaScanner* self)
{
	gboolean found = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	result = found;
	return result;
}

static void
vala_scanner_pp_space (ValaScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_scanner_pp_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static void
vala_scanner_pp_directive (ValaScanner* self)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar* begin = NULL;
	gchar* _tmp15_;
	gint len = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp34_ = FALSE;
	ValaScannerConditional* _tmp35_;
	gint _tmp35__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	if (self->priv->line == 1) {
		_tmp4_ = self->priv->column == 2;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->current;
		_tmp6_ = self->priv->end;
		_tmp3_ = _tmp5_ < _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		_tmp2_ = _tmp8_ == '!';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp14_;
			_tmp10_ = self->priv->current;
			_tmp11_ = self->priv->end;
			if (_tmp10_ < _tmp11_) {
				gchar* _tmp12_;
				gchar _tmp13_;
				_tmp12_ = self->priv->current;
				_tmp13_ = _tmp12_[0];
				_tmp9_ = _tmp13_ != '\n';
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
			_tmp14_ = self->priv->current;
			self->priv->current = _tmp14_ + 1;
		}
		return;
	}
	vala_scanner_pp_space (self);
	_tmp15_ = self->priv->current;
	begin = _tmp15_;
	len = 0;
	while (TRUE) {
		gboolean _tmp16_ = FALSE;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp17_ = self->priv->current;
		_tmp18_ = self->priv->end;
		if (_tmp17_ < _tmp18_) {
			gchar* _tmp19_;
			gchar _tmp20_;
			_tmp19_ = self->priv->current;
			_tmp20_ = _tmp19_[0];
			_tmp16_ = g_ascii_isalnum (_tmp20_);
		} else {
			_tmp16_ = FALSE;
		}
		if (!_tmp16_) {
			break;
		}
		_tmp21_ = self->priv->current;
		self->priv->current = _tmp21_ + 1;
		_tmp22_ = self->priv->column;
		self->priv->column = _tmp22_ + 1;
		_tmp23_ = len;
		len = _tmp23_ + 1;
	}
	if (len == 2) {
		gchar* _tmp25_;
		_tmp25_ = begin;
		_tmp24_ = vala_scanner_matches (_tmp25_, "if");
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		vala_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp26_ = FALSE;
		if (len == 4) {
			gchar* _tmp27_;
			_tmp27_ = begin;
			_tmp26_ = vala_scanner_matches (_tmp27_, "elif");
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			vala_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp28_ = FALSE;
			if (len == 4) {
				gchar* _tmp29_;
				_tmp29_ = begin;
				_tmp28_ = vala_scanner_matches (_tmp29_, "else");
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				vala_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp30_ = FALSE;
				if (len == 5) {
					gchar* _tmp31_;
					_tmp31_ = begin;
					_tmp30_ = vala_scanner_matches (_tmp31_, "endif");
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					vala_scanner_parse_pp_endif (self);
				} else {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					_tmp32_ = vala_scanner_get_source_reference (self, -len, len);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp33_);
				}
			}
		}
	}
	_tmp35_ = self->priv->conditional_stack;
	_tmp35__length1 = self->priv->conditional_stack_length1;
	if (_tmp35__length1 > 0) {
		ValaScannerConditional* _tmp36_;
		gint _tmp36__length1;
		ValaScannerConditional* _tmp37_;
		gint _tmp37__length1;
		ValaScannerConditional _tmp38_;
		_tmp36_ = self->priv->conditional_stack;
		_tmp36__length1 = self->priv->conditional_stack_length1;
		_tmp37_ = self->priv->conditional_stack;
		_tmp37__length1 = self->priv->conditional_stack_length1;
		_tmp38_ = _tmp36_[_tmp37__length1 - 1];
		_tmp34_ = _tmp38_.skip_section;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		gboolean bol = FALSE;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_ = FALSE;
			gchar* _tmp45_;
			gchar _tmp46_;
			gchar* _tmp50_;
			gint _tmp51_;
			_tmp39_ = self->priv->current;
			_tmp40_ = self->priv->end;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			if (bol) {
				gchar* _tmp42_;
				gchar _tmp43_;
				_tmp42_ = self->priv->current;
				_tmp43_ = _tmp42_[0];
				_tmp41_ = _tmp43_ == '#';
			} else {
				_tmp41_ = FALSE;
			}
			if (_tmp41_) {
				gchar* _tmp44_;
				_tmp44_ = self->priv->current;
				self->priv->current = _tmp44_ - (self->priv->column - 1);
				self->priv->column = 1;
				return;
			}
			_tmp45_ = self->priv->current;
			_tmp46_ = _tmp45_[0];
			if (_tmp46_ == '\n') {
				gint _tmp47_;
				_tmp47_ = self->priv->line;
				self->priv->line = _tmp47_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp48_;
				gchar _tmp49_;
				_tmp48_ = self->priv->current;
				_tmp49_ = _tmp48_[0];
				if (!g_ascii_isspace (_tmp49_)) {
					bol = FALSE;
				}
			}
			_tmp50_ = self->priv->current;
			self->priv->current = _tmp50_ + 1;
			_tmp51_ = self->priv->column;
			self->priv->column = _tmp51_ + 1;
		}
	}
}

static void
vala_scanner_pp_eol (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp6_);
	}
}

static void
_vala_array_add22 (ValaScannerConditional* * array,
                   gint* length,
                   gint* size,
                   const ValaScannerConditional* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
vala_scanner_parse_pp_if (ValaScanner* self)
{
	gboolean condition = FALSE;
	ValaScannerConditional* _tmp0_;
	gint _tmp0__length1;
	ValaScannerConditional _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	condition = vala_scanner_parse_pp_expression (self);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp1_, 0, sizeof (ValaScannerConditional));
	_vala_array_add22 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp1_);
	if (condition) {
		gboolean _tmp3_ = FALSE;
		ValaScannerConditional* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->priv->conditional_stack;
		_tmp4__length1 = self->priv->conditional_stack_length1;
		if (_tmp4__length1 == 1) {
			_tmp3_ = TRUE;
		} else {
			ValaScannerConditional* _tmp5_;
			gint _tmp5__length1;
			ValaScannerConditional* _tmp6_;
			gint _tmp6__length1;
			ValaScannerConditional _tmp7_;
			_tmp5_ = self->priv->conditional_stack;
			_tmp5__length1 = self->priv->conditional_stack_length1;
			_tmp6_ = self->priv->conditional_stack;
			_tmp6__length1 = self->priv->conditional_stack_length1;
			_tmp7_ = _tmp5_[_tmp6__length1 - 2];
			_tmp3_ = !_tmp7_.skip_section;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaScannerConditional* _tmp8_;
		gint _tmp8__length1;
		ValaScannerConditional* _tmp9_;
		gint _tmp9__length1;
		_tmp8_ = self->priv->conditional_stack;
		_tmp8__length1 = self->priv->conditional_stack_length1;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp8_[_tmp9__length1 - 1].matched = TRUE;
	} else {
		ValaScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaScannerConditional* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = self->priv->conditional_stack;
		_tmp11__length1 = self->priv->conditional_stack_length1;
		_tmp10_[_tmp11__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_scanner_parse_pp_elif (ValaScanner* self)
{
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	condition = vala_scanner_parse_pp_expression (self);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	if (condition) {
		ValaScannerConditional* _tmp9_;
		gint _tmp9__length1;
		ValaScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaScannerConditional _tmp11_;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = _tmp9_[_tmp10__length1 - 1];
		_tmp8_ = !_tmp11_.matched;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp12_ = FALSE;
		ValaScannerConditional* _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		if (_tmp13__length1 == 1) {
			_tmp12_ = TRUE;
		} else {
			ValaScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaScannerConditional* _tmp15_;
			gint _tmp15__length1;
			ValaScannerConditional _tmp16_;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = self->priv->conditional_stack;
			_tmp15__length1 = self->priv->conditional_stack_length1;
			_tmp16_ = _tmp14_[_tmp15__length1 - 2];
			_tmp12_ = !_tmp16_.skip_section;
		}
		_tmp7_ = _tmp12_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaScannerConditional* _tmp20_;
		gint _tmp20__length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp17_[_tmp18__length1 - 1].matched = TRUE;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp19_[_tmp20__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaScannerConditional* _tmp22_;
		gint _tmp22__length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_scanner_parse_pp_else (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	ValaScannerConditional* _tmp8_;
	gint _tmp8__length1;
	ValaScannerConditional* _tmp9_;
	gint _tmp9__length1;
	ValaScannerConditional _tmp10_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	_tmp8_ = self->priv->conditional_stack;
	_tmp8__length1 = self->priv->conditional_stack_length1;
	_tmp9_ = self->priv->conditional_stack;
	_tmp9__length1 = self->priv->conditional_stack_length1;
	_tmp10_ = _tmp8_[_tmp9__length1 - 1];
	if (!_tmp10_.matched) {
		gboolean _tmp11_ = FALSE;
		ValaScannerConditional* _tmp12_;
		gint _tmp12__length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		if (_tmp12__length1 == 1) {
			_tmp11_ = TRUE;
		} else {
			ValaScannerConditional* _tmp13_;
			gint _tmp13__length1;
			ValaScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaScannerConditional _tmp15_;
			_tmp13_ = self->priv->conditional_stack;
			_tmp13__length1 = self->priv->conditional_stack_length1;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = _tmp13_[_tmp14__length1 - 2];
			_tmp11_ = !_tmp15_.skip_section;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaScannerConditional* _tmp16_;
		gint _tmp16__length1;
		ValaScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaScannerConditional* _tmp19_;
		gint _tmp19__length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp16_[_tmp17__length1 - 1].matched = TRUE;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp18_[_tmp19__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp20_;
		gint _tmp20__length1;
		ValaScannerConditional* _tmp21_;
		gint _tmp21__length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp20_[_tmp21__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_scanner_parse_pp_endif (ValaScanner* self)
{
	ValaScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
vala_scanner_parse_pp_symbol (ValaScanner* self)
{
	gint len = 0;
	gchar* identifier = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean defined = FALSE;
	const gchar* _tmp12_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = vala_scanner_is_ident_char (self, _tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		_tmp7_ = len;
		len = _tmp7_ + 1;
	}
	if (len == 0) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp9_);
		result = FALSE;
		return result;
	}
	_tmp10_ = self->priv->current;
	_tmp11_ = string_substring ((const gchar*) (_tmp10_ - len), (glong) 0, (glong) len);
	identifier = _tmp11_;
	_tmp12_ = identifier;
	if (g_strcmp0 (_tmp12_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = identifier;
		if (g_strcmp0 (_tmp13_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp14_;
			ValaCodeContext* _tmp15_;
			ValaCodeContext* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = self->priv->_source_file;
			_tmp15_ = vala_source_file_get_context (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = identifier;
			defined = vala_code_context_is_defined (_tmp16_, _tmp17_);
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}

static gboolean
vala_scanner_parse_pp_primary_expression (ValaScanner* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		if (vala_scanner_is_ident_char (self, _tmp5_)) {
			result = vala_scanner_parse_pp_symbol (self);
			return result;
		} else {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			if (_tmp7_ == '(') {
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean _result_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->column;
				self->priv->column = _tmp9_ + 1;
				vala_scanner_pp_space (self);
				_result_ = vala_scanner_parse_pp_expression (self);
				vala_scanner_pp_space (self);
				_tmp11_ = self->priv->current;
				_tmp12_ = self->priv->end;
				if (_tmp11_ < _tmp12_) {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == ')';
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					gint _tmp16_;
					_tmp15_ = self->priv->current;
					self->priv->current = _tmp15_ + 1;
					_tmp16_ = self->priv->column;
					self->priv->column = _tmp16_ + 1;
				} else {
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					_tmp17_ = vala_scanner_get_source_reference (self, 0, 0);
					_tmp18_ = _tmp17_;
					vala_report_error (_tmp18_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp18_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp19_ = vala_scanner_get_source_reference (self, 0, 0);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp20_);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_scanner_parse_pp_unary_expression (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		vala_scanner_pp_space (self);
		result = !vala_scanner_parse_pp_unary_expression (self);
		return result;
	}
	result = vala_scanner_parse_pp_primary_expression (self);
	return result;
}

static gboolean
vala_scanner_parse_pp_equality_expression (ValaScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_scanner_parse_pp_unary_expression (self);
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '=';
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp8_;
			gboolean right = FALSE;
			_tmp8_ = self->priv->current;
			self->priv->current = _tmp8_ + 2;
			self->priv->column = self->priv->column + 2;
			vala_scanner_pp_space (self);
			right = vala_scanner_parse_pp_unary_expression (self);
			left = left == right;
		} else {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = self->priv->end;
			if (_tmp11_ < (_tmp12_ - 1)) {
				gchar* _tmp13_;
				gchar _tmp14_;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				_tmp10_ = _tmp14_ == '!';
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gchar* _tmp15_;
				gchar _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_[1];
				_tmp9_ = _tmp16_ == '=';
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp17_;
				gboolean right = FALSE;
				_tmp17_ = self->priv->current;
				self->priv->current = _tmp17_ + 2;
				self->priv->column = self->priv->column + 2;
				vala_scanner_pp_space (self);
				right = vala_scanner_parse_pp_unary_expression (self);
				left = left != right;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}

static gboolean
vala_scanner_parse_pp_and_expression (ValaScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_scanner_parse_pp_equality_expression (self);
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '&';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_scanner_pp_space (self);
		right = vala_scanner_parse_pp_equality_expression (self);
		if (left) {
			_tmp9_ = right;
		} else {
			_tmp9_ = FALSE;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_scanner_parse_pp_or_expression (ValaScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_scanner_parse_pp_and_expression (self);
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '|';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_scanner_pp_space (self);
		right = vala_scanner_parse_pp_and_expression (self);
		if (left) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = right;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_scanner_parse_pp_expression (ValaScanner* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_scanner_parse_pp_or_expression (self);
	return result;
}

static gboolean
vala_scanner_whitespace (ValaScanner* self)
{
	gboolean found = FALSE;
	gboolean bol = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	bol = self->priv->column == 1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gchar _tmp6_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = g_ascii_isspace (_tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		if (_tmp6_ == '\n') {
			gint _tmp7_;
			_tmp7_ = self->priv->line;
			self->priv->line = _tmp7_ + 1;
			self->priv->column = 0;
			bol = TRUE;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	if (bol) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->current;
		_tmp13_ = self->priv->end;
		_tmp11_ = _tmp12_ < _tmp13_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		_tmp10_ = _tmp15_ == '#';
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		vala_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}

static gboolean
vala_scanner_comment (ValaScanner* self,
                      gboolean file_comment)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp13_;
	gchar _tmp14_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		_tmp1_ = _tmp7_ != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != '/') {
			gchar* _tmp11_;
			gchar _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_[1];
			_tmp8_ = _tmp12_ != '*';
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_[1];
	if (_tmp14_ == '/') {
		ValaSourceReference* source_reference = NULL;
		gchar* _tmp16_;
		gchar* begin = NULL;
		gchar* _tmp17_;
		ValaSourceReference* _tmp24_;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp15_;
			_tmp15_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp15_;
		}
		_tmp16_ = self->priv->current;
		self->priv->current = _tmp16_ + 2;
		_tmp17_ = self->priv->current;
		begin = _tmp17_;
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp23_;
			_tmp19_ = self->priv->current;
			_tmp20_ = self->priv->end;
			if (_tmp19_ < _tmp20_) {
				gchar* _tmp21_;
				gchar _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_[0];
				_tmp18_ = _tmp22_ != '\n';
			} else {
				_tmp18_ = FALSE;
			}
			if (!_tmp18_) {
				break;
			}
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + 1;
		}
		_tmp24_ = source_reference;
		if (_tmp24_ != NULL) {
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			ValaSourceReference* _tmp30_;
			_tmp25_ = begin;
			_tmp26_ = self->priv->current;
			_tmp27_ = begin;
			_tmp28_ = string_substring ((const gchar*) _tmp25_, (glong) 0, (glong) (_tmp26_ - _tmp27_));
			_tmp29_ = _tmp28_;
			_tmp30_ = source_reference;
			vala_scanner_push_comment (self, _tmp29_, _tmp30_, file_comment);
			_g_free0 (_tmp29_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gchar* _tmp35_;
		gchar _tmp36_;
		gchar* _tmp38_;
		gchar* begin = NULL;
		gchar* _tmp39_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		ValaSourceReference* _tmp57_;
		gchar* _tmp64_;
		source_reference = NULL;
		if (file_comment) {
			gchar* _tmp32_;
			gchar _tmp33_;
			_tmp32_ = self->priv->current;
			_tmp33_ = _tmp32_[2];
			_tmp31_ = _tmp33_ == '*';
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp35_ = self->priv->current;
		_tmp36_ = _tmp35_[2];
		if (_tmp36_ == '*') {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = file_comment;
		}
		if (_tmp34_) {
			ValaSourceReference* _tmp37_;
			_tmp37_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp37_;
		}
		_tmp38_ = self->priv->current;
		self->priv->current = _tmp38_ + 2;
		self->priv->column = self->priv->column + 2;
		_tmp39_ = self->priv->current;
		begin = _tmp39_;
		while (TRUE) {
			gboolean _tmp40_ = FALSE;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp48_;
			gchar _tmp49_;
			gchar* _tmp51_;
			gint _tmp52_;
			_tmp41_ = self->priv->current;
			_tmp42_ = self->priv->end;
			if (_tmp41_ < (_tmp42_ - 1)) {
				gboolean _tmp43_ = FALSE;
				gchar* _tmp44_;
				gchar _tmp45_;
				_tmp44_ = self->priv->current;
				_tmp45_ = _tmp44_[0];
				if (_tmp45_ != '*') {
					_tmp43_ = TRUE;
				} else {
					gchar* _tmp46_;
					gchar _tmp47_;
					_tmp46_ = self->priv->current;
					_tmp47_ = _tmp46_[1];
					_tmp43_ = _tmp47_ != '/';
				}
				_tmp40_ = _tmp43_;
			} else {
				_tmp40_ = FALSE;
			}
			if (!_tmp40_) {
				break;
			}
			_tmp48_ = self->priv->current;
			_tmp49_ = _tmp48_[0];
			if (_tmp49_ == '\n') {
				gint _tmp50_;
				_tmp50_ = self->priv->line;
				self->priv->line = _tmp50_ + 1;
				self->priv->column = 0;
			}
			_tmp51_ = self->priv->current;
			self->priv->current = _tmp51_ + 1;
			_tmp52_ = self->priv->column;
			self->priv->column = _tmp52_ + 1;
		}
		_tmp53_ = self->priv->current;
		_tmp54_ = self->priv->end;
		if (_tmp53_ == (_tmp54_ - 1)) {
			ValaSourceReference* _tmp55_;
			ValaSourceReference* _tmp56_;
			_tmp55_ = vala_scanner_get_source_reference (self, 0, 0);
			_tmp56_ = _tmp55_;
			vala_report_error (_tmp56_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp56_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp57_ = source_reference;
		if (_tmp57_ != NULL) {
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			ValaSourceReference* _tmp63_;
			_tmp58_ = begin;
			_tmp59_ = self->priv->current;
			_tmp60_ = begin;
			_tmp61_ = string_substring ((const gchar*) _tmp58_, (glong) 0, (glong) (_tmp59_ - _tmp60_));
			_tmp62_ = _tmp61_;
			_tmp63_ = source_reference;
			vala_scanner_push_comment (self, _tmp62_, _tmp63_, file_comment);
			_g_free0 (_tmp62_);
		}
		_tmp64_ = self->priv->current;
		self->priv->current = _tmp64_ + 2;
		self->priv->column = self->priv->column + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}

static void
vala_scanner_space (ValaScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

void
vala_scanner_parse_file_comments (ValaScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_scanner_comment (self, TRUE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
vala_scanner_push_comment (ValaScanner* self,
                           const gchar* comment_item,
                           ValaSourceReference* source_reference,
                           gboolean file_comment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	if (string_get (comment_item, (glong) 0) == '*') {
		ValaComment* _tmp0_;
		ValaComment* _tmp3_;
		_tmp0_ = self->priv->_comment;
		if (_tmp0_ != NULL) {
			ValaSourceFile* _tmp1_;
			ValaComment* _tmp2_;
			_tmp1_ = self->priv->_source_file;
			_tmp2_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp1_, _tmp2_);
		}
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp3_;
	}
	if (file_comment) {
		ValaSourceFile* _tmp4_;
		ValaComment* _tmp5_;
		ValaComment* _tmp6_;
		_tmp4_ = self->priv->_source_file;
		_tmp5_ = vala_comment_new (comment_item, source_reference);
		_tmp6_ = _tmp5_;
		vala_source_file_add_comment (_tmp4_, _tmp6_);
		_vala_comment_unref0 (_tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}

/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}

ValaComment*
vala_scanner_pop_comment (ValaScanner* self)
{
	ValaComment* _tmp0_;
	ValaComment* comment = NULL;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	ValaComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}

static ValaScannerConditional*
vala_scanner_conditional_dup (const ValaScannerConditional* self)
{
	ValaScannerConditional* dup;
	dup = g_new0 (ValaScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaScannerConditional));
	return dup;
}

static void
vala_scanner_conditional_free (ValaScannerConditional* self)
{
	g_free (self);
}

static GType
vala_scanner_conditional_get_type_once (void)
{
	GType vala_scanner_conditional_type_id;
	vala_scanner_conditional_type_id = g_boxed_type_register_static ("ValaScannerConditional", (GBoxedCopyFunc) vala_scanner_conditional_dup, (GBoxedFreeFunc) vala_scanner_conditional_free);
	return vala_scanner_conditional_type_id;
}

static GType
vala_scanner_conditional_get_type (void)
{
	static volatile gsize vala_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_conditional_type_id__volatile)) {
		GType vala_scanner_conditional_type_id;
		vala_scanner_conditional_type_id = vala_scanner_conditional_get_type_once ();
		g_once_init_leave (&vala_scanner_conditional_type_id__volatile, vala_scanner_conditional_type_id);
	}
	return vala_scanner_conditional_type_id__volatile;
}

static void
vala_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_scanner_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_scanner_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_scanner_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_scanner_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	ValaScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_scanner (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ValaParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_scanner (GValue* value,
                        gpointer v_object)
{
	ValaScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}

void
vala_value_take_scanner (GValue* value,
                         gpointer v_object)
{
	ValaScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}

static void
vala_scanner_class_init (ValaScannerClass * klass,
                         gpointer klass_data)
{
	vala_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValaScannerClass *) klass)->finalize = vala_scanner_finalize;
	g_type_class_adjust_private_offset (klass, &ValaScanner_private_offset);
}

static void
vala_scanner_instance_init (ValaScanner * self,
                            gpointer klass)
{
	self->priv = vala_scanner_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_scanner_finalize (ValaScanner * obj)
{
	ValaScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SCANNER, ValaScanner);
	g_signal_handlers_destroy (self);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}

/**
 * Lexical scanner for Vala source files.
 */
static GType
vala_scanner_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_scanner_init, vala_value_scanner_free_value, vala_value_scanner_copy_value, vala_value_scanner_peek_pointer, "p", vala_value_scanner_collect_value, "p", vala_value_scanner_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScanner), 0, (GInstanceInitFunc) vala_scanner_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_scanner_type_id;
	vala_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaScanner_private_offset = g_type_add_instance_private (vala_scanner_type_id, sizeof (ValaScannerPrivate));
	return vala_scanner_type_id;
}

GType
vala_scanner_get_type (void)
{
	static volatile gsize vala_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_type_id__volatile)) {
		GType vala_scanner_type_id;
		vala_scanner_type_id = vala_scanner_get_type_once ();
		g_once_init_leave (&vala_scanner_type_id__volatile, vala_scanner_type_id);
	}
	return vala_scanner_type_id__volatile;
}

gpointer
vala_scanner_ref (gpointer instance)
{
	ValaScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_scanner_unref (gpointer instance)
{
	ValaScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

