// Generated by gmmproc 2.60.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/unixfdlist.h>
#include <giomm/private/unixfdlist_p.h>


/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gunixfdlist.h>
#include <glibmm/error.h>

namespace Gio
{

UnixFDList::UnixFDList(const Glib::ArrayHandle<int>& fds)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  // g_unix_fd_list_new_from_array() must be called.
  // Its parameters don't correspond to properties.
  // __CONSTRUCT() + g_unit_fd_list_append() is not an alternative.
  // g_unit_fd_list_append() duplicates the file descriptor,
  // but g_unix_fd_list_new_from_array() does not.
  Glib::Object((GObject*)g_unix_fd_list_new_from_array(fds.data(), fds.size()))
{
}

UnixFDList::UnixFDList(const Glib::ArrayHandle<int>& fds, int n_fds)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  // g_unix_fd_list_new_from_array() must be called.
  // Its parameters don't correspond to properties.
  // __CONSTRUCT() + g_unit_fd_list_append() is not an alternative.
  // g_unit_fd_list_append() duplicates the file descriptor,
  // but g_unix_fd_list_new_from_array() does not.
  Glib::Object((GObject*)g_unix_fd_list_new_from_array(fds.data(), n_fds))
{
}

const Glib::ArrayHandle<int>
UnixFDList::peek_fds() const
{
  int length = 0;
  const auto fds = g_unix_fd_list_peek_fds(const_cast<GUnixFDList*>(gobj()), &length);
  // The array is terminated with a -1, but that terminating element is
  // not included in the length that g_unix_fd_list_peek_fds() returns.
  return Glib::ArrayHandle<int>(fds, length, Glib::OWNERSHIP_NONE);
}

Glib::ArrayHandle<int>
UnixFDList::steal_fds()
{
  int length = 0;
  const auto fds = g_unix_fd_list_steal_fds(gobj(), &length);
  // The array is terminated with a -1, but that terminating element is
  // not included in the length that g_unix_fd_list_steal_fds() returns.
  return Glib::ArrayHandle<int>(fds, length, Glib::OWNERSHIP_DEEP);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::UnixFDList> wrap(GUnixFDList* object, bool take_copy)
{
  return Glib::RefPtr<Gio::UnixFDList>( dynamic_cast<Gio::UnixFDList*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& UnixFDList_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &UnixFDList_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_unix_fd_list_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void UnixFDList_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* UnixFDList_Class::wrap_new(GObject* object)
{
  return new UnixFDList((GUnixFDList*)object);
}


/* The implementation: */

GUnixFDList* UnixFDList::gobj_copy()
{
  reference();
  return gobj();
}

UnixFDList::UnixFDList(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

UnixFDList::UnixFDList(GUnixFDList* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


UnixFDList::UnixFDList(UnixFDList&& src) noexcept
: Glib::Object(std::move(src))
{}

UnixFDList& UnixFDList::operator=(UnixFDList&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


UnixFDList::~UnixFDList() noexcept
{}


UnixFDList::CppClassType UnixFDList::unixfdlist_class_; // initialize static member

GType UnixFDList::get_type()
{
  return unixfdlist_class_.init().get_type();
}


GType UnixFDList::get_base_type()
{
  return g_unix_fd_list_get_type();
}


UnixFDList::UnixFDList()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(unixfdlist_class_.init()))
{
  

}

Glib::RefPtr<UnixFDList> UnixFDList::create()
{
  return Glib::RefPtr<UnixFDList>( new UnixFDList() );
}

Glib::RefPtr<UnixFDList> UnixFDList::create(const Glib::ArrayHandle<int>& fds)
{
  return Glib::RefPtr<UnixFDList>( new UnixFDList(fds) );
}

Glib::RefPtr<UnixFDList> UnixFDList::create(const Glib::ArrayHandle<int>& fds, int n_fds)
{
  return Glib::RefPtr<UnixFDList>( new UnixFDList(fds, n_fds) );
}

int UnixFDList::get_length() const
{
  return g_unix_fd_list_get_length(const_cast<GUnixFDList*>(gobj()));
}

int UnixFDList::get(int index) const
{
  GError* gerror = nullptr;
  int retvalue = g_unix_fd_list_get(const_cast<GUnixFDList*>(gobj()), index, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

int UnixFDList::append(int fd)
{
  GError* gerror = nullptr;
  int retvalue = g_unix_fd_list_append(gobj(), fd, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}


} // namespace Gio


