/* backend.c generated by valac 0.22.0.42-1ce8b, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;
typedef struct _FolksBackendPrivate FolksBackendPrivate;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

struct _FolksBackend {
	GObject parent_instance;
	FolksBackendPrivate * priv;
};

struct _FolksBackendClass {
	GObjectClass parent_class;
	void (*disable_persona_store) (FolksBackend* self, FolksPersonaStore* store);
	void (*enable_persona_store) (FolksBackend* self, FolksPersonaStore* store);
	void (*set_persona_stores) (FolksBackend* self, GeeSet* storeids);
	void (*prepare) (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_finish) (FolksBackend* self, GAsyncResult* _res_, GError** error);
	void (*unprepare) (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*unprepare_finish) (FolksBackend* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_is_prepared) (FolksBackend* self);
	gboolean (*get_is_quiescent) (FolksBackend* self);
	const gchar* (*get_name) (FolksBackend* self);
	GeeMap* (*get_persona_stores) (FolksBackend* self);
};


static gpointer folks_backend_parent_class = NULL;

GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKEND_IS_PREPARED,
	FOLKS_BACKEND_IS_QUIESCENT,
	FOLKS_BACKEND_NAME,
	FOLKS_BACKEND_PERSONA_STORES
};
const gchar* folks_backend_get_name (FolksBackend* self);
void folks_backend_disable_persona_store (FolksBackend* self, FolksPersonaStore* store);
static void folks_backend_real_disable_persona_store (FolksBackend* self, FolksPersonaStore* store);
void folks_backend_enable_persona_store (FolksBackend* self, FolksPersonaStore* store);
static void folks_backend_real_enable_persona_store (FolksBackend* self, FolksPersonaStore* store);
void folks_backend_set_persona_stores (FolksBackend* self, GeeSet* storeids);
static void folks_backend_real_set_persona_stores (FolksBackend* self, GeeSet* storeids);
void folks_backend_prepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_prepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
void folks_backend_unprepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_unprepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
FolksBackend* folks_backend_construct (GType object_type);
gboolean folks_backend_get_is_prepared (FolksBackend* self);
gboolean folks_backend_get_is_quiescent (FolksBackend* self);
GeeMap* folks_backend_get_persona_stores (FolksBackend* self);
static GObject * folks_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backend_finalize (GObject* obj);
static void _vala_folks_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * Disable a {@link PersonaStore}.
   *
   * If the given persona store is in this backend {@link Backend.persona_stores},
   * it will be removed, and we will disconnect from its signals.
   *
   * @param store the {@link PersonaStore} to disable.
   *
   * @since 0.9.0
   */
static void folks_backend_real_disable_persona_store (FolksBackend* self, FolksPersonaStore* store) {
	g_critical ("Type `%s' does not implement abstract method `folks_backend_disable_persona_store'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void folks_backend_disable_persona_store (FolksBackend* self, FolksPersonaStore* store) {
	g_return_if_fail (self != NULL);
	FOLKS_BACKEND_GET_CLASS (self)->disable_persona_store (self, store);
}


/**
   * Enable a {@link PersonaStore}.
   *
   * If the given persona store is not already in this backend
   * {@link Backend.persona_stores}, it will be added to the backend and
   * {@link Backend.persona_stores} property notification will be emitted,
   * along with {@link Backend.persona_store_added}.
   *
   * @param store the {@link PersonaStore} to enable.
   *
   * @since 0.9.0
   */
static void folks_backend_real_enable_persona_store (FolksBackend* self, FolksPersonaStore* store) {
	g_critical ("Type `%s' does not implement abstract method `folks_backend_enable_persona_store'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void folks_backend_enable_persona_store (FolksBackend* self, FolksPersonaStore* store) {
	g_return_if_fail (self != NULL);
	FOLKS_BACKEND_GET_CLASS (self)->enable_persona_store (self, store);
}


/**
   * Set the {@link PersonaStore}s to use in this backend.
   *
   * This will cause {@link Backend.persona_store_removed} signals to be emitted
   * for all removed stores, followed by {@link Backend.persona_store_added}
   * signals for all added stores. As these signals are emitted, the sets of
   * individuals in any associated {@link IndividualAggregator}s will be
   * updated, and {@link IndividualAggregator.individuals_changed} may be
   * emitted multiple times as appropriate. A property change notification for
   * {@link Backend.persona_stores} will be emitted last.
   * Note: pass null storeids to use all available persona stores.
   *
   * @param storeids a Set of {@link PersonaStore} IDs to use.
   *
   * @since 0.9.0
   */
static void folks_backend_real_set_persona_stores (FolksBackend* self, GeeSet* storeids) {
	g_critical ("Type `%s' does not implement abstract method `folks_backend_set_persona_stores'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void folks_backend_set_persona_stores (FolksBackend* self, GeeSet* storeids) {
	g_return_if_fail (self != NULL);
	FOLKS_BACKEND_GET_CLASS (self)->set_persona_stores (self, storeids);
}


void folks_backend_prepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_BACKEND_GET_CLASS (self)->prepare (self, _callback_, _user_data_);
}


void folks_backend_prepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error) {
	FOLKS_BACKEND_GET_CLASS (self)->prepare_finish (self, _res_, error);
}


void folks_backend_unprepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_BACKEND_GET_CLASS (self)->unprepare (self, _callback_, _user_data_);
}


void folks_backend_unprepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error) {
	FOLKS_BACKEND_GET_CLASS (self)->unprepare_finish (self, _res_, error);
}


FolksBackend* folks_backend_construct (GType object_type) {
	FolksBackend * self = NULL;
	self = (FolksBackend*) g_object_new (object_type, NULL);
	return self;
}


gboolean folks_backend_get_is_prepared (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_BACKEND_GET_CLASS (self)->get_is_prepared (self);
}


gboolean folks_backend_get_is_quiescent (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_BACKEND_GET_CLASS (self)->get_is_quiescent (self);
}


const gchar* folks_backend_get_name (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_BACKEND_GET_CLASS (self)->get_name (self);
}


GeeMap* folks_backend_get_persona_stores (FolksBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_BACKEND_GET_CLASS (self)->get_persona_stores (self);
}


static GObject * folks_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackend * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_BACKEND, FolksBackend);
	_tmp0_ = folks_backend_get_name (self);
	_tmp1_ = _tmp0_;
	g_debug ("backend.vala:40: Constructing Backend ‘%s’ (%p)", _tmp1_, self);
	return obj;
}


static void folks_backend_class_init (FolksBackendClass * klass) {
	folks_backend_parent_class = g_type_class_peek_parent (klass);
	FOLKS_BACKEND_CLASS (klass)->disable_persona_store = folks_backend_real_disable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->enable_persona_store = folks_backend_real_enable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->set_persona_stores = folks_backend_real_set_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backend_finalize;
	/**
	   * Whether {@link Backend.prepare} has successfully completed for this
	   * backend.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether the backend has reached a quiescent state. This will happen at some
	   * point after {@link Backend.prepare} has successfully completed for the
	   * backend. A backend is in a quiescent state when all the
	   * {@link PersonaStore}s that it originally knows about have been loaded.
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link Backend.is_prepared} has changed to ``true``.
	   *
	   * When {@link Backend.unprepare} is called, this will be reset to ``false``.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A unique name for the backend.
	   *
	   * This will be used to identify the backend, and should also be used as the
	   * {@link PersonaStore.type_id} of the {@link PersonaStore}s used by the
	   * backend.
	   *
	   * This is guaranteed to always be available; even before
	   * {@link Backend.prepare} is called.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link PersonaStore}s in use by the backend.
	   *
	   * A backend may expose {@link Persona}s from multiple servers or accounts
	   * (for example), so may have a {@link PersonaStore} for each.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_PERSONA_STORES, g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when a {@link PersonaStore} is added to the backend.
	   *
	   * This will not be emitted until after {@link Backend.prepare} has been
	   * called.
	   *
	   * @param store the {@link PersonaStore}
	   */
	g_signal_new ("persona_store_added", FOLKS_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_PERSONA_STORE);
	/**
	   * Emitted when a {@link PersonaStore} is removed from the backend.
	   *
	   * This will not be emitted until after {@link Backend.prepare} has been
	   * called.
	   *
	   * @param store the {@link PersonaStore}
	   */
	g_signal_new ("persona_store_removed", FOLKS_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_PERSONA_STORE);
}


static void folks_backend_instance_init (FolksBackend * self) {
}


static void folks_backend_finalize (GObject* obj) {
	FolksBackend * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_BACKEND, FolksBackend);
	_tmp0_ = folks_backend_get_name (self);
	_tmp1_ = _tmp0_;
	g_debug ("backend.vala:45: Destroying Backend ‘%s’ (%p)", _tmp1_, self);
	G_OBJECT_CLASS (folks_backend_parent_class)->finalize (obj);
}


/**
 * A single backend to libfolks, such as Telepathy or evolution-data-server.
 * Each backend provides {@link Persona}s which are aggregated to form
 * {@link Individual}s.
 *
 * After creating a Backend instance, you must connect to the
 * {@link Backend.persona_store_added} and
 * {@link Backend.persona_store_removed} signals, //then// call
 * {@link Backend.prepare}, otherwise a race condition may occur between
 * emission of {@link Backend.persona_store_added} and your code connecting to
 * it.
 */
GType folks_backend_get_type (void) {
	static volatile gsize folks_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackend), 0, (GInstanceInitFunc) folks_backend_instance_init, NULL };
		GType folks_backend_type_id;
		folks_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_backend_type_id__volatile, folks_backend_type_id);
	}
	return folks_backend_type_id__volatile;
}


static void _vala_folks_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_BACKEND, FolksBackend);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



