/* bluez-persona.c generated by valac 0.22.0.42-1ce8b, the Vala compiler
 * generated from bluez-persona.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Arun Raghavan <arun.raghavan@collabora.co.uk>
 *          Jeremy Whiting <jeremy.whiting@collabora.com>
 *          Simon McVittie <simon.mcvittie@collabora.co.uk>
 *          Matthieu Bouron <matthieu.bouron@collabora.com>
 *
 * Based on kf-persona.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libebook-contacts/libebook-contacts.h>


#define FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA (folks_backends_blue_z_persona_get_type ())
#define FOLKS_BACKENDS_BLUE_Z_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaClass))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaClass))

typedef struct _FolksBackendsBlueZPersona FolksBackendsBlueZPersona;
typedef struct _FolksBackendsBlueZPersonaClass FolksBackendsBlueZPersonaClass;
typedef struct _FolksBackendsBlueZPersonaPrivate FolksBackendsBlueZPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _FolksBackendsBlueZPersona {
	FolksPersona parent_instance;
	FolksBackendsBlueZPersonaPrivate * priv;
};

struct _FolksBackendsBlueZPersonaClass {
	FolksPersonaClass parent_class;
};

struct _FolksBackendsBlueZPersonaPrivate {
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	GeeSet* _urls;
	GeeSet* _urls_ro;
	GLoadableIcon* _avatar;
	GeeHashSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	GeeHashSet* _email_addresses;
	GeeSet* _email_addresses_ro;
};


static gpointer folks_backends_blue_z_persona_parent_class = NULL;
static gchar** folks_backends_blue_z_persona__writeable_properties;
static gint folks_backends_blue_z_persona__writeable_properties_length1;
static gchar** folks_backends_blue_z_persona__writeable_properties = NULL;
static gint folks_backends_blue_z_persona__writeable_properties_length1 = 0;
static gint _folks_backends_blue_z_persona__writeable_properties_size_ = 0;
static FolksAvatarDetailsIface* folks_backends_blue_z_persona_folks_avatar_details_parent_iface = NULL;
static FolksEmailDetailsIface* folks_backends_blue_z_persona_folks_email_details_parent_iface = NULL;
static FolksNameDetailsIface* folks_backends_blue_z_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface* folks_backends_blue_z_persona_folks_phone_details_parent_iface = NULL;
static FolksUrlDetailsIface* folks_backends_blue_z_persona_folks_url_details_parent_iface = NULL;

GType folks_backends_blue_z_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaPrivate))
enum  {
	FOLKS_BACKENDS_BLUE_Z_PERSONA_DUMMY_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES
};
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_new (const gchar* vcf, const gchar* name, const gchar* vcard, FolksPersonaStore* store, gboolean is_user);
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_construct (GType object_type, const gchar* vcf, const gchar* name, const gchar* vcard, FolksPersonaStore* store, gboolean is_user);
static void _folks_backends_blue_z_persona_set_vcard (FolksBackendsBlueZPersona* self, const gchar* vcard);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
static void folks_backends_blue_z_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static GObject * folks_backends_blue_z_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_blue_z_persona_finalize (GObject* obj);
static void _vala_folks_backends_blue_z_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_blue_z_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties[2] = {"phone-numbers", "email-addresses"};

/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * the Persona given by the group ``uid`` in the key file ``key_file``.
   *
   * @param vcf the VCard filename reference. For example: 0.vcf.
   * @param name the Persona the contact name or alias.
   * @param vcard the Vcard stored as a string.
   * @param store the store to which the Persona belongs.
   * @param is_user whether the Persona is the user itself or not.
   *
   * @since 0.9.6
   */
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_construct (GType object_type, const gchar* vcf, const gchar* name, const gchar* vcard, FolksPersonaStore* store, gboolean is_user) {
	FolksBackendsBlueZPersona * self = NULL;
	gchar* iid = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* uid = NULL;
	FolksPersonaStore* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	FolksPersonaStore* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	g_return_val_if_fail (vcf != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (vcard != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = vcard;
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp0_, (gsize) (-1));
	iid = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_persona_build_uid ("bluez", _tmp4_, iid);
	uid = _tmp5_;
	_tmp6_ = name;
	_tmp7_ = store;
	_tmp8_ = is_user;
	self = (FolksBackendsBlueZPersona*) g_object_new (object_type, "display-id", _tmp6_, "iid", iid, "uid", uid, "store", _tmp7_, "is-user", _tmp8_, NULL);
	_tmp9_ = vcard;
	_folks_backends_blue_z_persona_set_vcard (self, _tmp9_);
	_g_free0 (uid);
	_g_free0 (iid);
	return self;
}


FolksBackendsBlueZPersona* folks_backends_blue_z_persona_new (const gchar* vcf, const gchar* name, const gchar* vcard, FolksPersonaStore* store, gboolean is_user) {
	return folks_backends_blue_z_persona_construct (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, vcf, name, vcard, store, is_user);
}


static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self) {
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}


static gpointer __vala_EVCardAttribute_copy0 (gpointer self) {
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}


static void _vala_EVCardAttribute_free (EVCardAttribute* self) {
	g_boxed_free (e_vcard_attribute_get_type (), self);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void _folks_backends_blue_z_persona_set_vcard (FolksBackendsBlueZPersona* self, const gchar* vcard) {
	EVCard* card = NULL;
	const gchar* _tmp0_ = NULL;
	EVCard* _tmp1_ = NULL;
	EVCardAttribute* attribute = NULL;
	EVCard* _tmp2_ = NULL;
	EVCardAttribute* _tmp3_ = NULL;
	EVCardAttribute* _tmp4_ = NULL;
	EVCardAttribute* _tmp5_ = NULL;
	EVCard* _tmp13_ = NULL;
	EVCardAttribute* _tmp14_ = NULL;
	EVCardAttribute* _tmp15_ = NULL;
	EVCardAttribute* _tmp16_ = NULL;
	EVCard* _tmp22_ = NULL;
	EVCardAttribute* _tmp23_ = NULL;
	EVCardAttribute* _tmp24_ = NULL;
	EVCardAttribute* _tmp25_ = NULL;
	EVCard* _tmp31_ = NULL;
	EVCardAttribute* _tmp32_ = NULL;
	EVCardAttribute* _tmp33_ = NULL;
	EVCardAttribute* _tmp34_ = NULL;
	EVCard* _tmp45_ = NULL;
	EVCardAttribute* _tmp46_ = NULL;
	EVCardAttribute* _tmp47_ = NULL;
	EVCardAttribute* _tmp48_ = NULL;
	EVCard* _tmp64_ = NULL;
	EVCardAttribute* _tmp65_ = NULL;
	EVCardAttribute* _tmp66_ = NULL;
	EVCardAttribute* _tmp67_ = NULL;
	EVCard* _tmp109_ = NULL;
	EVCardAttribute* _tmp110_ = NULL;
	EVCardAttribute* _tmp111_ = NULL;
	EVCardAttribute* _tmp112_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	_tmp0_ = vcard;
	_tmp1_ = e_vcard_new_from_string (_tmp0_);
	card = _tmp1_;
	_tmp2_ = card;
	_tmp3_ = e_vcard_get_attribute (_tmp2_, "TEL");
	_tmp4_ = __vala_EVCardAttribute_copy0 (_tmp3_);
	attribute = _tmp4_;
	_tmp5_ = attribute;
	if (_tmp5_ != NULL) {
		GeeHashSet* _tmp6_ = NULL;
		EVCardAttribute* _tmp7_ = NULL;
		GString* _tmp8_ = NULL;
		GString* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		FolksPhoneFieldDetails* _tmp11_ = NULL;
		FolksPhoneFieldDetails* _tmp12_ = NULL;
		_tmp6_ = self->priv->_phone_numbers;
		_tmp7_ = attribute;
		_tmp8_ = e_vcard_attribute_get_value_decoded (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_->str;
		_tmp11_ = folks_phone_field_details_new (_tmp10_, NULL);
		_tmp12_ = _tmp11_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_string_free0 (_tmp9_);
	}
	_tmp13_ = card;
	_tmp14_ = e_vcard_get_attribute (_tmp13_, "FN");
	_tmp15_ = __vala_EVCardAttribute_copy0 (_tmp14_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp15_;
	_tmp16_ = attribute;
	if (_tmp16_ != NULL) {
		EVCardAttribute* _tmp17_ = NULL;
		GString* _tmp18_ = NULL;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp17_ = attribute;
		_tmp18_ = e_vcard_attribute_get_value_decoded (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->str;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp21_;
		_g_string_free0 (_tmp19_);
	}
	_tmp22_ = card;
	_tmp23_ = e_vcard_get_attribute (_tmp22_, "NICKNAME");
	_tmp24_ = __vala_EVCardAttribute_copy0 (_tmp23_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp24_;
	_tmp25_ = attribute;
	if (_tmp25_ != NULL) {
		EVCardAttribute* _tmp26_ = NULL;
		GString* _tmp27_ = NULL;
		GString* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp26_ = attribute;
		_tmp27_ = e_vcard_attribute_get_value_decoded (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->str;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp30_;
		_g_string_free0 (_tmp28_);
	}
	_tmp31_ = card;
	_tmp32_ = e_vcard_get_attribute (_tmp31_, "URL");
	_tmp33_ = __vala_EVCardAttribute_copy0 (_tmp32_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp33_;
	_tmp34_ = attribute;
	if (_tmp34_ != NULL) {
		gchar* url = NULL;
		EVCardAttribute* _tmp35_ = NULL;
		GString* _tmp36_ = NULL;
		GString* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		GeeSet* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		FolksUrlFieldDetails* _tmp43_ = NULL;
		FolksUrlFieldDetails* _tmp44_ = NULL;
		_tmp35_ = attribute;
		_tmp36_ = e_vcard_attribute_get_value_decoded (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_->str;
		_tmp39_ = g_strdup (_tmp38_);
		_tmp40_ = _tmp39_;
		_g_string_free0 (_tmp37_);
		url = _tmp40_;
		_tmp41_ = self->priv->_urls;
		_tmp42_ = url;
		_tmp43_ = folks_url_field_details_new (_tmp42_, NULL);
		_tmp44_ = _tmp43_;
		gee_collection_add ((GeeCollection*) _tmp41_, _tmp44_);
		_g_object_unref0 (_tmp44_);
		_g_free0 (url);
	}
	_tmp45_ = card;
	_tmp46_ = e_vcard_get_attribute (_tmp45_, "PHOTO");
	_tmp47_ = __vala_EVCardAttribute_copy0 (_tmp46_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp47_;
	_tmp48_ = attribute;
	if (_tmp48_ != NULL) {
		gchar* encoded_data = NULL;
		EVCardAttribute* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		guint8* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		guint8* _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		GBytes* bytes = NULL;
		const gchar* _tmp56_ = NULL;
		size_t _tmp57_;
		guchar* _tmp58_ = NULL;
		guchar* _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		GBytes* _tmp60_ = NULL;
		GBytes* _tmp61_ = NULL;
		GBytes* _tmp62_ = NULL;
		GBytesIcon* _tmp63_ = NULL;
		_tmp49_ = attribute;
		_tmp50_ = e_vcard_attribute_get_value (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = string_get_data (_tmp51_, &_tmp52__length1);
		_tmp53_ = _tmp52_;
		_tmp53__length1 = _tmp52__length1;
		_tmp54_ = g_strdup ((const gchar*) _tmp53_);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp51_);
		encoded_data = _tmp55_;
		_tmp56_ = encoded_data;
		_tmp58_ = g_base64_decode (_tmp56_, &_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp59__length1 = _tmp57_;
		_tmp60_ = g_bytes_new (_tmp59_, _tmp57_);
		_tmp61_ = _tmp60_;
		_tmp59_ = (g_free (_tmp59_), NULL);
		bytes = _tmp61_;
		_tmp62_ = bytes;
		_tmp63_ = (GBytesIcon*) g_bytes_icon_new (_tmp62_);
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = (GLoadableIcon*) _tmp63_;
		_g_bytes_unref0 (bytes);
		_g_free0 (encoded_data);
	}
	_tmp64_ = card;
	_tmp65_ = e_vcard_get_attribute (_tmp64_, "N");
	_tmp66_ = __vala_EVCardAttribute_copy0 (_tmp65_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp66_;
	_tmp67_ = attribute;
	if (_tmp67_ != NULL) {
		gchar** components = NULL;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gchar** _tmp73_ = NULL;
		gint components_length1 = 0;
		gint _components_size_ = 0;
		guint components_size = 0U;
		GList* values = NULL;
		EVCardAttribute* _tmp74_ = NULL;
		GList* _tmp75_ = NULL;
		GList* _tmp76_ = NULL;
		guint _tmp77_ = 0U;
		guint _tmp78_ = 0U;
		gchar** _tmp94_ = NULL;
		gint _tmp94__length1 = 0;
		const gchar* _tmp95_ = NULL;
		gchar** _tmp96_ = NULL;
		gint _tmp96__length1 = 0;
		const gchar* _tmp97_ = NULL;
		gchar** _tmp98_ = NULL;
		gint _tmp98__length1 = 0;
		const gchar* _tmp99_ = NULL;
		gchar** _tmp100_ = NULL;
		gint _tmp100__length1 = 0;
		const gchar* _tmp101_ = NULL;
		gchar** _tmp102_ = NULL;
		gint _tmp102__length1 = 0;
		const gchar* _tmp103_ = NULL;
		FolksStructuredName* _tmp104_ = NULL;
		GList* _tmp105_ = NULL;
		guint _tmp106_ = 0U;
		_tmp68_ = g_strdup ("");
		_tmp69_ = g_strdup ("");
		_tmp70_ = g_strdup ("");
		_tmp71_ = g_strdup ("");
		_tmp72_ = g_strdup ("");
		_tmp73_ = g_new0 (gchar*, 5 + 1);
		_tmp73_[0] = _tmp68_;
		_tmp73_[1] = _tmp69_;
		_tmp73_[2] = _tmp70_;
		_tmp73_[3] = _tmp71_;
		_tmp73_[4] = _tmp72_;
		components = _tmp73_;
		components_length1 = 5;
		_components_size_ = components_length1;
		components_size = (guint) 5;
		_tmp74_ = attribute;
		_tmp75_ = e_vcard_attribute_get_values_decoded (_tmp74_);
		values = _tmp75_;
		_tmp76_ = values;
		_tmp77_ = g_list_length (_tmp76_);
		_tmp78_ = components_size;
		if (_tmp77_ < _tmp78_) {
			GList* _tmp79_ = NULL;
			guint _tmp80_ = 0U;
			_tmp79_ = values;
			_tmp80_ = g_list_length (_tmp79_);
			components_size = _tmp80_;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp81_ = FALSE;
				_tmp81_ = TRUE;
				while (TRUE) {
					gboolean _tmp82_ = FALSE;
					gint _tmp84_ = 0;
					guint _tmp85_ = 0U;
					gchar** _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					gint _tmp87_ = 0;
					GList* _tmp88_ = NULL;
					gint _tmp89_ = 0;
					gconstpointer _tmp90_ = NULL;
					const gchar* _tmp91_ = NULL;
					gchar* _tmp92_ = NULL;
					gchar* _tmp93_ = NULL;
					_tmp82_ = _tmp81_;
					if (!_tmp82_) {
						gint _tmp83_ = 0;
						_tmp83_ = i;
						i = _tmp83_ + 1;
					}
					_tmp81_ = FALSE;
					_tmp84_ = i;
					_tmp85_ = components_size;
					if (!(((guint) _tmp84_) < _tmp85_)) {
						break;
					}
					_tmp86_ = components;
					_tmp86__length1 = components_length1;
					_tmp87_ = i;
					_tmp88_ = values;
					_tmp89_ = i;
					_tmp90_ = g_list_nth_data (_tmp88_, (guint) _tmp89_);
					_tmp91_ = ((GString*) _tmp90_)->str;
					_tmp92_ = g_strdup (_tmp91_);
					_g_free0 (_tmp86_[_tmp87_]);
					_tmp86_[_tmp87_] = _tmp92_;
					_tmp93_ = _tmp86_[_tmp87_];
				}
			}
		}
		_tmp94_ = components;
		_tmp94__length1 = components_length1;
		_tmp95_ = _tmp94_[0];
		_tmp96_ = components;
		_tmp96__length1 = components_length1;
		_tmp97_ = _tmp96_[1];
		_tmp98_ = components;
		_tmp98__length1 = components_length1;
		_tmp99_ = _tmp98_[2];
		_tmp100_ = components;
		_tmp100__length1 = components_length1;
		_tmp101_ = _tmp100_[3];
		_tmp102_ = components;
		_tmp102__length1 = components_length1;
		_tmp103_ = _tmp102_[4];
		_tmp104_ = folks_structured_name_new (_tmp95_, _tmp97_, _tmp99_, _tmp101_, _tmp103_);
		_g_object_unref0 (self->priv->_structured_name);
		self->priv->_structured_name = _tmp104_;
		_tmp105_ = values;
		_tmp106_ = g_list_length (_tmp105_);
		if (_tmp106_ != ((guint) 5)) {
			GList* _tmp107_ = NULL;
			guint _tmp108_ = 0U;
			_tmp107_ = values;
			_tmp108_ = g_list_length (_tmp107_);
			g_debug ("bluez-persona.vala:269: Expected 5 components to N value of vcard, got" \
" %u", _tmp108_);
		}
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp109_ = card;
	_tmp110_ = e_vcard_get_attribute (_tmp109_, "EMAIL");
	_tmp111_ = __vala_EVCardAttribute_copy0 (_tmp110_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp111_;
	_tmp112_ = attribute;
	if (_tmp112_ != NULL) {
		GeeHashSet* _tmp113_ = NULL;
		EVCardAttribute* _tmp114_ = NULL;
		GString* _tmp115_ = NULL;
		GString* _tmp116_ = NULL;
		const gchar* _tmp117_ = NULL;
		FolksEmailFieldDetails* _tmp118_ = NULL;
		FolksEmailFieldDetails* _tmp119_ = NULL;
		_tmp113_ = self->priv->_email_addresses;
		_tmp114_ = attribute;
		_tmp115_ = e_vcard_attribute_get_value_decoded (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = _tmp116_->str;
		_tmp118_ = folks_email_field_details_new (_tmp117_, NULL);
		_tmp119_ = _tmp118_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp113_, _tmp119_);
		_g_object_unref0 (_tmp119_);
		_g_string_free0 (_tmp116_);
	}
	__vala_EVCardAttribute_free0 (attribute);
	_g_object_unref0 (card);
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void folks_backends_blue_z_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FolksBackendsBlueZPersona * self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "phone-numbers") == 0) {
		{
			GeeIterator* _phone_number_it = NULL;
			GeeHashSet* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
			_tmp1_ = self->priv->_phone_numbers;
			_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
			_phone_number_it = _tmp2_;
			while (TRUE) {
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				FolksPhoneFieldDetails* phone_number = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				FolksPhoneFieldDetails* _tmp7_ = NULL;
				gconstpointer _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				_tmp3_ = _phone_number_it;
				_tmp4_ = gee_iterator_next (_tmp3_);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = _phone_number_it;
				_tmp6_ = gee_iterator_get (_tmp5_);
				phone_number = (FolksPhoneFieldDetails*) _tmp6_;
				_tmp7_ = phone_number;
				_tmp8_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (((const gchar*) _tmp9_) != NULL) {
					FolksPersonaLinkablePropertyCallback _tmp10_ = NULL;
					void* _tmp10__target = NULL;
					FolksPhoneFieldDetails* _tmp11_ = NULL;
					gconstpointer _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					_tmp10_ = callback;
					_tmp10__target = callback_target;
					_tmp11_ = phone_number;
					_tmp12_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp10_ ((const gchar*) _tmp13_, _tmp10__target);
				}
				_g_object_unref0 (phone_number);
			}
			_g_object_unref0 (_phone_number_it);
		}
	} else {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = prop_name;
		if (g_strcmp0 (_tmp14_, "email-addresses") == 0) {
			{
				GeeIterator* _email_address_it = NULL;
				GeeHashSet* _tmp15_ = NULL;
				GeeIterator* _tmp16_ = NULL;
				_tmp15_ = self->priv->_email_addresses;
				_tmp16_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp15_);
				_email_address_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					FolksEmailFieldDetails* email_address = NULL;
					GeeIterator* _tmp19_ = NULL;
					gpointer _tmp20_ = NULL;
					FolksEmailFieldDetails* _tmp21_ = NULL;
					gconstpointer _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					_tmp17_ = _email_address_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _email_address_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					email_address = (FolksEmailFieldDetails*) _tmp20_;
					_tmp21_ = email_address;
					_tmp22_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp21_);
					_tmp23_ = _tmp22_;
					if (((const gchar*) _tmp23_) != NULL) {
						FolksPersonaLinkablePropertyCallback _tmp24_ = NULL;
						void* _tmp24__target = NULL;
						FolksEmailFieldDetails* _tmp25_ = NULL;
						gconstpointer _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						_tmp24_ = callback;
						_tmp24__target = callback_target;
						_tmp25_ = email_address;
						_tmp26_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp24_ ((const gchar*) _tmp27_, _tmp24__target);
					}
					_g_object_unref0 (email_address);
				}
				_g_object_unref0 (_email_address_it);
			}
		} else {
			const gchar* _tmp28_ = NULL;
			FolksPersonaLinkablePropertyCallback _tmp29_ = NULL;
			void* _tmp29__target = NULL;
			_tmp28_ = prop_name;
			_tmp29_ = callback;
			_tmp29__target = callback_target;
			FOLKS_PERSONA_CLASS (folks_backends_blue_z_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), _tmp28_, _tmp29_, _tmp29__target);
		}
	}
}


static gchar** folks_backends_blue_z_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsBlueZPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_BLUE_Z_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static GeeSet* folks_backends_blue_z_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static GLoadableIcon* folks_backends_blue_z_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	FolksBackendsBlueZPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	FolksBackendsBlueZPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static gchar** folks_backends_blue_z_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsBlueZPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = folks_backends_blue_z_persona__writeable_properties;
	_tmp0__length1 = folks_backends_blue_z_persona__writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GeeSet* folks_backends_blue_z_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* folks_backends_blue_z_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	FolksBackendsBlueZPersona* self;
	FolksStructuredName* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	FolksBackendsBlueZPersona* self;
	FolksStructuredName* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* folks_backends_blue_z_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* folks_backends_blue_z_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	FolksBackendsBlueZPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* folks_backends_blue_z_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	FolksBackendsBlueZPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static GObject * folks_backends_blue_z_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsBlueZPersona * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GeeHashSet* _tmp6_ = NULL;
	GeeHashSet* _tmp7_ = NULL;
	GeeSet* _tmp8_ = NULL;
	GeeSet* _tmp9_ = NULL;
	GeeHashSet* _tmp10_ = NULL;
	GeeHashSet* _tmp11_ = NULL;
	GeeSet* _tmp12_ = NULL;
	GeeSet* _tmp13_ = NULL;
	GeeHashSet* _tmp14_ = NULL;
	GeeSet* _tmp15_ = NULL;
	GeeSet* _tmp16_ = NULL;
	GeeSet* _tmp17_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_backends_blue_z_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_persona_get_display_id ((FolksPersona*) self);
	_tmp5_ = _tmp4_;
	g_debug ("bluez-persona.vala:197: Adding BlueZ Persona '%s' (IID '%s', group '%s" \
"')", _tmp1_, _tmp3_, _tmp5_);
	_tmp6_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp6_;
	_tmp7_ = self->priv->_phone_numbers;
	_tmp8_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp9_;
	_tmp10_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp10_;
	_tmp11_ = self->priv->_email_addresses;
	_tmp12_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp13_;
	_tmp14_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = (GeeSet*) _tmp14_;
	_tmp15_ = self->priv->_urls;
	_tmp16_ = gee_set_get_read_only_view (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp17_;
	return obj;
}


static void folks_backends_blue_z_persona_class_init (FolksBackendsBlueZPersonaClass * klass) {
	gchar** _tmp0_ = NULL;
	folks_backends_blue_z_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsBlueZPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = folks_backends_blue_z_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = folks_backends_blue_z_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = folks_backends_blue_z_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_blue_z_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_blue_z_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_blue_z_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_blue_z_persona_finalize;
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS, g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	  * {@inheritDoc}
	  *
	  * @since 0.9.6
	  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	  * {@inheritDoc}
	  *
	  * @since 0.9.6
	  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_blue_z_persona__writeable_properties = _tmp0_;
	folks_backends_blue_z_persona__writeable_properties_length1 = 0;
}


static void folks_backends_blue_z_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = folks_backends_blue_z_persona_real_get_avatar;
	iface->set_avatar = folks_backends_blue_z_persona_real_set_avatar;
}


static void folks_backends_blue_z_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email_addresses = folks_backends_blue_z_persona_real_get_email_addresses;
	iface->set_email_addresses = folks_backends_blue_z_persona_real_set_email_addresses;
}


static void folks_backends_blue_z_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = folks_backends_blue_z_persona_real_get_structured_name;
	iface->set_structured_name = folks_backends_blue_z_persona_real_set_structured_name;
	iface->get_full_name = folks_backends_blue_z_persona_real_get_full_name;
	iface->set_full_name = folks_backends_blue_z_persona_real_set_full_name;
	iface->get_nickname = folks_backends_blue_z_persona_real_get_nickname;
	iface->set_nickname = folks_backends_blue_z_persona_real_set_nickname;
}


static void folks_backends_blue_z_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_phone_numbers = folks_backends_blue_z_persona_real_get_phone_numbers;
	iface->set_phone_numbers = folks_backends_blue_z_persona_real_set_phone_numbers;
}


static void folks_backends_blue_z_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	folks_backends_blue_z_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = folks_backends_blue_z_persona_real_get_urls;
	iface->set_urls = folks_backends_blue_z_persona_real_set_urls;
}


static void folks_backends_blue_z_persona_instance_init (FolksBackendsBlueZPersona * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self->priv = FOLKS_BACKENDS_BLUE_Z_PERSONA_GET_PRIVATE (self);
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_nickname = _tmp1_;
	self->priv->_urls = NULL;
	self->priv->_urls_ro = NULL;
	self->priv->_avatar = NULL;
}


static void folks_backends_blue_z_persona_finalize (GObject* obj) {
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	G_OBJECT_CLASS (folks_backends_blue_z_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.9.6
 */
GType folks_backends_blue_z_persona_get_type (void) {
	static volatile gsize folks_backends_blue_z_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_blue_z_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsBlueZPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_blue_z_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsBlueZPersona), 0, (GInstanceInitFunc) folks_backends_blue_z_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) folks_backends_blue_z_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_backends_blue_z_persona_type_id;
		folks_backends_blue_z_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsBlueZPersona", &g_define_type_info, 0);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (folks_backends_blue_z_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_once_init_leave (&folks_backends_blue_z_persona_type_id__volatile, folks_backends_blue_z_persona_type_id);
	}
	return folks_backends_blue_z_persona_type_id__volatile;
}


static void _vala_folks_backends_blue_z_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_blue_z_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsBlueZPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



