# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	adler2@2.0.1
	aho-corasick@1.1.4
	allocator-api2@0.2.21
	android_system_properties@0.1.5
	anes@0.1.6
	annotate-snippets@0.11.5
	anstream@0.6.21
	anstyle-lossy@1.1.4
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-svg@0.1.11
	anstyle-wincon@3.0.10
	anstyle@1.0.13
	anyhow@1.0.100
	approx@0.5.1
	arc-swap@1.7.1
	argfile@0.2.1
	arrayvec@0.7.6
	assert_fs@1.1.3
	attribute-derive-macro@0.10.3
	attribute-derive@0.10.3
	autocfg@1.5.0
	base64@0.13.1
	bincode@2.0.1
	bincode_derive@2.0.1
	bindgen@0.72.1
	bit-set@0.8.0
	bit-vec@0.8.0
	bitflags@1.3.2
	bitflags@2.10.0
	bitvec@1.0.1
	block-buffer@0.10.4
	block2@0.6.2
	boxcar@0.2.14
	bstr@1.12.1
	bumpalo@3.19.0
	byteorder@1.5.0
	cachedir@0.3.1
	camino@1.2.1
	cast@0.3.0
	castaway@0.2.4
	cc@1.2.38
	cexpr@0.6.0
	cfg-if@1.0.3
	cfg_aliases@0.2.1
	chrono@0.4.42
	ciborium-io@0.2.2
	ciborium-ll@0.2.2
	ciborium@0.2.2
	clang-sys@1.8.1
	clap@4.5.53
	clap_builder@4.5.53
	clap_complete@4.5.58
	clap_complete_command@0.6.1
	clap_complete_nushell@4.5.8
	clap_derive@4.5.49
	clap_lex@0.7.5
	clearscreen@4.0.2
	codspeed-criterion-compat-walltime@4.0.4
	codspeed-criterion-compat@4.0.4
	codspeed-divan-compat-macros@4.0.4
	codspeed-divan-compat-walltime@4.0.4
	codspeed-divan-compat@4.0.4
	codspeed@4.0.4
	collection_literals@1.0.2
	colorchoice@1.0.4
	colored@2.2.0
	colored@3.0.0
	compact_str@0.9.0
	condtype@1.3.0
	console@0.15.11
	console@0.16.1
	console_error_panic_hook@0.1.7
	console_log@1.0.0
	core-foundation-sys@0.8.7
	countme@3.0.1
	cpufeatures@0.2.17
	crc32fast@1.5.0
	criterion-plot@0.5.0
	criterion-plot@0.6.0
	criterion@0.7.0
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.12
	crossbeam-utils@0.8.21
	crossbeam@0.8.4
	crunchy@0.2.4
	crypto-common@0.1.6
	csv-core@0.1.12
	csv@1.4.0
	ctrlc@3.5.1
	darling@0.21.3
	darling_core@0.21.3
	darling_macro@0.21.3
	dashmap@6.1.0
	datatest-stable@0.3.3
	derive-where@1.6.0
	diff@0.1.13
	difflib@0.4.0
	digest@0.10.7
	dirs-sys@0.5.0
	dirs@6.0.0
	dispatch2@0.3.0
	displaydoc@0.2.5
	divan-macros@0.1.17
	doc-comment@0.3.3
	drop_bomb@0.1.5
	dunce@1.0.5
	dyn-clone@1.0.20
	either@1.15.0
	encode_unicode@1.0.0
	env_home@0.1.0
	equivalent@1.0.2
	errno@0.3.14
	escape8259@0.5.3
	escargot@0.5.15
	etcetera@0.11.0
	fancy-regex@0.14.0
	fastrand@2.3.0
	fern@0.7.1
	filetime@0.2.26
	find-msvc-tools@0.1.2
	flate2@1.1.2
	fnv@1.0.7
	foldhash@0.1.5
	form_urlencoded@1.2.2
	fs-err@2.11.0
	fsevent-sys@4.1.0
	funty@2.0.0
	generic-array@0.14.7
	get-size-derive2@0.7.3
	get-size2@0.7.3
	getopts@0.2.24
	getrandom@0.2.16
	getrandom@0.3.4
	glob@0.3.3
	globset@0.4.18
	globwalk@0.9.1
	half@2.6.0
	hashbrown@0.14.5
	hashbrown@0.15.5
	hashbrown@0.16.1
	hashlink@0.10.0
	heck@0.5.0
	hermit-abi@0.5.2
	html-escape@0.2.13
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.64
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.1
	icu_properties_data@2.0.1
	icu_provider@2.0.0
	ident_case@1.0.1
	idna@1.1.0
	idna_adapter@1.2.1
	ignore@0.4.25
	imara-diff@0.1.8
	imperative@1.0.6
	indexmap@2.12.1
	indicatif@0.18.3
	indoc@2.0.7
	inotify-sys@0.1.5
	inotify@0.11.0
	insta-cmd@0.6.0
	insta@1.43.2
	interpolator@0.5.0
	intrusive-collections@0.9.7
	inventory@0.3.21
	is-docker@0.2.0
	is-macro@0.3.7
	is-terminal@0.4.16
	is-wsl@0.4.0
	is_terminal_polyfill@1.70.1
	itertools@0.10.5
	itertools@0.13.0
	itertools@0.14.0
	itoa@1.0.15
	jiff-static@0.2.16
	jiff-tzdb-platform@0.1.3
	jiff-tzdb@0.1.4
	jiff@0.2.16
	jobserver@0.1.34
	jod-thread@1.0.0
	js-sys@0.3.82
	kqueue-sys@1.0.4
	kqueue@1.1.1
	lazy_static@1.5.0
	libc@0.2.177
	libcst@1.8.6
	libcst_derive@1.8.6
	libloading@0.8.9
	libmimalloc-sys@0.1.44
	libredox@0.1.10
	libtest-mimic@0.7.3
	libtest-mimic@0.8.1
	linux-raw-sys@0.11.0
	litemap@0.8.0
	lock_api@0.4.13
	log@0.4.28
	lsp-server@0.7.9
	manyhow-macros@0.11.4
	manyhow@0.11.4
	markdown@1.0.0
	matchers@0.2.0
	matches@0.1.10
	matchit@0.9.0
	memchr@2.7.6
	memoffset@0.9.1
	mimalloc@0.1.48
	minicov@0.3.7
	minimal-lexical@0.2.1
	miniz_oxide@0.8.9
	mio@1.0.4
	natord@1.0.9
	newtype-uuid@1.2.4
	nix@0.29.0
	nix@0.30.1
	nom@7.1.3
	normalize-line-endings@0.3.0
	notify-types@2.0.0
	notify@8.2.0
	nu-ansi-term@0.50.1
	num-traits@0.2.19
	num_cpus@1.17.0
	objc2-encode@4.1.0
	objc2@0.6.3
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	oorandom@11.1.5
	option-ext@0.2.0
	ordermap@1.0.0
	os_pipe@1.2.2
	os_str_bytes@7.1.1
	parking_lot@0.12.4
	parking_lot_core@0.9.11
	paste@1.0.15
	path-absolutize@3.1.1
	path-dedot@3.1.1
	path-slash@0.2.1
	pathdiff@0.2.3
	peg-macros@0.8.5
	peg-runtime@0.8.5
	peg@0.8.5
	pep440_rs@0.7.3
	pep508_rs@0.9.2
	percent-encoding@2.3.2
	pest@2.8.2
	pest_derive@2.8.2
	pest_generator@2.8.2
	pest_meta@2.8.2
	phf@0.11.3
	phf_codegen@0.11.3
	phf_generator@0.11.3
	phf_shared@0.11.3
	pin-project-lite@0.2.16
	pkg-config@0.3.32
	portable-atomic-util@0.2.4
	portable-atomic@1.11.1
	potential_utf@0.1.3
	ppv-lite86@0.2.21
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	pretty_assertions@1.4.1
	prettyplease@0.2.37
	proc-macro-crate@3.4.0
	proc-macro-utils@0.10.0
	proc-macro2@1.0.103
	pyproject-toml@0.13.7
	quick-junit@0.5.2
	quick-xml@0.38.4
	quickcheck@1.0.3
	quickcheck_macros@1.1.0
	quote-use-macros@0.8.4
	quote-use@0.8.4
	quote@1.0.42
	r-efi@5.3.0
	radium@0.7.0
	rand@0.8.5
	rand@0.9.2
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	rayon-core@1.13.0
	rayon@1.11.0
	redox_syscall@0.5.17
	redox_users@0.5.2
	ref-cast-impl@1.0.25
	ref-cast@1.0.25
	regex-automata@0.4.13
	regex-lite@0.1.7
	regex-syntax@0.8.6
	regex@1.12.2
	ron@0.7.1
	rust-stemmers@1.2.0
	rustc-hash@2.1.1
	rustc-stable-hash@0.1.2
	rustix@1.1.2
	rustversion@1.0.22
	ryu@1.0.20
	same-file@1.0.6
	schemars@1.0.5
	schemars_derive@1.0.5
	scopeguard@1.2.0
	seahash@4.1.0
	serde-wasm-bindgen@0.6.5
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_derive_internals@0.29.1
	serde_json@1.0.145
	serde_repr@0.1.20
	serde_spanned@1.0.3
	serde_test@1.0.177
	serde_with@3.15.1
	serde_with_macros@3.15.1
	sha2@0.10.9
	sharded-slab@0.1.7
	shellexpand@3.1.1
	shlex@1.3.0
	similar@2.7.0
	siphasher@1.0.1
	smallvec@1.15.1
	snapbox-macros@0.4.0
	snapbox@0.6.23
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	statrs@0.18.0
	strip-ansi-escapes@0.2.1
	strsim@0.11.1
	strum@0.27.2
	strum_macros@0.27.2
	supports-hyperlinks@3.1.0
	syn@2.0.111
	synstructure@0.13.2
	tap@1.0.1
	tempfile@3.23.0
	termcolor@1.4.1
	terminal_size@0.4.3
	terminfo@0.9.0
	termtree@0.5.1
	test-case-core@3.3.1
	test-case-macros@3.3.1
	test-case@3.3.1
	thin-vec@0.2.14
	thiserror-impl@1.0.69
	thiserror-impl@2.0.17
	thiserror@1.0.69
	thiserror@2.0.17
	thread_local@1.1.9
	threadpool@1.8.1
	tikv-jemalloc-sys@0.6.1+5.3.0-1-ge13ca993e8ccb9ba9847cc330696e02839f328f7
	tikv-jemallocator@0.6.1
	tinystr@0.8.1
	tinytemplate@1.2.1
	tinyvec@1.10.0
	tinyvec_macros@0.1.1
	toml@0.9.8
	toml_datetime@0.7.3
	toml_edit@0.23.6
	toml_parser@1.0.4
	toml_writer@1.0.4
	tracing-attributes@0.1.31
	tracing-core@0.1.35
	tracing-flame@0.2.0
	tracing-indicatif@0.3.13
	tracing-log@0.2.0
	tracing-subscriber@0.3.22
	tracing@0.1.43
	tryfn@0.2.3
	typed-arena@2.0.2
	typenum@1.18.0
	ucd-trie@0.1.7
	unic-char-property@0.9.0
	unic-char-range@0.9.0
	unic-common@0.9.0
	unic-ucd-category@0.9.0
	unic-ucd-version@0.9.0
	unicode-id@0.3.6
	unicode-ident@1.0.22
	unicode-normalization@0.1.24
	unicode-width@0.2.2
	unicode_names2@1.3.0
	unicode_names2_generator@1.3.0
	unit-prefix@0.5.1
	unscanny@0.1.0
	unty@0.0.4
	url@2.5.7
	urlencoding@2.1.3
	utf8-width@0.1.7
	utf8_iter@1.0.4
	utf8parse@0.2.2
	uuid-macro-internal@1.18.1
	uuid@1.18.1
	valuable@0.1.1
	version-ranges@0.1.1
	version_check@0.9.5
	virtue@0.0.18
	vt100@0.16.2
	vte@0.14.1
	vte@0.15.0
	wait-timeout@0.2.1
	walkdir@2.5.0
	wasi@0.11.1+wasi-snapshot-preview1
	wasip2@1.0.1+wasi-0.2.4
	wasm-bindgen-futures@0.4.55
	wasm-bindgen-macro-support@0.2.105
	wasm-bindgen-macro@0.2.105
	wasm-bindgen-shared@0.2.105
	wasm-bindgen-test-macro@0.3.55
	wasm-bindgen-test@0.3.55
	wasm-bindgen@0.2.105
	web-sys@0.3.82
	web-time@1.1.0
	which@8.0.0
	wild@2.2.1
	winapi-util@0.1.11
	windows-core@0.62.0
	windows-implement@0.60.0
	windows-interface@0.59.1
	windows-link@0.1.3
	windows-link@0.2.0
	windows-result@0.4.0
	windows-strings@0.5.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-sys@0.60.2
	windows-sys@0.61.0
	windows-targets@0.52.6
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winnow@0.7.13
	winsafe@0.0.19
	wit-bindgen@0.46.0
	writeable@0.6.1
	wyz@0.5.1
	yansi@1.0.1
	yoke-derive@0.8.0
	yoke@0.8.0
	zerocopy-derive@0.8.27
	zerocopy@0.8.27
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.4
	zip@0.6.6
	zstd-safe@5.0.2+zstd.1.5.2
	zstd-sys@2.0.16+zstd.1.5.7
	zstd@0.11.2+zstd.1.5.2
"

declare -A GIT_CRATES=(
	[lsp-types]='https://github.com/astral-sh/lsp-types;3512a9f33eadc5402cfab1b8f7340824c8ca1439;lsp-types-%commit%'
	[salsa-macro-rules]='https://github.com/salsa-rs/salsa;ce80691fa0b87dc2fd2235a26544e63e5e43d8d3;salsa-%commit%/components/salsa-macro-rules'
	[salsa-macros]='https://github.com/salsa-rs/salsa;ce80691fa0b87dc2fd2235a26544e63e5e43d8d3;salsa-%commit%/components/salsa-macros'
	[salsa]='https://github.com/salsa-rs/salsa;ce80691fa0b87dc2fd2235a26544e63e5e43d8d3;salsa-%commit%'
)

RUST_MIN_VER="1.90.0"

inherit shell-completion cargo

DESCRIPTION="An extremely fast Python type checker and language server, written in Rust"
HOMEPAGE="
	https://docs.astral.sh/ty/
	https://github.com/astral-sh/ty
"
SRC_URI="
	${CARGO_CRATE_URIS}
	https://github.com/astral-sh/ty/releases/download/${PV}/source.tar.gz -> ${P}.tar.gz
"

S=${WORKDIR}/${P}/ruff

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD CC0-1.0 ISC MIT MPL-2.0 PSF-2 Unicode-3.0
	Unicode-DFS-2016 WTFPL-2 ZLIB
"
SLOT="0"
KEYWORDS="~amd64"

RDEPEND="
	!elibc_musl? ( !elibc_Darwin? ( !elibc_bionic? ( dev-libs/jemalloc:= ) ) )
	app-arch/zstd
"
DEPEND="
	${RDEPEND}
"

QA_FLAGS_IGNORED="usr/bin/.*"

src_prepare() {
	default

	# Experimental cruft cleaner. These crates are not used by the ruff binary,
	# and when they are removed in the git repo, the lockfile is regenerated
	# and gets quite a bit smaller. Hence pycargoebuild also produces much
	# smaller CRATES= variables. Less for the user to download, fewer distfiles
	# to mirror.
	pushd crates >/dev/null || die
	rm -r ruff{,_{benchmark,dev,server,workspace}} ruff_python_*_integration_tests ty_completion_eval *_wasm || die
	popd > /dev/null || die

	# tests that hang in the ebuild environment
	rm crates/ruff_annotate_snippets/tests/examples.rs || die
}

src_unpack() {
	# The upstream source is a git submodule, and their source tarball has
	# no leading directory.
	mkdir -p "${WORKDIR}/${P}" || die
	cd "${WORKDIR}/${P}" || die

	cargo_src_unpack
	mv salsa* lsp-types* "${WORKDIR}"
}

src_configure() {
	export RUSTFLAGS="${RUSTFLAGS}"
	cargo_src_configure
}

src_compile() {
	cd crates/ty || die

	local -x ZSTD_SYS_USE_PKG_CONFIG=1
	# Gentoo bug #927338
	if use !elibc_musl && use !elibc_Darwin && use !elibc_bionic; then
		local -x CARGO_FEATURE_UNPREFIXED_MALLOC_ON_SUPPORTED_PLATFORMS=1
		local -x JEMALLOC_OVERRIDE="${ESYSROOT}/usr/$(get_libdir)"/libjemalloc.so
	fi
	cargo_src_compile

	local releasedir
	releasedir=../../$(cargo_target_dir)

	${releasedir}/ty generate-shell-completion bash > ty-completion.bash || die
	${releasedir}/ty generate-shell-completion zsh > ty-completion.zsh || die
}

src_test() {
	cd crates/ty || die

	local -x ZSTD_SYS_USE_PKG_CONFIG=1
	# Gentoo bug #927338
	if use !elibc_musl && use !elibc_Darwin && use !elibc_bionic; then
		local -x CARGO_FEATURE_UNPREFIXED_MALLOC_ON_SUPPORTED_PLATFORMS=1
		local -x JEMALLOC_OVERRIDE="${ESYSROOT}/usr/$(get_libdir)"/libjemalloc.so
	fi
	cargo_src_test --target-dir "${PWD}"/tested-target/
}

src_install() {
	cd crates/ty || die

	local releasedir=../../$(cargo_target_dir)

	dobin ${releasedir}/ty

	newbashcomp ty-completion.bash ty
	newzshcomp ty-completion.zsh _ty
}
