import sys
from _typeshed import SupportsRichComparisonT as _T  # All type variable use in this module requires comparability.
from typing import Final

__about__: Final[str]

def heapify(heap: list[_T], /) -> None: ...
def heappop(heap: list[_T], /) -> _T: ...
def heappush(heap: list[_T], item: _T, /) -> None: ...
def heappushpop(heap: list[_T], item: _T, /) -> _T: ...
def heapreplace(heap: list[_T], item: _T, /) -> _T: ...

if sys.version_info >= (3, 14):
    def heapify_max(heap: list[_T], /) -> None: ...
    def heappop_max(heap: list[_T], /) -> _T: ...
    def heappush_max(heap: list[_T], item: _T, /) -> None: ...
    def heappushpop_max(heap: list[_T], item: _T, /) -> _T: ...
    def heapreplace_max(heap: list[_T], item: _T, /) -> _T: ...
