from typing import final

from mypy_extensions import i64, i32, i16, u8

@final
class BytesWriter:
    def append(self, x: int, /) -> None: ...
    def write(self, b: bytes | bytearray, /) -> None: ...
    def getvalue(self) -> bytes: ...
    def truncate(self, size: i64, /) -> None: ...
    def __len__(self) -> i64: ...
    def __getitem__(self, i: i64, /) -> u8: ...
    def __setitem__(self, i: i64, x: u8, /) -> None: ...

@final
class StringWriter:
    def append(self, x: int, /) -> None: ...
    def write(self, s: str, /) -> None: ...
    def getvalue(self) -> str: ...
    def __len__(self) -> i64: ...
    def __getitem__(self, i: i64, /) -> i32: ...

def write_i16_le(b: BytesWriter, n: i16, /) -> None: ...
def write_i16_be(b: BytesWriter, n: i16, /) -> None: ...
def read_i16_le(b: bytes, index: i64, /) -> i16: ...
def read_i16_be(b: bytes, index: i64, /) -> i16: ...
def write_i32_le(b: BytesWriter, n: i32, /) -> None: ...
def write_i32_be(b: BytesWriter, n: i32, /) -> None: ...
def read_i32_le(b: bytes, index: i64, /) -> i32: ...
def read_i32_be(b: bytes, index: i64, /) -> i32: ...
def write_i64_le(b: BytesWriter, n: i64, /) -> None: ...
def write_i64_be(b: BytesWriter, n: i64, /) -> None: ...
def read_i64_le(b: bytes, index: i64, /) -> i64: ...
def read_i64_be(b: bytes, index: i64, /) -> i64: ...
def write_f32_le(b: BytesWriter, n: float, /) -> None: ...
def write_f32_be(b: BytesWriter, n: float, /) -> None: ...
def read_f32_le(b: bytes, index: i64, /) -> float: ...
def read_f32_be(b: bytes, index: i64, /) -> float: ...
def write_f64_le(b: BytesWriter, n: float, /) -> None: ...
def write_f64_be(b: BytesWriter, n: float, /) -> None: ...
def read_f64_le(b: bytes, index: i64, /) -> float: ...
def read_f64_be(b: bytes, index: i64, /) -> float: ...
